<?php
// $Revision: 1.1 $
// ------------------------------------------------------------------------- //
//  XooNIps Library Module Xoops modules for XooNIps Platforms               //
//  Copyright (C) 2006-2009 Keio University and RIKEN, Japan.                //
//  All rights reserved.                                                     //
//  http://sourceforge.jp/projects/xoonips-library/                          //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
if ( ! defined( 'XOOPS_ROOT_PATH' ) ) {
  exit();
}

/**
 * convert Japanese Kana to Roma-ji
 *
 * @access public
 * @param string $str input string
 * @return string converted string
 */
function xnparticleKana2Roma( $str ) {
  $unicode = xoonips_getutility( 'unicode' );
  // convert _CHARSET to UTF-8
  $str2 = $unicode->encode_utf8( $str, _CHARSET );
  // convert UTF-8 to ASCII + HTML numeric entity references
  $str2 = $unicode->decode_utf8( $str2, 'ASCII', 'h' );

  $str2 = str_replace( '&#12300;', '&#x201C;', $str2 );
  $str2 = str_replace( '&#12301;', '&#x201D;', $str2 );
  $str2 = str_replace( '&#12302;', '&#x2018;', $str2 );
  $str2 = str_replace( '&#12303;', '&#x2019;', $str2 );
  $str2 = str_replace( '&#12289;', ', ', $str2 );
  $str2 = str_replace( '&#12290;', '. ', $str2 );
  $str2 = str_replace( '&#12540;', '^', $str2 );
  $str2 = _xnparticleHiragana2Roma( $str2 );
  $str2 = _xnparticleKatakana2Roma( $str2 );
  $str2 = strtoupper( substr( $str2, 0, 1 ) ).substr( $str2, 1 );
  $str2 = str_replace( '. a', '. A', $str2 );
  $str2 = str_replace( '. b', '. B', $str2 );
  $str2 = str_replace( '. c', '. C', $str2 );
  $str2 = str_replace( '. d', '. D', $str2 );
  $str2 = str_replace( '. e', '. E', $str2 );
  $str2 = str_replace( '. f', '. F', $str2 );
  $str2 = str_replace( '. g', '. G', $str2 );
  $str2 = str_replace( '. h', '. H', $str2 );
  $str2 = str_replace( '. i', '. I', $str2 );
  $str2 = str_replace( '. j', '. J', $str2 );
  $str2 = str_replace( '. k', '. K', $str2 );
  $str2 = str_replace( '. l', '. L', $str2 );
  $str2 = str_replace( '. m', '. M', $str2 );
  $str2 = str_replace( '. n', '. N', $str2 );
  $str2 = str_replace( '. o', '. O', $str2 );
  $str2 = str_replace( '. p', '. P', $str2 );
  $str2 = str_replace( '. q', '. Q', $str2 );
  $str2 = str_replace( '. r', '. R', $str2 );
  $str2 = str_replace( '. s', '. S', $str2 );
  $str2 = str_replace( '. t', '. T', $str2 );
  $str2 = str_replace( '. u', '. U', $str2 );
  $str2 = str_replace( '. v', '. V', $str2 );
  $str2 = str_replace( '. w', '. W', $str2 );
  $str2 = str_replace( '. x', '. X', $str2 );
  $str2 = str_replace( '. y', '. Y', $str2 );
  $str2 = str_replace( '. z', '. Z', $str2 );
  // Hepburn system : Japanese road sign
  $str2 = str_replace( '^', '', $str2 );
  $str2 = str_replace( '&#12288;', ' ', $str2 );
  $str2 = str_replace( '&#65292;', ',', $str2 );
  $str2 = str_replace( '&#65294;', '.', $str2 );
  $str2 = str_replace( '&#12539;', ' ', $str2 );
  $str2 = str_replace( '&#65306;', ':', $str2 );
  $str2 = str_replace( '&#65307;', ';', $str2 );
  $str2 = str_replace( '&#65311;', '?', $str2 );
  $str2 = str_replace( '&#65281;', '!', $str2 );
  $str2 = str_replace( '&#65342;', '^', $str2 );
  $str2 = str_replace( '&#65343;', '_', $str2 );
  $str2 = str_replace( '&#65293;', '-', $str2 );
  $str2 = str_replace( '&#65295;', '/', $str2 );
  $str2 = str_replace( '&#65374;', '~', $str2 );
  $str2 = str_replace( '&#65372;', '|', $str2 );
  $str2 = str_replace( '&#65288;', '(', $str2 );
  $str2 = str_replace( '&#65289;', ')', $str2 );
  $str2 = str_replace( '&#65339;', '[', $str2 );
  $str2 = str_replace( '&#65341;', ']', $str2 );
  $str2 = str_replace( '&#65371;', '{', $str2 );
  $str2 = str_replace( '&#65373;', '}', $str2 );
  $str2 = str_replace( '&#65291;', '+', $str2 );
  $str2 = str_replace( '&#8208;', '-', $str2 );
  $str2 = str_replace( '&#65309;', '=', $str2 );
  $str2 = str_replace( '&#65308;', '<', $str2 );
  $str2 = str_replace( '&#65310;', '>', $str2 );
  $str2 = str_replace( '&#65284;', "$", $str2 );
  $str2 = str_replace( '&#65285;', '%', $str2 );
  $str2 = str_replace( '&#65283;', '#', $str2 );
  $str2 = str_replace( '&#65286;', '&', $str2 );
  $str2 = str_replace( '&#65290;', '*', $str2 );
  $str2 = str_replace( '&#65312;', '@', $str2 );
  $str2 = str_replace( '&#65296;', '0', $str2 );
  $str2 = str_replace( '&#65297;', '1', $str2 );
  $str2 = str_replace( '&#65298;', '2', $str2 );
  $str2 = str_replace( '&#65299;', '3', $str2 );
  $str2 = str_replace( '&#65300;', '4', $str2 );
  $str2 = str_replace( '&#65301;', '5', $str2 );
  $str2 = str_replace( '&#65302;', '6', $str2 );
  $str2 = str_replace( '&#65303;', '7', $str2 );
  $str2 = str_replace( '&#65304;', '8', $str2 );
  $str2 = str_replace( '&#65305;', '9', $str2 );
  $str2 = str_replace( '&#65313;', 'A', $str2 );
  $str2 = str_replace( '&#65314;', 'B', $str2 );
  $str2 = str_replace( '&#65315;', 'C', $str2 );
  $str2 = str_replace( '&#65316;', 'D', $str2 );
  $str2 = str_replace( '&#65317;', 'E', $str2 );
  $str2 = str_replace( '&#65318;', 'F', $str2 );
  $str2 = str_replace( '&#65319;', 'G', $str2 );
  $str2 = str_replace( '&#65320;', 'H', $str2 );
  $str2 = str_replace( '&#65321;', 'I', $str2 );
  $str2 = str_replace( '&#65322;', 'J', $str2 );
  $str2 = str_replace( '&#65323;', 'K', $str2 );
  $str2 = str_replace( '&#65324;', 'L', $str2 );
  $str2 = str_replace( '&#65325;', 'M', $str2 );
  $str2 = str_replace( '&#65326;', 'N', $str2 );
  $str2 = str_replace( '&#65327;', 'O', $str2 );
  $str2 = str_replace( '&#65328;', 'P', $str2 );
  $str2 = str_replace( '&#65329;', 'Q', $str2 );
  $str2 = str_replace( '&#65330;', 'R', $str2 );
  $str2 = str_replace( '&#65331;', 'S', $str2 );
  $str2 = str_replace( '&#65332;', 'T', $str2 );
  $str2 = str_replace( '&#65333;', 'U', $str2 );
  $str2 = str_replace( '&#65334;', 'V', $str2 );
  $str2 = str_replace( '&#65335;', 'W', $str2 );
  $str2 = str_replace( '&#65336;', 'X', $str2 );
  $str2 = str_replace( '&#65337;', 'Y', $str2 );
  $str2 = str_replace( '&#65338;', 'Z', $str2 );
  $str2 = str_replace( '&#65345;', 'a', $str2 );
  $str2 = str_replace( '&#65346;', 'b', $str2 );
  $str2 = str_replace( '&#65347;', 'c', $str2 );
  $str2 = str_replace( '&#65348;', 'd', $str2 );
  $str2 = str_replace( '&#65349;', 'e', $str2 );
  $str2 = str_replace( '&#65350;', 'f', $str2 );
  $str2 = str_replace( '&#65351;', 'g', $str2 );
  $str2 = str_replace( '&#65352;', 'h', $str2 );
  $str2 = str_replace( '&#65353;', 'i', $str2 );
  $str2 = str_replace( '&#65354;', 'j', $str2 );
  $str2 = str_replace( '&#65355;', 'k', $str2 );
  $str2 = str_replace( '&#65356;', 'l', $str2 );
  $str2 = str_replace( '&#65357;', 'm', $str2 );
  $str2 = str_replace( '&#65358;', 'n', $str2 );
  $str2 = str_replace( '&#65359;', 'o', $str2 );
  $str2 = str_replace( '&#65360;', 'p', $str2 );
  $str2 = str_replace( '&#65361;', 'q', $str2 );
  $str2 = str_replace( '&#65362;', 'r', $str2 );
  $str2 = str_replace( '&#65363;', 's', $str2 );
  $str2 = str_replace( '&#65364;', 't', $str2 );
  $str2 = str_replace( '&#65365;', 'u', $str2 );
  $str2 = str_replace( '&#65366;', 'v', $str2 );
  $str2 = str_replace( '&#65367;', 'w', $str2 );
  $str2 = str_replace( '&#65368;', 'x', $str2 );
  $str2 = str_replace( '&#65369;', 'y', $str2 );
  $str2 = str_replace( '&#65370;', 'z', $str2 );

  // convert ASCII + HTML numeric entity references to UTF-8
  $str2 = mb_decode_numericentity( $str2, array( 0x0, 0x10000, 0, 0xfffff ), 'UTF-8' );
  // convert UTF-8 to _CHARSET
  $str2 = $unicode->convert_encoding( $str2, _CHARSET, 'h', 'UTF-8' );

  return $str2;
}

/**
 * convert Japanese Hiragana to Roma-ji
 *
 * @access private
 * @param string $str input string
 * @return string converted string
 */
function _xnparticleHiragana2Roma( $str ) {
  $str2 = $str;
  $str2 = str_replace( '&#12354;&#12354;', '&#12354;^', $str2 );
  $str2 = str_replace( '&#12356;&#12356;', '&#12356;^', $str2 );
  $str2 = str_replace( '&#12358;&#12358;', '&#12358;^', $str2 );
  $str2 = str_replace( '&#12360;&#12360;', '&#12360;^', $str2 );
  $str2 = str_replace( '&#12362;&#12362;', '&#12362;^', $str2 );
  $str2 = str_replace( '&#12362;&#12358;', '&#12362;^', $str2 );
  $str2 = str_replace( '&#12363;&#12354;', '&#12363;^', $str2 );
  $str2 = str_replace( '&#12365;&#12356;', '&#12365;^', $str2 );
  $str2 = str_replace( '&#12367;&#12358;', '&#12367;^', $str2 );
  $str2 = str_replace( '&#12369;&#12360;', '&#12369;^', $str2 );
  $str2 = str_replace( '&#12371;&#12362;', '&#12371;^', $str2 );
  $str2 = str_replace( '&#12371;&#12358;', '&#12371;^', $str2 );
  $str2 = str_replace( '&#12364;&#12354;', '&#12364;^', $str2 );
  $str2 = str_replace( '&#12366;&#12356;', '&#12366;^', $str2 );
  $str2 = str_replace( '&#12368;&#12358;', '&#12368;^', $str2 );
  $str2 = str_replace( '&#12370;&#12360;', '&#12370;^', $str2 );
  $str2 = str_replace( '&#12372;&#12362;', '&#12372;^', $str2 );
  $str2 = str_replace( '&#12372;&#12358;', '&#12372;^', $str2 );
  $str2 = str_replace( '&#12373;&#12354;', '&#12373;^', $str2 );
  $str2 = str_replace( '&#12375;&#12356;', '&#12375;^', $str2 );
  $str2 = str_replace( '&#12377;&#12358;', '&#12377;^', $str2 );
  $str2 = str_replace( '&#12379;&#12360;', '&#12379;^', $str2 );
  $str2 = str_replace( '&#12381;&#12362;', '&#12381;^', $str2 );
  $str2 = str_replace( '&#12381;&#12358;', '&#12381;^', $str2 );
  $str2 = str_replace( '&#12374;&#12354;', '&#12374;^', $str2 );
  $str2 = str_replace( '&#12376;&#12356;', '&#12376;^', $str2 );
  $str2 = str_replace( '&#12378;&#12358;', '&#12378;^', $str2 );
  $str2 = str_replace( '&#12380;&#12360;', '&#12380;^', $str2 );
  $str2 = str_replace( '&#12382;&#12362;', '&#12382;^', $str2 );
  $str2 = str_replace( '&#12382;&#12358;', '&#12382;^', $str2 );
  $str2 = str_replace( '&#12383;&#12354;', '&#12383;^', $str2 );
  $str2 = str_replace( '&#12385;&#12356;', '&#12385;^', $str2 );
  $str2 = str_replace( '&#12388;&#12358;', '&#12388;^', $str2 );
  $str2 = str_replace( '&#12390;&#12360;', '&#12390;^', $str2 );
  $str2 = str_replace( '&#12392;&#12362;', '&#12392;^', $str2 );
  $str2 = str_replace( '&#12392;&#12358;', '&#12392;^', $str2 );
  $str2 = str_replace( '&#12384;&#12354;', '&#12384;^', $str2 );
  $str2 = str_replace( '&#12386;&#12356;', '&#12386;^', $str2 );
  $str2 = str_replace( '&#12389;&#12358;', '&#12389;^', $str2 );
  $str2 = str_replace( '&#12391;&#12360;', '&#12391;^', $str2 );
  $str2 = str_replace( '&#12393;&#12362;', '&#12393;^', $str2 );
  $str2 = str_replace( '&#12393;&#12358;', '&#12393;^', $str2 );
  $str2 = str_replace( '&#12394;&#12354;', '&#12394;^', $str2 );
  $str2 = str_replace( '&#12395;&#12356;', '&#12395;^', $str2 );
  $str2 = str_replace( '&#12396;&#12358;', '&#12396;^', $str2 );
  $str2 = str_replace( '&#12397;&#12360;', '&#12397;^', $str2 );
  $str2 = str_replace( '&#12398;&#12362;', '&#12398;^', $str2 );
  $str2 = str_replace( '&#12398;&#12358;', '&#12398;^', $str2 );
  $str2 = str_replace( '&#12399;&#12354;', '&#12399;^', $str2 );
  $str2 = str_replace( '&#12402;&#12356;', '&#12402;^', $str2 );
  $str2 = str_replace( '&#12405;&#12358;', '&#12405;^', $str2 );
  $str2 = str_replace( '&#12408;&#12360;', '&#12408;^', $str2 );
  $str2 = str_replace( '&#12411;&#12362;', '&#12411;^', $str2 );
  $str2 = str_replace( '&#12411;&#12358;', '&#12411;^', $str2 );
  $str2 = str_replace( '&#12400;&#12354;', '&#12400;^', $str2 );
  $str2 = str_replace( '&#12403;&#12356;', '&#12403;^', $str2 );
  $str2 = str_replace( '&#12406;&#12358;', '&#12406;^', $str2 );
  $str2 = str_replace( '&#12409;&#12360;', '&#12409;^', $str2 );
  $str2 = str_replace( '&#12412;&#12362;', '&#12412;^', $str2 );
  $str2 = str_replace( '&#12412;&#12358;', '&#12412;^', $str2 );
  $str2 = str_replace( '&#12401;&#12354;', '&#12401;^', $str2 );
  $str2 = str_replace( '&#12404;&#12356;', '&#12404;^', $str2 );
  $str2 = str_replace( '&#12407;&#12358;', '&#12407;^', $str2 );
  $str2 = str_replace( '&#12410;&#12360;', '&#12410;^', $str2 );
  $str2 = str_replace( '&#12413;&#12362;', '&#12413;^', $str2 );
  $str2 = str_replace( '&#12413;&#12358;', '&#12413;^', $str2 );
  $str2 = str_replace( '&#12414;&#12354;', '&#12414;^', $str2 );
  $str2 = str_replace( '&#12415;&#12356;', '&#12415;^', $str2 );
  $str2 = str_replace( '&#12416;&#12358;', '&#12416;^', $str2 );
  $str2 = str_replace( '&#12417;&#12360;', '&#12417;^', $str2 );
  $str2 = str_replace( '&#12418;&#12362;', '&#12418;^', $str2 );
  $str2 = str_replace( '&#12418;&#12358;', '&#12418;^', $str2 );
  $str2 = str_replace( '&#12420;&#12354;', '&#12420;^', $str2 );
  $str2 = str_replace( '&#12419;&#12354;', '&#12419;^', $str2 );
  $str2 = str_replace( '&#12422;&#12358;', '&#12422;^', $str2 );
  $str2 = str_replace( '&#12421;&#12358;', '&#12421;^', $str2 );
  $str2 = str_replace( '&#12424;&#12362;', '&#12424;^', $str2 );
  $str2 = str_replace( '&#12423;&#12362;', '&#12423;^', $str2 );
  $str2 = str_replace( '&#12424;&#12358;', '&#12424;^', $str2 );
  $str2 = str_replace( '&#12423;&#12358;', '&#12423;^', $str2 );
  $str2 = str_replace( '&#12425;&#12354;', '&#12425;^', $str2 );
  $str2 = str_replace( '&#12426;&#12356;', '&#12426;^', $str2 );
  $str2 = str_replace( '&#12427;&#12358;', '&#12427;^', $str2 );
  $str2 = str_replace( '&#12428;&#12360;', '&#12428;^', $str2 );
  $str2 = str_replace( '&#12429;&#12362;', '&#12429;^', $str2 );
  $str2 = str_replace( '&#12429;&#12358;', '&#12429;^', $str2 );
  $str2 = str_replace( '&#12431;&#12354;', '&#12431;^', $str2 );
  $str2 = str_replace( '&#12434;&#12362;', '&#12434;^', $str2 );
  $str2 = str_replace( '&#12434;&#12358;', '&#12434;^', $str2 );
  $str2 = str_replace( '&#12387;&#12356;&#12359;', 'yye', $str2 );
  $str2 = str_replace( '&#12387;&#12358;&#12353;', 'wwha', $str2 );
  $str2 = str_replace( '&#12387;&#12358;&#12355;', 'wwhi', $str2 );
  $str2 = str_replace( '&#12387;&#12358;&#12359;', 'wwhe', $str2 );
  $str2 = str_replace( '&#12387;&#12358;&#12361;', 'wwho', $str2 );
  $str2 = str_replace( '&#12387;&#12365;&#12419;', 'kkya', $str2 );
  $str2 = str_replace( '&#12387;&#12365;&#12355;', 'kkyi', $str2 );
  $str2 = str_replace( '&#12387;&#12365;&#12421;', 'kkyu', $str2 );
  $str2 = str_replace( '&#12387;&#12365;&#12359;', 'kkye', $str2 );
  $str2 = str_replace( '&#12387;&#12365;&#12423;', 'kkyo', $str2 );
  $str2 = str_replace( '&#12387;&#12367;&#12419;', 'qqya', $str2 );
  $str2 = str_replace( '&#12387;&#12367;&#12355;', 'qqyi', $str2 );
  $str2 = str_replace( '&#12387;&#12367;&#12421;', 'qqyu', $str2 );
  $str2 = str_replace( '&#12387;&#12367;&#12359;', 'qqye', $str2 );
  $str2 = str_replace( '&#12387;&#12367;&#12423;', 'qqyo', $str2 );
  $str2 = str_replace( '&#12387;&#12367;&#12353;', 'qqwa', $str2 );
  $str2 = str_replace( '&#12387;&#12367;&#12355;', 'qqwi', $str2 );
  $str2 = str_replace( '&#12387;&#12367;&#12357;', 'qqwu', $str2 );
  $str2 = str_replace( '&#12387;&#12367;&#12359;', 'qqwe', $str2 );
  $str2 = str_replace( '&#12387;&#12367;&#12361;', 'qqwo', $str2 );
  $str2 = str_replace( '&#12387;&#12366;&#12419;', 'ggya', $str2 );
  $str2 = str_replace( '&#12387;&#12366;&#12355;', 'ggyi', $str2 );
  $str2 = str_replace( '&#12387;&#12366;&#12421;', 'ggyu', $str2 );
  $str2 = str_replace( '&#12387;&#12366;&#12359;', 'ggye', $str2 );
  $str2 = str_replace( '&#12387;&#12366;&#12423;', 'ggyo', $str2 );
  $str2 = str_replace( '&#12387;&#12368;&#12353;', 'ggwa', $str2 );
  $str2 = str_replace( '&#12387;&#12368;&#12355;', 'ggwi', $str2 );
  $str2 = str_replace( '&#12387;&#12368;&#12357;', 'ggwu', $str2 );
  $str2 = str_replace( '&#12387;&#12368;&#12359;', 'ggwe', $str2 );
  $str2 = str_replace( '&#12387;&#12368;&#12361;', 'ggwo', $str2 );
  $str2 = str_replace( '&#12387;&#12375;&#12355;', 'ssyi', $str2 );
  $str2 = str_replace( '&#12387;&#12377;&#12353;', 'sswa', $str2 );
  $str2 = str_replace( '&#12387;&#12377;&#12355;', 'sswi', $str2 );
  $str2 = str_replace( '&#12387;&#12377;&#12357;', 'sswu', $str2 );
  $str2 = str_replace( '&#12387;&#12377;&#12359;', 'sswe', $str2 );
  $str2 = str_replace( '&#12387;&#12377;&#12361;', 'sswo', $str2 );
  $str2 = str_replace( '&#12387;&#12388;&#12353;', 'ttsa', $str2 );
  $str2 = str_replace( '&#12387;&#12388;&#12355;', 'ttsi', $str2 );
  $str2 = str_replace( '&#12387;&#12388;&#12359;', 'ttse', $str2 );
  $str2 = str_replace( '&#12387;&#12388;&#12361;', 'ttso', $str2 );
  $str2 = str_replace( '&#12387;&#12390;&#12419;', 'ttha', $str2 );
  $str2 = str_replace( '&#12387;&#12390;&#12355;', 'tthi', $str2 );
  $str2 = str_replace( '&#12387;&#12390;&#12421;', 'tthu', $str2 );
  $str2 = str_replace( '&#12387;&#12390;&#12359;', 'tthe', $str2 );
  $str2 = str_replace( '&#12387;&#12390;&#12423;', 'ttho', $str2 );
  $str2 = str_replace( '&#12387;&#12392;&#12353;', 'ttwa', $str2 );
  $str2 = str_replace( '&#12387;&#12392;&#12355;', 'ttwi', $str2 );
  $str2 = str_replace( '&#12387;&#12392;&#12357;', 'ttwu', $str2 );
  $str2 = str_replace( '&#12387;&#12392;&#12359;', 'ttwe', $str2 );
  $str2 = str_replace( '&#12387;&#12392;&#12361;', 'ttwo', $str2 );
  $str2 = str_replace( '&#12387;&#12391;&#12419;', 'ddha', $str2 );
  $str2 = str_replace( '&#12387;&#12391;&#12355;', 'ddhi', $str2 );
  $str2 = str_replace( '&#12387;&#12391;&#12421;', 'ddhu', $str2 );
  $str2 = str_replace( '&#12387;&#12391;&#12359;', 'ddhe', $str2 );
  $str2 = str_replace( '&#12387;&#12391;&#12423;', 'ddho', $str2 );
  $str2 = str_replace( '&#12387;&#12393;&#12353;', 'ddwa', $str2 );
  $str2 = str_replace( '&#12387;&#12393;&#12355;', 'ddwi', $str2 );
  $str2 = str_replace( '&#12387;&#12393;&#12357;', 'ddwu', $str2 );
  $str2 = str_replace( '&#12387;&#12393;&#12359;', 'ddwe', $str2 );
  $str2 = str_replace( '&#12387;&#12393;&#12361;', 'ddwo', $str2 );
  $str2 = str_replace( '&#12387;&#12402;&#12419;', 'hhya', $str2 );
  $str2 = str_replace( '&#12387;&#12402;&#12355;', 'hhyi', $str2 );
  $str2 = str_replace( '&#12387;&#12402;&#12421;', 'hhyu', $str2 );
  $str2 = str_replace( '&#12387;&#12402;&#12359;', 'hhye', $str2 );
  $str2 = str_replace( '&#12387;&#12402;&#12423;', 'hhyo', $str2 );
  $str2 = str_replace( '&#12387;&#12405;&#12419;', 'ffya', $str2 );

  #$str2 = str_replace("&#12387;&#12405;&#12355;", "ffyi", $str2);
  $str2 = str_replace( '&#12387;&#12405;&#12421;', 'ffyu', $str2 );

  #$str2 = str_replace("&#12387;&#12405;&#12359;", "ffye", $str2);
  $str2 = str_replace( '&#12387;&#12405;&#12423;', 'ffyo', $str2 );
  $str2 = str_replace( '&#12387;&#12405;&#12353;', 'ffwa', $str2 );
  $str2 = str_replace( '&#12387;&#12405;&#12355;', 'ffwi', $str2 );
  $str2 = str_replace( '&#12387;&#12405;&#12357;', 'ffwu', $str2 );
  $str2 = str_replace( '&#12387;&#12405;&#12359;', 'ffwe', $str2 );
  $str2 = str_replace( '&#12387;&#12405;&#12361;', 'ffwo', $str2 );
  $str2 = str_replace( '&#12387;&#12403;&#12419;', 'bbya', $str2 );
  $str2 = str_replace( '&#12387;&#12403;&#12355;', 'bbyi', $str2 );
  $str2 = str_replace( '&#12387;&#12403;&#12421;', 'bbyu', $str2 );
  $str2 = str_replace( '&#12387;&#12403;&#12359;', 'bbye', $str2 );
  $str2 = str_replace( '&#12387;&#12403;&#12423;', 'bbyo', $str2 );
  $str2 = str_replace( '&#12387;&#12532;&#12419;', 'vvya', $str2 );
  $str2 = str_replace( '&#12387;&#12532;&#12421;', 'vvyu', $str2 );
  $str2 = str_replace( '&#12387;&#12532;&#12423;', 'vvyo', $str2 );
  $str2 = str_replace( '&#12387;&#12404;&#12419;', 'ppya', $str2 );
  $str2 = str_replace( '&#12387;&#12404;&#12355;', 'ppyi', $str2 );
  $str2 = str_replace( '&#12387;&#12404;&#12421;', 'ppyu', $str2 );
  $str2 = str_replace( '&#12387;&#12404;&#12359;', 'ppye', $str2 );
  $str2 = str_replace( '&#12387;&#12404;&#12423;', 'ppyo', $str2 );
  $str2 = str_replace( '&#12387;&#12415;&#12419;', 'mmya', $str2 );
  $str2 = str_replace( '&#12387;&#12415;&#12355;', 'mmyi', $str2 );
  $str2 = str_replace( '&#12387;&#12415;&#12421;', 'mmyu', $str2 );
  $str2 = str_replace( '&#12387;&#12415;&#12359;', 'mmye', $str2 );
  $str2 = str_replace( '&#12387;&#12415;&#12423;', 'mmyo', $str2 );
  $str2 = str_replace( '&#12387;&#12426;&#12419;', 'rrya', $str2 );
  $str2 = str_replace( '&#12387;&#12426;&#12355;', 'rryi', $str2 );
  $str2 = str_replace( '&#12387;&#12426;&#12421;', 'rryu', $str2 );
  $str2 = str_replace( '&#12387;&#12426;&#12359;', 'rrye', $str2 );
  $str2 = str_replace( '&#12387;&#12426;&#12423;', 'rryo', $str2 );
  $str2 = str_replace( '&#12387;&#12532;&#12353;', 'vva', $str2 );
  $str2 = str_replace( '&#12387;&#12532;&#12355;', 'vvi', $str2 );
  $str2 = str_replace( '&#12387;&#12532;&#12359;', 'vve', $str2 );
  $str2 = str_replace( '&#12387;&#12532;&#12361;', 'vvo', $str2 );
  // Hepburn system
  $str2 = str_replace( '&#12387;&#12375;&#12419;', 'ssha', $str2 );
  $str2 = str_replace( '&#12387;&#12375;&#12421;', 'sshu', $str2 );
  $str2 = str_replace( '&#12387;&#12375;&#12359;', 'sshe', $str2 );
  $str2 = str_replace( '&#12387;&#12375;&#12423;', 'ssho', $str2 );
  $str2 = str_replace( '&#12387;&#12376;&#12419;', 'jja', $str2 );
  $str2 = str_replace( '&#12387;&#12376;&#12355;', 'jjyi', $str2 );
  $str2 = str_replace( '&#12387;&#12376;&#12421;', 'jju', $str2 );
  $str2 = str_replace( '&#12387;&#12376;&#12359;', 'jje', $str2 );
  $str2 = str_replace( '&#12387;&#12376;&#12423;', 'jjo', $str2 );
  $str2 = str_replace( '&#12387;&#12385;&#12419;', 'tcha', $str2 );
  $str2 = str_replace( '&#12387;&#12385;&#12355;', 'ccyi', $str2 );
  $str2 = str_replace( '&#12387;&#12385;&#12421;', 'tchu', $str2 );
  $str2 = str_replace( '&#12387;&#12385;&#12359;', 'tche', $str2 );
  $str2 = str_replace( '&#12387;&#12385;&#12423;', 'tcho', $str2 );
  $str2 = str_replace( '&#12387;&#12386;&#12419;', 'jja', $str2 );
  $str2 = str_replace( '&#12387;&#12386;&#12355;', 'jjyi', $str2 );
  $str2 = str_replace( '&#12387;&#12386;&#12421;', 'jju', $str2 );
  $str2 = str_replace( '&#12387;&#12386;&#12359;', 'jje', $str2 );
  $str2 = str_replace( '&#12387;&#12386;&#12423;', 'jjo', $str2 );
  $str2 = str_replace( '&#12435;&#12404;&#12419;', 'mpya', $str2 );
  $str2 = str_replace( '&#12435;&#12404;&#12355;', 'mpyi', $str2 );
  $str2 = str_replace( '&#12435;&#12404;&#12421;', 'mpyu', $str2 );
  $str2 = str_replace( '&#12435;&#12404;&#12359;', 'mpye', $str2 );
  $str2 = str_replace( '&#12435;&#12404;&#12423;', 'mpyo', $str2 );
  $str2 = str_replace( '&#12435;&#12403;&#12419;', 'mbya', $str2 );
  $str2 = str_replace( '&#12435;&#12403;&#12355;', 'mbyi', $str2 );
  $str2 = str_replace( '&#12435;&#12403;&#12421;', 'mbyu', $str2 );
  $str2 = str_replace( '&#12435;&#12403;&#12359;', 'mbye', $str2 );
  $str2 = str_replace( '&#12435;&#12403;&#12423;', 'mbyo', $str2 );
  $str2 = str_replace( '&#12435;&#12415;&#12419;', 'mmya', $str2 );
  $str2 = str_replace( '&#12435;&#12415;&#12355;', 'mmyi', $str2 );
  $str2 = str_replace( '&#12435;&#12415;&#12421;', 'mmyu', $str2 );
  $str2 = str_replace( '&#12435;&#12415;&#12359;', 'mmye', $str2 );
  $str2 = str_replace( '&#12435;&#12415;&#12423;', 'mmyo', $str2 );
  $str2 = str_replace( '&#12435;&#12354;', 'n\'a', $str2 );
  $str2 = str_replace( '&#12435;&#12356;', 'n\'i', $str2 );
  $str2 = str_replace( '&#12435;&#12358;', 'n\'u', $str2 );
  $str2 = str_replace( '&#12435;&#12360;', 'n\'e', $str2 );
  $str2 = str_replace( '&#12435;&#12362;', 'n\'o', $str2 );
  $str2 = str_replace( '&#12435;&#12420;', 'n\'ya', $str2 );
  $str2 = str_replace( '&#12435;&#12422;', 'n\'yu', $str2 );
  $str2 = str_replace( '&#12435;&#12424;', 'n\'yo', $str2 );
  $str2 = str_replace( '&#12356;&#12359;', 'ye', $str2 );
  $str2 = str_replace( '&#12358;&#12353;', 'wha', $str2 );
  $str2 = str_replace( '&#12358;&#12355;', 'whi', $str2 );
  $str2 = str_replace( '&#12358;&#12359;', 'whe', $str2 );
  $str2 = str_replace( '&#12358;&#12361;', 'who', $str2 );
  $str2 = str_replace( '&#12365;&#12419;', 'kya', $str2 );
  $str2 = str_replace( '&#12365;&#12355;', 'kyi', $str2 );
  $str2 = str_replace( '&#12365;&#12421;', 'kyu', $str2 );
  $str2 = str_replace( '&#12365;&#12359;', 'kye', $str2 );
  $str2 = str_replace( '&#12365;&#12423;', 'kyo', $str2 );
  $str2 = str_replace( '&#12367;&#12419;', 'qya', $str2 );
  $str2 = str_replace( '&#12367;&#12355;', 'qyi', $str2 );
  $str2 = str_replace( '&#12367;&#12421;', 'qyu', $str2 );
  $str2 = str_replace( '&#12367;&#12359;', 'qye', $str2 );
  $str2 = str_replace( '&#12367;&#12423;', 'qyo', $str2 );
  $str2 = str_replace( '&#12367;&#12353;', 'qwa', $str2 );
  $str2 = str_replace( '&#12367;&#12355;', 'qwi', $str2 );
  $str2 = str_replace( '&#12367;&#12357;', 'qwu', $str2 );
  $str2 = str_replace( '&#12367;&#12359;', 'qwe', $str2 );
  $str2 = str_replace( '&#12367;&#12361;', 'qwo', $str2 );
  $str2 = str_replace( '&#12366;&#12419;', 'gya', $str2 );
  $str2 = str_replace( '&#12366;&#12355;', 'gyi', $str2 );
  $str2 = str_replace( '&#12366;&#12421;', 'gyu', $str2 );
  $str2 = str_replace( '&#12366;&#12359;', 'gye', $str2 );
  $str2 = str_replace( '&#12366;&#12423;', 'gyo', $str2 );
  $str2 = str_replace( '&#12368;&#12353;', 'gwa', $str2 );
  $str2 = str_replace( '&#12368;&#12355;', 'gwi', $str2 );
  $str2 = str_replace( '&#12368;&#12357;', 'gwu', $str2 );
  $str2 = str_replace( '&#12368;&#12359;', 'gwe', $str2 );
  $str2 = str_replace( '&#12368;&#12361;', 'gwo', $str2 );
  $str2 = str_replace( '&#12375;&#12355;', 'syi', $str2 );
  $str2 = str_replace( '&#12377;&#12353;', 'swa', $str2 );
  $str2 = str_replace( '&#12377;&#12355;', 'swi', $str2 );
  $str2 = str_replace( '&#12377;&#12357;', 'swu', $str2 );
  $str2 = str_replace( '&#12377;&#12359;', 'swe', $str2 );
  $str2 = str_replace( '&#12377;&#12361;', 'swo', $str2 );
  $str2 = str_replace( '&#12388;&#12353;', 'tsa', $str2 );
  $str2 = str_replace( '&#12388;&#12355;', 'tsi', $str2 );
  $str2 = str_replace( '&#12388;&#12359;', 'tse', $str2 );
  $str2 = str_replace( '&#12388;&#12361;', 'tso', $str2 );
  $str2 = str_replace( '&#12390;&#12419;', 'tha', $str2 );
  $str2 = str_replace( '&#12390;&#12355;', 'thi', $str2 );
  $str2 = str_replace( '&#12390;&#12421;', 'thu', $str2 );
  $str2 = str_replace( '&#12390;&#12359;', 'the', $str2 );
  $str2 = str_replace( '&#12390;&#12423;', 'tho', $str2 );
  $str2 = str_replace( '&#12392;&#12353;', 'twa', $str2 );
  $str2 = str_replace( '&#12392;&#12355;', 'twi', $str2 );
  $str2 = str_replace( '&#12392;&#12357;', 'twu', $str2 );
  $str2 = str_replace( '&#12392;&#12359;', 'twe', $str2 );
  $str2 = str_replace( '&#12392;&#12361;', 'two', $str2 );
  $str2 = str_replace( '&#12391;&#12419;', 'dha', $str2 );
  $str2 = str_replace( '&#12391;&#12355;', 'dhi', $str2 );
  $str2 = str_replace( '&#12391;&#12421;', 'dhu', $str2 );
  $str2 = str_replace( '&#12391;&#12359;', 'dhe', $str2 );
  $str2 = str_replace( '&#12391;&#12423;', 'dho', $str2 );
  $str2 = str_replace( '&#12393;&#12353;', 'dwa', $str2 );
  $str2 = str_replace( '&#12393;&#12355;', 'dwi', $str2 );
  $str2 = str_replace( '&#12393;&#12357;', 'dwu', $str2 );
  $str2 = str_replace( '&#12393;&#12359;', 'dwe', $str2 );
  $str2 = str_replace( '&#12393;&#12361;', 'dwo', $str2 );
  $str2 = str_replace( '&#12395;&#12419;', 'nya', $str2 );
  $str2 = str_replace( '&#12395;&#12355;', 'nyi', $str2 );
  $str2 = str_replace( '&#12395;&#12421;', 'nyu', $str2 );
  $str2 = str_replace( '&#12395;&#12359;', 'nye', $str2 );
  $str2 = str_replace( '&#12395;&#12423;', 'nyo', $str2 );
  $str2 = str_replace( '&#12402;&#12419;', 'hya', $str2 );
  $str2 = str_replace( '&#12402;&#12355;', 'hyi', $str2 );
  $str2 = str_replace( '&#12402;&#12421;', 'hyu', $str2 );
  $str2 = str_replace( '&#12402;&#12359;', 'hye', $str2 );
  $str2 = str_replace( '&#12402;&#12423;', 'hyo', $str2 );
  $str2 = str_replace( '&#12405;&#12419;', 'fya', $str2 );
  $str2 = str_replace( '&#12405;&#12355;', 'fyi', $str2 );

  #$str2 = str_replace("&#12405;&#12421;", "fyu", $str2);
  $str2 = str_replace( '&#12405;&#12359;', 'fye', $str2 );

  #$str2 = str_replace("&#12405;&#12423;", "fyo", $str2);
  $str2 = str_replace( '&#12405;&#12353;', 'fwa', $str2 );
  $str2 = str_replace( '&#12405;&#12355;', 'fwi', $str2 );
  $str2 = str_replace( '&#12405;&#12357;', 'fwu', $str2 );
  $str2 = str_replace( '&#12405;&#12359;', 'fwe', $str2 );
  $str2 = str_replace( '&#12405;&#12361;', 'fwo', $str2 );
  $str2 = str_replace( '&#12403;&#12419;', 'bya', $str2 );
  $str2 = str_replace( '&#12403;&#12355;', 'byi', $str2 );
  $str2 = str_replace( '&#12403;&#12421;', 'byu', $str2 );
  $str2 = str_replace( '&#12403;&#12359;', 'bye', $str2 );
  $str2 = str_replace( '&#12403;&#12423;', 'byo', $str2 );
  $str2 = str_replace( '&#12532;&#12419;', 'vya', $str2 );
  $str2 = str_replace( '&#12532;&#12421;', 'vyu', $str2 );
  $str2 = str_replace( '&#12532;&#12423;', 'vyo', $str2 );
  $str2 = str_replace( '&#12404;&#12419;', 'pya', $str2 );
  $str2 = str_replace( '&#12404;&#12355;', 'pyi', $str2 );
  $str2 = str_replace( '&#12404;&#12421;', 'pyu', $str2 );
  $str2 = str_replace( '&#12404;&#12359;', 'pye', $str2 );
  $str2 = str_replace( '&#12404;&#12423;', 'pyo', $str2 );
  $str2 = str_replace( '&#12415;&#12419;', 'mya', $str2 );
  $str2 = str_replace( '&#12415;&#12355;', 'myi', $str2 );
  $str2 = str_replace( '&#12415;&#12421;', 'myu', $str2 );
  $str2 = str_replace( '&#12415;&#12359;', 'mye', $str2 );
  $str2 = str_replace( '&#12415;&#12423;', 'myo', $str2 );
  $str2 = str_replace( '&#12426;&#12419;', 'rya', $str2 );
  $str2 = str_replace( '&#12426;&#12355;', 'ryi', $str2 );
  $str2 = str_replace( '&#12426;&#12421;', 'ryu', $str2 );
  $str2 = str_replace( '&#12426;&#12359;', 'rye', $str2 );
  $str2 = str_replace( '&#12426;&#12423;', 'ryo', $str2 );
  $str2 = str_replace( '&#12532;&#12353;', 'va', $str2 );
  $str2 = str_replace( '&#12532;&#12355;', 'vi', $str2 );
  $str2 = str_replace( '&#12532;&#12359;', 've', $str2 );
  $str2 = str_replace( '&#12532;&#12361;', 'vo', $str2 );
  $str2 = str_replace( '&#12387;&#12532;', 'vvu', $str2 );
  $str2 = str_replace( '&#12387;&#12363;', 'kka', $str2 );
  $str2 = str_replace( '&#12387;&#12365;', 'kki', $str2 );
  $str2 = str_replace( '&#12387;&#12367;', 'kku', $str2 );
  $str2 = str_replace( '&#12387;&#12369;', 'kke', $str2 );
  $str2 = str_replace( '&#12387;&#12371;', 'kko', $str2 );
  $str2 = str_replace( '&#12387;&#12364;', 'gga', $str2 );
  $str2 = str_replace( '&#12387;&#12366;', 'ggi', $str2 );
  $str2 = str_replace( '&#12387;&#12368;', 'ggu', $str2 );
  $str2 = str_replace( '&#12387;&#12370;', 'gge', $str2 );
  $str2 = str_replace( '&#12387;&#12372;', 'ggo', $str2 );
  $str2 = str_replace( '&#12387;&#12373;', 'ssa', $str2 );
  $str2 = str_replace( '&#12387;&#12377;', 'ssu', $str2 );
  $str2 = str_replace( '&#12387;&#12379;', 'sse', $str2 );
  $str2 = str_replace( '&#12387;&#12381;', 'sso', $str2 );
  $str2 = str_replace( '&#12387;&#12374;', 'zza', $str2 );
  $str2 = str_replace( '&#12387;&#12378;', 'zzu', $str2 );
  $str2 = str_replace( '&#12387;&#12380;', 'zze', $str2 );
  $str2 = str_replace( '&#12387;&#12382;', 'zzo', $str2 );
  $str2 = str_replace( '&#12387;&#12383;', 'tta', $str2 );
  $str2 = str_replace( '&#12387;&#12390;', 'tte', $str2 );
  $str2 = str_replace( '&#12387;&#12392;', 'tto', $str2 );
  $str2 = str_replace( '&#12387;&#12384;', 'dda', $str2 );
  $str2 = str_replace( '&#12387;&#12391;', 'dde', $str2 );
  $str2 = str_replace( '&#12387;&#12393;', 'ddo', $str2 );
  $str2 = str_replace( '&#12387;&#12399;', 'hha', $str2 );
  $str2 = str_replace( '&#12387;&#12402;', 'hhi', $str2 );
  $str2 = str_replace( '&#12387;&#12408;', 'hhe', $str2 );
  $str2 = str_replace( '&#12387;&#12411;', 'hho', $str2 );
  $str2 = str_replace( '&#12387;&#12400;', 'bba', $str2 );
  $str2 = str_replace( '&#12387;&#12403;', 'bbi', $str2 );
  $str2 = str_replace( '&#12387;&#12406;', 'bbu', $str2 );
  $str2 = str_replace( '&#12387;&#12409;', 'bbe', $str2 );
  $str2 = str_replace( '&#12387;&#12412;', 'bbo', $str2 );
  $str2 = str_replace( '&#12387;&#12401;', 'ppa', $str2 );
  $str2 = str_replace( '&#12387;&#12404;', 'ppi', $str2 );
  $str2 = str_replace( '&#12387;&#12407;', 'ppu', $str2 );
  $str2 = str_replace( '&#12387;&#12410;', 'ppe', $str2 );
  $str2 = str_replace( '&#12387;&#12413;', 'ppo', $str2 );
  $str2 = str_replace( '&#12387;&#12414;', 'mma', $str2 );
  $str2 = str_replace( '&#12387;&#12415;', 'mmi', $str2 );
  $str2 = str_replace( '&#12387;&#12416;', 'mmu', $str2 );
  $str2 = str_replace( '&#12387;&#12417;', 'mme', $str2 );
  $str2 = str_replace( '&#12387;&#12418;', 'mmo', $str2 );
  $str2 = str_replace( '&#12387;&#12420;', 'yya', $str2 );
  $str2 = str_replace( '&#12387;&#12422;', 'yyu', $str2 );
  $str2 = str_replace( '&#12387;&#12424;', 'yyo', $str2 );
  $str2 = str_replace( '&#12387;&#12425;', 'rra', $str2 );
  $str2 = str_replace( '&#12387;&#12426;', 'rri', $str2 );
  $str2 = str_replace( '&#12387;&#12427;', 'rru', $str2 );
  $str2 = str_replace( '&#12387;&#12428;', 'rre', $str2 );
  $str2 = str_replace( '&#12387;&#12429;', 'rro', $str2 );
  $str2 = str_replace( '&#12387;&#12431;', 'wwa', $str2 );
  $str2 = str_replace( '&#12387;&#12434;', 'wwo', $str2 );
  $str2 = str_replace( '&#12387;&#12435;', 'xxn', $str2 );
  $str2 = str_replace( '&#12387;&#12430;', 'llwa', $str2 );
  $str2 = str_replace( '&#12387;&#12353;', 'lla', $str2 );
  $str2 = str_replace( '&#12387;&#12355;', 'lli', $str2 );
  $str2 = str_replace( '&#12387;&#12357;', 'llu', $str2 );
  $str2 = str_replace( '&#12387;&#12359;', 'lle', $str2 );
  $str2 = str_replace( '&#12387;&#12361;', 'llo', $str2 );
  $str2 = str_replace( '&#12387;&#12419;', 'llya', $str2 );
  $str2 = str_replace( '&#12387;&#12355;', 'llyi', $str2 );
  $str2 = str_replace( '&#12387;&#12421;', 'llyu', $str2 );
  $str2 = str_replace( '&#12387;&#12359;', 'llye', $str2 );
  $str2 = str_replace( '&#12387;&#12423;', 'llyo', $str2 );
  // Hepburn system
  $str2 = str_replace( '&#12375;&#12419;', 'sha', $str2 );
  $str2 = str_replace( '&#12375;&#12421;', 'shu', $str2 );
  $str2 = str_replace( '&#12375;&#12359;', 'she', $str2 );
  $str2 = str_replace( '&#12375;&#12423;', 'sho', $str2 );
  $str2 = str_replace( '&#12376;&#12419;', 'ja', $str2 );
  $str2 = str_replace( '&#12376;&#12355;', 'jyi', $str2 );
  $str2 = str_replace( '&#12376;&#12421;', 'ju', $str2 );
  $str2 = str_replace( '&#12376;&#12359;', 'je', $str2 );
  $str2 = str_replace( '&#12376;&#12423;', 'jo', $str2 );
  $str2 = str_replace( '&#12385;&#12419;', 'cha', $str2 );
  $str2 = str_replace( '&#12385;&#12355;', 'cyi', $str2 );
  $str2 = str_replace( '&#12385;&#12421;', 'chu', $str2 );
  $str2 = str_replace( '&#12385;&#12359;', 'che', $str2 );
  $str2 = str_replace( '&#12385;&#12423;', 'cho', $str2 );
  $str2 = str_replace( '&#12386;&#12419;', 'ja', $str2 );
  $str2 = str_replace( '&#12386;&#12355;', 'jyi', $str2 );
  $str2 = str_replace( '&#12386;&#12421;', 'ju', $str2 );
  $str2 = str_replace( '&#12386;&#12359;', 'je', $str2 );
  $str2 = str_replace( '&#12386;&#12423;', 'jo', $str2 );
  $str2 = str_replace( '&#12387;&#12375;', 'sshi', $str2 );
  $str2 = str_replace( '&#12387;&#12376;', 'jji', $str2 );
  $str2 = str_replace( '&#12387;&#12385;', 'tchi', $str2 );
  $str2 = str_replace( '&#12387;&#12388;', 'ttsu', $str2 );
  $str2 = str_replace( '&#12387;&#12386;', 'jji', $str2 );
  $str2 = str_replace( '&#12387;&#12389;', 'zzu', $str2 );
  $str2 = str_replace( '&#12387;&#12405;', 'ffu', $str2 );
  $str2 = str_replace( '&#12435;&#12400;', 'mba', $str2 );
  $str2 = str_replace( '&#12435;&#12403;', 'mbi', $str2 );
  $str2 = str_replace( '&#12435;&#12406;', 'mbu', $str2 );
  $str2 = str_replace( '&#12435;&#12409;', 'mbe', $str2 );
  $str2 = str_replace( '&#12435;&#12412;', 'mbo', $str2 );
  $str2 = str_replace( '&#12435;&#12401;', 'mpa', $str2 );
  $str2 = str_replace( '&#12435;&#12404;', 'mpi', $str2 );
  $str2 = str_replace( '&#12435;&#12407;', 'mpu', $str2 );
  $str2 = str_replace( '&#12435;&#12410;', 'mpe', $str2 );
  $str2 = str_replace( '&#12435;&#12413;', 'mpo', $str2 );
  $str2 = str_replace( '&#12435;&#12414;', 'mma', $str2 );
  $str2 = str_replace( '&#12435;&#12415;', 'mmi', $str2 );
  $str2 = str_replace( '&#12435;&#12416;', 'mmu', $str2 );
  $str2 = str_replace( '&#12435;&#12417;', 'mme', $str2 );
  $str2 = str_replace( '&#12435;&#12418;', 'mmo', $str2 );
  $str2 = str_replace( '&#12387;&#12432;', 'WWI', $str2 );
  $str2 = str_replace( '&#12387;&#12433;', 'WWE', $str2 );
  $str2 = str_replace( '&#12532;', 'vu', $str2 );
  $str2 = str_replace( '&#12354;', 'a', $str2 );
  $str2 = str_replace( '&#12356;', 'i', $str2 );
  $str2 = str_replace( '&#12358;', 'u', $str2 );
  $str2 = str_replace( '&#12360;', 'e', $str2 );
  $str2 = str_replace( '&#12362;', 'o', $str2 );
  $str2 = str_replace( '&#12363;', 'ka', $str2 );
  $str2 = str_replace( '&#12365;', 'ki', $str2 );
  $str2 = str_replace( '&#12367;', 'ku', $str2 );
  $str2 = str_replace( '&#12369;', 'ke', $str2 );
  $str2 = str_replace( '&#12371;', 'ko', $str2 );
  $str2 = str_replace( '&#12364;', 'ga', $str2 );
  $str2 = str_replace( '&#12366;', 'gi', $str2 );
  $str2 = str_replace( '&#12368;', 'gu', $str2 );
  $str2 = str_replace( '&#12370;', 'ge', $str2 );
  $str2 = str_replace( '&#12372;', 'go', $str2 );
  $str2 = str_replace( '&#12373;', 'sa', $str2 );
  $str2 = str_replace( '&#12377;', 'su', $str2 );
  $str2 = str_replace( '&#12379;', 'se', $str2 );
  $str2 = str_replace( '&#12381;', 'so', $str2 );
  $str2 = str_replace( '&#12374;', 'za', $str2 );
  $str2 = str_replace( '&#12378;', 'zu', $str2 );
  $str2 = str_replace( '&#12380;', 'ze', $str2 );
  $str2 = str_replace( '&#12382;', 'zo', $str2 );
  $str2 = str_replace( '&#12383;', 'ta', $str2 );
  $str2 = str_replace( '&#12390;', 'te', $str2 );
  $str2 = str_replace( '&#12392;', 'to', $str2 );
  $str2 = str_replace( '&#12384;', 'da', $str2 );
  $str2 = str_replace( '&#12391;', 'de', $str2 );
  $str2 = str_replace( '&#12393;', 'do', $str2 );
  $str2 = str_replace( '&#12394;', 'na', $str2 );
  $str2 = str_replace( '&#12395;', 'ni', $str2 );
  $str2 = str_replace( '&#12396;', 'nu', $str2 );
  $str2 = str_replace( '&#12397;', 'ne', $str2 );
  $str2 = str_replace( '&#12398;', 'no', $str2 );
  $str2 = str_replace( '&#12399;', 'ha', $str2 );
  $str2 = str_replace( '&#12402;', 'hi', $str2 );
  $str2 = str_replace( '&#12408;', 'he', $str2 );
  $str2 = str_replace( '&#12411;', 'ho', $str2 );
  $str2 = str_replace( '&#12400;', 'ba', $str2 );
  $str2 = str_replace( '&#12403;', 'bi', $str2 );
  $str2 = str_replace( '&#12406;', 'bu', $str2 );
  $str2 = str_replace( '&#12409;', 'be', $str2 );
  $str2 = str_replace( '&#12412;', 'bo', $str2 );
  $str2 = str_replace( '&#12401;', 'pa', $str2 );
  $str2 = str_replace( '&#12404;', 'pi', $str2 );
  $str2 = str_replace( '&#12407;', 'pu', $str2 );
  $str2 = str_replace( '&#12410;', 'pe', $str2 );
  $str2 = str_replace( '&#12413;', 'po', $str2 );
  $str2 = str_replace( '&#12414;', 'ma', $str2 );
  $str2 = str_replace( '&#12415;', 'mi', $str2 );
  $str2 = str_replace( '&#12416;', 'mu', $str2 );
  $str2 = str_replace( '&#12417;', 'me', $str2 );
  $str2 = str_replace( '&#12418;', 'mo', $str2 );
  $str2 = str_replace( '&#12420;', 'ya', $str2 );
  $str2 = str_replace( '&#12422;', 'yu', $str2 );
  $str2 = str_replace( '&#12424;', 'yo', $str2 );
  $str2 = str_replace( '&#12425;', 'ra', $str2 );
  $str2 = str_replace( '&#12426;', 'ri', $str2 );
  $str2 = str_replace( '&#12427;', 'ru', $str2 );
  $str2 = str_replace( '&#12428;', 're', $str2 );
  $str2 = str_replace( '&#12429;', 'ro', $str2 );
  $str2 = str_replace( '&#12431;', 'wa', $str2 );
  $str2 = str_replace( '&#12434;', 'wo', $str2 );
  $str2 = str_replace( '&#12435;', 'n', $str2 );
  $str2 = str_replace( '&#12430;', 'lwa', $str2 );
  $str2 = str_replace( '&#12353;', 'la', $str2 );
  $str2 = str_replace( '&#12355;', 'li', $str2 );
  $str2 = str_replace( '&#12357;', 'lu', $str2 );
  $str2 = str_replace( '&#12359;', 'le', $str2 );
  $str2 = str_replace( '&#12361;', 'lo', $str2 );
  $str2 = str_replace( '&#12419;', 'lya', $str2 );
  $str2 = str_replace( '&#12355;', 'lyi', $str2 );
  $str2 = str_replace( '&#12421;', 'lyu', $str2 );
  $str2 = str_replace( '&#12359;', 'lye', $str2 );
  $str2 = str_replace( '&#12423;', 'lyo', $str2 );
  $str2 = str_replace( '&#12533;', 'lka', $str2 );
  $str2 = str_replace( '&#12534;', 'lke', $str2 );
  // Hepburn system
  $str2 = str_replace( '&#12375;', 'shi', $str2 );
  $str2 = str_replace( '&#12376;', 'ji', $str2 );
  $str2 = str_replace( '&#12385;', 'chi', $str2 );
  $str2 = str_replace( '&#12388;', 'tsu', $str2 );
  $str2 = str_replace( '&#12386;', 'ji', $str2 );
  $str2 = str_replace( '&#12389;', 'zu', $str2 );
  $str2 = str_replace( '&#12405;', 'fu', $str2 );
  $str2 = str_replace( '&#12387;', 'ltsu', $str2 );
  $str2 = str_replace( '&#12432;', 'WI', $str2 );
  $str2 = str_replace( '&#12433;', 'WE', $str2 );
  return $str2;
}

/**
 * convert Japanese Katakana to Roma-ji
 *
 * @access private
 * @param string $str input string
 * @return string converted string
 */
function _xnparticleKatakana2Roma( $str ) {
  $str2 = $str;
  $str2 = str_replace( '&#12450;&#12450;', '&#12450;^', $str2 );
  $str2 = str_replace( '&#12452;&#12452;', '&#12452;^', $str2 );
  $str2 = str_replace( '&#12454;&#12454;', '&#12454;^', $str2 );
  $str2 = str_replace( '&#12456;&#12456;', '&#12456;^', $str2 );
  $str2 = str_replace( '&#12458;&#12458;', '&#12458;^', $str2 );
  $str2 = str_replace( '&#12458;&#12454;', '&#12458;^', $str2 );
  $str2 = str_replace( '&#12459;&#12450;', '&#12459;^', $str2 );
  $str2 = str_replace( '&#12461;&#12452;', '&#12461;^', $str2 );
  $str2 = str_replace( '&#12463;&#12454;', '&#12463;^', $str2 );
  $str2 = str_replace( '&#12465;&#12456;', '&#12465;^', $str2 );
  $str2 = str_replace( '&#12467;&#12458;', '&#12467;^', $str2 );
  $str2 = str_replace( '&#12467;&#12454;', '&#12467;^', $str2 );
  $str2 = str_replace( '&#12460;&#12450;', '&#12460;^', $str2 );
  $str2 = str_replace( '&#12462;&#12452;', '&#12462;^', $str2 );
  $str2 = str_replace( '&#12464;&#12454;', '&#12464;^', $str2 );
  $str2 = str_replace( '&#12466;&#12456;', '&#12466;^', $str2 );
  $str2 = str_replace( '&#12468;&#12458;', '&#12468;^', $str2 );
  $str2 = str_replace( '&#12468;&#12454;', '&#12468;^', $str2 );
  $str2 = str_replace( '&#12469;&#12450;', '&#12469;^', $str2 );
  $str2 = str_replace( '&#12471;&#12452;', '&#12471;^', $str2 );
  $str2 = str_replace( '&#12473;&#12454;', '&#12473;^', $str2 );
  $str2 = str_replace( '&#12475;&#12456;', '&#12475;^', $str2 );
  $str2 = str_replace( '&#12477;&#12458;', '&#12477;^', $str2 );
  $str2 = str_replace( '&#12477;&#12454;', '&#12477;^', $str2 );
  $str2 = str_replace( '&#12470;&#12450;', '&#12470;^', $str2 );
  $str2 = str_replace( '&#12472;&#12452;', '&#12472;^', $str2 );
  $str2 = str_replace( '&#12474;&#12454;', '&#12474;^', $str2 );
  $str2 = str_replace( '&#12476;&#12456;', '&#12476;^', $str2 );
  $str2 = str_replace( '&#12478;&#12458;', '&#12478;^', $str2 );
  $str2 = str_replace( '&#12478;&#12454;', '&#12478;^', $str2 );
  $str2 = str_replace( '&#12479;&#12450;', '&#12479;^', $str2 );
  $str2 = str_replace( '&#12481;&#12452;', '&#12481;^', $str2 );
  $str2 = str_replace( '&#12484;&#12454;', '&#12484;^', $str2 );
  $str2 = str_replace( '&#12486;&#12456;', '&#12486;^', $str2 );
  $str2 = str_replace( '&#12488;&#12458;', '&#12488;^', $str2 );
  $str2 = str_replace( '&#12488;&#12454;', '&#12488;^', $str2 );
  $str2 = str_replace( '&#12480;&#12450;', '&#12480;^', $str2 );
  $str2 = str_replace( '&#12482;&#12452;', '&#12482;^', $str2 );
  $str2 = str_replace( '&#12485;&#12454;', '&#12485;^', $str2 );
  $str2 = str_replace( '&#12487;&#12456;', '&#12487;^', $str2 );
  $str2 = str_replace( '&#12489;&#12458;', '&#12489;^', $str2 );
  $str2 = str_replace( '&#12489;&#12454;', '&#12489;^', $str2 );
  $str2 = str_replace( '&#12490;&#12450;', '&#12490;^', $str2 );
  $str2 = str_replace( '&#12491;&#12452;', '&#12491;^', $str2 );
  $str2 = str_replace( '&#12492;&#12454;', '&#12492;^', $str2 );
  $str2 = str_replace( '&#12493;&#12456;', '&#12493;^', $str2 );
  $str2 = str_replace( '&#12494;&#12458;', '&#12494;^', $str2 );
  $str2 = str_replace( '&#12494;&#12454;', '&#12494;^', $str2 );
  $str2 = str_replace( '&#12495;&#12450;', '&#12495;^', $str2 );
  $str2 = str_replace( '&#12498;&#12452;', '&#12498;^', $str2 );
  $str2 = str_replace( '&#12501;&#12454;', '&#12501;^', $str2 );
  $str2 = str_replace( '&#12504;&#12456;', '&#12504;^', $str2 );
  $str2 = str_replace( '&#12507;&#12458;', '&#12507;^', $str2 );
  $str2 = str_replace( '&#12507;&#12454;', '&#12507;^', $str2 );
  $str2 = str_replace( '&#12496;&#12450;', '&#12496;^', $str2 );
  $str2 = str_replace( '&#12499;&#12452;', '&#12499;^', $str2 );
  $str2 = str_replace( '&#12502;&#12454;', '&#12502;^', $str2 );
  $str2 = str_replace( '&#12505;&#12456;', '&#12505;^', $str2 );
  $str2 = str_replace( '&#12508;&#12458;', '&#12508;^', $str2 );
  $str2 = str_replace( '&#12508;&#12454;', '&#12508;^', $str2 );
  $str2 = str_replace( '&#12497;&#12450;', '&#12497;^', $str2 );
  $str2 = str_replace( '&#12500;&#12452;', '&#12500;^', $str2 );
  $str2 = str_replace( '&#12503;&#12454;', '&#12503;^', $str2 );
  $str2 = str_replace( '&#12506;&#12456;', '&#12506;^', $str2 );
  $str2 = str_replace( '&#12509;&#12458;', '&#12509;^', $str2 );
  $str2 = str_replace( '&#12509;&#12454;', '&#12509;^', $str2 );
  $str2 = str_replace( '&#12510;&#12450;', '&#12510;^', $str2 );
  $str2 = str_replace( '&#12511;&#12452;', '&#12511;^', $str2 );
  $str2 = str_replace( '&#12512;&#12454;', '&#12512;^', $str2 );
  $str2 = str_replace( '&#12513;&#12456;', '&#12513;^', $str2 );
  $str2 = str_replace( '&#12514;&#12458;', '&#12514;^', $str2 );
  $str2 = str_replace( '&#12514;&#12454;', '&#12514;^', $str2 );
  $str2 = str_replace( '&#12516;&#12450;', '&#12516;^', $str2 );
  $str2 = str_replace( '&#12515;&#12450;', '&#12515;^', $str2 );
  $str2 = str_replace( '&#12518;&#12454;', '&#12518;^', $str2 );
  $str2 = str_replace( '&#12517;&#12454;', '&#12517;^', $str2 );
  $str2 = str_replace( '&#12520;&#12458;', '&#12520;^', $str2 );
  $str2 = str_replace( '&#12519;&#12458;', '&#12519;^', $str2 );
  $str2 = str_replace( '&#12520;&#12454;', '&#12520;^', $str2 );
  $str2 = str_replace( '&#12519;&#12454;', '&#12519;^', $str2 );
  $str2 = str_replace( '&#12521;&#12450;', '&#12521;^', $str2 );
  $str2 = str_replace( '&#12522;&#12452;', '&#12522;^', $str2 );
  $str2 = str_replace( '&#12523;&#12454;', '&#12523;^', $str2 );
  $str2 = str_replace( '&#12524;&#12456;', '&#12524;^', $str2 );
  $str2 = str_replace( '&#12525;&#12458;', '&#12525;^', $str2 );
  $str2 = str_replace( '&#12525;&#12454;', '&#12525;^', $str2 );
  $str2 = str_replace( '&#12527;&#12450;', '&#12527;^', $str2 );
  $str2 = str_replace( '&#12530;&#12458;', '&#12530;^', $str2 );
  $str2 = str_replace( '&#12530;&#12454;', '&#12530;^', $str2 );
  $str2 = str_replace( '&#12483;&#12452;&#12455;', 'yye', $str2 );
  $str2 = str_replace( '&#12483;&#12454;&#12449;', 'wwha', $str2 );
  $str2 = str_replace( '&#12483;&#12454;&#12451;', 'wwhi', $str2 );
  $str2 = str_replace( '&#12483;&#12454;&#12455;', 'wwhe', $str2 );
  $str2 = str_replace( '&#12483;&#12454;&#12457;', 'wwho', $str2 );
  $str2 = str_replace( '&#12483;&#12461;&#12515;', 'kkya', $str2 );
  $str2 = str_replace( '&#12483;&#12461;&#12451;', 'kkyi', $str2 );
  $str2 = str_replace( '&#12483;&#12461;&#12517;', 'kkyu', $str2 );
  $str2 = str_replace( '&#12483;&#12461;&#12455;', 'kkye', $str2 );
  $str2 = str_replace( '&#12483;&#12461;&#12519;', 'kkyo', $str2 );
  $str2 = str_replace( '&#12483;&#12463;&#12515;', 'qqya', $str2 );
  $str2 = str_replace( '&#12483;&#12463;&#12451;', 'qqyi', $str2 );
  $str2 = str_replace( '&#12483;&#12463;&#12517;', 'qqyu', $str2 );
  $str2 = str_replace( '&#12483;&#12463;&#12455;', 'qqye', $str2 );
  $str2 = str_replace( '&#12483;&#12463;&#12519;', 'qqyo', $str2 );
  $str2 = str_replace( '&#12483;&#12463;&#12449;', 'qqwa', $str2 );
  $str2 = str_replace( '&#12483;&#12463;&#12451;', 'qqwi', $str2 );
  $str2 = str_replace( '&#12483;&#12463;&#12453;', 'qqwu', $str2 );
  $str2 = str_replace( '&#12483;&#12463;&#12455;', 'qqwe', $str2 );
  $str2 = str_replace( '&#12483;&#12463;&#12457;', 'qqwo', $str2 );
  $str2 = str_replace( '&#12483;&#12462;&#12515;', 'ggya', $str2 );
  $str2 = str_replace( '&#12483;&#12462;&#12451;', 'ggyi', $str2 );
  $str2 = str_replace( '&#12483;&#12462;&#12517;', 'ggyu', $str2 );
  $str2 = str_replace( '&#12483;&#12462;&#12455;', 'ggye', $str2 );
  $str2 = str_replace( '&#12483;&#12462;&#12519;', 'ggyo', $str2 );
  $str2 = str_replace( '&#12483;&#12464;&#12449;', 'ggwa', $str2 );
  $str2 = str_replace( '&#12483;&#12464;&#12451;', 'ggwi', $str2 );
  $str2 = str_replace( '&#12483;&#12464;&#12453;', 'ggwu', $str2 );
  $str2 = str_replace( '&#12483;&#12464;&#12455;', 'ggwe', $str2 );
  $str2 = str_replace( '&#12483;&#12464;&#12457;', 'ggwo', $str2 );
  $str2 = str_replace( '&#12483;&#12471;&#12451;', 'ssyi', $str2 );
  $str2 = str_replace( '&#12483;&#12473;&#12449;', 'sswa', $str2 );
  $str2 = str_replace( '&#12483;&#12473;&#12451;', 'sswi', $str2 );
  $str2 = str_replace( '&#12483;&#12473;&#12453;', 'sswu', $str2 );
  $str2 = str_replace( '&#12483;&#12473;&#12455;', 'sswe', $str2 );
  $str2 = str_replace( '&#12483;&#12473;&#12457;', 'sswo', $str2 );
  $str2 = str_replace( '&#12483;&#12484;&#12449;', 'ttsa', $str2 );
  $str2 = str_replace( '&#12483;&#12484;&#12451;', 'ttsi', $str2 );
  $str2 = str_replace( '&#12483;&#12484;&#12455;', 'ttse', $str2 );
  $str2 = str_replace( '&#12483;&#12484;&#12457;', 'ttso', $str2 );
  $str2 = str_replace( '&#12483;&#12486;&#12515;', 'ttha', $str2 );
  $str2 = str_replace( '&#12483;&#12486;&#12451;', 'tthi', $str2 );
  $str2 = str_replace( '&#12483;&#12486;&#12517;', 'tthu', $str2 );
  $str2 = str_replace( '&#12483;&#12486;&#12455;', 'tthe', $str2 );
  $str2 = str_replace( '&#12483;&#12486;&#12519;', 'ttho', $str2 );
  $str2 = str_replace( '&#12483;&#12488;&#12449;', 'ttwa', $str2 );
  $str2 = str_replace( '&#12483;&#12488;&#12451;', 'ttwi', $str2 );
  $str2 = str_replace( '&#12483;&#12488;&#12453;', 'ttwu', $str2 );
  $str2 = str_replace( '&#12483;&#12488;&#12455;', 'ttwe', $str2 );
  $str2 = str_replace( '&#12483;&#12488;&#12457;', 'ttwo', $str2 );
  $str2 = str_replace( '&#12483;&#12487;&#12515;', 'ddha', $str2 );
  $str2 = str_replace( '&#12483;&#12487;&#12451;', 'ddhi', $str2 );
  $str2 = str_replace( '&#12483;&#12487;&#12517;', 'ddhu', $str2 );
  $str2 = str_replace( '&#12483;&#12487;&#12455;', 'ddhe', $str2 );
  $str2 = str_replace( '&#12483;&#12487;&#12519;', 'ddho', $str2 );
  $str2 = str_replace( '&#12483;&#12489;&#12449;', 'ddwa', $str2 );
  $str2 = str_replace( '&#12483;&#12489;&#12451;', 'ddwi', $str2 );
  $str2 = str_replace( '&#12483;&#12489;&#12453;', 'ddwu', $str2 );
  $str2 = str_replace( '&#12483;&#12489;&#12455;', 'ddwe', $str2 );
  $str2 = str_replace( '&#12483;&#12489;&#12457;', 'ddwo', $str2 );
  $str2 = str_replace( '&#12483;&#12498;&#12515;', 'hhya', $str2 );
  $str2 = str_replace( '&#12483;&#12498;&#12451;', 'hhyi', $str2 );
  $str2 = str_replace( '&#12483;&#12498;&#12517;', 'hhyu', $str2 );
  $str2 = str_replace( '&#12483;&#12498;&#12455;', 'hhye', $str2 );
  $str2 = str_replace( '&#12483;&#12498;&#12519;', 'hhyo', $str2 );
  $str2 = str_replace( '&#12483;&#12501;&#12515;', 'ffya', $str2 );

  #$str2 = str_replace("&#12483;&#12501;&#12451;", "ffyi", $str2);
  $str2 = str_replace( '&#12483;&#12501;&#12517;', 'ffyu', $str2 );

  #$str2 = str_replace("&#12483;&#12501;&#12455;", "ffye", $str2);
  $str2 = str_replace( '&#12483;&#12501;&#12519;', 'ffyo', $str2 );
  $str2 = str_replace( '&#12483;&#12501;&#12449;', 'ffwa', $str2 );
  $str2 = str_replace( '&#12483;&#12501;&#12451;', 'ffwi', $str2 );
  $str2 = str_replace( '&#12483;&#12501;&#12453;', 'ffwu', $str2 );
  $str2 = str_replace( '&#12483;&#12501;&#12455;', 'ffwe', $str2 );
  $str2 = str_replace( '&#12483;&#12501;&#12457;', 'ffwo', $str2 );
  $str2 = str_replace( '&#12483;&#12499;&#12515;', 'bbya', $str2 );
  $str2 = str_replace( '&#12483;&#12499;&#12451;', 'bbyi', $str2 );
  $str2 = str_replace( '&#12483;&#12499;&#12517;', 'bbyu', $str2 );
  $str2 = str_replace( '&#12483;&#12499;&#12455;', 'bbye', $str2 );
  $str2 = str_replace( '&#12483;&#12499;&#12519;', 'bbyo', $str2 );
  $str2 = str_replace( '&#12483;&#12532;&#12515;', 'vvya', $str2 );
  $str2 = str_replace( '&#12483;&#12532;&#12517;', 'vvyu', $str2 );
  $str2 = str_replace( '&#12483;&#12532;&#12519;', 'vvyo', $str2 );
  $str2 = str_replace( '&#12483;&#12500;&#12515;', 'ppya', $str2 );
  $str2 = str_replace( '&#12483;&#12500;&#12451;', 'ppyi', $str2 );
  $str2 = str_replace( '&#12483;&#12500;&#12517;', 'ppyu', $str2 );
  $str2 = str_replace( '&#12483;&#12500;&#12455;', 'ppye', $str2 );
  $str2 = str_replace( '&#12483;&#12500;&#12519;', 'ppyo', $str2 );
  $str2 = str_replace( '&#12483;&#12511;&#12515;', 'mmya', $str2 );
  $str2 = str_replace( '&#12483;&#12511;&#12451;', 'mmyi', $str2 );
  $str2 = str_replace( '&#12483;&#12511;&#12517;', 'mmyu', $str2 );
  $str2 = str_replace( '&#12483;&#12511;&#12455;', 'mmye', $str2 );
  $str2 = str_replace( '&#12483;&#12511;&#12519;', 'mmyo', $str2 );
  $str2 = str_replace( '&#12483;&#12522;&#12515;', 'rrya', $str2 );
  $str2 = str_replace( '&#12483;&#12522;&#12451;', 'rryi', $str2 );
  $str2 = str_replace( '&#12483;&#12522;&#12517;', 'rryu', $str2 );
  $str2 = str_replace( '&#12483;&#12522;&#12455;', 'rrye', $str2 );
  $str2 = str_replace( '&#12483;&#12522;&#12519;', 'rryo', $str2 );
  $str2 = str_replace( '&#12483;&#12532;&#12449;', 'vva', $str2 );
  $str2 = str_replace( '&#12483;&#12532;&#12451;', 'vvi', $str2 );
  $str2 = str_replace( '&#12483;&#12532;&#12455;', 'vve', $str2 );
  $str2 = str_replace( '&#12483;&#12532;&#12457;', 'vvo', $str2 );
  // Hepburn system
  $str2 = str_replace( '&#12483;&#12471;&#12515;', 'ssha', $str2 );
  $str2 = str_replace( '&#12483;&#12471;&#12517;', 'sshu', $str2 );
  $str2 = str_replace( '&#12483;&#12471;&#12455;', 'sshe', $str2 );
  $str2 = str_replace( '&#12483;&#12471;&#12519;', 'ssho', $str2 );
  $str2 = str_replace( '&#12483;&#12472;&#12515;', 'jja', $str2 );
  $str2 = str_replace( '&#12483;&#12472;&#12451;', 'jjyi', $str2 );
  $str2 = str_replace( '&#12483;&#12472;&#12517;', 'jju', $str2 );
  $str2 = str_replace( '&#12483;&#12472;&#12455;', 'jje', $str2 );
  $str2 = str_replace( '&#12483;&#12472;&#12519;', 'jjo', $str2 );
  $str2 = str_replace( '&#12483;&#12481;&#12515;', 'tcha', $str2 );
  $str2 = str_replace( '&#12483;&#12481;&#12451;', 'ccyi', $str2 );
  $str2 = str_replace( '&#12483;&#12481;&#12517;', 'tchu', $str2 );
  $str2 = str_replace( '&#12483;&#12481;&#12455;', 'tche', $str2 );
  $str2 = str_replace( '&#12483;&#12481;&#12519;', 'tcho', $str2 );
  $str2 = str_replace( '&#12483;&#12482;&#12515;', 'jja', $str2 );
  $str2 = str_replace( '&#12483;&#12482;&#12451;', 'jjyi', $str2 );
  $str2 = str_replace( '&#12483;&#12482;&#12517;', 'jju', $str2 );
  $str2 = str_replace( '&#12483;&#12482;&#12455;', 'jje', $str2 );
  $str2 = str_replace( '&#12483;&#12482;&#12519;', 'jjo', $str2 );
  $str2 = str_replace( '&#12531;&#12499;&#12515;', 'mbya', $str2 );
  $str2 = str_replace( '&#12531;&#12499;&#12451;', 'mbyi', $str2 );
  $str2 = str_replace( '&#12531;&#12499;&#12517;', 'mbyu', $str2 );
  $str2 = str_replace( '&#12531;&#12499;&#12455;', 'mbye', $str2 );
  $str2 = str_replace( '&#12531;&#12499;&#12519;', 'mbyo', $str2 );
  $str2 = str_replace( '&#12531;&#12500;&#12515;', 'mpya', $str2 );
  $str2 = str_replace( '&#12531;&#12500;&#12451;', 'mpyi', $str2 );
  $str2 = str_replace( '&#12531;&#12500;&#12517;', 'mpyu', $str2 );
  $str2 = str_replace( '&#12531;&#12500;&#12455;', 'mpye', $str2 );
  $str2 = str_replace( '&#12531;&#12500;&#12519;', 'mpyo', $str2 );
  $str2 = str_replace( '&#12531;&#12511;&#12515;', 'mmya', $str2 );
  $str2 = str_replace( '&#12531;&#12511;&#12451;', 'mmyi', $str2 );
  $str2 = str_replace( '&#12531;&#12511;&#12517;', 'mmyu', $str2 );
  $str2 = str_replace( '&#12531;&#12511;&#12455;', 'mmye', $str2 );
  $str2 = str_replace( '&#12531;&#12511;&#12519;', 'mmyo', $str2 );
  $str2 = str_replace( '&#12531;&#12450;', 'n\'a', $str2 );
  $str2 = str_replace( '&#12531;&#12452;', 'n\'i', $str2 );
  $str2 = str_replace( '&#12531;&#12454;', 'n\'u', $str2 );
  $str2 = str_replace( '&#12531;&#12456;', 'n\'e', $str2 );
  $str2 = str_replace( '&#12531;&#12458;', 'n\'o', $str2 );
  $str2 = str_replace( '&#12531;&#12516;', 'n\'ya', $str2 );
  $str2 = str_replace( '&#12531;&#12518;', 'n\'yu', $str2 );
  $str2 = str_replace( '&#12531;&#12520;', 'n\'yo', $str2 );
  $str2 = str_replace( '&#12452;&#12455;', 'ye', $str2 );
  $str2 = str_replace( '&#12454;&#12449;', 'wha', $str2 );
  $str2 = str_replace( '&#12454;&#12451;', 'whi', $str2 );
  $str2 = str_replace( '&#12454;&#12455;', 'whe', $str2 );
  $str2 = str_replace( '&#12454;&#12457;', 'who', $str2 );
  $str2 = str_replace( '&#12461;&#12515;', 'kya', $str2 );
  $str2 = str_replace( '&#12461;&#12451;', 'kyi', $str2 );
  $str2 = str_replace( '&#12461;&#12517;', 'kyu', $str2 );
  $str2 = str_replace( '&#12461;&#12455;', 'kye', $str2 );
  $str2 = str_replace( '&#12461;&#12519;', 'kyo', $str2 );
  $str2 = str_replace( '&#12463;&#12515;', 'qya', $str2 );
  $str2 = str_replace( '&#12463;&#12451;', 'qyi', $str2 );
  $str2 = str_replace( '&#12463;&#12517;', 'qyu', $str2 );
  $str2 = str_replace( '&#12463;&#12455;', 'qye', $str2 );
  $str2 = str_replace( '&#12463;&#12519;', 'qyo', $str2 );
  $str2 = str_replace( '&#12463;&#12449;', 'qwa', $str2 );
  $str2 = str_replace( '&#12463;&#12451;', 'qwi', $str2 );
  $str2 = str_replace( '&#12463;&#12453;', 'qwu', $str2 );
  $str2 = str_replace( '&#12463;&#12455;', 'qwe', $str2 );
  $str2 = str_replace( '&#12463;&#12457;', 'qwo', $str2 );
  $str2 = str_replace( '&#12462;&#12515;', 'gya', $str2 );
  $str2 = str_replace( '&#12462;&#12451;', 'gyi', $str2 );
  $str2 = str_replace( '&#12462;&#12517;', 'gyu', $str2 );
  $str2 = str_replace( '&#12462;&#12455;', 'gye', $str2 );
  $str2 = str_replace( '&#12462;&#12519;', 'gyo', $str2 );
  $str2 = str_replace( '&#12464;&#12449;', 'gwa', $str2 );
  $str2 = str_replace( '&#12464;&#12451;', 'gwi', $str2 );
  $str2 = str_replace( '&#12464;&#12453;', 'gwu', $str2 );
  $str2 = str_replace( '&#12464;&#12455;', 'gwe', $str2 );
  $str2 = str_replace( '&#12464;&#12457;', 'gwo', $str2 );
  $str2 = str_replace( '&#12471;&#12451;', 'syi', $str2 );
  $str2 = str_replace( '&#12473;&#12449;', 'swa', $str2 );
  $str2 = str_replace( '&#12473;&#12451;', 'swi', $str2 );
  $str2 = str_replace( '&#12473;&#12453;', 'swu', $str2 );
  $str2 = str_replace( '&#12473;&#12455;', 'swe', $str2 );
  $str2 = str_replace( '&#12473;&#12457;', 'swo', $str2 );
  $str2 = str_replace( '&#12484;&#12449;', 'tsa', $str2 );
  $str2 = str_replace( '&#12484;&#12451;', 'tsi', $str2 );
  $str2 = str_replace( '&#12484;&#12455;', 'tse', $str2 );
  $str2 = str_replace( '&#12484;&#12457;', 'tso', $str2 );
  $str2 = str_replace( '&#12486;&#12515;', 'tha', $str2 );
  $str2 = str_replace( '&#12486;&#12451;', 'thi', $str2 );
  $str2 = str_replace( '&#12486;&#12517;', 'thu', $str2 );
  $str2 = str_replace( '&#12486;&#12455;', 'the', $str2 );
  $str2 = str_replace( '&#12486;&#12519;', 'tho', $str2 );
  $str2 = str_replace( '&#12488;&#12449;', 'twa', $str2 );
  $str2 = str_replace( '&#12488;&#12451;', 'twi', $str2 );
  $str2 = str_replace( '&#12488;&#12453;', 'twu', $str2 );
  $str2 = str_replace( '&#12488;&#12455;', 'twe', $str2 );
  $str2 = str_replace( '&#12488;&#12457;', 'two', $str2 );
  $str2 = str_replace( '&#12487;&#12515;', 'dha', $str2 );
  $str2 = str_replace( '&#12487;&#12451;', 'dhi', $str2 );
  $str2 = str_replace( '&#12487;&#12517;', 'dhu', $str2 );
  $str2 = str_replace( '&#12487;&#12455;', 'dhe', $str2 );
  $str2 = str_replace( '&#12487;&#12519;', 'dho', $str2 );
  $str2 = str_replace( '&#12489;&#12449;', 'dwa', $str2 );
  $str2 = str_replace( '&#12489;&#12451;', 'dwi', $str2 );
  $str2 = str_replace( '&#12489;&#12453;', 'dwu', $str2 );
  $str2 = str_replace( '&#12489;&#12455;', 'dwe', $str2 );
  $str2 = str_replace( '&#12489;&#12457;', 'dwo', $str2 );
  $str2 = str_replace( '&#12491;&#12515;', 'nya', $str2 );
  $str2 = str_replace( '&#12491;&#12451;', 'nyi', $str2 );
  $str2 = str_replace( '&#12491;&#12517;', 'nyu', $str2 );
  $str2 = str_replace( '&#12491;&#12455;', 'nye', $str2 );
  $str2 = str_replace( '&#12491;&#12519;', 'nyo', $str2 );
  $str2 = str_replace( '&#12498;&#12515;', 'hya', $str2 );
  $str2 = str_replace( '&#12498;&#12451;', 'hyi', $str2 );
  $str2 = str_replace( '&#12498;&#12517;', 'hyu', $str2 );
  $str2 = str_replace( '&#12498;&#12455;', 'hye', $str2 );
  $str2 = str_replace( '&#12498;&#12519;', 'hyo', $str2 );
  $str2 = str_replace( '&#12501;&#12515;', 'fya', $str2 );

  #$str2 = str_replace("&#12501;&#12451;", "fyi", $str2);
  $str2 = str_replace( '&#12501;&#12517;', 'fyu', $str2 );

  #$str2 = str_replace("&#12501;&#12455;", "fye", $str2);
  $str2 = str_replace( '&#12501;&#12519;', 'fyo', $str2 );
  $str2 = str_replace( '&#12501;&#12449;', 'fwa', $str2 );
  $str2 = str_replace( '&#12501;&#12451;', 'fwi', $str2 );
  $str2 = str_replace( '&#12501;&#12453;', 'fwu', $str2 );
  $str2 = str_replace( '&#12501;&#12455;', 'fwe', $str2 );
  $str2 = str_replace( '&#12501;&#12457;', 'fwo', $str2 );
  $str2 = str_replace( '&#12499;&#12515;', 'bya', $str2 );
  $str2 = str_replace( '&#12499;&#12451;', 'byi', $str2 );
  $str2 = str_replace( '&#12499;&#12517;', 'byu', $str2 );
  $str2 = str_replace( '&#12499;&#12455;', 'bye', $str2 );
  $str2 = str_replace( '&#12499;&#12519;', 'byo', $str2 );
  $str2 = str_replace( '&#12532;&#12515;', 'vya', $str2 );
  $str2 = str_replace( '&#12532;&#12517;', 'vyu', $str2 );
  $str2 = str_replace( '&#12532;&#12519;', 'vyo', $str2 );
  $str2 = str_replace( '&#12500;&#12515;', 'pya', $str2 );
  $str2 = str_replace( '&#12500;&#12451;', 'pyi', $str2 );
  $str2 = str_replace( '&#12500;&#12517;', 'pyu', $str2 );
  $str2 = str_replace( '&#12500;&#12455;', 'pye', $str2 );
  $str2 = str_replace( '&#12500;&#12519;', 'pyo', $str2 );
  $str2 = str_replace( '&#12511;&#12515;', 'mya', $str2 );
  $str2 = str_replace( '&#12511;&#12451;', 'myi', $str2 );
  $str2 = str_replace( '&#12511;&#12517;', 'myu', $str2 );
  $str2 = str_replace( '&#12511;&#12455;', 'mye', $str2 );
  $str2 = str_replace( '&#12511;&#12519;', 'myo', $str2 );
  $str2 = str_replace( '&#12522;&#12515;', 'rya', $str2 );
  $str2 = str_replace( '&#12522;&#12451;', 'ryi', $str2 );
  $str2 = str_replace( '&#12522;&#12517;', 'ryu', $str2 );
  $str2 = str_replace( '&#12522;&#12455;', 'rye', $str2 );
  $str2 = str_replace( '&#12522;&#12519;', 'ryo', $str2 );
  $str2 = str_replace( '&#12532;&#12449;', 'va', $str2 );
  $str2 = str_replace( '&#12532;&#12451;', 'vi', $str2 );
  $str2 = str_replace( '&#12532;&#12455;', 've', $str2 );
  $str2 = str_replace( '&#12532;&#12457;', 'vo', $str2 );
  $str2 = str_replace( '&#12483;&#12532;', 'vvu', $str2 );
  $str2 = str_replace( '&#12483;&#12459;', 'kka', $str2 );
  $str2 = str_replace( '&#12483;&#12461;', 'kki', $str2 );
  $str2 = str_replace( '&#12483;&#12463;', 'kku', $str2 );
  $str2 = str_replace( '&#12483;&#12465;', 'kke', $str2 );
  $str2 = str_replace( '&#12483;&#12467;', 'kko', $str2 );
  $str2 = str_replace( '&#12483;&#12460;', 'gga', $str2 );
  $str2 = str_replace( '&#12483;&#12462;', 'ggi', $str2 );
  $str2 = str_replace( '&#12483;&#12464;', 'ggu', $str2 );
  $str2 = str_replace( '&#12483;&#12466;', 'gge', $str2 );
  $str2 = str_replace( '&#12483;&#12468;', 'ggo', $str2 );
  $str2 = str_replace( '&#12483;&#12469;', 'ssa', $str2 );
  $str2 = str_replace( '&#12483;&#12473;', 'ssu', $str2 );
  $str2 = str_replace( '&#12483;&#12475;', 'sse', $str2 );
  $str2 = str_replace( '&#12483;&#12477;', 'sso', $str2 );
  $str2 = str_replace( '&#12483;&#12470;', 'zza', $str2 );
  $str2 = str_replace( '&#12483;&#12474;', 'zzu', $str2 );
  $str2 = str_replace( '&#12483;&#12476;', 'zze', $str2 );
  $str2 = str_replace( '&#12483;&#12478;', 'zzo', $str2 );
  $str2 = str_replace( '&#12483;&#12479;', 'tta', $str2 );
  $str2 = str_replace( '&#12483;&#12486;', 'tte', $str2 );
  $str2 = str_replace( '&#12483;&#12488;', 'tto', $str2 );
  $str2 = str_replace( '&#12483;&#12480;', 'dda', $str2 );
  $str2 = str_replace( '&#12483;&#12487;', 'dde', $str2 );
  $str2 = str_replace( '&#12483;&#12489;', 'ddo', $str2 );
  $str2 = str_replace( '&#12483;&#12495;', 'hha', $str2 );
  $str2 = str_replace( '&#12483;&#12498;', 'hhi', $str2 );
  $str2 = str_replace( '&#12483;&#12504;', 'hhe', $str2 );
  $str2 = str_replace( '&#12483;&#12507;', 'hho', $str2 );
  $str2 = str_replace( '&#12483;&#12496;', 'bba', $str2 );
  $str2 = str_replace( '&#12483;&#12499;', 'bbi', $str2 );
  $str2 = str_replace( '&#12483;&#12502;', 'bbu', $str2 );
  $str2 = str_replace( '&#12483;&#12505;', 'bbe', $str2 );
  $str2 = str_replace( '&#12483;&#12508;', 'bbo', $str2 );
  $str2 = str_replace( '&#12483;&#12497;', 'ppa', $str2 );
  $str2 = str_replace( '&#12483;&#12500;', 'ppi', $str2 );
  $str2 = str_replace( '&#12483;&#12503;', 'ppu', $str2 );
  $str2 = str_replace( '&#12483;&#12506;', 'ppe', $str2 );
  $str2 = str_replace( '&#12483;&#12509;', 'ppo', $str2 );
  $str2 = str_replace( '&#12483;&#12510;', 'mma', $str2 );
  $str2 = str_replace( '&#12483;&#12511;', 'mmi', $str2 );
  $str2 = str_replace( '&#12483;&#12512;', 'mmu', $str2 );
  $str2 = str_replace( '&#12483;&#12513;', 'mme', $str2 );
  $str2 = str_replace( '&#12483;&#12514;', 'mmo', $str2 );
  $str2 = str_replace( '&#12483;&#12516;', 'yya', $str2 );
  $str2 = str_replace( '&#12483;&#12518;', 'yyu', $str2 );
  $str2 = str_replace( '&#12483;&#12520;', 'yyo', $str2 );
  $str2 = str_replace( '&#12483;&#12521;', 'rra', $str2 );
  $str2 = str_replace( '&#12483;&#12522;', 'rri', $str2 );
  $str2 = str_replace( '&#12483;&#12523;', 'rru', $str2 );
  $str2 = str_replace( '&#12483;&#12524;', 'rre', $str2 );
  $str2 = str_replace( '&#12483;&#12525;', 'rro', $str2 );
  $str2 = str_replace( '&#12483;&#12527;', 'wwa', $str2 );
  $str2 = str_replace( '&#12483;&#12530;', 'wwo', $str2 );
  $str2 = str_replace( '&#12483;&#12531;', 'xxn', $str2 );
  $str2 = str_replace( '&#12483;&#12526;', 'llwa', $str2 );
  $str2 = str_replace( '&#12483;&#12449;', 'lla', $str2 );
  $str2 = str_replace( '&#12483;&#12451;', 'lli', $str2 );
  $str2 = str_replace( '&#12483;&#12453;', 'llu', $str2 );
  $str2 = str_replace( '&#12483;&#12455;', 'lle', $str2 );
  $str2 = str_replace( '&#12483;&#12457;', 'llo', $str2 );
  $str2 = str_replace( '&#12483;&#12515;', 'llya', $str2 );
  $str2 = str_replace( '&#12483;&#12451;', 'llyi', $str2 );
  $str2 = str_replace( '&#12483;&#12517;', 'llyu', $str2 );
  $str2 = str_replace( '&#12483;&#12455;', 'llye', $str2 );
  $str2 = str_replace( '&#12483;&#12519;', 'llyo', $str2 );
  // Hepburn system
  $str2 = str_replace( '&#12471;&#12515;', 'sha', $str2 );
  $str2 = str_replace( '&#12471;&#12517;', 'shu', $str2 );
  $str2 = str_replace( '&#12471;&#12455;', 'she', $str2 );
  $str2 = str_replace( '&#12471;&#12519;', 'sho', $str2 );
  $str2 = str_replace( '&#12472;&#12515;', 'ja', $str2 );
  $str2 = str_replace( '&#12472;&#12451;', 'jyi', $str2 );
  $str2 = str_replace( '&#12472;&#12517;', 'ju', $str2 );
  $str2 = str_replace( '&#12472;&#12455;', 'je', $str2 );
  $str2 = str_replace( '&#12472;&#12519;', 'jo', $str2 );
  $str2 = str_replace( '&#12481;&#12515;', 'cha', $str2 );
  $str2 = str_replace( '&#12481;&#12451;', 'cyi', $str2 );
  $str2 = str_replace( '&#12481;&#12517;', 'chu', $str2 );
  $str2 = str_replace( '&#12481;&#12455;', 'che', $str2 );
  $str2 = str_replace( '&#12481;&#12519;', 'cho', $str2 );
  $str2 = str_replace( '&#12482;&#12515;', 'ja', $str2 );
  $str2 = str_replace( '&#12482;&#12451;', 'jyi', $str2 );
  $str2 = str_replace( '&#12482;&#12517;', 'ju', $str2 );
  $str2 = str_replace( '&#12482;&#12455;', 'je', $str2 );
  $str2 = str_replace( '&#12482;&#12519;', 'jo', $str2 );
  $str2 = str_replace( '&#12483;&#12471;', 'sshi', $str2 );
  $str2 = str_replace( '&#12483;&#12472;', 'jji', $str2 );
  $str2 = str_replace( '&#12483;&#12481;', 'tchi', $str2 );
  $str2 = str_replace( '&#12483;&#12484;', 'ttsu', $str2 );
  $str2 = str_replace( '&#12483;&#12482;', 'jji', $str2 );
  $str2 = str_replace( '&#12483;&#12485;', 'zzu', $str2 );
  $str2 = str_replace( '&#12483;&#12501;', 'ffu', $str2 );
  $str2 = str_replace( '&#12531;&#12496;', 'mba', $str2 );
  $str2 = str_replace( '&#12531;&#12499;', 'mbi', $str2 );
  $str2 = str_replace( '&#12531;&#12502;', 'mbu', $str2 );
  $str2 = str_replace( '&#12531;&#12505;', 'mbe', $str2 );
  $str2 = str_replace( '&#12531;&#12508;', 'mbo', $str2 );
  $str2 = str_replace( '&#12531;&#12497;', 'mpa', $str2 );
  $str2 = str_replace( '&#12531;&#12500;', 'mpi', $str2 );
  $str2 = str_replace( '&#12531;&#12503;', 'mpu', $str2 );
  $str2 = str_replace( '&#12531;&#12506;', 'mpe', $str2 );
  $str2 = str_replace( '&#12531;&#12509;', 'mpo', $str2 );
  $str2 = str_replace( '&#12531;&#12510;', 'mma', $str2 );
  $str2 = str_replace( '&#12531;&#12511;', 'mmi', $str2 );
  $str2 = str_replace( '&#12531;&#12512;', 'mmu', $str2 );
  $str2 = str_replace( '&#12531;&#12513;', 'mme', $str2 );
  $str2 = str_replace( '&#12531;&#12514;', 'mmo', $str2 );
  $str2 = str_replace( '&#12483;&#12528;', 'WWI', $str2 );
  $str2 = str_replace( '&#12483;&#12529;', 'WWE', $str2 );
  $str2 = str_replace( '&#12532;', 'vu', $str2 );
  $str2 = str_replace( '&#12450;', 'a', $str2 );
  $str2 = str_replace( '&#12452;', 'i', $str2 );
  $str2 = str_replace( '&#12454;', 'u', $str2 );
  $str2 = str_replace( '&#12456;', 'e', $str2 );
  $str2 = str_replace( '&#12458;', 'o', $str2 );
  $str2 = str_replace( '&#12459;', 'ka', $str2 );
  $str2 = str_replace( '&#12461;', 'ki', $str2 );
  $str2 = str_replace( '&#12463;', 'ku', $str2 );
  $str2 = str_replace( '&#12465;', 'ke', $str2 );
  $str2 = str_replace( '&#12467;', 'ko', $str2 );
  $str2 = str_replace( '&#12460;', 'ga', $str2 );
  $str2 = str_replace( '&#12462;', 'gi', $str2 );
  $str2 = str_replace( '&#12464;', 'gu', $str2 );
  $str2 = str_replace( '&#12466;', 'ge', $str2 );
  $str2 = str_replace( '&#12468;', 'go', $str2 );
  $str2 = str_replace( '&#12469;', 'sa', $str2 );
  $str2 = str_replace( '&#12473;', 'su', $str2 );
  $str2 = str_replace( '&#12475;', 'se', $str2 );
  $str2 = str_replace( '&#12477;', 'so', $str2 );
  $str2 = str_replace( '&#12470;', 'za', $str2 );
  $str2 = str_replace( '&#12474;', 'zu', $str2 );
  $str2 = str_replace( '&#12476;', 'ze', $str2 );
  $str2 = str_replace( '&#12478;', 'zo', $str2 );
  $str2 = str_replace( '&#12479;', 'ta', $str2 );
  $str2 = str_replace( '&#12486;', 'te', $str2 );
  $str2 = str_replace( '&#12488;', 'to', $str2 );
  $str2 = str_replace( '&#12480;', 'da', $str2 );
  $str2 = str_replace( '&#12487;', 'de', $str2 );
  $str2 = str_replace( '&#12489;', 'do', $str2 );
  $str2 = str_replace( '&#12490;', 'na', $str2 );
  $str2 = str_replace( '&#12491;', 'ni', $str2 );
  $str2 = str_replace( '&#12492;', 'nu', $str2 );
  $str2 = str_replace( '&#12493;', 'ne', $str2 );
  $str2 = str_replace( '&#12494;', 'no', $str2 );
  $str2 = str_replace( '&#12495;', 'ha', $str2 );
  $str2 = str_replace( '&#12498;', 'hi', $str2 );
  $str2 = str_replace( '&#12504;', 'he', $str2 );
  $str2 = str_replace( '&#12507;', 'ho', $str2 );
  $str2 = str_replace( '&#12496;', 'ba', $str2 );
  $str2 = str_replace( '&#12499;', 'bi', $str2 );
  $str2 = str_replace( '&#12502;', 'bu', $str2 );
  $str2 = str_replace( '&#12505;', 'be', $str2 );
  $str2 = str_replace( '&#12508;', 'bo', $str2 );
  $str2 = str_replace( '&#12497;', 'pa', $str2 );
  $str2 = str_replace( '&#12500;', 'pi', $str2 );
  $str2 = str_replace( '&#12503;', 'pu', $str2 );
  $str2 = str_replace( '&#12506;', 'pe', $str2 );
  $str2 = str_replace( '&#12509;', 'po', $str2 );
  $str2 = str_replace( '&#12510;', 'ma', $str2 );
  $str2 = str_replace( '&#12511;', 'mi', $str2 );
  $str2 = str_replace( '&#12512;', 'mu', $str2 );
  $str2 = str_replace( '&#12513;', 'me', $str2 );
  $str2 = str_replace( '&#12514;', 'mo', $str2 );
  $str2 = str_replace( '&#12516;', 'ya', $str2 );
  $str2 = str_replace( '&#12518;', 'yu', $str2 );
  $str2 = str_replace( '&#12520;', 'yo', $str2 );
  $str2 = str_replace( '&#12521;', 'ra', $str2 );
  $str2 = str_replace( '&#12522;', 'ri', $str2 );
  $str2 = str_replace( '&#12523;', 'ru', $str2 );
  $str2 = str_replace( '&#12524;', 're', $str2 );
  $str2 = str_replace( '&#12525;', 'ro', $str2 );
  $str2 = str_replace( '&#12527;', 'wa', $str2 );
  $str2 = str_replace( '&#12530;', 'wo', $str2 );
  $str2 = str_replace( '&#12531;', 'n', $str2 );
  $str2 = str_replace( '&#12526;', 'lwa', $str2 );
  $str2 = str_replace( '&#12449;', 'la', $str2 );
  $str2 = str_replace( '&#12451;', 'li', $str2 );
  $str2 = str_replace( '&#12453;', 'lu', $str2 );
  $str2 = str_replace( '&#12455;', 'le', $str2 );
  $str2 = str_replace( '&#12457;', 'lo', $str2 );
  $str2 = str_replace( '&#12515;', 'lya', $str2 );
  $str2 = str_replace( '&#12451;', 'lyi', $str2 );
  $str2 = str_replace( '&#12517;', 'lyu', $str2 );
  $str2 = str_replace( '&#12455;', 'lye', $str2 );
  $str2 = str_replace( '&#12519;', 'lyo', $str2 );
  $str2 = str_replace( '&#12533;', 'lka', $str2 );
  $str2 = str_replace( '&#12534;', 'lke', $str2 );
  $str2 = str_replace( '&#12471;', 'shi', $str2 );
  $str2 = str_replace( '&#12472;', 'ji', $str2 );
  $str2 = str_replace( '&#12481;', 'chi', $str2 );
  $str2 = str_replace( '&#12484;', 'tsu', $str2 );
  $str2 = str_replace( '&#12482;', 'ji', $str2 );
  $str2 = str_replace( '&#12485;', 'zu', $str2 );
  $str2 = str_replace( '&#12501;', 'fu', $str2 );
  $str2 = str_replace( '&#12483;', 'ltsu', $str2 );
  $str2 = str_replace( '&#12528;', 'WI', $str2 );
  $str2 = str_replace( '&#12529;', 'WE', $str2 );
  return $str2;
}

?>
