<?php
//  XooNIps article item type module
//  $Revision: 1.10 $
//  --------------------------------------------------------------------------
//  XooNIps Library Module Xoops modules for XooNIps Platforms
//  Copyright (C) 2006 Keio University and RIKEN, Japan. All rights reserved.
//  http://sourceforge.jp/projects/xoonips-library/
//  --------------------------------------------------------------------------
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//  --------------------------------------------------------------------------

if ( ! defined( 'XOOPS_ROOT_PATH' ) ) exit();

global $xoopsConfig;
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xnparticle/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xnparticle/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnparticle/language/english/main.php' );
}

include_once( XOOPS_ROOT_PATH.'/modules/xnparticle/include/include.php');
include_once XOOPS_ROOT_PATH . "/modules/xnparticle/class/xnparticle.php";


function xnparticleGetTypes(){
	return array( 'article'=>_MD_XNPARTICLE_ARTICLE_TYPE_ARTICLE_LABEL, 'review'=>_MD_XNPARTICLE_ARTICLE_TYPE_REVIEW_LABEL, 'other'=>_MD_XNPARTICLE_ARTICLE_TYPE_OTHER_LABEL );
}

function xnparticleTrimArray( $array_data ) {
        foreach( $array_data as $key => $val ) {
                $array_data[$key] = trim($val);
        }
        return $array_data;
}

function xnparticleDetailSubTitleString( $detail, $item_id ) {
	$detail_child_sub_title = xnparticleGetDetailChildSubTitleInformation( $item_id );
	$detail['sub_title_str'] = "<table border='0'>\n";
	$i = 0;
	while ( list( $key, list( $article_child_sub_title_id, $article_id, $sub_title_name, $sub_title_kana, $sub_title_romaji, $sub_title_order ) ) = each( $detail_child_sub_title ) ){
                $detail['sub_title_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>";
                //$detail['sub_title_str'] .= $sub_title_name." (".$sub_title_kana.":".$sub_title_romaji.")</td></tr>\n";
                $detail['sub_title_str'] .= $sub_title_name."</td></tr>\n";
		$i++;
	}
	$detail['sub_title_str'] .= "</table>";
	$detail['sub_title_cnt'] = strval(fmod($i, 2));
	if ($i == 0) {
		$detail['sub_title_str'] = "";
	}
	return $detail;
}

function xnparticleDetailAuthorString( $detail, $item_id ) {
	$detail_child_author = xnparticleGetDetailChildAuthorInformation( $item_id );
	$detail['author_str'] = "<table border='0'>\n";
	$i = 0;
	while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $detail_child_author ) ){
		$detail['author_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td colspan='2'>".$author_name;
                if(!empty($author_romaji)){
		    $detail['author_str'] .= "(".$author_romaji.")";
                }
                $detail['author_str'] .= "</td></tr>\n";
                if(!empty($author_affiliation) || !empty($author_affiliation_translation)){
                    if(!empty($author_affiliation) && !empty($author_affiliation_translation)){
		        $detail['author_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td colspan='2'>".$author_affiliation." (".$author_affiliation_translation.")</td></tr>\n";
                    }
                    else if(!empty($author_affiliation)){
		        $detail['author_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td colspan='2'>".$author_affiliation."</td></tr>\n";
                    }else if(!empty($author_affiliation_translation)){
		        $detail['author_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td colspan='2'>(".$author_affiliation_translation.")</td></tr>\n";
                    }
                }
                if(!empty($author_role)){
		$detail['author_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td width='20%'>"._MD_XNPARTICLE_AUTHOR_ROLE_LABEL."</td><td>:".$author_role."</td></tr>\n";
                }
                if(!empty($author_link)){
		$detail['author_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td width='20%'>"._MD_XNPARTICLE_AUTHOR_LINK_LABEL."</td><td>:<a href='".$author_link."' target='_new'>".$author_link."</a></td></tr>\n";
                }
		$i++;
	}
	$detail['author_str'] .= "</table>";
	$detail['author_cnt'] = strval(fmod($i, 2));
	if ($i == 0) {
		$detail['author_str'] = "";
	}
	return $detail;
}

function xnparticleDetailKeywordsString( $detail, $item_id ) {
	$detail_child_keywords = xnparticleGetDetailChildKeywordsInformation( $item_id );
	$detail['keyword_str'] = "<table>\n";
	$i = 0;
	while ( list( $key, list( $article_child_keywords_id, $article_id, $keywords, $keywords_order ) ) = each( $detail_child_keywords ) ){
		$detail['keyword_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$keywords."</td></tr>\n";
		$i++;
	}
	$detail['keyword_str'] .= "</table>";
	$detail['keywords_cnt'] = strval(fmod($i, 2));
	if ($i == 0) {
		$detail['keyword_str'] = "";
	}
	return $detail;
}

function xnparticleDetailNdcClassificationsString( $detail, $item_id ) {
	$detail_child_ndc_classifications = xnparticleGetDetailChildNdcClassificationsInformation( $item_id );
	$detail['ndc_classification_str'] = "<table>\n";
	$i = 0;
	while ( list( $key, list( $article_child_ndc_classifications_id, $article_id, $ndc_classifications, $ndc_classifications_order ) ) = each( $detail_child_ndc_classifications ) ){
		$detail['ndc_classification_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$ndc_classifications."</td></tr>\n";
		$i++;
	}
	$detail['ndc_classification_str'] .= "</table>";
	$detail['ndc_classifications_cnt'] = strval(fmod($i, 2));
	if ($i == 0) {
		$detail['ndc_classification_str'] = "";
	}
	return $detail;
}

function xnparticleDetailPhysicalDescriptionsString( $detail, $item_id ) {
        $detail_child_physical_descriptions = xnparticleGetDetailChildPhysicalDescriptionsInformation( $item_id );
        $detail['physical_description_str'] = "<table>\n";
        $i = 0;
        while ( list( $key, list( $article_child_physical_descriptions_id, $article_id, $physical_descriptions, $physical_descriptions_order ) ) = each( $detail_child_physical_descriptions ) ){
                $detail['physical_description_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$physical_descriptions."</td></tr>\n";
                $i++;
        }
        $detail['physical_description_str'] .= "</table>";
        $detail['physical_descriptions_cnt'] = strval(fmod($i, 2));
        if ($i == 0) {
                $detail['physical_description_str'] = "";
        }
        return $detail;
}

function xnparticleDetailLangsString( $detail, $item_id ) {
        $detail_child_langs = xnparticleGetDetailChildLangsInformation( $item_id );
        $detail['lang_str'] = "<table>\n";
        $i = 0;
        while ( list( $key, list( $article_child_langs_id, $article_id, $langs, $langs_order ) ) = each( $detail_child_langs ) ){
                $detail['lang_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$langs."</td></tr>\n";
                $i++;
        }
        $detail['lang_str'] .= "</table>";
        $detail['langs_cnt'] = strval(fmod($i, 2));
        if ($i == 0) {
                $detail['lang_str'] = "";
        }
        return $detail;
}

function xnparticleDetailIdIssnsString( $detail, $item_id ) {
        $detail_child_id_issns = xnparticleGetDetailChildIdIssnsInformation( $item_id );
        $detail['id_issn_str'] = "<table>\n";
        $i = 0;
        while ( list( $key, list( $article_child_id_issns_id, $article_id, $id_issns, $id_issns_order ) ) = each( $detail_child_id_issns ) ){
                $detail['id_issn_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$id_issns."</td></tr>\n";
                $i++;
                if(empty($id_issns))$i--;
        }
        $detail['id_issn_str'] .= "</table>";
        $detail['id_issns_cnt'] = strval(fmod($i, 2));
        if ($i == 0) {
                $detail['id_issn_str'] = "";
        }
        return $detail;
}

function xnparticleDetailIdIsbnsString( $detail, $item_id ) {
        $detail_child_id_isbns = xnparticleGetDetailChildIdIsbnsInformation( $item_id );
        $detail['id_isbn_str'] = "<table>\n";
        $i = 0;
        while ( list( $key, list( $article_child_id_isbns_id, $article_id, $id_isbns, $id_isbns_order ) ) = each( $detail_child_id_isbns ) ){
                $detail['id_isbn_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$id_isbns."</td></tr>\n";
                $i++;
                if(empty($id_isbns))$i--;
        }
        $detail['id_isbn_str'] .= "</table>";
        $detail['id_isbns_cnt'] = strval(fmod($i, 2));
        if ($i == 0) {
                $detail['id_isbn_str'] = "";
        }
        return $detail;
}

function xnparticleDetailIdDoisString( $detail, $item_id ) {
        $detail_child_id_dois = xnparticleGetDetailChildIdDoisInformation( $item_id );
        $detail['id_doi_str'] = "<table>\n";
        $i = 0;
        while ( list( $key, list( $article_child_id_dois_id, $article_id, $id_dois, $id_dois_order ) ) = each( $detail_child_id_dois ) ){
                $detail['id_doi_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$id_dois."</td></tr>\n";
                $i++;
                if(empty($id_dois))$i--;
        }
        $detail['id_doi_str'] .= "</table>";
        $detail['id_dois_cnt'] = strval(fmod($i, 2));
        if ($i == 0) {
                $detail['id_doi_str'] = "";
        }
        return $detail;
}

function xnparticleDetailIdUrisString( $detail, $item_id ) {
        $detail_child_id_uris = xnparticleGetDetailChildIdUrisInformation( $item_id );
        $detail['id_uri_str'] = "<table>\n";
        $i = 0;
        while ( list( $key, list( $article_child_id_uris_id, $article_id, $id_uris, $id_uris_order ) ) = each( $detail_child_id_uris ) ){
                $detail['id_uri_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$id_uris."</td></tr>\n";
                $i++;
                if(empty($id_uris))$i--;
        }
        $detail['id_uri_str'] .= "</table>";
        $detail['id_uris_cnt'] = strval(fmod($i, 2));
        if ($i == 0) {
                $detail['id_uri_str'] = "";
        }
        return $detail;
}

function xnparticleDetailIdLocalsString( $detail, $item_id ) {
        $detail_child_id_locals = xnparticleGetDetailChildIdLocalsInformation( $item_id );
        $detail['id_local_str'] = "<table>\n";
        $i = 0;
        while ( list( $key, list( $article_child_id_locals_id, $article_id, $id_locals, $id_locals_order ) ) = each( $detail_child_id_locals ) ){
                $detail['id_local_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$id_locals."</td></tr>\n";
                $i++;
                if(empty($id_locals))$i--;
        }
        $detail['id_local_str'] .= "</table>";
        $detail['id_locals_cnt'] = strval(fmod($i, 2));
        if ($i == 0) {
                $detail['id_local_str'] = "";
        }
        return $detail;
}

function xnparticleDetailUrisString( $detail, $item_id ) {
        $detail_child_uris = xnparticleGetDetailChildUrisInformation( $item_id );
        $detail['uri_str'] = "<table>\n";
        $i = 0;
        while ( list( $key, list( $article_child_uris_id, $article_id, $uris, $uris_order ) ) = each( $detail_child_uris ) ){
                $detail['uri_str'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$uris."</td></tr>\n";
                $i++;
                if(empty($uris))$i--;
        }
        $detail['uri_str'] .= "</table>";
        $detail['uris_cnt'] = strval(fmod($i, 2));
        if ($i == 0) {
                $detail['uri_str'] = "";
        }
        return $detail;
}

function xnparticleGetDetailChildHiddenStr( $item_id ) {
	$return_str = "";

	//detail_child_sub_title
	$detail_child_sub_title = xnparticleGetDetailChildSubTitleInformation( $item_id );
        $i = count($detail_child_sub_title);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_sub_title_name = "<input type='hidden' name='sub_title_name' value='";
		$str_sub_title_kana = "<input type='hidden' name='sub_title_kana' value='";
		$str_sub_title_romaji = "<input type='hidden' name='sub_title_romaji' value='";
		$str_sub_title_order = "<input type='hidden' name='sub_title_order' value='";
		while ( list( $key, list( $article_child_sub_title_id, $article_id, $sub_title_name, $sub_title_kana, $sub_title_romaji, $sub_title_order ) ) = each( $detail_child_sub_title ) ){
			if($j>0){
				$str_sub_title_name .= "\n";
				$str_sub_title_kana .= "\n";
				$str_sub_title_romaji .= "\n";
				$str_sub_title_order .= "\n";
			}
			$str_sub_title_name .= $sub_title_name;
			$str_sub_title_kana .= $sub_title_kana;
			$str_sub_title_romaji .= $sub_title_romaji;
			$str_sub_title_order .= $sub_title_order;
			$j++;
		}
		$str_sub_title_name .= "'>\n";
		$str_sub_title_kana .= "'>\n";
		$str_sub_title_romaji .= "'>\n";
		$str_sub_title_order .= "'>\n";
	}
	$return_str .= $str_sub_title_name.$str_sub_title_kana.$str_sub_title_romaji.$str_sub_title_order;

	//detail_child_author
	$detail_child_author = xnparticleGetDetailChildAuthorInformation( $item_id );
        $i = count($detail_child_author);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_author_id = "<input type='hidden' name='author_id' value='";
		$str_author_name = "<input type='hidden' name='author_name' value='";
		$str_author_kana = "<input type='hidden' name='author_kana' value='";
		$str_author_romaji = "<input type='hidden' name='author_romaji' value='";
		$str_author_affiliation = "<input type='hidden' name='author_affiliation' value='";
		$str_author_affiliation_translation = "<input type='hidden' name='author_affiliation_translation' value='";
		$str_author_role = "<input type='hidden' name='author_role' value='";
		$str_author_link = "<input type='hidden' name='author_link' value='";
		$str_author_order = "<input type='hidden' name='author_order' value='";
		while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $detail_child_author ) ){
			if($j>0){
				$str_author_id .= "\n";
				$str_author_name .= "\n";
				$str_author_kana .= "\n";
				$str_author_romaji .= "\n";
				$str_author_affiliation .= "\n";
				$str_author_affiliation_translation .= "\n";
				$str_author_role .= "\n";
				$str_author_link .= "\n";
				$str_author_order .= "\n";
			}

			$str_author_id .= $author_id;
			$str_author_name .= $author_name;
			$str_author_kana .= $author_kana;
			$str_author_romaji .= $author_romaji;
			$str_author_affiliation .= $author_affiliation;
			$str_author_affiliation_translation .= $author_affiliation_translation;
			$str_author_role .= $author_role;
			$str_author_link .= $author_link;
			$str_author_order .= $author_order;
			$j++;
		}
		$str_author_id .= "'>\n";
		$str_author_name .= "'>\n";
		$str_author_kana .= "'>\n";
		$str_author_romaji .= "'>\n";
		$str_author_affiliation .= "'>\n";
		$str_author_affiliation_translation .= "'>\n";
		$str_author_role .= "'>\n";
		$str_author_link .= "'>\n";
		$str_author_order .= "'>\n";
	}
	$return_str .= $str_author_id.$str_author_name.$str_author_kana.$str_author_romaji.$str_author_affiliation.$str_author_affiliation_translation.$str_author_role.$str_author_link.$str_author_order;

	//detail_child_keywords
	$detail_child_keywords = xnparticleGetDetailChildKeywordsInformation( $item_id );
        $i = count($detail_child_keywords);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_keywords = "<input type='hidden' name='keywords' value='";
		$str_keywords_order = "<input type='hidden' name='keywords_order' value='";
		while ( list( $key, list( $article_child_keywords_id, $article_id, $keywords, $keywords_order ) ) = each( $detail_child_keywords ) ){
			if($j>0){
				$str_keywords .= "\n";
				$str_keywords_order .= "\n";
			}
			$str_keywords .= $keywords;
			$str_keywords_order .= $keywords_order;
			$j++;
		}
		$str_keywords .= "'>\n";
		$str_keywords_order .= "'>\n";
	}
	if(empty($str_keywords))$str_keywords = "";
	if(empty($str_keywords_order))$str_keywords_order = "";
	$return_str .= $str_keywords.$str_keywords_order;

	//detail_child_ndc_classifications
	$detail_child_ndc_classifications = xnparticleGetDetailChildNdcClassificationsInformation( $item_id );
        $i = count($detail_child_ndc_classifications);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_ndc_classifications = "<input type='hidden' name='ndc_classifications' value='";
		$str_ndc_classifications_order = "<input type='hidden' name='ndc_classifications_order' value='";
		while ( list( $key, list( $article_child_ndc_classifications_id, $article_id, $ndc_classifications, $ndc_classifications_order ) ) = each( $detail_child_ndc_classifications ) ){
			if($j>0){
				$str_ndc_classifications .= "\n";
				$str_ndc_classifications_order .= "\n";
			}
			$str_ndc_classifications .= $ndc_classifications;
			$str_ndc_classifications_order .= $ndc_classifications_order;
			$j++;
		}
		$str_ndc_classifications .= "'>\n";
		$str_ndc_classifications_order .= "'>\n";
	}
	if(empty($str_ndc_classifications))$str_ndc_classifications = "";
	if(empty($str_ndc_classifications_order))$str_ndc_classifications_order = "";
	$return_str .= $str_ndc_classifications.$str_ndc_classifications_order;

	//detail_child_physical_descriptions
	$detail_child_physical_descriptions = xnparticleGetDetailChildPhysicalDescriptionsInformation( $item_id );
        $i = count($detail_child_physical_descriptions);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_physical_descriptions = "<input type='hidden' name='physical_descriptions' value='";
		$str_physical_descriptions_order = "<input type='hidden' name='physical_descriptions_order' value='";
		while ( list( $key, list( $article_child_physical_descriptions_id, $article_id, $physical_descriptions, $physical_descriptions_order ) ) = each( $detail_child_physical_descriptions ) ){
			if($j>0){
				$str_physical_descriptions .= "\n";
				$str_physical_descriptions_order .= "\n";
			}
			$str_physical_descriptions .= $physical_descriptions;
			$str_physical_descriptions_order .= $physical_descriptions_order;
			$j++;
		}
		$str_physical_descriptions .= "'>\n";
		$str_physical_descriptions_order .= "'>\n";
	}
	if(empty($str_physical_descriptions))$str_physical_descriptions = "";
	if(empty($str_physical_descriptions_order))$str_physical_descriptions_order = "";
	$return_str .= $str_physical_descriptions.$str_physical_descriptions_order;

	//detail_child_langs
	$detail_child_langs = xnparticleGetDetailChildLangsInformation( $item_id );
        $i = count($detail_child_langs);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_langs = "<input type='hidden' name='langs' value='";
		$str_langs_order = "<input type='hidden' name='langs_order' value='";
		while ( list( $key, list( $article_child_langs_id, $article_id, $langs, $langs_order ) ) = each( $detail_child_langs ) ){
			if($j>0){
				$str_langs .= "\n";
				$str_langs_order .= "\n";
			}
			$str_langs .= $langs;
			$str_langs_order .= $langs_order;
			$j++;
		}
		$str_langs .= "'>\n";
		$str_langs_order .= "'>\n";
	}
	if(empty($str_langs))$str_langs = "";
	if(empty($str_langs_order))$str_langs_order = "";
	$return_str .= $str_langs.$str_langs_order;

	//detail_child_id_issns
	$detail_child_id_issns = xnparticleGetDetailChildIdIssnsInformation( $item_id );
        $i = count($detail_child_id_issns);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_id_issns = "<input type='hidden' name='id_issns' value='";
		$str_id_issns_order = "<input type='hidden' name='id_issns_order' value='";
		while ( list( $key, list( $article_child_id_issns_id, $article_id, $id_issns, $id_issns_order ) ) = each( $detail_child_id_issns ) ){
			if($j>0){
				$str_id_issns .= "\n";
				$str_id_issns_order .= "\n";
			}
			$str_id_issns .= $id_issns;
			$str_id_issns_order .= $id_issns_order;
			$j++;
		}
		$str_id_issns .= "'>\n";
		$str_id_issns_order .= "'>\n";
	}
	if(empty($str_id_issns))$str_id_issns = "";
	if(empty($str_id_issns_order))$str_id_issns_order = "";
	$return_str .= $str_id_issns.$str_id_issns_order;

	//detail_child_id_isbns
	$detail_child_id_isbns = xnparticleGetDetailChildIdIsbnsInformation( $item_id );
        $i = count($detail_child_id_isbns);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_id_isbns = "<input type='hidden' name='id_isbns' value='";
		$str_id_isbns_order = "<input type='hidden' name='id_isbns_order' value='";
		while ( list( $key, list( $article_child_id_isbns_id, $article_id, $id_isbns, $id_isbns_order ) ) = each( $detail_child_id_isbns ) ){
			if($j>0){
				$str_id_isbns .= "\n";
				$str_id_isbns_order .= "\n";
			}
			$str_id_isbns .= $id_isbns;
			$str_id_isbns_order .= $id_isbns_order;
			$j++;
		}
		$str_id_isbns .= "'>\n";
		$str_id_isbns_order .= "'>\n";
	}
	if(empty($str_id_isbns))$str_id_isbns = "";
	if(empty($str_id_isbns_order))$str_id_isbns_order = "";
	$return_str .= $str_id_isbns.$str_id_isbns_order;

	//detail_child_id_dois
	$detail_child_id_dois = xnparticleGetDetailChildIdDoisInformation( $item_id );
        $i = count($detail_child_id_dois);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_id_dois = "<input type='hidden' name='id_dois' value='";
		$str_id_dois_order = "<input type='hidden' name='id_dois_order' value='";
		while ( list( $key, list( $article_child_id_dois_id, $article_id, $id_dois, $id_dois_order ) ) = each( $detail_child_id_dois ) ){
			if($j>0){
				$str_id_dois .= "\n";
				$str_id_dois_order .= "\n";
			}
			$str_id_dois .= $id_dois;
			$str_id_dois_order .= $id_dois_order;
			$j++;
		}
		$str_id_dois .= "'>\n";
		$str_id_dois_order .= "'>\n";
	}
	if(empty($str_id_dois))$str_id_dois = "";
	if(empty($str_id_dois_order))$str_id_dois_order = "";
	$return_str .= $str_id_dois.$str_id_dois_order;

	//detail_child_id_uris
	$detail_child_id_uris = xnparticleGetDetailChildIdUrisInformation( $item_id );
        $i = count($detail_child_id_uris);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_id_uris = "<input type='hidden' name='id_uris' value='";
		$str_id_uris_order = "<input type='hidden' name='id_uris_order' value='";
		while ( list( $key, list( $article_child_id_uris_id, $article_id, $id_uris, $id_uris_order ) ) = each( $detail_child_id_uris ) ){
			if($j>0){
				$str_id_uris .= "\n";
				$str_id_uris_order .= "\n";
			}
			$str_id_uris .= $id_uris;
			$str_id_uris_order .= $id_uris_order;
			$j++;
		}
		$str_id_uris .= "'>\n";
		$str_id_uris_order .= "'>\n";
	}
	if(empty($str_id_uris))$str_id_uris = "";
	if(empty($str_id_uris_order))$str_id_uris_order = "";
	$return_str .= $str_id_uris.$str_id_uris_order;

	//detail_child_id_locals
	$detail_child_id_locals = xnparticleGetDetailChildIdLocalsInformation( $item_id );
        $i = count($detail_child_id_locals);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_id_locals = "<input type='hidden' name='id_locals' value='";
		$str_id_locals_order = "<input type='hidden' name='id_locals_order' value='";
		while ( list( $key, list( $article_child_id_locals_id, $article_id, $id_locals, $id_locals_order ) ) = each( $detail_child_id_locals ) ){
			if($j>0){
				$str_id_locals .= "\n";
				$str_id_locals_order .= "\n";
			}
			$str_id_locals .= $id_locals;
			$str_id_locals_order .= $id_locals_order;
			$j++;
		}
		$str_id_locals .= "'>\n";
		$str_id_locals_order .= "'>\n";
	}
	if(empty($str_id_locals))$str_id_locals = "";
	if(empty($str_id_locals_order))$str_id_locals_order = "";
	$return_str .= $str_id_locals.$str_id_locals_order;

	//detail_child_uris
	$detail_child_uris = xnparticleGetDetailChildUrisInformation( $item_id );
        $i = count($detail_child_uris);
        if ($i > 0) {
        	$myts =& MyTextSanitizer::getInstance( );
		$j = 0;
		$str_uris = "<input type='hidden' name='uris' value='";
		$str_uris_order = "<input type='hidden' name='uris_order' value='";
		while ( list( $key, list( $article_child_uris_id, $article_id, $uris, $uris_order ) ) = each( $detail_child_uris ) ){
			if($j>0){
				$str_uris .= "\n";
				$str_uris_order .= "\n";
			}
			$str_uris .= $uris;
			$str_uris_order .= $uris_order;
			$j++;
		}
		$str_uris .= "'>\n";
		$str_uris_order .= "'>\n";
	}
	if(empty($str_uris))$str_uris = "";
	if(empty($str_uris_order))$str_uris_order = "";
	$return_str .= $str_uris.$str_uris_order;

	return $return_str;
}

function xnparticleRegisterTitleRomajiString( $detail ) {
	if (( isset($_POST['xnparticleTitleRomajiFlag']) ) && ( $_POST['xnparticleTitleRomajiFlag'] == '1' )) {
		$str = $detail['title_kana'];
		$detail['title_romaji'] = xnpKana2Roma($str);
	}
	return $detail;
}

function xnparticleRegisterSubTitleString( $detail ) {
	if (( isset($_POST['xnparticleAddSubTitleFlag']) ) && ( $_POST['xnparticleAddSubTitleFlag'] == '1' )) {
		if (!empty($detail['sub_title_name']) || !empty($detail['sub_title_kana']) || !empty($detail['sub_title_romaji']) ){
			$detail['sub_title_name'] .= "\n";
			$detail['sub_title_kana'] .= "\n";
			$detail['sub_title_romaji'] .= "\n";
		}
		$detail['sub_title_name'] .= ( !empty( $detail['sub_title_name_add'] ) ) ? $detail['sub_title_name_add'] : " ";
		$detail['sub_title_kana'] .= ( !empty( $detail['sub_title_kana_add'] ) ) ? $detail['sub_title_kana_add'] : " ";
		$detail['sub_title_romaji'] .= ( !empty( $detail['sub_title_romaji_add'] ) ) ? $detail['sub_title_romaji_add'] : " ";
		$detail['sub_title_name_add'] = '';
		$detail['sub_title_kana_add'] = '';
		$detail['sub_title_romaji_add'] = '';
	}
	if (( isset($_POST['xnparticleUpdateSubTitleFlag']) ) && ( $_POST['xnparticleUpdateSubTitleFlag'] == '1' )) {
		$sub_title_name_update = array();
		$sub_title_kana_update = array();
		$sub_title_romaji_update = array();
		$sub_title_order_update = array();
		$sub_title_delete_update = array();
		foreach ( $_POST as $key=>$value ){
			if (substr($key,0,24) == "sub_title_delete_update_"){
				array_push($sub_title_delete_update, $value);
			}
		}
		$i = 0;
		$j = 0;
		$k = 0;
		$l = 0;
		foreach ( $_POST as $key=>$value ){
			if (substr($key,0,22) == "sub_title_name_update_"){
				if (in_array($i, $sub_title_delete_update) == FALSE) {
					array_push($sub_title_name_update, ( $value != "" ) ? $value : " ");
				}
				$i++;
			}
			if (substr($key,0,22) == "sub_title_kana_update_"){
				if (in_array($j, $sub_title_delete_update) == FALSE) {
					array_push($sub_title_kana_update, ( $value != "" ) ? $value : " ");
				}
				$j++;
			}
			if (substr($key,0,24) == "sub_title_romaji_update_"){
				if (in_array($k, $sub_title_delete_update) == FALSE) {
					array_push($sub_title_romaji_update, ( $value != "" ) ? $value : " ");
				}
				$k++;
			}
			if (substr($key,0,23) == "sub_title_order_update_"){
				if (in_array($l, $sub_title_delete_update) == FALSE) {
					array_push($sub_title_order_update, $value);
				}
				$l++;
			}
		}
		$sub_title_sort = array_map(NULL, $sub_title_order_update, $sub_title_name_update, $sub_title_kana_update, $sub_title_romaji_update);
		sort($sub_title_sort);
		$detail['sub_title_name'] = "";
		$detail['sub_title_kana'] = "";
		$detail['sub_title_romaji'] = "";
		foreach ( $sub_title_sort as $key=>$value ){
			if (!empty($value[1]) || !empty($value[2]) ||!empty($value[3]) ) { 
				if ( !empty( $detail['sub_title_name'] ) || !empty( $detail['sub_title_kana'] ) || !empty( $detail['sub_title_romaji'] ) ){
					$detail['sub_title_name'] .= "\n";
					$detail['sub_title_kana'] .= "\n";
					$detail['sub_title_romaji'] .= "\n";
				}
				$detail['sub_title_name'] .= $value[1];
				$detail['sub_title_kana'] .= $value[2];
				$detail['sub_title_romaji'] .= $value[3];
			}
		}
	}
	if ( !empty($detail['sub_title_name']) ){
		$sub_title_name = explode( "\n", $detail['sub_title_name'] );
		$sub_title_kana = explode( "\n", $detail['sub_title_kana'] );
		$sub_title_romaji = explode( "\n", $detail['sub_title_romaji'] );
		$i = count($sub_title_name);
		$j = 0;
		reset($sub_title_kana);
		reset($sub_title_romaji);
		$detail['sub_title_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
		foreach ( $sub_title_name as  $value ){
			$sub_title_name_1 = ( $value != " " ) ? $value : "";
			$sub_title_kana_1 = ( current($sub_title_kana) != " " ) ? current($sub_title_kana) : "";
			$sub_title_romaji_1 = ( current($sub_title_romaji) != " " ) ? current($sub_title_romaji) : "";
			$detail['sub_title_str'] .= "<tr><td colspan='3'><hr /></td></tr><tr><td width='320'><input size=40 type='text' name='sub_title_name_update_".$j."' value='".$value."' />:"._MD_XNPARTICLE_AUTHOR_NAME_LABEL."</td>\n";
			$detail['sub_title_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='sub_title_delete_update_".$j."' value='".$j."' />\n";
			$detail['sub_title_str'] .= "&nbsp;&nbsp;<select size='1' name='sub_title_order_update_".$j."'>";
			for ($k = 0; $k < $i; $k++) {
				$detail['sub_title_str'] .= "<option value='".$k."'";
				if ($k == $j) {
					$detail['sub_title_str'] .= " selected";
				}
				$detail['sub_title_str'] .= ">".$k."</option>";
			}
			$detail['sub_title_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='sub_title_kana_update_".$j."' value='".$sub_title_kana_1."' />:"._MD_XNPARTICLE_KANA_LABEL."</td>\n";
			$detail['sub_title_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='sub_title_romaji_update_".$j."' value='".$sub_title_romaji_1."' />:"._MD_XNPARTICLE_ROMAJI_LABEL."</td>\n";
			$j++;
			next($sub_title_kana);
			next($sub_title_romaji);
		}
		$detail['sub_title_str'] .= "</table>";
	}
	return $detail;
}


function xnparticleRegisterAuthorString( $detail ) {
	if (( isset($_POST['xnparticleAddAuthorFlag']) ) && ( $_POST['xnparticleAddAuthorFlag'] == '1' )) {
		if (( !empty( $detail['author_id'] ) ) || ( !empty( $detail['author_name'] ) ) || ( !empty( $detail['author_kana'] ) ) || ( !empty( $detail['author_romaji'] ) ) || ( !empty( $detail['author_affiliation'] ) ) || ( !empty( $detail['author_affiliation_translation'] )) || ( !empty( $detail['author_role'] ) ) || ( !empty( $detail['author_link'] ) )){
			$detail['author_id'] .= "\n";
			$detail['author_name'] .= "\n";
			$detail['author_kana'] .= "\n";
			$detail['author_romaji'] .= "\n";
			$detail['author_affiliation'] .= "\n";
			$detail['author_affiliation_translation'] .= "\n";
			$detail['author_role'] .= "\n";
			$detail['author_link'] .= "\n";
		}
		$detail['author_id']   .= ( !empty( $detail['author_id_add'] ) ) ? $detail['author_id_add'] : " ";
		$detail['author_name'] .= ( !empty( $detail['author_name_add'] ) ) ? $detail['author_name_add'] : " ";
		$detail['author_kana'] .= ( !empty( $detail['author_kana_add'] ) ) ? $detail['author_kana_add'] : " ";
		$detail['author_romaji'] .= ( !empty( $detail['author_romaji_add'] ) ) ? $detail['author_romaji_add'] : " ";
		$detail['author_affiliation'] .= ( !empty( $detail['author_affiliation_add'] ) ) ? $detail['author_affiliation_add'] : " ";
		$detail['author_affiliation_translation'] .= ( !empty( $detail['author_affiliation_translation_add'] ) ) ? $detail['author_affiliation_translation_add'] : " ";
		$detail['author_role'] .= ( !empty( $detail['author_role_add'] ) ) ? $detail['author_role_add'] : " ";
		$detail['author_link'] .= ( !empty( $detail['author_link_add'] ) ) ? $detail['author_link_add'] : " ";
		$detail['author_id_add'] = '';
		$detail['author_name_add'] = '';
		$detail['author_kana_add'] = '';
		$detail['author_romaji_add'] = '';
		$detail['author_role_add'] = '';
		$detail['author_link_add'] = '';
	}
	if (( isset($_POST['xnparticleUpdateAuthorFlag']) ) && ( $_POST['xnparticleUpdateAuthorFlag'] == '1' )) {
		$author_id_update = array();
		$author_name_update = array();
		$author_kana_update = array();
		$author_romaji_update = array();
		$author_affiliation_update = array();
		$author_affiliation_translation_update = array();
		$author_role_update = array();
		$author_link_update = array();
		$author_order_update = array();
		$author_delete_update = array();
		foreach ( $_POST as $key=>$value ){
			if (substr($key,0,21) == "author_delete_update_"){
				array_push($author_delete_update, $value);
			}
		}
		$i = 0;
		$j = 0;
		$k = 0;
		$l = 0;
		$m = 0;
		$n = 0;
		$o = 0;
		$p = 0;
		$q = 0;
		foreach ( $_POST as $key=>$value ){
			if (substr($key,0,17) == "author_id_update_"){
				if (in_array($i, $author_delete_update) == FALSE) {
					array_push($author_id_update, ( $value != "" ) ? $value : " ");
				}
				$i++;
			}
			if (substr($key,0,19) == "author_name_update_"){
				if (in_array($j, $author_delete_update) == FALSE) {
					array_push($author_name_update, ( $value != "" ) ? $value : " ");
				}
				$j++;
			}
			if (substr($key,0,19) == "author_kana_update_"){
				if (in_array($k, $author_delete_update) == FALSE) {
					array_push($author_kana_update, ( $value != "" ) ? $value : " ");
				}
				$k++;
			}
			if (substr($key,0,21) == "author_romaji_update_"){
				if (in_array($l, $author_delete_update) == FALSE) {
					array_push($author_romaji_update, ( $value != "" ) ? $value : " ");
				}
				$l++;
			}
			if (substr($key,0,26) == "author_affiliation_update_"){
				if (in_array($m, $author_delete_update) == FALSE) {
					array_push($author_affiliation_update, ( $value != "" ) ? $value : " ");
				}
				$m++;
			}
			if (substr($key,0,38) == "author_affiliation_translation_update_"){
				if (in_array($n, $author_delete_update) == FALSE) {
					array_push($author_affiliation_translation_update, ( $value != "" ) ? $value : " ");
				}
				$n++;
			}
			if (substr($key,0,19) == "author_role_update_"){
				if (in_array($o, $author_delete_update) == FALSE) {
					array_push($author_role_update, ( $value != "" ) ? $value : " ");
				}
				$o++;
			}
			if (substr($key,0,19) == "author_link_update_"){
				if (in_array($p, $author_delete_update) == FALSE) {
					array_push($author_link_update, ( $value != "" ) ? $value : " ");
				}
				$p++;
			}
			if (substr($key,0,20) == "author_order_update_"){
				if (in_array($q, $author_delete_update) == FALSE) {
					array_push($author_order_update, $value);
				}
				$q++;
			}
		}
		$author_sort = array_map(NULL, $author_order_update, $author_id_update, $author_name_update, $author_kana_update, $author_romaji_update, $author_affiliation_update, $author_affiliation_translation_update, $author_role_update, $author_link_update);
		sort($author_sort);
		$detail['author_id'] = "";
		$detail['author_name'] = "";
		$detail['author_kana'] = "";
		$detail['author_romaji'] = "";
		$detail['author_affiliation'] = "";
		$detail['author_affiliation_translation'] = "";
		$detail['author_role'] = "";
		$detail['author_link'] = "";
		foreach ( $author_sort as $key=>$value ){
			if ((!empty($value[1])) || (!empty($value[2])) || (!empty($value[3])) || (!empty($value[4])) || (!empty($value[5]))  || (!empty($value[6]))  || (!empty($value[7])) || (!empty($value[8])) ) { 
				if ( ( !empty( $detail['author_id'] ) ) || ( !empty( $detail['author_name'] ) ) || ( !empty( $detail['author_kana'] ) ) || ( !empty( $detail['author_romaji'] ) ) || ( !empty( $detail['author_affiliation'] ) ) || ( !empty( $detail['author_affiliation_translation'] )) || ( !empty( $detail['author_role'] ) ) || ( !empty( $detail['author_link'] )) ){
					$detail['author_id'] .= "\n";
					$detail['author_name'] .= "\n";
					$detail['author_kana'] .= "\n";
					$detail['author_romaji'] .= "\n";
					$detail['author_affiliation'] .= "\n";
					$detail['author_affiliation_translation'] .= "\n";
					$detail['author_role'] .= "\n";
					$detail['author_link'] .= "\n";
				}
				$detail['author_id'] .= $value[1];
				$detail['author_name'] .= $value[2];
				$detail['author_kana'] .= $value[3];
				$detail['author_romaji'] .= $value[4];
				$detail['author_affiliation'] .= $value[5];
				$detail['author_affiliation_translation'] .= $value[6];
				$detail['author_role'] .= $value[7];
				$detail['author_link'] .= $value[8];
			}
		}
	}
	if ( !empty( $detail['author_name'] ) ){
		$author_id   = explode( "\n", $detail['author_id'] );
		$author_name = explode( "\n", $detail['author_name'] );
		$author_kana = explode( "\n", $detail['author_kana'] );
		$author_romaji = explode( "\n", $detail['author_romaji'] );
		$author_affiliation = explode( "\n", $detail['author_affiliation'] );
		$author_affiliation_translation = explode( "\n", $detail['author_affiliation_translation'] );
		$author_role = explode( "\n", $detail['author_role'] );
		$author_link = explode( "\n", $detail['author_link'] );
		$i = count($author_name);
		$j = 0;
		reset($author_id);
		reset($author_kana);
		reset($author_romaji);
		reset($author_affiliation);
		reset($author_affiliation_translation);
		reset($author_role);
		reset($author_link);
		$detail['author_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
		foreach ( $author_name as  $value ){
			$author_name_1 = ( $value != " " ) ? $value : "";
			$author_id_1 = ( current($author_id) != " " ) ? current($author_id) : "";
			$author_kana_1 = ( current($author_kana) != " " ) ? current($author_kana) : "";
			$author_romaji_1 = ( current($author_romaji) != " " ) ? current($author_romaji) : "";
			$author_affiliation_1 = ( current($author_affiliation) != " " ) ? current($author_affiliation) : "";
			$author_affiliation_translation_1 = ( current($author_affiliation_translation) != " " ) ? current($author_affiliation_translation) : "";
			$author_role_1 = ( current($author_role) != " " ) ? current($author_role) : "";
			$author_link_1 = ( current($author_link) != " " ) ? current($author_link) : "";
			$detail['author_str'] .= "<tr><td colspan='3'><hr /></td></tr><tr><td width='320'><input size=40 type='text' name='author_id_update_".$j."' value='".$author_id_1."' />:"._MD_XNPARTICLE_AUTHOR_ID_LABEL."</td>\n";
			$detail['author_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='author_delete_update_".$j."' value='".$j."' />\n";
			$detail['author_str'] .= "&nbsp;&nbsp;<select size='1' name='author_order_update_".$j."'>";
			for ($k = 0; $k < $i; $k++) {
				$detail['author_str'] .= "<option value='".$k."'";
				if ($k == $j) {
					$detail['author_str'] .= " selected";
				}
				$detail['author_str'] .= ">".$k."</option>";
			}
			$detail['author_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='author_name_update_".$j."' value='".$value."' />:"._MD_XNPARTICLE_AUTHOR_NAME_LABEL."</td>\n";
			$detail['author_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='author_kana_update_".$j."' value='".$author_kana_1."' />:"._MD_XNPARTICLE_KANA_LABEL."</td>\n";
			$detail['author_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='author_romaji_update_".$j."' value='".$author_romaji_1."' />:"._MD_XNPARTICLE_ROMAJI_LABEL."</td>\n";
			$detail['author_str'] .= "<tr><td width='320'><input size='40' type='text' name='author_affiliation_update_".$j."' value='".$author_affiliation_1."' />:"._MD_XNPARTICLE_AUTHOR_AFFILIATION_LABEL."</td></tr>\n";
			$detail['author_str'] .= "<tr><td width='320'><input size='40' type='text' name='author_affiliation_translation_update_".$j."' value='".$author_affiliation_translation_1."' />:"._MD_XNPARTICLE_AUTHOR_AFFILIATION_TRANSLATION_LABEL."</td></tr>\n";
			$detail['author_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='author_role_update_".$j."' value='".$author_role_1."' />:"._MD_XNPARTICLE_AUTHOR_ROLE_LABEL."</td>\n";
			$detail['author_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='author_link_update_".$j."' value='".$author_link_1."' />:"._MD_XNPARTICLE_AUTHOR_LINK_LABEL."</td>\n";
			$j++;
			next($author_id);
			next($author_kana);
			next($author_romaji);
			next($author_affiliation);
			next($author_affiliation_translation);
			next($author_role);
			next($author_link);
		}
		$detail['author_str'] .= "</table>";
	}
	return $detail;
}


function xnparticleRegisterKeywordsString( $detail ) {
	if (( isset($_POST['xnparticleAddKeywordFlag']) ) && ( $_POST['xnparticleAddKeywordFlag'] == '1' )) {
		if ( !empty( $detail['keywords'] ) ){
			$detail['keywords'] .= "\n";
		}
		$detail['keywords'] .= $detail['keywords_add'];
		$detail['keywords_add'] = '';
	}
	if (( isset($_POST['xnparticleUpdateKeywordFlag']) ) && ( $_POST['xnparticleUpdateKeywordFlag'] == '1' )) {
		$keywords_update = array();
		$keywords_order_update = array();
		$keywords_delete_update = array();
		foreach ( $_POST as $key=>$value ){
			if (substr($key,0,22) == "keyword_delete_update_"){
				array_push($keywords_delete_update, $value);
			}
		}
		$i = 0;
		$j = 0;
		foreach ( $_POST as $key=>$value ){
			if (substr($key,0,15) == "keyword_update_"){
				if (in_array($i, $keywords_delete_update) == FALSE) {
					array_push($keywords_update, ( $value != "" ) ? $value : " ");
				}
				$i++;
			}
			if (substr($key,0,21) == "keyword_order_update_"){
				if (in_array($j, $keywords_delete_update) == FALSE) {
					array_push($keywords_order_update, $value);
				}
				$j++;
			}
		}
		$keywords_sort = array_map(NULL, $keywords_order_update, $keywords_update);
		sort($keywords_sort);
		$detail['keywords'] = "";
		foreach ( $keywords_sort as $key=>$value ){
			if (!empty($value[1])) { 
				if ( !empty( $detail['keywords'] ) ){
					$detail['keywords'] .= "\n";
				}
				$detail['keywords'] .= $value[1];
			}
		}
	}
	if ( !empty( $detail['keywords'] ) ){
		$keywords = explode( "\n", $detail['keywords'] );
		$i = count($keywords);
		$j = 0;
		$detail['keyword_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
		foreach ( $keywords as  $value ){
			$keywords_1 = ( $value != " " ) ? $value : "";
			$detail['keyword_str'] .= "<tr>";
			$detail['keyword_str'] .= "<td width='10'><input size=50 type='text' name='keyword_update_".$j."' value='".$keywords_1."' STYLE='ime-mode:active;' /></td>\n";
			$detail['keyword_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='keyword_delete_update_".$j."' value='".$j."' />\n";
			$detail['keyword_str'] .= "&nbsp;&nbsp;<select size='1' name='keyword_order_update_".$j."'>";
			for ($k = 0; $k < $i; $k++) {
				$detail['keyword_str'] .= "<option value='".$k."'";
				if ($k == $j) {
					$detail['keyword_str'] .= " selected";
				}
				$detail['keyword_str'] .= ">".$k."</option>";
			}
			$detail['keyword_str'] .= "</td></tr>\n";
			$j++;
		}
		$detail['keyword_str'] .= "</table>\n";
	}
	return $detail;
}


function xnparticleRegisterNdcClassificationsString( $detail ) {
        if (( isset($_POST['xnparticleAddNdcClassificationFlag']) ) && ( $_POST['xnparticleAddNdcClassificationFlag'] == '1' )) {
                if ( !empty( $detail['ndc_classifications'] ) ){
                        $detail['ndc_classifications'] .= "\n";
                }
                $detail['ndc_classifications'] .= $detail['ndc_classifications_add'];
                $detail['ndc_classifications_add'] = '';
        }
        if (( isset($_POST['xnparticleUpdateNdcClassificationFlag']) ) && ( $_POST['xnparticleUpdateNdcClassificationFlag'] == '1' )) {
                $ndc_classifications_update = array();
                $ndc_classifications_order_update = array();
                $ndc_classifications_delete_update = array();
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,33) == "ndc_classification_delete_update_"){
                                array_push($ndc_classifications_delete_update, $value);
                        }
                }
                $i = 0;
                $j = 0;
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,26) == "ndc_classification_update_"){
                                if (in_array($i, $ndc_classifications_delete_update) == FALSE) {
                                        array_push($ndc_classifications_update, ( $value != "" ) ? $value : " ");
                                }
                                $i++;
                        }
                        if (substr($key,0,32) == "ndc_classification_order_update_"){
                                if (in_array($j, $ndc_classifications_delete_update) == FALSE) {
                                        array_push($ndc_classifications_order_update, $value);
                                }
                                $j++;
                        }
                }
                $ndc_classifications_sort = array_map(NULL, $ndc_classifications_order_update, $ndc_classifications_update);
                sort($ndc_classifications_sort);
                $detail['ndc_classifications'] = "";
                foreach ( $ndc_classifications_sort as $key=>$value ){
                        if (!empty($value[1])) {
                                if ( !empty( $detail['ndc_classifications'] ) ){
                                        $detail['ndc_classifications'] .= "\n";
                                }
                                $detail['ndc_classifications'] .= $value[1];
                        }
                }
        }
        if ( !empty( $detail['ndc_classifications'] ) ){
                $ndc_classifications = explode( "\n", $detail['ndc_classifications'] );
                $i = count($ndc_classifications);
                $j = 0;
                $detail['ndc_classification_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
                foreach ( $ndc_classifications as  $value ){
                        $ndc_classifications_1 = ( $value != " " ) ? $value : "";
                        $detail['ndc_classification_str'] .= "<tr>";
                        $detail['ndc_classification_str'] .= "<td width='10'><input size=50 type='text' name='ndc_classification_update_".$j."' value='".$ndc_classifications_1."' STYLE='ime-mode:active;' /></td>\n";
                        $detail['ndc_classification_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='ndc_classification_delete_update_".$j."' value='".$j."' />\n";
			$detail['ndc_classification_str'] .= "&nbsp;&nbsp;<select size='1' name='ndc_classification_order_update_".$j."'>";
                        for ($k = 0; $k < $i; $k++) {
                                $detail['ndc_classification_str'] .= "<option value='".$k."'";
                                if ($k == $j) {
                                        $detail['ndc_classification_str'] .= " selected";
                                }
                                $detail['ndc_classification_str'] .= ">".$k."</option>";
                        }
                        $detail['ndc_classification_str'] .= "</td></tr>\n";
                        $j++;
                }
                $detail['ndc_classification_str'] .= "</table>\n";
        }
        return $detail;
}

function xnparticleRegisterPhysicalDescriptionsString( $detail ) {
        if (( isset($_POST['xnparticleAddPhysicalDescriptionFlag']) ) && ( $_POST['xnparticleAddPhysicalDescriptionFlag'] == '1' )) {
                if ( !empty( $detail['physical_descriptions'] ) ){
                        $detail['physical_descriptions'] .= "\n";
                }
                $detail['physical_descriptions'] .= $detail['physical_descriptions_add'];
                $detail['physical_descriptions_add'] = '';
        }
        if (( isset($_POST['xnparticleUpdatePhysicalDescriptionFlag']) ) && ( $_POST['xnparticleUpdatePhysicalDescriptionFlag'] == '1' )) {
                $physical_descriptions_update = array();
                $physical_descriptions_order_update = array();
                $physical_descriptions_delete_update = array();
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,34) == "physical_description_delete_update_"){
                                array_push($physical_descriptions_delete_update, $value);
                        }
                }
                $i = 0;
                $j = 0;
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,28) == "physical_description_update_"){
                                if (in_array($i, $physical_descriptions_delete_update) == FALSE) {
                                        array_push($physical_descriptions_update, ( $value != "" ) ? $value : " ");
                                }
                                $i++;
                        }
                        if (substr($key,0,34) == "physical_description_order_update_"){
                                if (in_array($j, $physical_descriptions_delete_update) == FALSE) {
                                        array_push($physical_descriptions_order_update, $value);
                                }
                                $j++;
                        }
                }
                $physical_descriptions_sort = array_map(NULL, $physical_descriptions_order_update, $physical_descriptions_update);
                sort($physical_descriptions_sort);
                $detail['physical_descriptions'] = "";
                foreach ( $physical_descriptions_sort as $key=>$value ){
                        if (!empty($value[1])) {
                                if ( !empty( $detail['physical_descriptions'] ) ){
                                        $detail['physical_descriptions'] .= "\n";
                                }
                                $detail['physical_descriptions'] .= $value[1];
                        }
                }
        }
        if ( !empty( $detail['physical_descriptions'] ) ){
                $physical_descriptions = explode( "\n", $detail['physical_descriptions'] );
                $i = count($physical_descriptions);
                $j = 0;
                $detail['physical_description_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
                foreach ( $physical_descriptions as  $value ){
                        $physical_descriptions_1 = ( $value != " " ) ? $value : "";
                        $detail['physical_description_str'] .= "<tr>";
                        $detail['physical_description_str'] .= "<td width='10'><input size=50 type='text' name='physical_description_update_".$j."' value='".$physical_descriptions_1."' STYLE='ime-mode:active;' /></td>\n";
                        $detail['physical_description_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='physical_description_delete_update_".$j."' value='".$j."' />\n";
			$detail['physical_description_str'] .= "&nbsp;&nbsp;<select size='1' name='physical_description_order_update_".$j."'>";
                        for ($k = 0; $k < $i; $k++) {
                                $detail['physical_description_str'] .= "<option value='".$k."'";
                                if ($k == $j) {
                                        $detail['physical_description_str'] .= " selected";
                                }
                                $detail['physical_description_str'] .= ">".$k."</option>";
                        }
                        $detail['physical_description_str'] .= "</td></tr>\n";
                        $j++;
                }
                $detail['physical_description_str'] .= "</table>\n";
        }
        return $detail;
}


function xnparticleRegisterLangsString( $detail ) {
        if (( isset($_POST['xnparticleAddLangFlag']) ) && ( $_POST['xnparticleAddLangFlag'] == '1' )) {
                if ( !empty( $detail['langs'] ) ){
                        $detail['langs'] .= "\n";
                }
                $detail['langs'] .= $detail['langs_add'];
                $detail['langs_add'] = '';
        }
        if (( isset($_POST['xnparticleUpdateLangFlag']) ) && ( $_POST['xnparticleUpdateLangFlag'] == '1' )) {
                $langs_update = array();
                $langs_order_update = array();
                $langs_delete_update = array();
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,19) == "lang_delete_update_"){
                                array_push($langs_delete_update, $value);
                        }
                }
                $i = 0;
                $j = 0;
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,12) == "lang_update_"){
                                if (in_array($i, $langs_delete_update) == FALSE) {
                                        array_push($langs_update, ( $value != "" ) ? $value : " ");
                                }
                                $i++;
                        }
                        if (substr($key,0,18) == "lang_order_update_"){
                                if (in_array($j, $langs_delete_update) == FALSE) {
                                        array_push($langs_order_update, $value);
                                }
                                $j++;
                        }
                }
                $langs_sort = array_map(NULL, $langs_order_update, $langs_update);
                sort($langs_sort);
                $detail['langs'] = "";
                foreach ( $langs_sort as $key=>$value ){
                        if (!empty($value[1])) {
                                if ( !empty( $detail['langs'] ) ){
                                        $detail['langs'] .= "\n";
                                }
                                $detail['langs'] .= $value[1];
                        }
                }
        }
        if ( !empty( $detail['langs'] ) ){
                $langs = explode( "\n", $detail['langs'] );
                $i = count($langs);
                $j = 0;
                $detail['lang_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
                foreach ( $langs as  $value ){
                        $langs_1 = ( $value != " " ) ? $value : "";
                        $detail['lang_str'] .= "<tr>";
                        $detail['lang_str'] .= "<td width='10'><input size=50 type='text' name='lang_update_".$j."' value='".$langs_1."' STYLE='ime-mode:active;' /></td>\n";
                        $detail['lang_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='lang_delete_update_".$j."' value='".$j."' />\n";
			$detail['lang_str'] .= "&nbsp;&nbsp;<select size='1' name='lang_order_update_".$j."'>";
                        for ($k = 0; $k < $i; $k++) {
                                $detail['lang_str'] .= "<option value='".$k."'";
                                if ($k == $j) {
                                        $detail['lang_str'] .= " selected";
                                }
                                $detail['lang_str'] .= ">".$k."</option>";
                        }
                        $detail['lang_str'] .= "</td></tr>\n";
                        $j++;
                }
                $detail['lang_str'] .= "</table>\n";
        }
        return $detail;
}

function xnparticleRegisterIdIssnsString( $detail ) {
        if (( isset($_POST['xnparticleAddIdIssnFlag']) ) && ( $_POST['xnparticleAddIdIssnFlag'] == '1' )) {
                if ( !empty( $detail['id_issns'] ) ){
                        $detail['id_issns'] .= "\n";
                }
                $detail['id_issns'] .= $detail['id_issns_add'];
                $detail['id_issns_add'] = '';
        }
        if (( isset($_POST['xnparticleUpdateIdIssnFlag']) ) && ( $_POST['xnparticleUpdateIdIssnFlag'] == '1' )) {
                $id_issns_update = array();
                $id_issns_order_update = array();
                $id_issns_delete_update = array();
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,22) == "id_issn_delete_update_"){
                                array_push($id_issns_delete_update, $value);
                        }
                }
                $i = 0;
                $j = 0;
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,15) == "id_issn_update_"){
                                if (in_array($i, $id_issns_delete_update) == FALSE) {
                                        array_push($id_issns_update, ( $value != "" ) ? $value : " ");
                                }
                                $i++;
                        }
                        if (substr($key,0,21) == "id_issn_order_update_"){
                                if (in_array($j, $id_issns_delete_update) == FALSE) {
                                        array_push($id_issns_order_update, $value);
                                }
                                $j++;
                        }
                }
                $id_issns_sort = array_map(NULL, $id_issns_order_update, $id_issns_update);
                sort($id_issns_sort);
                $detail['id_issns'] = "";
                foreach ( $id_issns_sort as $key=>$value ){
                        if (!empty($value[1])) {
                                if ( !empty( $detail['id_issns'] ) ){
                                        $detail['id_issns'] .= "\n";
                                }
                                $detail['id_issns'] .= $value[1];
                        }
                }
        }
        if ( !empty( $detail['id_issns'] ) ){
                $id_issns = explode( "\n", $detail['id_issns'] );
                $i = count($id_issns);
                $j = 0;
                $detail['id_issn_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
                foreach ( $id_issns as  $value ){
                        $id_issns_1 = ( $value != " " ) ? $value : "";
                        $detail['id_issn_str'] .= "<tr>";
                        $detail['id_issn_str'] .= "<td width='10'><input size=50 type='text' name='id_issn_update_".$j."' value='".$id_issns_1."' STYLE='ime-mode:active;' /></td>\n";
                        $detail['id_issn_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='id_issn_delete_update_".$j."' value='".$j."' />\n";
			$detail['id_issn_str'] .= "&nbsp;&nbsp;<select size='1' name='id_issn_order_update_".$j."'>";
                        for ($k = 0; $k < $i; $k++) {
                                $detail['id_issn_str'] .= "<option value='".$k."'";
                                if ($k == $j) {
                                        $detail['id_issn_str'] .= " selected";
                                }
                                $detail['id_issn_str'] .= ">".$k."</option>";
                        }
                        $detail['id_issn_str'] .= "</td></tr>\n";
                        $j++;
                }
                $detail['id_issn_str'] .= "</table>\n";
        }
        return $detail;
}


function xnparticleRegisterIdIsbnsString( $detail ) {
        if (( isset($_POST['xnparticleAddIdIsbnFlag']) ) && ( $_POST['xnparticleAddIdIsbnFlag'] == '1' )) {
                if ( !empty( $detail['id_isbns'] ) ){
                        $detail['id_isbns'] .= "\n";
                }
                $detail['id_isbns'] .= $detail['id_isbns_add'];
                $detail['id_isbns_add'] = '';
        }
        if (( isset($_POST['xnparticleUpdateIdIsbnFlag']) ) && ( $_POST['xnparticleUpdateIdIsbnFlag'] == '1' )) {
                $id_isbns_update = array();
                $id_isbns_order_update = array();
                $id_isbns_delete_update = array();
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,22) == "id_isbn_delete_update_"){
                                array_push($id_isbns_delete_update, $value);
                        }
                }
                $i = 0;
                $j = 0;
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,15) == "id_isbn_update_"){
                                if (in_array($i, $id_isbns_delete_update) == FALSE) {
                                        array_push($id_isbns_update, ( $value != "" ) ? $value : " ");
                                }
                                $i++;
                        }
                        if (substr($key,0,21) == "id_isbn_order_update_"){
                                if (in_array($j, $id_isbns_delete_update) == FALSE) {
                                        array_push($id_isbns_order_update, $value);
                                }
                                $j++;
                        }
                }
                $id_isbns_sort = array_map(NULL, $id_isbns_order_update, $id_isbns_update);
                sort($id_isbns_sort);
                $detail['id_isbns'] = "";
                foreach ( $id_isbns_sort as $key=>$value ){
                        if (!empty($value[1])) {
                                if ( !empty( $detail['id_isbns'] ) ){
                                        $detail['id_isbns'] .= "\n";
                                }
                                $detail['id_isbns'] .= $value[1];
                        }
                }
        }
        if ( !empty( $detail['id_isbns'] ) ){
                $id_isbns = explode( "\n", $detail['id_isbns'] );
                $i = count($id_isbns);
                $j = 0;
                $detail['id_isbn_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
                foreach ( $id_isbns as  $value ){
                        $id_isbns_1 = ( $value != " " ) ? $value : "";
                        $detail['id_isbn_str'] .= "<tr>";
                        $detail['id_isbn_str'] .= "<td width='10'><input size=50 type='text' name='id_isbn_update_".$j."' value='".$id_isbns_1."' STYLE='ime-mode:active;' /></td>\n";
                        $detail['id_isbn_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='id_isbn_delete_update_".$j."' value='".$j."' />\n";
			$detail['id_isbn_str'] .= "&nbsp;&nbsp;<select size='1' name='id_isbn_order_update_".$j."'>";
                        for ($k = 0; $k < $i; $k++) {
                                $detail['id_isbn_str'] .= "<option value='".$k."'";
                                if ($k == $j) {
                                        $detail['id_isbn_str'] .= " selected";
                                }
                                $detail['id_isbn_str'] .= ">".$k."</option>";
                        }
                        $detail['id_isbn_str'] .= "</td></tr>\n";
                        $j++;
                }
                $detail['id_isbn_str'] .= "</table>\n";
        }
        return $detail;
}

function xnparticleRegisterIdDoisString( $detail ) {
        if (( isset($_POST['xnparticleAddIdDoiFlag']) ) && ( $_POST['xnparticleAddIdDoiFlag'] == '1' )) {
                if ( !empty( $detail['id_dois'] ) ){
                        $detail['id_dois'] .= "\n";
                }
                $detail['id_dois'] .= $detail['id_dois_add'];
                $detail['id_dois_add'] = '';
        }
        if (( isset($_POST['xnparticleUpdateIdDoiFlag']) ) && ( $_POST['xnparticleUpdateIdDoiFlag'] == '1' )) {
                $id_dois_update = array();
                $id_dois_order_update = array();
                $id_dois_delete_update = array();
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,21) == "id_doi_delete_update_"){
                                array_push($id_dois_delete_update, $value);
                        }
                }
                $i = 0;
                $j = 0;
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,14) == "id_doi_update_"){
                                if (in_array($i, $id_dois_delete_update) == FALSE) {
                                        array_push($id_dois_update, ( $value != "" ) ? $value : " ");
                                }
                                $i++;
                        }
                        if (substr($key,0,20) == "id_doi_order_update_"){
                                if (in_array($j, $id_dois_delete_update) == FALSE) {
                                        array_push($id_dois_order_update, $value);
                                }
                                $j++;
                        }
                }
                $id_dois_sort = array_map(NULL, $id_dois_order_update, $id_dois_update);
                sort($id_dois_sort);
                $detail['id_dois'] = "";
                foreach ( $id_dois_sort as $key=>$value ){
                        if (!empty($value[1])) {
                                if ( !empty( $detail['id_dois'] ) ){
                                        $detail['id_dois'] .= "\n";
                                }
                                $detail['id_dois'] .= $value[1];
                        }
                }
        }
        if ( !empty( $detail['id_dois'] ) ){
                $id_dois = explode( "\n", $detail['id_dois'] );
                $i = count($id_dois);
                $j = 0;
                $detail['id_doi_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
                foreach ( $id_dois as  $value ){
                        $id_dois_1 = ( $value != " " ) ? $value : "";
                        $detail['id_doi_str'] .= "<tr>";
                        $detail['id_doi_str'] .= "<td width='10'><input size=50 type='text' name='id_doi_update_".$j."' value='".$id_dois_1."' STYLE='ime-mode:active;' /></td>\n";
                        $detail['id_doi_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='id_doi_delete_update_".$j."' value='".$j."' />\n";
			$detail['id_doi_str'] .= "&nbsp;&nbsp;<select size='1' name='id_doi_order_update_".$j."'>";
                        for ($k = 0; $k < $i; $k++) {
                                $detail['id_doi_str'] .= "<option value='".$k."'";
                                if ($k == $j) {
                                        $detail['id_doi_str'] .= " selected";
                                }
                                $detail['id_doi_str'] .= ">".$k."</option>";
                        }
                        $detail['id_doi_str'] .= "</td></tr>\n";
                        $j++;
                }
                $detail['id_doi_str'] .= "</table>\n";
        }
        return $detail;
}

function xnparticleRegisterIdUrisString( $detail ) {
        if (( isset($_POST['xnparticleAddIdUriFlag']) ) && ( $_POST['xnparticleAddIdUriFlag'] == '1' )) {
                if ( !empty( $detail['id_uris'] ) ){
                        $detail['id_uris'] .= "\n";
                }
                $detail['id_uris'] .= $detail['id_uris_add'];
                $detail['id_uris_add'] = '';
        }
        if (( isset($_POST['xnparticleUpdateIdUriFlag']) ) && ( $_POST['xnparticleUpdateIdUriFlag'] == '1' )) {
                $id_uris_update = array();
                $id_uris_order_update = array();
                $id_uris_delete_update = array();
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,21) == "id_uri_delete_update_"){
                                array_push($id_uris_delete_update, $value);
                        }
                }
                $i = 0;
                $j = 0;
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,14) == "id_uri_update_"){
                                if (in_array($i, $id_uris_delete_update) == FALSE) {
                                        array_push($id_uris_update, ( $value != "" ) ? $value : " ");
                                }
                                $i++;
                        }
                        if (substr($key,0,20) == "id_uri_order_update_"){
                                if (in_array($j, $id_uris_delete_update) == FALSE) {
                                        array_push($id_uris_order_update, $value);
                                }
                                $j++;
                        }
                }
                $id_uris_sort = array_map(NULL, $id_uris_order_update, $id_uris_update);
                sort($id_uris_sort);
                $detail['id_uris'] = "";
                foreach ( $id_uris_sort as $key=>$value ){
                        if (!empty($value[1])) {
                                if ( !empty( $detail['id_uris'] ) ){
                                        $detail['id_uris'] .= "\n";
                                }
                                $detail['id_uris'] .= $value[1];
                        }
                }
        }
        if ( !empty( $detail['id_uris'] ) ){
                $id_uris = explode( "\n", $detail['id_uris'] );
                $i = count($id_uris);
                $j = 0;
                $detail['id_uri_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
                foreach ( $id_uris as  $value ){
                        $id_uris_1 = ( $value != " " ) ? $value : "";
                        $detail['id_uri_str'] .= "<tr>";
                        $detail['id_uri_str'] .= "<td width='10'><input size=50 type='text' name='id_uri_update_".$j."' value='".$id_uris_1."' STYLE='ime-mode:active;' /></td>\n";
                        $detail['id_uri_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='id_uri_delete_update_".$j."' value='".$j."' />\n";
			$detail['id_uri_str'] .= "&nbsp;&nbsp;<select size='1' name='id_uri_order_update_".$j."'>";
                        for ($k = 0; $k < $i; $k++) {
                                $detail['id_uri_str'] .= "<option value='".$k."'";
                                if ($k == $j) {
                                        $detail['id_uri_str'] .= " selected";
                                }
                                $detail['id_uri_str'] .= ">".$k."</option>";
                        }
                        $detail['id_uri_str'] .= "</td></tr>\n";
                        $j++;
                }
                $detail['id_uri_str'] .= "</table>\n";
        }
        return $detail;
}

function xnparticleRegisterIdLocalsString( $detail ) {
        if (( isset($_POST['xnparticleAddIdLocalFlag']) ) && ( $_POST['xnparticleAddIdLocalFlag'] == '1' )) {
                if ( !empty( $detail['id_locals'] ) ){
                        $detail['id_locals'] .= "\n";
                }
                $detail['id_locals'] .= $detail['id_locals_add'];
                $detail['id_locals_add'] = '';
        }
        if (( isset($_POST['xnparticleUpdateIdLocalFlag']) ) && ( $_POST['xnparticleUpdateIdLocalFlag'] == '1' )) {
                $id_locals_update = array();
                $id_locals_order_update = array();
                $id_locals_delete_update = array();
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,23) == "id_local_delete_update_"){
                                array_push($id_locals_delete_update, $value);
                        }
                }
                $i = 0;
                $j = 0;
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,16) == "id_local_update_"){
                                if (in_array($i, $id_locals_delete_update) == FALSE) {
                                        array_push($id_locals_update, ( $value != "" ) ? $value : " ");
                                }
                                $i++;
                        }
                        if (substr($key,0,22) == "id_local_order_update_"){
                                if (in_array($j, $id_locals_delete_update) == FALSE) {
                                        array_push($id_locals_order_update, $value);
                                }
                                $j++;
                        }
                }
                $id_locals_sort = array_map(NULL, $id_locals_order_update, $id_locals_update);
                sort($id_locals_sort);
                $detail['id_locals'] = "";
                foreach ( $id_locals_sort as $key=>$value ){
                        if (!empty($value[1])) {
                                if ( !empty( $detail['id_locals'] ) ){
                                        $detail['id_locals'] .= "\n";
                                }
                                $detail['id_locals'] .= $value[1];
                        }
                }
        }
        if ( !empty( $detail['id_locals'] ) ){
                $id_locals = explode( "\n", $detail['id_locals'] );
                $i = count($id_locals);
                $j = 0;
                $detail['id_local_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
                foreach ( $id_locals as  $value ){
                        $id_locals_1 = ( $value != " " ) ? $value : "";
                        $detail['id_local_str'] .= "<tr>";
                        $detail['id_local_str'] .= "<td width='10'><input size=50 type='text' name='id_local_update_".$j."' value='".$id_locals_1."' STYLE='ime-mode:active;' /></td>\n";
                        $detail['id_local_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='id_local_delete_update_".$j."' value='".$j."' />\n";
			$detail['id_local_str'] .= "&nbsp;&nbsp;<select size='1' name='id_local_order_update_".$j."'>";
                        for ($k = 0; $k < $i; $k++) {
                                $detail['id_local_str'] .= "<option value='".$k."'";
                                if ($k == $j) {
                                        $detail['id_local_str'] .= " selected";
                                }
                                $detail['id_local_str'] .= ">".$k."</option>";
                        }
                        $detail['id_local_str'] .= "</td></tr>\n";
                        $j++;
                }
                $detail['id_local_str'] .= "</table>\n";
        }
        return $detail;
}

function xnparticleRegisterUrisString( $detail ) {
        if (( isset($_POST['xnparticleAddUriFlag']) ) && ( $_POST['xnparticleAddUriFlag'] == '1' )) {
                if ( !empty( $detail['uris'] ) ){
                        $detail['uris'] .= "\n";
                }
                $detail['uris'] .= $detail['uris_add'];
                $detail['uris_add'] = '';
        }
        if (( isset($_POST['xnparticleUpdateUriFlag']) ) && ( $_POST['xnparticleUpdateUriFlag'] == '1' )) {
                $uris_update = array();
                $uris_order_update = array();
                $uris_delete_update = array();
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,18) == "uri_delete_update_"){
                                array_push($uris_delete_update, $value);
                        }
                }
                $i = 0;
                $j = 0;
                foreach ( $_POST as $key=>$value ){
                        if (substr($key,0,11) == "uri_update_"){
                                if (in_array($i, $uris_delete_update) == FALSE) {
                                        array_push($uris_update, ( $value != "" ) ? $value : " ");
                                }
                                $i++;
                        }
                        if (substr($key,0,17) == "uri_order_update_"){
                                if (in_array($j, $uris_delete_update) == FALSE) {
                                        array_push($uris_order_update, $value);
                                }
                                $j++;
                        }
                }
                $uris_sort = array_map(NULL, $uris_order_update, $uris_update);
                sort($uris_sort);
                $detail['uris'] = "";
                foreach ( $uris_sort as $key=>$value ){
                        if (!empty($value[1])) {
                                if ( !empty( $detail['uris'] ) ){
                                        $detail['uris'] .= "\n";
                                }
                                $detail['uris'] .= $value[1];
                        }
                }
        }
        if ( !empty( $detail['uris'] ) ){
                $uris = explode( "\n", $detail['uris'] );
                $i = count($uris);
                $j = 0;
                $detail['uri_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
                foreach ( $uris as  $value ){
                        $uris_1 = ( $value != " " ) ? $value : "";
                        $detail['uri_str'] .= "<tr>";
                        $detail['uri_str'] .= "<td width='10'><input size=50 type='text' name='uri_update_".$j."' value='".$uris_1."' STYLE='ime-mode:active;' /></td>\n";
                        $detail['uri_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='uri_delete_update_".$j."' value='".$j."' />\n";
			$detail['uri_str'] .= "&nbsp;&nbsp;<select size='1' name='uri_order_update_".$j."'>";
                        for ($k = 0; $k < $i; $k++) {
                                $detail['uri_str'] .= "<option value='".$k."'";
                                if ($k == $j) {
                                        $detail['uri_str'] .= " selected";
                                }
                                $detail['uri_str'] .= ">".$k."</option>";
                        }
                        $detail['uri_str'] .= "</td></tr>\n";
                        $j++;
                }
                $detail['uri_str'] .= "</table>\n";
        }
        return $detail;
}


function xnparticleTrimRepeatableColumn( $cols ) {
	$col = "";
	$cols_1 = explode( "\n", $cols );
	if ( !empty( $cols_1 )){
		foreach ( $cols_1 as $value ){
			if ( $col != "" ){
				$col .= ", ";
			}
			$col .= $value;
		}
	}
	$col = str_replace("\r", "", $col);
	return $col;
}

/** get DetailInformation by item_id
  * 
  */
function xnparticleGetDetailInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'title'           	  =>'',
			'title_kana'          =>'',
			'title_romaji'        =>'',
			'edition'             =>'',
			'publish_place'       =>'',
			'publisher'             =>'',
			'publisher_kana' =>'',
			'publisher_romaji' =>'',
			'year_f'                  =>'',
			'year_t'                  =>'',
			'date_create'             =>'',
			'date_update'             =>'',
			'date_record'             =>'',
			'jtitle'                  =>'',
			'jtitle_translation'      =>'',
			'jtitle_volume'           =>'',
			'jtitle_issue'            =>'',
			'jtitle_year'             =>'',
			'jtitle_month'            =>'',
			'jtitle_spage'            =>'',
			'jtitle_epage'            =>'',
			'abstract'        	  =>'',
			'table_of_contents'    	  =>'',
			'type_of_resource'    =>'',
			'genre'	        	  =>'',
			'access_condition'     	  =>''
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail") . " where article_id=$item_id";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail = $xoopsDB->fetchArray($result);
	return $detail;
}

function xnparticleGetDetailChildSubTitleInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'sub_title_name'                    =>'',
			'sub_title_kana'                    =>'',
			'sub_title_romaji'                  =>'',
		);
	
	$sql = "select article_child_sub_title_id,article_id,sub_title_name,sub_title_kana,sub_title_romaji,sub_title_order from " . $xoopsDB->prefix("xnparticle_item_detail_child_sub_title") . " where article_id=$item_id order by sub_title_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_sub_title = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_sub_title[] = $row;
	}
	return $detail_child_sub_title;
}

function xnparticleGetDetailChildAuthorInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'author_id'                      =>'',
			'author_name'                    =>'',
			'author_kana'                    =>'',
			'author_romaji'                  =>'',
			'author_affiliation'             =>'',
			'author_affiliation_translation' =>'',
			'author_role'                    =>'',
			'author_link'                    =>''
		);
	
	$sql = "select article_child_author_id,article_id,author_id,author_name,author_kana,author_romaji,author_affiliation,author_affiliation_translation,author_role,author_link,author_order from " . $xoopsDB->prefix("xnparticle_item_detail_child_author") . " where article_id=$item_id order by author_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_author = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_author[] = $row;
	}
	return $detail_child_author;
}

function xnparticleGetDetailChildKeywordsInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'keywords'         =>'',
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail_child_keywords") . " where article_id=$item_id order by keywords_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_keywords = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_keywords[] = $row;
	}
	return $detail_child_keywords;
}

function xnparticleGetDetailChildNdcClassificationsInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'ndc_classifications'         =>'',
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail_child_ndc_classifications") . " where article_id=$item_id order by ndc_classifications_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_ndc_classifications = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_ndc_classifications[] = $row;
	}
	return $detail_child_ndc_classifications;
}

function xnparticleGetDetailChildPhysicalDescriptionsInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'physical_descriptions'         =>'',
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail_child_physical_descriptions") . " where article_id=$item_id order by physical_descriptions_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_physical_descriptions = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_physical_descriptions[] = $row;
	}
	return $detail_child_physical_descriptions;
}

function xnparticleGetDetailChildLangsInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'langs'         =>'',
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail_child_langs") . " where article_id=$item_id order by langs_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_langs = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_langs[] = $row;
	}
	return $detail_child_langs;
}

function xnparticleGetDetailChildIdIssnsInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'id_issns'         =>'',
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_issns") . " where article_id=$item_id order by id_issns_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_id_issns = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_id_issns[] = $row;
	}
	return $detail_child_id_issns;
}

function xnparticleGetDetailChildIdIsbnsInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'id_isbns'         =>'',
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_isbns") . " where article_id=$item_id order by id_isbns_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_id_isbns = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_id_isbns[] = $row;
	}
	return $detail_child_id_isbns;
}

function xnparticleGetDetailChildIdDoisInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'id_dois'         =>'',
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_dois") . " where article_id=$item_id order by id_dois_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_id_dois = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_id_dois[] = $row;
	}
	return $detail_child_id_dois;
}

function xnparticleGetDetailChildIdUrisInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'id_uris'         =>'',
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_uris") . " where article_id=$item_id order by id_uris_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_id_uris = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_id_uris[] = $row;
	}
	return $detail_child_id_uris;
}

function xnparticleGetDetailChildIdLocalsInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'id_locals'         =>'',
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_locals") . " where article_id=$item_id order by id_locals_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_id_locals = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_id_locals[] = $row;
	}
	return $detail_child_id_locals;
}

function xnparticleGetDetailChildUrisInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'uris'         =>'',
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnparticle_item_detail_child_uris") . " where article_id=$item_id order by uris_order";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$detail_child_uris = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) ) {
		$detail_child_uris[] = $row;
	}
	return $detail_child_uris;
}

function xnparticleGetMetaInformation( $item_id ){
	
	$ret = array();
	$basic = xnpGetBasicInformationArray($item_id);
	$detail = xnparticleGetDetailInformation( $item_id );
	if ( !empty( $basic ) ){
		$ret[_MD_XOONIPS_ITEM_TITLE_LABEL] = implode( "\n", $basic['titles'] );
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = implode( "\n", $basic['keywords'] );
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPARTICLE_TITLE_LABEL." "._MD_XOONIPS_ITEM_TITLE_LABEL] = $detail['title'];
		$ret[_MD_XNPARTICLE_TITLE_LABEL." "._MD_XNPARTICLE_KANA_LABEL] = $detail['title_kana'];
		$ret[_MD_XNPARTICLE_TITLE_LABEL." "._MD_XNPARTICLE_ROMAJI_LABEL] = $detail['title_romaji'];
	}
	$detail_child_sub_title = xnparticleGetDetailChildSubTitleInformation( $item_id );
	$i = count($detail_child_sub_title);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_sub_title_id, $article_id, $sub_title_name, $sub_title_kana, $sub_title_romaji, $sub_title_order ) ) = each( $detail_child_sub_title ) ){
			if (!empty($sub_title_name)) {
				$sub_title_str = $sub_title_name;
			}
			if (!empty($sub_title_kana)) {
				$sub_title_str = $sub_title_kana;
			}
			if (!empty($sub_title_romaji)) {
				$sub_title_str .= " (".$sub_title_romaji.")";
			}
			$ret[_MD_XNPARTICLE_SUB_TITLE_LABEL] = $sub_title_str;
		}
   	}
	$detail_child_author = xnparticleGetDetailChildAuthorInformation( $item_id );
	$i = count($detail_child_author);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $detail_child_author ) ){
			if (!empty($author_id)) {
				$author_str = $author_id;
			}
			if (!empty($author_name)) {
				$author_str = $author_name;
			}
			if (!empty($author_kana)) {
				$author_str = $author_kana;
			}
			if (!empty($author_romaji)) {
				$author_str .= " (".$author_romaji.")";
			}
			if (!empty($author_affiliation)) {
				$author_str .= " -".$author_affiliation;
			}
			if (!empty($author_affiliation_translation)) {
				$author_str .= " (".$author_affiliation_translation.")";
			}
			if (!empty($author_role)) {
				$author_str = $author_role;
			}
			if (!empty($author_link)) {
				$author_str = $author_link;
			}
			$ret[_MD_XNPARTICLE_AUTHOR_LABEL] = $author_str;
		}
   	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPARTICLE_EDITION_LABEL] = $detail['edition'];
		$ret[_MD_XNPARTICLE_PUBLISH_PLACE_LABEL] = $detail['publish_place'];
        }
	if ( !empty( $detail ) ){
		$ret[_MD_XNPARTICLE_PUBLISHER_LABEL] = $detail['publisher'];
		$ret[_MD_XNPARTICLE_PUBLISHER_LABEL." "._MD_XNPARTICLE_KANA_LABEL] = $detail['publisher_kana'];
		$ret[_MD_XNPARTICLE_PUBLISHER_LABEL." "._MD_XNPARTICLE_ROMAJI_LABEL] = $detail['publisher_romaji'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPARTICLE_PUBLISH_YEAR_LABEL] = $detail['year_f'].$detail['year_t'];
		$ret[_MD_XNPARTICLE_DATE_CREATE_LABEL] = $detail['date_create'];
		$ret[_MD_XNPARTICLE_DATE_UPDATE_LABEL] = $detail['date_update'];
		$ret[_MD_XNPARTICLE_DATE_RECORD_LABEL] = $detail['date_record'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPARTICLE_JTITLE_LABEL]." ".$ret[_MD_XNPARTICLE_AUTHOR_NAME_LABEL] = $detail['jtitle'];
		$ret[_MD_XNPARTICLE_JTITLE_LABEL]." ".$ret[_MD_XNPARTICLE_TRANSLATION_LABEL] = $detail['jtitle_translation'];
		$ret[_MD_XNPARTICLE_JTITLE_LABEL]." ".$ret[_MD_XNPARTICLE_JTITLE_VOLUME_LABEL] = $detail['jtitle_volume'];
		$ret[_MD_XNPARTICLE_JTITLE_LABEL]." ".$ret[_MD_XNPARTICLE_JTITLE_ISSUE_LABEL] = $detail['jtitle_issue'];
		$ret[_MD_XNPARTICLE_JTITLE_LABEL]." ".$ret[_MD_XNPARTICLE_JTITLE_YEAR_LABEL] = $detail['jtitle_year'];
		$ret[_MD_XNPARTICLE_JTITLE_LABEL]." ".$ret[_MD_XNPARTICLE_JTITLE_MONTH_LABEL] = $detail['jtitle_month'];
		$ret[_MD_XNPARTICLE_JTITLE_LABEL]." ".$ret[_MD_XNPARTICLE_JTITLE_SPAGE_LABEL] = $detail['jtitle_spage'];
		$ret[_MD_XNPARTICLE_JTITLE_LABEL]." ".$ret[_MD_XNPARTICLE_JTITLE_EPAGE_LABEL] = $detail['jtitle_epage'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPARTICLE_ABSTRACT_LABEL] = $detail['abstract'];
		$ret[_MD_XNPARTICLE_TABLE_OF_CONTENTS_LABEL] = $detail['table_of_contents'];
		$ret[_MD_XNPARTICLE_ACCESS_CONDITION_LABEL] = $detail['access_condition'];
	}
	$detail_child_keywords = xnparticleGetDetailChildKeywordsInformation( $item_id );
	$i = count($detail_child_keywords);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_keywords_id, $article_id, $keywords, $keywords_order ) ) = each( $detail_child_keywords ) ){
			$ret[_MD_XNPARTICLE_KEYWORDS_LABEL] = $keywords;
		}
        }
	$detail_child_ndc_classifications = xnparticleGetDetailChildNdcClassificationsInformation( $item_id );
	$i = count($detail_child_ndc_classifications);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_ndc_classifications_id, $article_id, $ndc_classifications, $ndc_classifications_order ) ) = each( $detail_child_ndc_classifications ) ){
			$ret[_MD_XNPARTICLE_NDC_CLASSIFICATIONS_LABEL] = $ndc_classifications;
		}
        }
	$detail_child_physical_descriptions = xnparticleGetDetailChildPhysicalDescriptionsInformation( $item_id );
	$i = count($detail_child_physical_descriptions);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_physical_descriptions_id, $article_id, $physical_descriptions, $physical_descriptions_order ) ) = each( $detail_child_physical_descriptions ) ){
			$ret[_MD_XNPARTICLE_PHYSICAL_DESCRIPTIONS_LABEL] = $physical_descriptions;
		}
        }
	$detail_child_langs = xnparticleGetDetailChildLangsInformation( $item_id );
	$i = count($detail_child_langs);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_langs_id, $article_id, $langs, $langs_order ) ) = each( $detail_child_langs ) ){
			$ret[_MD_XNPARTICLE_LANGS_LABEL] = $langs;
		}
        }
	$detail_child_id_issns = xnparticleGetDetailChildIdIssnsInformation( $item_id );
	$i = count($detail_child_id_issns);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_id_issns_id, $article_id, $id_issns, $id_issns_order ) ) = each( $detail_child_id_issns ) ){
			$ret[_MD_XNPARTICLE_ISSN_LABEL] = $id_issns;
		}
        }
	$detail_child_id_isbns = xnparticleGetDetailChildIdIsbnsInformation( $item_id );
	$i = count($detail_child_id_isbns);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_id_isbns_id, $article_id, $id_isbns, $id_isbns_order ) ) = each( $detail_child_id_isbns ) ){
			$ret[_MD_XNPARTICLE_ISBN_LABEL] = $id_isbns;
		}
        }
	$detail_child_id_dois = xnparticleGetDetailChildIdDoisInformation( $item_id );
	$i = count($detail_child_id_dois);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_id_dois_id, $article_id, $id_dois, $id_dois_order ) ) = each( $detail_child_id_dois ) ){
			$ret[_MD_XNPARTICLE_DOI_LABEL] = $id_dois;
		}
        }
	$detail_child_id_uris = xnparticleGetDetailChildIdUrisInformation( $item_id );
	$i = count($detail_child_id_uris);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_id_uris_id, $article_id, $id_uris, $id_uris_order ) ) = each( $detail_child_id_uris ) ){
			$ret[_MD_XNPARTICLE_ID_URI_LABEL] = $id_uris;
		}
        }
	$detail_child_id_locals = xnparticleGetDetailChildIdLocalsInformation( $item_id );
	$i = count($detail_child_id_locals);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_id_locals_id, $article_id, $id_locals, $id_locals_order ) ) = each( $detail_child_id_locals ) ){
			$ret[_MD_XNPARTICLE_OTHER_LABEL] = $id_locals;
		}
        }
	$detail_child_uris = xnparticleGetDetailChildUrisInformation( $item_id );
	$i = count($detail_child_uris);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_uris_id, $article_id, $uris, $uris_order ) ) = each( $detail_child_uris ) ){
			$ret[_MD_XNPARTICLE_URI_LABEL] = $uris;
		}
        }
	if ( !empty( $detail ) ){
		$ret[_MD_XNPARTICLE_TYPE_OF_RESOURCE_LABEL] = $detail['type_of_resource'];
		$ret[_MD_XNPARTICLE_GENRE_LABEL] = $detail['genre'];
	}
	
	return $ret;
}

function xnparticleGetListBlock( $item_basic ){
	$item_id = $item_basic['item_id'];
	
	// get DetailInformation
	$item_detail = xnparticleGetDetailInformation( $item_id );
	if (!empty($item_detail['title'])) {
		$item_detail['title_str'] = $item_detail['title'];
	}
	$item_detail_child_author = xnparticleGetDetailChildAuthorInformation( $item_id );
	$item_detail['author_str'] = '';
	while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $item_detail_child_author ) ){
		if (($item_detail['author_str'] != '' ) && (!empty($author_name))) {
			$item_detail['author_str'] .= ' . ';
		}
		if (!empty($author_name)) {
			$item_detail['author_str'] .= $author_name;
		}
	}
	$article_images = xnparticleGetPreviewDetailBlock2( $item_id );
	
	// Set into the template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $item_detail );
	$tpl->assign( 'article_images', $article_images );
        $tpl->assign( 'doi', urlencode( $item_basic[ 'doi' ] ) );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );
	
	// Return as HTML
	return $tpl->fetch( "db:xnparticle_list_block.html" );
}

// Generate PreviewBlock shown in the listing page.
// Difference from the original xnpGetPreviewDetailBlock is that
// this function only obtain the first image thumbnail without caption.
function xnparticleGetPreviewDetailBlock2( $item_id ){
	
	// Obrain thumbnail and caption from the item_id
	$files = xnpGetFileInfo( "t_file.file_id, t_file.caption", "t_file_type.name='preview' and sess_id is NULL ", $item_id );
	// Generate html
	reset( $files );
	$imageHtml1 = array();
	$imageHtml2 = array();
	$fileIDs = array();
  if( count( $files ) > 0 ){
	  $file = $files[0];
    if( $file != NULL ){
		$fileID = $file[0];
		$thumbnailFileName = XOOPS_URL . "/modules/xoonips/image.php?file_id=$fileID&thumbnail=1";
		$imageFileName = XOOPS_URL . "/modules/xoonips/image.php?file_id=$fileID";
		$html = "<a href='$imageFileName' target='_blank'><img src='$thumbnailFileName' width='50' ></a>";
		return array( 'name'=>_MD_XOONIPS_ITEM_PREVIEW_LABEL, 'value'=> $html);
	}
    }
}

function xnparticleGetPrinterFriendlyListBlock( $item_basic ){
	return xnparticleGetListBlock( $item_basic );
}


function xnparticleGetDetailBlock( $item_id ){
	
	// Get DetailInformation
	$detail = xnparticleGetDetailInformation( $item_id );
	$detail = xnparticleDetailSubTitleString( $detail, $item_id );
	$detail = xnparticleDetailAuthorString( $detail, $item_id );
	$detail = xnparticleDetailKeywordsString( $detail, $item_id );
	$detail = xnparticleDetailNdcClassificationsString( $detail, $item_id );
	$detail = xnparticleDetailPhysicalDescriptionsString( $detail, $item_id );
	$detail = xnparticleDetailLangsString( $detail, $item_id );
	$detail = xnparticleDetailIdIssnsString( $detail, $item_id );
	$detail = xnparticleDetailIdIsbnsString( $detail, $item_id );
	$detail = xnparticleDetailIdDoisString( $detail, $item_id );
	$detail = xnparticleDetailIdUrisString( $detail, $item_id );
	$detail = xnparticleDetailIdLocalsString( $detail, $item_id );
	$detail = xnparticleDetailUrisString( $detail, $item_id );
	
	// Get blocks of "BasicInformation / Preview / IndexKeywords"
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
	$index   = xnpGetIndexDetailBlock( $item_id );
	$article_attachment = xnpGetAttachmentDetailBlock( $item_id, 'article_attachment' );
	$article_images = xnpGetPreviewDetailBlock( $item_id );
	
	// Set into the template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTplにセットされた変数($xoops_urlとか)を、$tplにコピーする。
	
	$tpl->assign( 'editable', xnp_get_item_permission( $_SESSION['XNPSID'], $item_id, OP_MODIFY ) );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'article_attachment', $article_attachment );
	$tpl->assign( 'article_images', $article_images );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'detail', $detail );
	
	//リピータブル項目のhiddenを作成
	$hidden_str_for_repeatable = xnparticleGetDetailChildHiddenStr( $item_id );
	$tpl->assign( 'hidden_str_for_repeatable', $hidden_str_for_repeatable );

	// タイトルを格納しておく。テーマによっては表示可能。
        $xoopsTpl -> assign( 'xoops_contentstitle',$detail['title']);

	// pdf, abstractの表示設定を得る
	$mhandler =& xoops_gethandler('module');
	$module = $mhandler->getByDirname( 'xnparticle' );
	$chandler = & xoops_gethandler('config');
	$assoc = $chandler->getConfigsByCat(false, $module->mid());
	$pdf_access_rights = $assoc['pdf_access_rights'];
	$abstract_access_rights = $assoc['abstract_access_rights'];
	
	// userがどの権限でitem_idにアクセスしているかを調べ， *_access_rightsと比べる
	$access_rights = xnpGetAccessRights( $item_id );
	$tpl->assign( 'show_pdf',      ( $pdf_access_rights      <= $access_rights ) );
	$tpl->assign( 'show_abstract', ( $abstract_access_rights <= $access_rights ) );
	
	// Return as HTML
	return $tpl->fetch( "db:xnparticle_detail_block.html" );
}

// todo
function xnparticleGetPrinterFriendlyDetailBlock( $item_id )
{
	// Get DetailInformation
	$detail = xnparticleGetDetailInformation( $item_id );
	$detail = xnparticleDetailSubTitleString( $detail, $item_id );
	$detail = xnparticleDetailAuthorString( $detail, $item_id );
	$detail = xnparticleDetailKeywordsString( $detail, $item_id );
	$detail = xnparticleDetailNdcClassificationsString( $detail, $item_id );
	$detail = xnparticleDetailPhysicalDescriptionsString( $detail, $item_id );
	$detail = xnparticleDetailLangsString( $detail, $item_id );
	$detail = xnparticleDetailIdIssnsString( $detail, $item_id );
	$detail = xnparticleDetailIdIsbnsString( $detail, $item_id );
	$detail = xnparticleDetailIdDoisString( $detail, $item_id );
	$detail = xnparticleDetailIdUrisString( $detail, $item_id );
	$detail = xnparticleDetailIdLocalsString( $detail, $item_id );
	$detail = xnparticleDetailUrisString( $detail, $item_id );
	
	// Get blocks of "BasicInformation / Preview / IndexKeywords"
	$basic   = xnpGetBasicInformationPrinterFriendlyBlock( $item_id );
	$index   = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$article_attachment = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'article_attachment' );
	$article_images = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	
	// Set into the template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTplにセットされた変数($xoops_urlとか)を、$tplにコピーする。
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'article_attachment', $article_attachment );
	$tpl->assign( 'article_images', $article_images );
	$tpl->assign( 'detail', $detail );
	
	// pdf, abstractの表示設定を得る
	$mhandler =& xoops_gethandler('module');
	$module = $mhandler->getByDirname( 'xnparticle' );
	$chandler = & xoops_gethandler('config');
	$assoc = $chandler->getConfigsByCat(false, $module->mid());
	$pdf_access_rights = $assoc['pdf_access_rights'];
	$abstract_access_rights = $assoc['abstract_access_rights'];
	
	// userがどの権限でitem_idにアクセスしているかを調べ， *_access_rightsと比べる
	$access_rights = xnpGetAccessRights( $item_id );
	$tpl->assign( 'show_pdf',      ( $pdf_access_rights      <= $access_rights ) );
	$tpl->assign( 'show_abstract', ( $abstract_access_rights <= $access_rights ) );
	
	// Return as HTML
	return $tpl->fetch( "db:xnparticle_detail_block.html" );
}

function xnparticleGetRegisterBlock(){
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();
	
	// Get DetailInformation
	if ( isset( $_POST['title'] ) ){
		$detail = array(
			'title'                 =>$myts->stripSlashesGPC(xnpGetPostVarDef('title'                 , '')),
			'title_kana'            =>$myts->stripSlashesGPC(xnpGetPostVarDef('title_kana'            , '')),
			'title_romaji'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('title_romaji'          , '')),
			'sub_title_name_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_name_add'       , '')),
			'sub_title_kana_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_kana_add'       , '')),
			'sub_title_romaji_add'     =>$myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_romaji_add'     , '')),
			'sub_title_name'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_name'           , ''))),
			'sub_title_kana'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_kana'           , ''))),
			'sub_title_romaji'         =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_romaji'         , ''))),
			'sub_title_order'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_order'          , '')),
			'author_id_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_id_add'       , '')),
			'author_name_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_name_add'       , '')),
			'author_kana_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_kana_add'       , '')),
			'author_romaji_add'     =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_romaji_add'     , '')),
			'author_affiliation_add'=>$myts->stripSlashesGPC(xnpGetPostVarDef('author_affiliation_add', '')),
			'author_affiliation_translation_add'=>$myts->stripSlashesGPC(xnpGetPostVarDef('author_affiliation_translation_add', '')),
			'author_role_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_role_add'       , '')),
			'author_link_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_link_add'       , '')),
			'author_id'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_id'           , ''))),
			'author_name'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_name'           , ''))),
			'author_kana'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_kana'           , ''))),
			'author_romaji'         =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_romaji'         , ''))),
			'author_affiliation'    =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_affiliation'    , ''))),
			'author_affiliation_translation'    =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_affiliation_translation'    , ''))),
			'author_role'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_role'           , ''))),
			'author_link'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_link'           , ''))),
			'author_order'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_order'          , '')),
			'publisher'               =>$myts->stripSlashesGPC(xnpGetPostVarDef('publisher'               , '')),
			'publisher_kana'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('publisher_kana'   , '')),
			'publisher_romaji'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('publisher_romaji'   , '')),
			'year_f'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('year_f'   , '')),
			'year_t'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('year_t'   , '')),
			'date_create'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('date_create'   , '')),
			'date_update'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('date_update'   , '')),
			'date_record'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('date_record'   , '')),
			'jtitle'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle'   , '')),
			'jtitle_translation'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_translation'   , '')),
			'jtitle_volume'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_volume'   , '')),
			'jtitle_issue'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_issue'   , '')),
			'jtitle_year'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_year'   , '')),
			'jtitle_month'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_month'   , '')),
			'jtitle_spage'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_spage'   , '')),
			'jtitle_epage'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_epage'   , '')),
			'abstract'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('abstract'              , '')),
			'table_of_contents'     =>$myts->stripSlashesGPC(xnpGetPostVarDef('table_of_contents'              , '')),
			'edition'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('edition'              , '')),
			'publish_place'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('publish_place'              , '')),
			'keywords_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('keywords_add'          , '')),
			'keywords'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('keywords'              , ''))),
			'ndc_classifications_add'=>$myts->stripSlashesGPC(xnpGetPostVarDef('ndc_classifications_add'          , '')),
			'ndc_classifications'     =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('ndc_classifications', ''))),
			'physical_descriptions_add'=>$myts->stripSlashesGPC(xnpGetPostVarDef('physical_descriptions_add'          , '')),
			'physical_descriptions'  =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('physical_descriptions', ''))),
			'langs_add'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('langs_add'          , '')),
			'langs'                  =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('langs', ''))),
			'id_issns_add'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('id_issns_add'          , '')),
			'id_issns'                  =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('id_issns', ''))),
			'id_isbns_add'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('id_isbns_add'          , '')),
			'id_isbns'                  =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('id_isbns', ''))),
			'id_dois_add'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('id_dois_add'          , '')),
			'id_dois'                  =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('id_dois', ''))),
			'id_uris_add'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('id_uris_add'          , '')),
			'id_uris'                  =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('id_uris', ''))),
			'id_locals_add'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('id_locals_add'          , '')),
			'id_locals'                  =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('id_locals', ''))),
			'uris_add'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('uris_add'          , '')),
			'uris'                  =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('uris', ''))),
			'type_of_resource'      =>$myts->stripSlashesGPC(xnpGetPostVarDef('type_of_resource'      , '')),
			'genre'                 =>$myts->stripSlashesGPC(xnpGetPostVarDef('genre'                 , '')),
			'access_condition'     =>$myts->stripSlashesGPC(xnpGetPostVarDef('access_condition'              , ''))
		);
	}
	else 
		$detail = array();
	
	$detail = xnparticleRegisterTitleRomajiString( $detail );
	$detail = xnparticleRegisterSubTitleString( $detail );
	$detail = xnparticleRegisterAuthorString( $detail );
	$detail = xnparticleRegisterKeywordsString( $detail );
	$detail = xnparticleRegisterNdcClassificationsString( $detail );
	$detail = xnparticleRegisterPhysicalDescriptionsString( $detail );
	$detail = xnparticleRegisterLangsString( $detail );
	$detail = xnparticleRegisterIdIssnsString( $detail );
	$detail = xnparticleRegisterIdIsbnsString( $detail );
	$detail = xnparticleRegisterIdDoisString( $detail );
	$detail = xnparticleRegisterIdUrisString( $detail );
	$detail = xnparticleRegisterIdLocalsString( $detail );
	$detail = xnparticleRegisterUrisString( $detail );
	
	// Get blocks of "BasicInformation / Preview / index block"
	$basic = xnpGetBasicInformationRegisterBlock();
	$index = xnpGetIndexRegisterBlock();
	$article_attachment = xnpGetAttachmentRegisterBlock( 'article_attachment' );
	$article_images = xnpGetPreviewRegisterBlock( );
	
	// Set into the template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTplにセットされた変数($xoops_urlとか)を、$tplにコピーする。
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'article_images', $article_images );
	$tpl->assign( 'article_attachment', $article_attachment );
	$tpl->assign( 'detail', $detail );
	
	// Return as HTML
	return $tpl->fetch( "db:xnparticle_register_block.html" );
}

function xnparticleGetEditBlock( $item_id ){
	global $xoopsDB;

	// Get "BasicInformation / Preview / index block"
	$basic   = xnpGetBasicInformationEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$article_attachment = xnpGetAttachmentEditBlock( $item_id, 'article_attachment' );
	$article_images = xnpGetPreviewEditBlock( $item_id );
	
	// Get DetailInformation
	if ( isset( $_POST['title'] ) ){
		$myts =& MyTextSanitizer::getInstance();
		$detail = array(
			'title'                 =>$myts->stripSlashesGPC(xnpGetPostVarDef('title'                 , '')),
			'title_kana'            =>$myts->stripSlashesGPC(xnpGetPostVarDef('title_kana'            , '')),
			'title_romaji'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('title_romaji'          , '')),
			'sub_title_name_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_name_add'       , '')),
			'sub_title_kana_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_kana_add'       , '')),
			'sub_title_romaji_add'     =>$myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_romaji_add'     , '')),
			'sub_title_name'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_name'           , ''))),
			'sub_title_kana'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_kana'           , ''))),
			'sub_title_romaji'         =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_romaji'         , ''))),
			'sub_title_order'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('sub_title_order'          , '')),
			'author_id_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_id_add'       , '')),
			'author_name_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_name_add'       , '')),
			'author_kana_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_kana_add'       , '')),
			'author_romaji_add'     =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_romaji_add'     , '')),
			'author_affiliation_add'=>$myts->stripSlashesGPC(xnpGetPostVarDef('author_affiliation_add', '')),
			'author_affiliation_translation_add'=>$myts->stripSlashesGPC(xnpGetPostVarDef('author_affiliation_translation_add', '')),
			'author_role_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_role_add'       , '')),
			'author_link_add'       =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_link_add'       , '')),
			'author_id'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_id'           , ''))),
			'author_name'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_name'           , ''))),
			'author_kana'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_kana'           , ''))),
			'author_romaji'         =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_romaji'         , ''))),
			'author_affiliation'    =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_affiliation'    , ''))),
			'author_affiliation_translation' =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_affiliation_translation'    , ''))),
			'author_role'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_role'           , ''))),
			'author_link'           =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('author_link'           , ''))),
			'author_order'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('author_order'          , '')),
			'publisher'               =>$myts->stripSlashesGPC(xnpGetPostVarDef('publisher'               , '')),
			'publisher_kana'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('publisher_kana'   , '')),
			'publisher_romaji'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('publisher_romaji'   , '')),
			'year_f'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('year_f'   , '')),
			'year_t'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('year_t'   , '')),
			'date_create'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('date_create'   , '')),
			'date_update'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('date_update'   , '')),
			'date_record'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('date_record'   , '')),
			'jtitle'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle'   , '')),
			'jtitle_translation'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_translation'   , '')),
			'jtitle_volume'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_volume'   , '')),
			'jtitle_issue'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_issue'   , '')),
			'jtitle_year'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_year'   , '')),
			'jtitle_month'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_month'   , '')),
			'jtitle_spage'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_spage'   , '')),
			'jtitle_epage'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('jtitle_epage'   , '')),
			'abstract'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('abstract'              , '')),
			'table_of_contents'     =>$myts->stripSlashesGPC(xnpGetPostVarDef('table_of_contents'     , '')),
			'edition'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('edition'              , '')),
			'publish_place'              =>$myts->stripSlashesGPC(xnpGetPostVarDef('publish_place'              , '')),
			'keywords_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('keywords_add'          , '')),
			'keywords'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('keywords'              , ''))),
			'ndc_classifications_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('ndc_classifications_add'          , '')),
			'ndc_classifications'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('ndc_classifications'  , ''))),
			'physical_descriptions_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('physical_descriptions_add'          , '')),
			'physical_descriptions'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('physical_descriptions'  , ''))),
			'langs_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('langs_add'          , '')),
			'langs'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('langs'  , ''))),
			'id_issns_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('id_issns_add'          , '')),
			'id_issns'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('id_issns'  , ''))),
			'id_isbns_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('id_isbns_add'          , '')),
			'id_isbns'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('id_isbns'  , ''))),
			'id_dois_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('id_dois_add'          , '')),
			'id_dois'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('id_dois'  , ''))),
			'id_uris_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('id_uris_add'          , '')),
			'id_uris'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('id_uris'  , ''))),
			'id_locals_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('id_locals_add'          , '')),
			'id_locals'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('id_locals'  , ''))),
			'uris_add'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('uris_add'          , '')),
			'uris'              =>htmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('uris'  , ''))),
			'type_of_resource'      =>$myts->stripSlashesGPC(xnpGetPostVarDef('type_of_resource'      , '')),
			'genre'                 =>$myts->stripSlashesGPC(xnpGetPostVarDef('genre'                 , '')),
			'access_condition'      =>$myts->stripSlashesGPC(xnpGetPostVarDef('access_condition'      , ''))
		);
	}
	else if ( !empty( $item_id ) ){
		$detail = xnparticleGetDetailInformation( $item_id );
		$detail_child_sub_title = xnparticleGetDetailChildSubTitleInformation( $item_id );
		$i = count($detail_child_sub_title);
		if ($i > 0) {
			$j = 0;
			$detail['sub_title_name'] = "";
			$detail['sub_title_kana'] = "";
			$detail['sub_title_romaji'] = "";
			$detail['sub_title_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_sub_title_id, $article_id, $sub_title_name, $sub_title_kana, $sub_title_romaji, $sub_title_order ) ) = each( $detail_child_sub_title ) ){
				if ( (!empty($detail['sub_title_name'])) || (!empty($detail['sub_title_kana'])) || (!empty($detail['sub_title_romaji'] )) ){
					$detail['sub_title_name'] .= "\n";
					$detail['sub_title_kana'] .= "\n";
					$detail['sub_title_romaji'] .= "\n";
				}
				$detail['sub_title_name'] .= ( !empty( $sub_title_name ) ) ? $sub_title_name : " ";
				$detail['sub_title_kana'] .= ( !empty( $sub_title_kana ) ) ? $sub_title_kana : " ";
				$detail['sub_title_romaji'] .= ( !empty( $sub_title_romaji ) ) ? $sub_title_romaji : " ";
				$detail['sub_title_str'] .= "<tr><td width='320'><input size=40 type='text' name='sub_title_name_update_".$j."' value='".$sub_title_name."' /></td>\n";
				$detail['sub_title_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='sub_title_delete_update_".$j."' value='".$j."' />\n";
				$detail['sub_title_str'] .= "&nbsp;&nbsp;<select size='1' name='sub_title_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['sub_title_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['sub_title_str'] .= " selected";
					}
					$detail['sub_title_str'] .= ">".$k."</option>";
				}
				$detail['sub_title_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='sub_title_kana_update_".$j."' value='".$sub_title_kana."' /></td>\n";
				$detail['sub_title_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='sub_title_romaji_update_".$j."' value='".$sub_title_romaji."' /></td>\n";
				$j++;
			}
			$detail['sub_title_str'] .= "</table>";
		}
		$detail_child_author = xnparticleGetDetailChildAuthorInformation( $item_id );
		$i = count($detail_child_author);
		if ($i > 0) {
			$j = 0;
			$detail['author_id'] = "";
			$detail['author_name'] = "";
			$detail['author_kana'] = "";
			$detail['author_romaji'] = "";
			$detail['author_affiliation'] = "";
			$detail['author_affiliation_translation'] = "";
			$detail['author_role'] = "";
			$detail['author_link'] = "";
			$detail['author_str'] = "<table><tr><td>"._MD_XNPARTICLE_EDIT_LABEL."</td><td>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $detail_child_author ) ){
				if ( (!empty($detail['author_id'])) || (!empty($detail['author_name'])) || (!empty($detail['author_kana'])) || (!empty($detail['author_romaji'] )) || (!empty($detail['author_affiliation'])) || (!empty($detail['author_affiliation_translation'])) || (!empty($detail['author_role'])) || (!empty( $detail['author_link'])) ){
					$detail['author_id'] .= "\n";
					$detail['author_name'] .= "\n";
					$detail['author_kana'] .= "\n";
					$detail['author_romaji'] .= "\n";
					$detail['author_affiliation'] .= "\n";
					$detail['author_affiliation_translation'] .= "\n";
					$detail['author_role'] .= "\n";
					$detail['author_link'] .= "\n";
				}
				$detail['author_id'] .= ( !empty( $author_id ) ) ? $author_id : " ";
				$detail['author_name'] .= ( !empty( $author_name ) ) ? $author_name : " ";
				$detail['author_kana'] .= ( !empty( $author_kana ) ) ? $author_kana : " ";
				$detail['author_romaji'] .= ( !empty( $author_romaji ) ) ? $author_romaji : " ";
				$detail['author_affiliation'] .= ( !empty( $author_affiliation ) ) ? $author_affiliation : " ";
				$detail['author_affiliation_translation'] .= ( !empty( $author_affiliation_translation ) ) ? $author_affiliation_translation : " ";
				$detail['author_role'] .= ( !empty( $author_role ) ) ? $author_role : " ";
				$detail['author_link'] .= ( !empty( $author_link ) ) ? $author_link : " ";
				$detail['author_str'] .= "<tr><td width='320'><input size=40 type='text' name='author_id_update_".$j."' value='".$author_id."' /></td>\n";
				$detail['author_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='author_delete_update_".$j."' value='".$j."' />\n";
				$detail['author_str'] .= "&nbsp;&nbsp;<select size='1' name='author_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['author_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['author_str'] .= " selected";
					}
					$detail['author_str'] .= ">".$k."</option>";
				}
				$detail['author_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='author_name_update_".$j."' value='".$author_name."' /></td>\n";
				$detail['author_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='author_kana_update_".$j."' value='".$author_kana."' /></td>\n";
				$detail['author_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='author_romaji_update_".$j."' value='".$author_romaji."' /></td>\n";
				$detail['author_str'] .= "<tr><td width='320'><input size='50' type='text' name='author_affiliation_update_".$j."' value='".$author_affiliation."' /></td></tr>\n";
				$detail['author_str'] .= "<tr><td width='320'><input size='50' type='text' name='author_affiliation_translation_update_".$j."' value='".$author_affiliation_translation."' /></td></tr>\n";
				$detail['author_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='author_role_update_".$j."' value='".$author_role."' /></td>\n";
				$detail['author_str'] .= "</td></tr>\n<tr><td width='320'><input size=40 type='text' name='author_link_update_".$j."' value='".$author_link."' /></td>\n";
				$j++;
			}
			$detail['author_str'] .= "</table>";
		}
		$detail_child_keywords = xnparticleGetDetailChildKeywordsInformation( $item_id );
		$i = count($detail_child_keywords);
		if ($i > 0) {
			$j = 0;
			$detail['keywords'] = "";
			$detail['keyword_str'] = "<table><tr><td></td><td class='oddeven'>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_keywords_id, $article_id, $keywords, $keywords_order ) ) = each( $detail_child_keywords ) ){
				if ( !empty( $detail['keywords'] ) ){
					$detail['keywords'] .= "\n";
				}
				$detail['keywords'] .= $keywords;
				$detail['keyword_str'] .= "<tr>";
				$detail['keyword_str'] .= "<td width='10'><input size=50 type='text' name='keyword_jpn_update_".$j."' value='".$keywords."' STYLE='ime-mode:active;' /></td>\n";
				$detail['keyword_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='keyword_delete_update_".$j."' value='".$j."' />\n";
				$detail['keyword_str'] .= "&nbsp;&nbsp;<select size='1' name='keyword_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['keyword_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['keyword_str'] .= " selected";
					}
					$detail['keyword_str'] .= ">".$k."</option>";
				}
				$detail['keyword_str'] .= "</td></tr>\n";
				$j++;
			}
			$detail['keyword_str'] .= "</table>\n";
		}
		$detail_child_ndc_classifications = xnparticleGetDetailChildNdcClassificationsInformation( $item_id );
		$i = count($detail_child_ndc_classifications);
		if ($i > 0) {
			$j = 0;
			$detail['ndc_classifications'] = "";
			$detail['ndc_classification_str'] = "<table><tr><td></td><td class='oddeven'>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_ndc_classifications_id, $article_id, $ndc_classifications, $ndc_classifications_order ) ) = each( $detail_child_ndc_classifications ) ){
				if ( !empty( $detail['ndc_classifications'] ) ){
					$detail['ndc_classifications'] .= "\n";
				}
				$detail['ndc_classifications'] .= $ndc_classifications;
				$detail['ndc_classification_str'] .= "<tr>";
				$detail['ndc_classification_str'] .= "<td width='10'><input size=50 type='text' name='ndc_classification_jpn_update_".$j."' value='".$ndc_classifications."' STYLE='ime-mode:active;' /></td>\n";
				$detail['ndc_classification_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='ndc_classification_delete_update_".$j."' value='".$j."' />\n";
				$detail['ndc_classification_str'] .= "&nbsp;&nbsp;<select size='1' name='ndc_classification_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['ndc_classification_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['ndc_classification_str'] .= " selected";
					}
					$detail['ndc_classification_str'] .= ">".$k."</option>";
				}
				$detail['ndc_classification_str'] .= "</td></tr>\n";
				$j++;
			}
			$detail['ndc_classification_str'] .= "</table>\n";
		}
		$detail_child_physical_descriptions = xnparticleGetDetailChildPhysicalDescriptionsInformation( $item_id );
		$i = count($detail_child_physical_descriptions);
		if ($i > 0) {
			$j = 0;
			$detail['physical_descriptions'] = "";
			$detail['physical_description_str'] = "<table><tr><td></td><td class='oddeven'>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_physical_descriptions_id, $article_id, $physical_descriptions, $physical_descriptions_order ) ) = each( $detail_child_physical_descriptions ) ){
				if ( !empty( $detail['physical_descriptions'] ) ){
					$detail['physical_descriptions'] .= "\n";
				}
				$detail['physical_descriptions'] .= $physical_descriptions;
				$detail['physical_description_str'] .= "<tr>";
				$detail['physical_description_str'] .= "<td width='10'><input size=50 type='text' name='physical_description_jpn_update_".$j."' value='".$physical_descriptions."' STYLE='ime-mode:active;' /></td>\n";
				$detail['physical_description_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='physical_description_delete_update_".$j."' value='".$j."' />\n";
				$detail['physical_description_str'] .= "&nbsp;&nbsp;<select size='1' name='physical_description_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['physical_description_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['physical_description_str'] .= " selected";
					}
					$detail['physical_description_str'] .= ">".$k."</option>";
				}
				$detail['physical_description_str'] .= "</td></tr>\n";
				$j++;
			}
			$detail['physical_description_str'] .= "</table>\n";
		}
		$detail_child_langs = xnparticleGetDetailChildLangsInformation( $item_id );
		$i = count($detail_child_langs);
		if ($i > 0) {
			$j = 0;
			$detail['langs'] = "";
			$detail['lang_str'] = "<table><tr><td></td><td class='oddeven'>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_langs_id, $article_id, $langs, $langs_order ) ) = each( $detail_child_langs ) ){
				if ( !empty( $detail['langs'] ) ){
					$detail['langs'] .= "\n";
				}
				$detail['langs'] .= $langs;
				$detail['lang_str'] .= "<tr>";
				$detail['lang_str'] .= "<td width='10'><input size=50 type='text' name='lang_jpn_update_".$j."' value='".$langs."' STYLE='ime-mode:active;' /></td>\n";
				$detail['lang_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='lang_delete_update_".$j."' value='".$j."' />\n";
				$detail['lang_str'] .= "&nbsp;&nbsp;<select size='1' name='lang_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['lang_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['lang_str'] .= " selected";
					}
					$detail['lang_str'] .= ">".$k."</option>";
				}
				$detail['lang_str'] .= "</td></tr>\n";
				$j++;
			}
			$detail['lang_str'] .= "</table>\n";
		}
		$detail_child_id_issns = xnparticleGetDetailChildIdIssnsInformation( $item_id );
		$i = count($detail_child_id_issns);
		if ($i > 0) {
			$j = 0;
			$detail['id_issns'] = "";
			$detail['id_issn_str'] = "<table><tr><td></td><td class='oddeven'>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_id_issns_id, $article_id, $id_issns, $id_issns_order ) ) = each( $detail_child_id_issns ) ){
				if ( !empty( $detail['id_issns'] ) ){
					$detail['id_issns'] .= "\n";
				}
				$detail['id_issns'] .= $id_issns;
				$detail['id_issn_str'] .= "<tr>";
				$detail['id_issn_str'] .= "<td width='10'><input size=50 type='text' name='id_issn_jpn_update_".$j."' value='".$id_issns."' STYLE='ime-mode:active;' /></td>\n";
				$detail['id_issn_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='id_issn_delete_update_".$j."' value='".$j."' />\n";
				$detail['id_issn_str'] .= "&nbsp;&nbsp;<select size='1' name='id_issn_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['id_issn_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['id_issn_str'] .= " selected";
					}
					$detail['id_issn_str'] .= ">".$k."</option>";
				}
				$detail['id_issn_str'] .= "</td></tr>\n";
				$j++;
			}
			$detail['id_issn_str'] .= "</table>\n";
		}
		$detail_child_id_isbns = xnparticleGetDetailChildIdIsbnsInformation( $item_id );
		$i = count($detail_child_id_isbns);
		if ($i > 0) {
			$j = 0;
			$detail['id_isbns'] = "";
			$detail['id_isbn_str'] = "<table><tr><td></td><td class='oddeven'>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_id_isbns_id, $article_id, $id_isbns, $id_isbns_order ) ) = each( $detail_child_id_isbns ) ){
				if ( !empty( $detail['id_isbns'] ) ){
					$detail['id_isbns'] .= "\n";
				}
				$detail['id_isbns'] .= $id_isbns;
				$detail['id_isbn_str'] .= "<tr>";
				$detail['id_isbn_str'] .= "<td width='10'><input size=50 type='text' name='id_isbn_jpn_update_".$j."' value='".$id_isbns."' STYLE='ime-mode:active;' /></td>\n";
				$detail['id_isbn_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='id_isbn_delete_update_".$j."' value='".$j."' />\n";
				$detail['id_isbn_str'] .= "&nbsp;&nbsp;<select size='1' name='id_isbn_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['id_isbn_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['id_isbn_str'] .= " selected";
					}
					$detail['id_isbn_str'] .= ">".$k."</option>";
				}
				$detail['id_isbn_str'] .= "</td></tr>\n";
				$j++;
			}
			$detail['id_isbn_str'] .= "</table>\n";
		}
		$detail_child_id_dois = xnparticleGetDetailChildIdDoisInformation( $item_id );
		$i = count($detail_child_id_dois);
		if ($i > 0) {
			$j = 0;
			$detail['id_dois'] = "";
			$detail['id_doi_str'] = "<table><tr><td></td><td class='oddeven'>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_id_dois_id, $article_id, $id_dois, $id_dois_order ) ) = each( $detail_child_id_dois ) ){
				if ( !empty( $detail['id_dois'] ) ){
					$detail['id_dois'] .= "\n";
				}
				$detail['id_dois'] .= $id_dois;
				$detail['id_doi_str'] .= "<tr>";
				$detail['id_doi_str'] .= "<td width='10'><input size=50 type='text' name='id_doi_jpn_update_".$j."' value='".$id_dois."' STYLE='ime-mode:active;' /></td>\n";
				$detail['id_doi_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='id_doi_delete_update_".$j."' value='".$j."' />\n";
				$detail['id_doi_str'] .= "&nbsp;&nbsp;<select size='1' name='id_doi_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['id_doi_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['id_doi_str'] .= " selected";
					}
					$detail['id_doi_str'] .= ">".$k."</option>";
				}
				$detail['id_doi_str'] .= "</td></tr>\n";
				$j++;
			}
			$detail['id_doi_str'] .= "</table>\n";
		}
		$detail_child_id_uris = xnparticleGetDetailChildIdUrisInformation( $item_id );
		$i = count($detail_child_id_uris);
		if ($i > 0) {
			$j = 0;
			$detail['id_uris'] = "";
			$detail['id_uri_str'] = "<table><tr><td></td><td class='oddeven'>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_id_uris_id, $article_id, $id_uris, $id_uris_order ) ) = each( $detail_child_id_uris ) ){
				if ( !empty( $detail['id_uris'] ) ){
					$detail['id_uris'] .= "\n";
				}
				$detail['id_uris'] .= $id_uris;
				$detail['id_uri_str'] .= "<tr>";
				$detail['id_uri_str'] .= "<td width='10'><input size=50 type='text' name='id_uri_jpn_update_".$j."' value='".$id_uris."' STYLE='ime-mode:active;' /></td>\n";
				$detail['id_uri_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='id_uri_delete_update_".$j."' value='".$j."' />\n";
				$detail['id_uri_str'] .= "&nbsp;&nbsp;<select size='1' name='id_uri_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['id_uri_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['id_uri_str'] .= " selected";
					}
					$detail['id_uri_str'] .= ">".$k."</option>";
				}
				$detail['id_uri_str'] .= "</td></tr>\n";
				$j++;
			}
			$detail['id_uri_str'] .= "</table>\n";
		}
		$detail_child_id_locals = xnparticleGetDetailChildIdLocalsInformation( $item_id );
		$i = count($detail_child_id_locals);
		if ($i > 0) {
			$j = 0;
			$detail['id_locals'] = "";
			$detail['id_local_str'] = "<table><tr><td></td><td class='oddeven'>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_id_locals_id, $article_id, $id_locals, $id_locals_order ) ) = each( $detail_child_id_locals ) ){
				if ( !empty( $detail['id_locals'] ) ){
					$detail['id_locals'] .= "\n";
				}
				$detail['id_locals'] .= $id_locals;
				$detail['id_local_str'] .= "<tr>";
				$detail['id_local_str'] .= "<td width='10'><input size=50 type='text' name='id_local_jpn_update_".$j."' value='".$id_locals."' STYLE='ime-mode:active;' /></td>\n";
				$detail['id_local_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='id_local_delete_update_".$j."' value='".$j."' />\n";
				$detail['id_local_str'] .= "&nbsp;&nbsp;<select size='1' name='id_local_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['id_local_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['id_local_str'] .= " selected";
					}
					$detail['id_local_str'] .= ">".$k."</option>";
				}
				$detail['id_local_str'] .= "</td></tr>\n";
				$j++;
			}
			$detail['id_local_str'] .= "</table>\n";
		}
		$detail_child_uris = xnparticleGetDetailChildUrisInformation( $item_id );
		$i = count($detail_child_uris);
		if ($i > 0) {
			$j = 0;
			$detail['uris'] = "";
			$detail['uri_str'] = "<table><tr><td></td><td class='oddeven'>"._MD_XNPARTICLE_EDIT_LABEL."</td><td class='oddeven'>"._MD_XNPARTICLE_DELETE_LABEL."&nbsp;"._MD_XNPARTICLE_ORDER_LABEL."</td></tr>\n";
			while ( list( $key, list( $article_child_uris_id, $article_id, $uris, $uris_order ) ) = each( $detail_child_uris ) ){
				if ( !empty( $detail['uris'] ) ){
					$detail['uris'] .= "\n";
				}
				$detail['uris'] .= $uris;
				$detail['uri_str'] .= "<tr>";
				$detail['uri_str'] .= "<td width='10'><input size=50 type='text' name='uri_jpn_update_".$j."' value='".$uris."' STYLE='ime-mode:active;' /></td>\n";
				$detail['uri_str'] .= "<td>&nbsp;&nbsp;<input type='checkbox' name='uri_delete_update_".$j."' value='".$j."' />\n";
				$detail['uri_str'] .= "&nbsp;&nbsp;<select size='1' name='uri_order_update_".$j."'>";
				for ($k = 0; $k < $i; $k++) {
					$detail['uri_str'] .= "<option value='".$k."'";
					if ($k == $j) {
						$detail['uri_str'] .= " selected";
					}
					$detail['uri_str'] .= ">".$k."</option>";
				}
				$detail['uri_str'] .= "</td></tr>\n";
				$j++;
			}
			$detail['uri_str'] .= "</table>\n";
		}
	}
	else
		$detail = array();

	$detail = xnparticleRegisterTitleRomajiString( $detail );
	$detail = xnparticleRegisterSubTitleString( $detail );
	$detail = xnparticleRegisterAuthorString( $detail );
	$detail = xnparticleRegisterKeywordsString( $detail );
	$detail = xnparticleRegisterNdcClassificationsString( $detail );
	$detail = xnparticleRegisterPhysicalDescriptionsString( $detail );
	$detail = xnparticleRegisterLangsString( $detail );
	$detail = xnparticleRegisterIdIssnsString( $detail );
	$detail = xnparticleRegisterIdIsbnsString( $detail );
	$detail = xnparticleRegisterIdDoisString( $detail );
	$detail = xnparticleRegisterIdUrisString( $detail );
	$detail = xnparticleRegisterIdLocalsString( $detail );
	$detail = xnparticleRegisterUrisString( $detail );

	// Set into the template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTplにセットされた変数($xoops_urlとか)を、$tplにコピーする。

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'article_images', $article_images );
	$tpl->assign( 'article_attachment', $article_attachment );
	$tpl->assign( 'detail', $detail );

	
	// Return as HTML
	return $tpl->fetch( "db:xnparticle_register_block.html" );
}


function xnparticleGetConfirmBlock( $item_id ){
	// Get "BasicInformation / Preview / index block"
	$basic   = xnpGetBasicInformationConfirmBlock( $item_id );
	$index   = xnpGetIndexConfirmBlock( $item_id );
	$article_attachment = xnpGetAttachmentConfirmBlock( $item_id, 'article_attachment' );
	$article_images = xnpGetPreviewConfirmBlock( $item_id );
	
	// Get DetailInformation
	if ( isset( $_POST['title'] ) ){
		$myts =& MyTextSanitizer::getInstance();
		$detail = array(
			'title'                           =>array( 'value' => $myts->stripSlashesGPC( $_POST['title'               ]) ),
			'title_kana'                      =>array( 'value' => $myts->stripSlashesGPC( $_POST['title_kana'          ]) ),
			'title_romaji'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['title_romaji'        ]) ),
			'sub_title_name'                     =>array( 'value' => $myts->stripSlashesGPC( $_POST['sub_title_name'         ]) ),
			'sub_title_kana'                     =>array( 'value' => $myts->stripSlashesGPC( $_POST['sub_title_kana'         ]) ),
			'sub_title_romaji'                   =>array( 'value' => $myts->stripSlashesGPC( $_POST['sub_title_romaji'       ]) ),
			'author_id'                       =>array( 'value' => $myts->stripSlashesGPC( $_POST['author_id'         ]) ),
			'author_name'                     =>array( 'value' => $myts->stripSlashesGPC( $_POST['author_name'         ]) ),
			'author_kana'                     =>array( 'value' => $myts->stripSlashesGPC( $_POST['author_kana'         ]) ),
			'author_romaji'                   =>array( 'value' => $myts->stripSlashesGPC( $_POST['author_romaji'       ]) ),
			'author_affiliation'              =>array( 'value' => $myts->stripSlashesGPC( $_POST['author_affiliation'  ]) ),
			'author_affiliation_translation'  =>array( 'value' => $myts->stripSlashesGPC( $_POST['author_affiliation_translation'  ]) ),
			'author_role'                     =>array( 'value' => $myts->stripSlashesGPC( $_POST['author_role'         ]) ),
			'author_link'                     =>array( 'value' => $myts->stripSlashesGPC( $_POST['author_link'         ]) ),
			'publisher'                         =>array( 'value' => $myts->stripSlashesGPC( $_POST['publisher'             ]) ),
			'publisher_kana'                         =>array( 'value' => $myts->stripSlashesGPC( $_POST['publisher_kana'             ]) ),
			'publisher_romaji'                         =>array( 'value' => $myts->stripSlashesGPC( $_POST['publisher_romaji'             ]) ),
			'year_f'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['year_f'                ]) ),
			'year_t'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['year_t'                ]) ),
			'date_create'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['date_create'                ]) ),
			'date_update'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['date_update'                ]) ),
			'date_record'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['date_record'                ]) ),
			'jtitle'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['jtitle'                ]) ),
			'jtitle_translation'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['jtitle_translation'                ]) ),
			'jtitle_volume'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['jtitle_volume'                ]) ),
			'jtitle_issue'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['jtitle_issue'                ]) ),
			'jtitle_year'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['jtitle_year'                ]) ),
			'jtitle_month'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['jtitle_month'                ]) ),
			'jtitle_spage'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['jtitle_spage'                ]) ),
			'jtitle_epage'                          =>array( 'value' => $myts->stripSlashesGPC( $_POST['jtitle_epage'                ]) ),
			'abstract'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['abstract'            ]) ),
			'table_of_contents'               =>array( 'value' => $myts->stripSlashesGPC( $_POST['table_of_contents'   ]) ),
			'edition'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['edition'            ]) ),
			'publish_place'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['publish_place'            ]) ),
			//'keywords_str'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['keywords_str'        ]) ),
			'keywords'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['keywords'            ]) ),
			//'ndc_classifications_str'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['ndc_classifications_str'        ]) ),
			'ndc_classifications'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['ndc_classifications'            ]) ),
			//'physical_descriptions_str'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['physical_descriptions_str'        ]) ),
			'physical_descriptions'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['physical_descriptions'            ]) ),
			//'langs_str'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['langs_str'        ]) ),
			'langs'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['langs'            ]) ),
			//'id_issns_str'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['id_issns_str'        ]) ),
			'id_issns'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['id_issns'            ]) ),
			//'id_isbns_str'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['id_isbns_str'        ]) ),
			'id_isbns'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['id_isbns'            ]) ),
			//'id_dois_str'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['id_dois_str'        ]) ),
			'id_dois'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['id_dois'            ]) ),
			//'id_uris_str'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['id_uris_str'        ]) ),
			'id_uris'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['id_uris'            ]) ),
			//'id_locals_str'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['id_locals_str'        ]) ),
			'id_locals'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['id_locals'            ]) ),
			//'uris_str'                    =>array( 'value' => $myts->stripSlashesGPC( $_POST['uris_str'        ]) ),
			'uris'                        =>array( 'value' => $myts->stripSlashesGPC( $_POST['uris'            ]) ),
			'type_of_resource'                =>array( 'value' => $myts->stripSlashesGPC( $_POST['type_of_resource'    ]) ),
			'genre'                           =>array( 'value' => $myts->stripSlashesGPC( $_POST['genre'               ]) ),
			'access_condition'                =>array( 'value' => $myts->stripSlashesGPC( $_POST['access_condition'    ]) )
		);
		xnpConfirmHtml( $detail, 'xnparticle_item_detail' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_sub_title' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_author' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_keywords' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_ndc_classifications' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_physical_descriptions' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_langs' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_id_issns' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_id_isbns' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_id_dois' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_id_uris' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_id_locals' );
		xnpConfirmHtml( $detail, 'xnparticle_item_detail_child_uris' );
		
		$sub_title_name                    = explode( "\n", $detail['sub_title_name'                   ]['value'] );
		$sub_title_kana                    = explode( "\n", $detail['sub_title_kana'                   ]['value'] );
		$sub_title_romaji                  = explode( "\n", $detail['sub_title_romaji'                 ]['value'] );
		$i = 0;
		reset($sub_title_kana);
		reset($sub_title_romaji);
		$detail['sub_title_str'] = array( 'value' => "<table>\n" );
		foreach ( $sub_title_name as  $value ){
			$sub_title_name_1 = ( $value != " " ) ? $value : "";
			$sub_title_kana_1 = ( current($sub_title_kana) != " " ) ? current($sub_title_kana) : "";
			$sub_title_romaji_1 = ( current($sub_title_romaji) != " " ) ? current($sub_title_romaji) : "";
			$detail['sub_title_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value." (".$sub_title_kana_1.":".$sub_title_romaji_1.")</td></tr>\n";
			next($sub_title_kana);
			next($sub_title_romaji);
			$i++;
		}
		$detail['sub_title_str']['value'] .= "</table>";
		$detail['sub_title_cnt'] = array( 'value' => strval(fmod(count($sub_title_name), 2)));

		$author_id                      = explode( "\n", $detail['author_id'                     ]['value'] );
		$author_name                    = explode( "\n", $detail['author_name'                   ]['value'] );
		$author_kana                    = explode( "\n", $detail['author_kana'                   ]['value'] );
		$author_romaji                  = explode( "\n", $detail['author_romaji'                 ]['value'] );
		$author_affiliation             = explode( "\n", $detail['author_affiliation'            ]['value'] );
		$author_affiliation_translation = explode( "\n", $detail['author_affiliation_translation']['value'] );
		$author_role                    = explode( "\n", $detail['author_role'                   ]['value'] );
		$author_link                    = explode( "\n", $detail['author_link'                   ]['value'] );
		$i = 0;
		reset($author_id);
		reset($author_kana);
		reset($author_romaji);
		reset($author_affiliation);
		reset($author_affiliation_translation);
		reset($author_role);
		reset($author_link);
		$detail['author_str'] = array( 'value' => "<table>\n" );
		foreach ( $author_name as  $value ){
			$author_id_1 = ( current($author_id) != " " ) ? current($author_id) : "";
			$author_name_1 = ( $value != " " ) ? $value : "";
			$author_kana_1 = ( current($author_kana) != " " ) ? current($author_kana) : "";
			$author_romaji_1 = ( current($author_romaji) != " " ) ? current($author_romaji) : "";
			$author_affiliation_1 = ( current($author_affiliation) != " " ) ? current($author_affiliation) : "";
			$author_affiliation_translation_1 = ( current($author_affiliation_translation) != " " ) ? current($author_affiliation_translation) : "";
			$author_role_1 = ( current($author_role) != " " ) ? current($author_role) : "";
			$author_link_1 = ( current($author_link) != " " ) ? current($author_link) : "";
			$detail['author_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td width='70'>"._MD_XNPARTICLE_AUTHOR_ID_LABEL."</td><td>:&nbsp;".$author_id_1."</td></tr>\n";
			$detail['author_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td width='70'>"._MD_XNPARTICLE_AUTHOR_NAME_LABEL."</td><td>:&nbsp;".$value." (".$author_kana_1.":".$author_romaji_1.")</td></tr>\n";
			$detail['author_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td width='70'>"._MD_XNPARTICLE_AUTHOR_AFFILIATION_LABEL."</td><td>:&nbsp;".$author_affiliation_1."(".$author_affiliation_translation_1.")</td></tr>\n";
			$detail['author_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td width='70'>"._MD_XNPARTICLE_AUTHOR_ROLE_LABEL."</td><td>:&nbsp;".$author_role_1."</td></tr>\n";
			$detail['author_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td width='70'>"._MD_XNPARTICLE_AUTHOR_LINK_LABEL."</td><td>:&nbsp;<a href='".$author_link_1."'>".$author_link_1."</a></td></tr>\n";
			next($author_id);
			next($author_kana);
			next($author_romaji);
			next($author_affiliation);
			next($author_affiliation_translation);
			next($author_role);
			next($author_link);
			$i++;
		}
		$detail['author_str']['value'] .= "</table>";
		$detail['author_cnt'] = array( 'value' => strval(fmod(count($author_name), 2)));
		$detail['keyword_str'] = array( 'value' => "" );
		if ( !empty( $detail['keywords'] ) ){
			$detail['keyword_str']['value'] = "<table>\n";
			$keywords = explode( "\n", $detail['keywords']['value'] );
			$i = 0;
			foreach ( $keywords as  $value ){
				$detail['keyword_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value."</td></tr>\n";
				$i++;
			}
			$detail['keyword_str']['value'] .= "</table>";
			$detail['keywords_cnt'] = array( 'value' => strval(fmod(count($keywords), 2)));
		}
		$detail['ndc_classification_str'] = array( 'value' => "" );
		if ( !empty( $detail['ndc_classifications'] ) ){
			$detail['ndc_classification_str']['value'] = "<table>\n";
			$ndc_classifications = explode( "\n", $detail['ndc_classifications']['value'] );
			$i = 0;
			foreach ( $ndc_classifications as  $value ){
				$detail['ndc_classification_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value."</td></tr>\n";
				$i++;
			}
			$detail['ndc_classification_str']['value'] .= "</table>";
			$detail['ndc_classifications_cnt'] = array( 'value' => strval(fmod(count($ndc_classifications), 2)));
		}
		$detail['physical_description_str'] = array( 'value' => "" );
		if ( !empty( $detail['physical_descriptions'] ) ){
			$detail['physical_description_str']['value'] = "<table>\n";
			$physical_descriptions = explode( "\n", $detail['physical_descriptions']['value'] );
			$i = 0;
			foreach ( $physical_descriptions as  $value ){
				$detail['physical_description_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value."</td></tr>\n";
				$i++;
			}
			$detail['physical_description_str']['value'] .= "</table>";
			$detail['physical_descriptions_cnt'] = array( 'value' => strval(fmod(count($physical_descriptions), 2)));
		}
		$detail['lang_str'] = array( 'value' => "" );
		if ( !empty( $detail['langs'] ) ){
			$detail['lang_str']['value'] = "<table>\n";
			$langs = explode( "\n", $detail['langs']['value'] );
			$i = 0;
			foreach ( $langs as  $value ){
				$detail['lang_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value."</td></tr>\n";
				$i++;
			}
			$detail['lang_str']['value'] .= "</table>";
			$detail['langs_cnt'] = array( 'value' => strval(fmod(count($langs), 2)));
		}
		$detail['id_issn_str'] = array( 'value' => "" );
		if ( !empty( $detail['id_issns'] ) ){
			$detail['id_issn_str']['value'] = "<table>\n";
			$id_issns = explode( "\n", $detail['id_issns']['value'] );
			$i = 0;
			foreach ( $id_issns as  $value ){
				$detail['id_issn_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value."</td></tr>\n";
				$i++;
			}
			$detail['id_issn_str']['value'] .= "</table>";
			$detail['id_issns_cnt'] = array( 'value' => strval(fmod(count($id_issns), 2)));
		}
		$detail['id_isbn_str'] = array( 'value' => "" );
		if ( !empty( $detail['id_isbns'] ) ){
			$detail['id_isbn_str']['value'] = "<table>\n";
			$id_isbns = explode( "\n", $detail['id_isbns']['value'] );
			$i = 0;
			foreach ( $id_isbns as  $value ){
				$detail['id_isbn_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value."</td></tr>\n";
				$i++;
			}
			$detail['id_isbn_str']['value'] .= "</table>";
			$detail['id_isbns_cnt'] = array( 'value' => strval(fmod(count($id_isbns), 2)));
		}
		$detail['id_doi_str'] = array( 'value' => "" );
		if ( !empty( $detail['id_dois'] ) ){
			$detail['id_doi_str']['value'] = "<table>\n";
			$id_dois = explode( "\n", $detail['id_dois']['value'] );
			$i = 0;
			foreach ( $id_dois as  $value ){
				$detail['id_doi_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value."</td></tr>\n";
				$i++;
			}
			$detail['id_doi_str']['value'] .= "</table>";
			$detail['id_dois_cnt'] = array( 'value' => strval(fmod(count($id_dois), 2)));
		}
		$detail['id_uri_str'] = array( 'value' => "" );
		if ( !empty( $detail['id_uris'] ) ){
			$detail['id_uri_str']['value'] = "<table>\n";
			$id_uris = explode( "\n", $detail['id_uris']['value'] );
			$i = 0;
			foreach ( $id_uris as  $value ){
				$detail['id_uri_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value."</td></tr>\n";
				$i++;
			}
			$detail['id_uri_str']['value'] .= "</table>";
			$detail['id_uris_cnt'] = array( 'value' => strval(fmod(count($id_uris), 2)));
		}
		$detail['id_local_str'] = array( 'value' => "" );
		if ( !empty( $detail['id_locals'] ) ){
			$detail['id_local_str']['value'] = "<table>\n";
			$id_locals = explode( "\n", $detail['id_locals']['value'] );
			$i = 0;
			foreach ( $id_locals as  $value ){
				$detail['id_local_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value."</td></tr>\n";
				$i++;
			}
			$detail['id_local_str']['value'] .= "</table>";
			$detail['id_locals_cnt'] = array( 'value' => strval(fmod(count($id_locals), 2)));
		}
		$detail['uri_str'] = array( 'value' => "" );
		if ( !empty( $detail['uris'] ) ){
			$detail['uri_str']['value'] = "<table>\n";
			$uris = explode( "\n", $detail['uris']['value'] );
			$i = 0;
			foreach ( $uris as  $value ){
				$detail['uri_str']['value'] .= "<tr class='oddeven".fmod($i, 2)."'><td>".$value."</td></tr>\n";
				$i++;
			}
			$detail['uri_str']['value'] .= "</table>";
			$detail['uris_cnt'] = array( 'value' => strval(fmod(count($uris), 2)));
		}
	}
	else
		$detail = array();
	
	if ( xnpHasWithout( $basic ) || xnpHasWithout( $detail ) 
	  || xnpHasWithout( $article_attachment ) || xnpHasWithout( $article_images ) ){
		global $system_message;
		$system_message = $system_message."\n<br /><font color='#ff0000'>" . _MD_XOONIPS_ITEM_WARNING_FIELD_TRIM . "</font><br />";
	}
	
	// Set into the template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTplにセットされた変数($xoops_urlとか)を、$tplにコピーする。
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'article_attachment', $article_attachment );
	$tpl->assign( 'article_images', $article_images );
	$tpl->assign( 'detail', $detail );
	
	// Return as HTML
	return $tpl->fetch( "db:xnparticle_confirm_block.html" );
}

/** DetailInformationの入力チェックを行う。
 * 登録確認画面、登録完了画面の2ヶ所から呼ばれる。
 */
function xnparticleCheckRegisterParameters( &$message ){
	$messages = array();
	if ( empty( $_POST['title'] ) )  $messages[] = "title required.";
	if ( count($messages) == 0 )
		return true;
	$message = implode( "", $messages );
	return false;
}

/** DetailInformationの入力チェックを行う。
 */
function xnparticleCheckEditParameters( &$message ){
	return xnparticleCheckRegisterParameters( $message );
}

function xnparticleInsertItem(){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// BasicInformation, Index, Attachmentの登録
	$detail_title = $_POST['title'];
	$detail_keywords = $_POST['keywords'];
	$detail_ndc_classifications = $_POST['ndc_classifications'];
	$detail_physical_descriptions = $_POST['physical_descriptions'];
	$detail_langs = $_POST['langs'];
	$detail_id_issns = $_POST['id_issns'];
	$detail_id_isbns = $_POST['id_isbns'];
	$detail_id_dois = $_POST['id_dois'];
	$detail_id_uris = $_POST['id_uris'];
	$detail_id_locals = $_POST['id_locals'];
	$detail_uris = $_POST['uris'];
	$_POST['title'] .= "\n"."\n".$_POST['title_kana']."\n".$_POST['title_romaji'];
	$_POST['keywords'] = xnparticleTrimRepeatableColumn( $_POST['keywords']);
	$_POST['ndc_classifications'] = xnparticleTrimRepeatableColumn( $_POST['ndc_classifications']);
	$_POST['physical_descriptions'] = xnparticleTrimRepeatableColumn( $_POST['physical_descriptions']);
	$_POST['langs'] = xnparticleTrimRepeatableColumn( $_POST['langs']);
	$_POST['id_issns'] = xnparticleTrimRepeatableColumn( $_POST['id_issns']);
	$_POST['id_isbns'] = xnparticleTrimRepeatableColumn( $_POST['id_isbns']);
	$_POST['id_dois'] = xnparticleTrimRepeatableColumn( $_POST['id_dois']);
	$_POST['id_uris'] = xnparticleTrimRepeatableColumn( $_POST['id_uris']);
	$_POST['id_locals'] = xnparticleTrimRepeatableColumn( $_POST['id_locals']);
	$_POST['uris'] = xnparticleTrimRepeatableColumn( $_POST['uris']);
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'article_attachment' );
				if ( $result ){
				}
			}
		}
		if ( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if ( !$result )
		return false;
	
	// 文字数制限
	$myts =& MyTextSanitizer::getInstance();
	$ar = array(
		'title'               =>encodeForm2Server($myts->addSlashes( $detail_title )),
		'title_kana'          =>encodeForm2Server($myts->addSlashes( $_POST['title_kana'        ] )),
		'title_romaji'        =>encodeForm2Server($myts->addSlashes( $_POST['title_romaji'      ] )),
		'publisher'           =>encodeForm2Server($myts->addSlashes( $_POST['publisher'         ] )),
		'publisher_kana'      =>encodeForm2Server($myts->addSlashes( $_POST['publisher_kana'    ] )),
		'publisher_romaji'    =>encodeForm2Server($myts->addSlashes( $_POST['publisher_romaji'  ] )),
		'year_f'              =>encodeForm2Server($myts->addSlashes( $_POST['year_f'        ] )),
		'year_t'              =>encodeForm2Server($myts->addSlashes( $_POST['year_t'        ] )),
		'date_create'         =>encodeForm2Server($myts->addSlashes( $_POST['date_create'   ] )),
		'date_update'         =>encodeForm2Server($myts->addSlashes( $_POST['date_update'   ] )),
		'date_record'         =>encodeForm2Server($myts->addSlashes( $_POST['date_record'   ] )),
		'jtitle'              =>encodeForm2Server($myts->addSlashes( $_POST['jtitle'        ] )),
		'jtitle_translation'  =>encodeForm2Server($myts->addSlashes( $_POST['jtitle_translation'] )),
		'jtitle_volume'       =>encodeForm2Server($myts->addSlashes( $_POST['jtitle_volume' ] )),
		'jtitle_issue'        =>encodeForm2Server($myts->addSlashes( $_POST['jtitle_issue'  ] )),
		'jtitle_year'         =>encodeForm2Server($myts->addSlashes( $_POST['jtitle_year'   ] )),
		'jtitle_month'        =>encodeForm2Server($myts->addSlashes( $_POST['jtitle_month'  ] )),
		'jtitle_spage'        =>encodeForm2Server($myts->addSlashes( $_POST['jtitle_spage'  ] )),
		'jtitle_epage'        =>encodeForm2Server($myts->addSlashes( $_POST['jtitle_epage'  ] )),
		'abstract'            =>encodeForm2Server($myts->addSlashes( $_POST['abstract'           ] )),
		'table_of_contents'   =>encodeForm2Server($myts->addSlashes( $_POST['table_of_contents'  ] )),
		'edition'             =>encodeForm2Server($myts->addSlashes( $_POST['edition'            ] )),
		'publish_place'       =>encodeForm2Server($myts->addSlashes( $_POST['publish_place'      ] )),
		'type_of_resource'    =>encodeForm2Server($myts->addSlashes( $_POST['type_of_resource'   ] )),
		'genre'               =>encodeForm2Server($myts->addSlashes( $_POST['genre'              ] )),
		'access_condition'    =>encodeForm2Server($myts->addSlashes( $_POST['access_condition'   ] )),
	);
	xnpTrimColumn( $ar, 'xnparticle_item_detail' );
	
	$myts =& MyTextSanitizer::getInstance();
	$keys = implode( ",", array(
		'title'               ,
		'title_kana'          ,
		'title_romaji'        ,
		'publisher'           ,
		'publisher_kana'      ,
		'publisher_romaji'    ,
		'year_f'              ,
		'year_t'              ,
		'date_create'         ,
		'date_update'         ,
		'date_record'         ,
		'jtitle'              ,
		'jtitle_translation'  ,
		'jtitle_volume'       ,
		'jtitle_issue'        ,
		'jtitle_year'         ,
		'jtitle_month'        ,
		'jtitle_spage'        ,
		'jtitle_epage'        ,
		'abstract'            ,
		'table_of_contents'   ,
		'edition'             ,
		'publish_place'       ,
		'type_of_resource'    ,
		'genre'               ,
		'access_condition'    ,
	) );
	
	$vals = implode( ",", array(
		                                         "'".$ar['title'               ]."'",
		                                         "'".$ar['title_kana'          ]."'",
		                                         "'".$ar['title_romaji'        ]."'",
		                                         "'".$ar['publisher'           ]."'",
		                                         "'".$ar['publisher_kana'      ]."'",
		                                         "'".$ar['publisher_romaji'    ]."'",
		                                         "'".$ar['year_f'    ]."'",
		                                         "'".$ar['year_t'    ]."'",
		                                         "'".$ar['date_create'    ]."'",
		                                         "'".$ar['date_update'    ]."'",
		                                         "'".$ar['date_record'    ]."'",
		                                         "'".$ar['jtitle'    ]."'",
		                                         "'".$ar['jtitle_translation'    ]."'",
		                                         "'".$ar['jtitle_volume'    ]."'",
		                                         "'".$ar['jtitle_issue'    ]."'",
		                                         "'".$ar['jtitle_year'    ]."'",
		                                         "'".$ar['jtitle_month'    ]."'",
		                                         "'".$ar['jtitle_spage'    ]."'",
		                                         "'".$ar['jtitle_epage'    ]."'",
		strlen($_POST['abstract'])==0 ? "null" : "'".$ar['abstract'            ]."'",
      		strlen($_POST['table_of_contents'])==0 ? "null" : "'".$ar['table_of_contents'            ]."'",
		                                         "'".$ar['edition'            ]."'",
		                                         "'".$ar['publish_place'            ]."'",
		                                         "'".$ar['type_of_resource'    ]."'",
		                                         "'".$ar['genre'               ]."'",
		strlen($_POST['access_condition'])==0 ? "null" : "'".$ar['access_condition'            ]."'",
	) );
	
	
	// Registration of the DetailInformation
	$myts =& MyTextSanitizer::getInstance();
	$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo "cannot insert item_detail";
		return false;
	}
	
	if ((!empty( $_POST['sub_title_name'])) || (!empty( $_POST['sub_title_kana'])) || (!empty($_POST['sub_title_romaji'])) ){
		$myts =& MyTextSanitizer::getInstance();
                $sub_title_name                    = xnparticleTrimArray( explode( "\n", $_POST['sub_title_name'] ));
                $sub_title_kana                    = xnparticleTrimArray( explode( "\n", $_POST['sub_title_kana'] ));
                $sub_title_romaji                  = xnparticleTrimArray( explode( "\n", $_POST['sub_title_romaji'] ));
		reset($sub_title_kana);
		reset($sub_title_romaji);
		
		$keys = implode( ",", array(
			'sub_title_name'                    ,
			'sub_title_kana'                    ,
			'sub_title_romaji'                  ,
			'sub_title_order'
		) );
		$i = 0;
		foreach ( $sub_title_name as  $value ){
			$sub_title_name_1 = ( $value != " " ) ? $value : "";
			$sub_title_kana_1 = ( current($sub_title_kana) != " " ) ?  current($sub_title_kana) : "";
			$sub_title_romaji_1 = ( current($sub_title_romaji) != " " ) ? current($sub_title_romaji) : "";
			
			$ar = array(
				'sub_title_name'                     => $myts->stripSlashesGPC( $sub_title_name_1                    ),
				'sub_title_kana'                     => $myts->stripSlashesGPC( $sub_title_kana_1                    ),
				'sub_title_romaji'                   => $myts->stripSlashesGPC( $sub_title_romaji_1                  ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_sub_title' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['sub_title_name'                   ]))."'",
				"'".addslashes(trim($ar['sub_title_kana'                   ]))."'",
				"'".addslashes(trim($ar['sub_title_romaji'                 ]))."'",
				$i
			) );
			// Registration of the DetailInformation Child Author
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_sub_title") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_sub_title";
				return false;
			}
			$i++;
			next($sub_title_kana);
			next($sub_title_romaji);
		}
	}

	if ((!empty( $_POST['author_id'])) || (!empty( $_POST['author_name'])) || (!empty( $_POST['author_kana'])) || (!empty($_POST['author_romaji'])) || (!empty( $_POST['author_affiliation'])) || (!empty( $_POST['author_affiliation_translation']))){
		$myts =& MyTextSanitizer::getInstance();
                $author_id                      = xnparticleTrimArray( explode( "\n", $_POST['author_id'] ));
                $author_name                    = xnparticleTrimArray( explode( "\n", $_POST['author_name'] ));
                $author_kana                    = xnparticleTrimArray( explode( "\n", $_POST['author_kana'] ));
                $author_romaji                  = xnparticleTrimArray( explode( "\n", $_POST['author_romaji'] ));
                $author_affiliation             = xnparticleTrimArray( explode( "\n", $_POST['author_affiliation'] ));
                $author_affiliation_translation = xnparticleTrimArray( explode( "\n", $_POST['author_affiliation_translation'] ));
                $author_role                    = xnparticleTrimArray( explode( "\n", $_POST['author_role'] ));
                $author_link                    = xnparticleTrimArray( explode( "\n", $_POST['author_link'] ));
		reset($author_id);
		reset($author_kana);
		reset($author_romaji);
		reset($author_affiliation);
		reset($author_affiliation_translation);
		reset($author_role);
		reset($author_link);
		
		$keys = implode( ",", array(
			'author_id'                    ,
			'author_name'                    ,
			'author_kana'                    ,
			'author_romaji'                  ,
			'author_affiliation'             ,
			'author_affiliation_translation' ,
			'author_role'                    ,
			'author_link'                    ,
			'author_order'
		) );
		$i = 0;
		foreach ( $author_name as  $value ){
			$author_id_1 = ( current($author_id) != " " ) ?  current($author_id) : "";
			$author_name_1 = ( $value != " " ) ? $value : "";
			$author_kana_1 = ( current($author_kana) != " " ) ?  current($author_kana) : "";
			$author_romaji_1 = ( current($author_romaji) != " " ) ? current($author_romaji) : "";
			$author_affiliation_1 = ( current($author_affiliation) != " " ) ? current($author_affiliation) : "";
			$author_affiliation_translation_1 = ( current($author_affiliation_translation) != " " ) ? current($author_affiliation_translation) : "";
			$author_role_1 = ( current($author_role) != " " ) ?  current($author_role) : "";
			$author_link_1 = ( current($author_link) != " " ) ?  current($author_link) : "";
			
			$ar = array(
				'author_id'                       => $myts->stripSlashesGPC( $author_id_1                    ),
				'author_name'                     => $myts->stripSlashesGPC( $author_name_1                    ),
				'author_kana'                     => $myts->stripSlashesGPC( $author_kana_1                    ),
				'author_romaji'                   => $myts->stripSlashesGPC( $author_romaji_1                  ),
				'author_affiliation'              => $myts->stripSlashesGPC( $author_affiliation_1             ),
				'author_affiliation_translation'  => $myts->stripSlashesGPC( $author_affiliation_translation_1 ),
				'author_role'                     => $myts->stripSlashesGPC( $author_role_1                    ),
				'author_link'                     => $myts->stripSlashesGPC( $author_link_1                    ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_author' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['author_id'                     ]))."'",
				"'".addslashes(trim($ar['author_name'                   ]))."'",
				"'".addslashes(trim($ar['author_kana'                   ]))."'",
				"'".addslashes(trim($ar['author_romaji'                 ]))."'",
				"'".addslashes(trim($ar['author_affiliation'            ]))."'",
				"'".addslashes(trim($ar['author_affiliation_translation']))."'",
				"'".addslashes(trim($ar['author_role'                   ]))."'",
				"'".addslashes(trim($ar['author_link'                   ]))."'",
				$i
			) );

			// Registration of the DetailInformation Child Author
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_author") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_author";
				return false;
			}
			$i++;
			next($author_id);
			next($author_kana);
			next($author_romaji);
			next($author_affiliation);
			next($author_affiliation_translation);
			next($author_role);
			next($author_link);
		}
	}
	
	if ( !empty( $detail_keywords ) ){
		$myts =& MyTextSanitizer::getInstance();
		$keywords = explode( "\n", $detail_keywords );
		$keys = implode( ",", array(
			'keywords'      ,
			'keywords_order'
		) );
		$i = 0;
		foreach ( $keywords as  $value ){
			$keywords_1 = ( $value != " " ) ? $value : "";
			
			$ar = array(
				'keywords' => $myts->stripSlashesGPC( $keywords_1 ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_keywords' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['keywords']))."'",
				$i
			) );
			
			// Registration of the DetailInformation Child Keywords
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_keywords") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_keywords";
				return false;
			}
			$i++;
		}
	}
	
	if ( !empty( $detail_ndc_classifications ) ){
		$myts =& MyTextSanitizer::getInstance();
		$ndc_classifications = explode( "\n", $detail_ndc_classifications );
		$keys = implode( ",", array(
			'ndc_classifications'      ,
			'ndc_classifications_order'
		) );
		$i = 0;
		foreach ( $ndc_classifications as  $value ){
			$ndc_classifications_1 = ( $value != " " ) ? $value : "";
			
			$ar = array(
				'ndc_classifications' => $myts->stripSlashesGPC( $ndc_classifications_1 ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_ndc_classifications' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['ndc_classifications']))."'",
				$i
			) );
			
			// Registration of the DetailInformation Child Ndc_classifications
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_ndc_classifications") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_ndc_classifications";
				return false;
			}
			$i++;
		}
	}

	if ( !empty( $detail_physical_descriptions ) ){
		$myts =& MyTextSanitizer::getInstance();
		$physical_descriptions = explode( "\n", $detail_physical_descriptions );
		$keys = implode( ",", array(
			'physical_descriptions'      ,
			'physical_descriptions_order'
		) );
		$i = 0;
		foreach ( $physical_descriptions as  $value ){
			$physical_descriptions_1 = ( $value != " " ) ? $value : "";
			
			$ar = array(
				'physical_descriptions' => $myts->stripSlashesGPC( $physical_descriptions_1 ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_physical_descriptions' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['physical_descriptions']))."'",
				$i
			) );
			
			// Registration of the DetailInformation Child Physical_description
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_physical_descriptions") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_physical_descriptions";
				return false;
			}
			$i++;
		}
	}

	if ( !empty( $detail_langs ) ){
		$myts =& MyTextSanitizer::getInstance();
		$langs = explode( "\n", $detail_langs );
		$keys = implode( ",", array(
			'langs'      ,
			'langs_order'
		) );
		$i = 0;
		foreach ( $langs as  $value ){
			$langs_1 = ( $value != " " ) ? $value : "";
			
			$ar = array(
				'langs' => $myts->stripSlashesGPC( $langs_1 ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_langs' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['langs']))."'",
				$i
			) );
			
			// Registration of the DetailInformation Child Lang
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_langs") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_langs";
				return false;
			}
			$i++;
		}
	}

	if ( !empty( $detail_id_issns ) ){
		$myts =& MyTextSanitizer::getInstance();
		$id_issns = explode( "\n", $detail_id_issns );
		$keys = implode( ",", array(
			'id_issns'      ,
			'id_issns_order'
		) );
		$i = 0;
		foreach ( $id_issns as  $value ){
			$id_issns_1 = ( $value != " " ) ? $value : "";
			
			$ar = array(
				'id_issns' => $myts->stripSlashesGPC( $id_issns_1 ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_id_issns' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['id_issns']))."'",
				$i
			) );
			
			// Registration of the DetailInformation Child Issn
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_issns") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_id_issns";
				return false;
			}
			$i++;
		}
	}

	if ( !empty( $detail_id_isbns ) ){
		$myts =& MyTextSanitizer::getInstance();
		$id_isbns = explode( "\n", $detail_id_isbns );
		$keys = implode( ",", array(
			'id_isbns'      ,
			'id_isbns_order'
		) );
		$i = 0;
		foreach ( $id_isbns as  $value ){
			$id_isbns_1 = ( $value != " " ) ? $value : "";
			
			$ar = array(
				'id_isbns' => $myts->stripSlashesGPC( $id_isbns_1 ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_id_isbns' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['id_isbns']))."'",
				$i
			) );
			
			// Registration of the DetailInformation Child Isbn
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_isbns") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_id_isbns";
				return false;
			}
			$i++;
		}
	}

	if ( !empty( $detail_id_dois ) ){
		$myts =& MyTextSanitizer::getInstance();
		$id_dois = explode( "\n", $detail_id_dois );
		$keys = implode( ",", array(
			'id_dois'      ,
			'id_dois_order'
		) );
		$i = 0;
		foreach ( $id_dois as  $value ){
			$id_dois_1 = ( $value != " " ) ? $value : "";
			
			$ar = array(
				'id_dois' => $myts->stripSlashesGPC( $id_dois_1 ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_id_dois' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['id_dois']))."'",
				$i
			) );
			
			// Registration of the DetailInformation Child Doi
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_dois") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_id_dois";
				return false;
			}
			$i++;
		}
	}

	if ( !empty( $detail_id_uris ) ){
		$myts =& MyTextSanitizer::getInstance();
		$id_uris = explode( "\n", $detail_id_uris );
		$keys = implode( ",", array(
			'id_uris'      ,
			'id_uris_order'
		) );
		$i = 0;
		foreach ( $id_uris as  $value ){
			$id_uris_1 = ( $value != " " ) ? $value : "";
			
			$ar = array(
				'id_uris' => $myts->stripSlashesGPC( $id_uris_1 ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_id_uris' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['id_uris']))."'",
				$i
			) );
			
			// Registration of the DetailInformation Child Uri
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_uris") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_id_uris";
				return false;
			}
			$i++;
		}
	}

	if ( !empty( $detail_id_locals ) ){
		$myts =& MyTextSanitizer::getInstance();
		$id_locals = explode( "\n", $detail_id_locals );
		$keys = implode( ",", array(
			'id_locals'      ,
			'id_locals_order'
		) );
		$i = 0;
		foreach ( $id_locals as  $value ){
			$id_locals_1 = ( $value != " " ) ? $value : "";
			
			$ar = array(
				'id_locals' => $myts->stripSlashesGPC( $id_locals_1 ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_id_locals' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['id_locals']))."'",
				$i
			) );
			
			// Registration of the DetailInformation Child Local
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_locals") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_id_locals";
				return false;
			}
			$i++;
		}
	}

	if ( !empty( $detail_uris ) ){
		$myts =& MyTextSanitizer::getInstance();
		$uris = explode( "\n", $detail_uris );
		$keys = implode( ",", array(
			'uris'      ,
			'uris_order'
		) );
		$i = 0;
		foreach ( $uris as  $value ){
			$uris_1 = ( $value != " " ) ? $value : "";
			
			$ar = array(
				'uris' => $myts->stripSlashesGPC( $uris_1 ),
			);
			xnpTrimColumn( $ar, 'xnparticle_item_detail_child_uris' );
			
			$vals = implode( ",", array(
				"'".addslashes(trim($ar['uris']))."'",
				$i
			) );
			
			// Registration of the DetailInformation Child URI
			$myts =& MyTextSanitizer::getInstance();
			$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_uris") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
			$result = $xoopsDB->queryF( $sql );
			if ( $result == false ){
				echo "cannot insert item_detail_child_uris";
				return false;
			}
			$i++;
		}
	}

	return true;
}

function xnparticleUpdateItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance();
	
	// Edit the "BasicInformation, Index, Preview, Attachment"
	$detail_title = $_POST['title'];
	$detail_keywords = $_POST['keywords'];
	$detail_ndc_classifications = $_POST['ndc_classifications'];
	$detail_physical_descriptions = $_POST['physical_descriptions'];
	$detail_langs = $_POST['langs'];
	$detail_id_issns = $_POST['id_issns'];
	$detail_id_isbns = $_POST['id_isbns'];
	$detail_id_dois = $_POST['id_dois'];
	$detail_id_uris = $_POST['id_uris'];
	$detail_id_locals = $_POST['id_locals'];
	$detail_uris = $_POST['uris'];
	$_POST['title'] .= "\n".$_POST['title_kana']."\n".$_POST['title_romaji'];
	$_POST['keywords'] = xnparticleTrimRepeatableColumn( $_POST['keywords']);
	$_POST['ndc_classifications'] = xnparticleTrimRepeatableColumn( $_POST['physical_descriptions']);
	$_POST['physical_descriptions'] = xnparticleTrimRepeatableColumn( $_POST['physical_descriptions']);
	$_POST['langs'] = xnparticleTrimRepeatableColumn( $_POST['langs']);
	$_POST['id_issns'] = xnparticleTrimRepeatableColumn( $_POST['id_issns']);
	$_POST['id_isbns'] = xnparticleTrimRepeatableColumn( $_POST['id_isbns']);
	$_POST['id_dois'] = xnparticleTrimRepeatableColumn( $_POST['id_dois']);
	$_POST['id_uris'] = xnparticleTrimRepeatableColumn( $_POST['id_uris']);
	$_POST['id_locals'] = xnparticleTrimRepeatableColumn( $_POST['id_locals']);
	$_POST['uris'] = xnparticleTrimRepeatableColumn( $_POST['uris']);
	$result = xnpUpdateBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'article_attachment' );
				if ( $result ){
					$result = xnp_insert_change_log( $xnpsid, $item_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
					$result = !$result;
					if( !$result )
						echo " xnp_insert_change_log failed.";
				}
				else echo " xnpUpdateAttachment failed.";
			}
            else echo " xnpUpdatePreview failed.";
		}
		else echo " xnpUpdateIndex failed.";
	}
	else echo " xnpUpdateBasicInformation failed.";
	if ( !$result )
		return false;
	
	// Registration of the DetailInformation
	$sql = implode( ',', array(
		'title'           	  ."='".$myts->addSlashes($detail_title                 )."'",
		'title_kana'          ."='".$myts->addSlashes($_POST['title_kana'          ])."'",
		'title_romaji'        ."='".$myts->addSlashes($_POST['title_romaji'        ])."'",
		'publisher'           ."='".$myts->addSlashes($_POST['publisher'           ])."'",
		'publisher_kana'      ."='".$myts->addSlashes($_POST['publisher_kana'      ])."'",
		'publisher_romaji'    ."='".$myts->addSlashes($_POST['publisher_romaji'    ])."'",
		'year_f'        ."='".$myts->addSlashes( $_POST['year_f'     ])."'",
		'year_t'        ."='".$myts->addSlashes( $_POST['year_t'     ])."'",
		'date_create'   ."='".$myts->addSlashes( $_POST['date_create'])."'",
		'date_update'   ."='".$myts->addSlashes( $_POST['date_update'])."'",
		'date_record'   ."='".$myts->addSlashes( $_POST['date_record'])."'",
		'jtitle'        ."='".$myts->addSlashes( $_POST['jtitle'     ])."'",
		'jtitle_translation'   ."='".$myts->addSlashes( $_POST['jtitle_translation'])."'",
		'jtitle_volume' ."='".$myts->addSlashes( $_POST['jtitle_volume'])."'",
		'jtitle_issue'  ."='".$myts->addSlashes( $_POST['jtitle_issue'])."'",
		'jtitle_year'   ."='".$myts->addSlashes( $_POST['jtitle_year'])."'",
		'jtitle_month'  ."='".$myts->addSlashes( $_POST['jtitle_month'])."'",
		'jtitle_spage'  ."='".$myts->addSlashes( $_POST['jtitle_spage'])."'",
		'jtitle_epage'  ."='".$myts->addSlashes( $_POST['jtitle_epage'])."'",
		'abstract'            ."=".( strlen($_POST['abstract'])==0 ? "null" : "'".$myts->addSlashes($_POST['abstract'])."'" ),
		'table_of_contents'   ."=".( strlen($_POST['table_of_contents'])==0 ? "null" : "'".$myts->addSlashes($_POST['table_of_contents'])."'" ),
		'edition'           	  ."='".$myts->addSlashes($_POST['edition'             ])."'",
		'publish_place'        	  ."='".$myts->addSlashes($_POST['publish_place'       ])."'",
		'type_of_resource'    ."='".$myts->addSlashes($_POST['type_of_resource'    ])."'",
		'genre'			      ."='".$myts->addSlashes($_POST['genre'               ])."'",
		'access_condition'   ."=".( strlen($_POST['access_condition'])==0 ? "null" : "'".$myts->addSlashes($_POST['access_condition'])."'" )
	) );
	$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail") . " set $sql where article_id = $item_id " );
	if ( $result == false )
		return false;
	
	if ( (!empty($_POST['sub_title_name'])) || (!empty($_POST['sub_title_kana'])) || (!empty($_POST['sub_title_romaji'])) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_sub_title") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$sub_title_name = explode( "\n", $_POST['sub_title_name'] );
		$sub_title_kana = explode( "\n", $_POST['sub_title_kana'] );
		$sub_title_romaji = explode( "\n", $_POST['sub_title_romaji'] );
		reset($sub_title_kana);
		reset($sub_title_romaji);
		$i = 0;
		foreach ( $sub_title_name as  $value ){
			$sub_title_name_1   = ( $value != " " ) ? $value : "";
			$sub_title_kana_1   = ( current($sub_title_kana) != " " ) ? current($sub_title_kana) : "";
			$sub_title_romaji_1 = ( current($sub_title_romaji) != " " ) ? current($sub_title_romaji) : "";
			$sql = implode( ',', array(
				'sub_title_name'                   ."='".$myts->addSlashes(trim($sub_title_name_1))."'",
				'sub_title_kana'                   ."='".$myts->addSlashes(trim($sub_title_kana_1))."'",
				'sub_title_romaji'                 ."='".$myts->addSlashes(trim($sub_title_romaji_1))."'",
			) );
			
			// Registration of the "DetailInformation Child SubTitle"
			$myts =& MyTextSanitizer::getInstance();
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_sub_title") . " set $sql where article_id = $item_id and sub_title_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'sub_title_name'                   ,
					'sub_title_kana'                   ,
					'sub_title_romaji'                 ,
					'sub_title_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($sub_title_name_1))."'",
					"'".$myts->addSlashes(trim($sub_title_kana_1))."'",
					"'".$myts->addSlashes(trim($sub_title_romaji_1))."'",
					$i
				) );
				// Registration of the "DetailInformation Child SubTitle"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_sub_title") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child";
					return false;
				}
			}
			$i++;
			next($sub_title_kana);
			next($sub_title_romaji);
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_sub_title")	. " where article_id = $item_id and sub_title_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_sub_title")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( (!empty($_POST['author_id'])) || (!empty($_POST['author_name'])) || (!empty($_POST['author_kana'])) || (!empty($_POST['author_romaji'])) || (!empty($_POST['author_affiliation'])) || (!empty($_POST['author_affiliation_translation'])) || (!empty($_POST['author_role'])) || (!empty($_POST['author_link']))  ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_author") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$author_id = explode( "\n", $_POST['author_id'] );
		$author_name = explode( "\n", $_POST['author_name'] );
		$author_kana = explode( "\n", $_POST['author_kana'] );
		$author_romaji = explode( "\n", $_POST['author_romaji'] );
		$author_affiliation = explode( "\n", $_POST['author_affiliation'] );
		$author_affiliation_translation = explode( "\n", $_POST['author_affiliation_translation'] );
		$author_role = explode( "\n", $_POST['author_role'] );
		$author_link = explode( "\n", $_POST['author_link'] );
		reset($author_id);
		reset($author_kana);
		reset($author_romaji);
		reset($author_affiliation);
		reset($author_affiliation_translation);
		reset($author_role);
		reset($author_link);
		$i = 0;
		foreach ( $author_name as  $value ){
			$author_id_1 = ( current($author_id) != " " ) ? current($author_id) : "";
			$author_name_1 = ( $value != " " ) ? $value : "";
			$author_kana_1 = ( current($author_kana) != " " ) ? current($author_kana) : "";
			$author_romaji_1 = ( current($author_romaji) != " " ) ? current($author_romaji) : "";
			$author_affiliation_1 = ( current($author_affiliation) != " " ) ? current($author_affiliation) : "";
			$author_affiliation_translation_1 = ( current($author_affiliation_translation) != " " ) ? current($author_affiliation_translation) : "";
			$author_role_1 = ( current($author_role) != " " ) ? current($author_role) : "";
			$author_link_1 = ( current($author_link) != " " ) ? current($author_link) : "";
			$sql = implode( ',', array(
				'author_id'                     ."='".$myts->addSlashes(trim($author_id_1))."'",
				'author_name'                   ."='".$myts->addSlashes(trim($author_name_1))."'",
				'author_kana'                   ."='".$myts->addSlashes(trim($author_kana_1))."'",
				'author_romaji'                 ."='".$myts->addSlashes(trim($author_romaji_1))."'",
				'author_affiliation'            ."='".$myts->addSlashes(trim($author_affiliation_1))."'",
				'author_affiliation_translation' ."='".$myts->addSlashes(trim($author_affiliation_translation_1))."'",
				'author_role'                   ."='".$myts->addSlashes(trim($author_role_1))."'",
				'author_link'                   ."='".$myts->addSlashes(trim($author_link_1))."'"
			) );
			
			// Registration of the "DetailInformation Child Author"
			$myts =& MyTextSanitizer::getInstance();
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_author") . " set $sql where article_id = $item_id and author_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'author_id'                     ,
					'author_name'                   ,
					'author_kana'                   ,
					'author_romaji'                 ,
					'author_affiliation'            ,
					'author_affiliation_translation',
					'author_role'                   ,
					'author_link'                   ,
					'author_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($author_id_1))."'",
					"'".$myts->addSlashes(trim($author_name_1))."'",
					"'".$myts->addSlashes(trim($author_kana_1))."'",
					"'".$myts->addSlashes(trim($author_romaji_1))."'",
					"'".$myts->addSlashes(trim($author_affiliation_1))."'",
					"'".$myts->addSlashes(trim($author_affiliation_translation_1))."'",
					"'".$myts->addSlashes(trim($author_role_1))."'",
					"'".$myts->addSlashes(trim($author_link_1))."'",
					$i
				) );
				// Registration of the "DetailInformation Child Author"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_author") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child";
					return false;
				}
			}
			$i++;
			next($author_id);
			next($author_kana);
			next($author_romaji);
			next($author_affiliation);
			next($author_affiliation_translation);
			next($author_role);
			next($author_link);
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_author")	. " where article_id = $item_id and author_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_author")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( !empty( $detail_keywords ) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_keywords") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$myts =& MyTextSanitizer::getInstance();
		$keywords = explode( "\n", $detail_keywords );
		$i = 0;
		foreach ( $keywords as  $value ){
			$keywords_1 = ( $value != " " ) ? $value : "";
			$sql = implode( ',', array(
				'keywords'           ."='".$myts->addSlashes(trim($keywords_1))."'",
			) );
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_keywords") . " set $sql where article_id = $item_id and keywords_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'keywords'      ,
					'keywords_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($keywords_1))."'",
					$i
				) );
				
				// Registration of the "DetailInformation Child Keywords"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_keywords") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child_keywords";
					return false;
				}
			}
			$i++;
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_keywords")	. " where article_id = $item_id and keywords_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_keywords")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( !empty( $detail_ndc_classifications ) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_ndc_classifications") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$myts =& MyTextSanitizer::getInstance();
		$ndc_classifications = explode( "\n", $detail_ndc_classifications );
		$i = 0;
		foreach ( $ndc_classifications as  $value ){
			$ndc_classifications_1 = ( $value != " " ) ? $value : "";
			$sql = implode( ',', array(
				'ndc_classifications'           ."='".$myts->addSlashes(trim($ndc_classifications_1))."'",
			) );
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_ndc_classifications") . " set $sql where article_id = $item_id and ndc_classifications_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'ndc_classifications'      ,
					'ndc_classifications_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($ndc_classifications_1))."'",
					$i
				) );
				
				// Registration of the "DetailInformation Child Ndc_Classifications"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_ndc_classifications") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child_ndc_classifications";
					return false;
				}
			}
			$i++;
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_ndc_classifications")	. " where article_id = $item_id and ndc_classifications_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_ndc_classifications")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( !empty( $detail_physical_descriptions ) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_physical_descriptions") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$myts =& MyTextSanitizer::getInstance();
		$physical_descriptions = explode( "\n", $detail_physical_descriptions );
		$i = 0;
		foreach ( $physical_descriptions as  $value ){
			$physical_descriptions_1 = ( $value != " " ) ? $value : "";
			$sql = implode( ',', array(
				'physical_descriptions'           ."='".$myts->addSlashes(trim($physical_descriptions_1))."'",
			) );
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_physical_descriptions") . " set $sql where article_id = $item_id and physical_descriptions_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'physical_descriptions'      ,
					'physical_descriptions_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($physical_descriptions_1))."'",
					$i
				) );
				
				// Registration of the "DetailInformation Child Physical_descriptions"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_physical_descriptions") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child_physical_descriptions";
					return false;
				}
			}
			$i++;
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_physical_descriptions")	. " where article_id = $item_id and physical_descriptions_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_physical_descriptions")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( !empty( $detail_langs ) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_langs") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$myts =& MyTextSanitizer::getInstance();
		$langs = explode( "\n", $detail_langs );
		$i = 0;
		foreach ( $langs as  $value ){
			$langs_1 = ( $value != " " ) ? $value : "";
			$sql = implode( ',', array(
				'langs'           ."='".$myts->addSlashes(trim($langs_1))."'",
			) );
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_langs") . " set $sql where article_id = $item_id and langs_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'langs'      ,
					'langs_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($langs_1))."'",
					$i
				) );
				
				// Registration of the "DetailInformation Child Langs"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_langs") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child_langs";
					return false;
				}
			}
			$i++;
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_langs")	. " where article_id = $item_id and langs_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_langs")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( !empty( $detail_id_issns ) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_issns") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$myts =& MyTextSanitizer::getInstance();
		$id_issns = explode( "\n", $detail_id_issns );
		$i = 0;
		foreach ( $id_issns as  $value ){
			$id_issns_1 = ( $value != " " ) ? $value : "";
			$sql = implode( ',', array(
				'id_issns'           ."='".$myts->addSlashes(trim($id_issns_1))."'",
			) );
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_id_issns") . " set $sql where article_id = $item_id and id_issns_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'id_issns'      ,
					'id_issns_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($id_issns_1))."'",
					$i
				) );
				
				// Registration of the "DetailInformation Child Issns"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_issns") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child_id_issns";
					return false;
				}
			}
			$i++;
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_issns")	. " where article_id = $item_id and id_issns_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_issns")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( !empty( $detail_id_isbns ) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_isbns") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$myts =& MyTextSanitizer::getInstance();
		$id_isbns = explode( "\n", $detail_id_isbns );
		$i = 0;
		foreach ( $id_isbns as  $value ){
			$id_isbns_1 = ( $value != " " ) ? $value : "";
			$sql = implode( ',', array(
				'id_isbns'           ."='".$myts->addSlashes(trim($id_isbns_1))."'",
			) );
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_id_isbns") . " set $sql where article_id = $item_id and id_isbns_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'id_isbns'      ,
					'id_isbns_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($id_isbns_1))."'",
					$i
				) );
				
				// Registration of the "DetailInformation Child Isbns"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_isbns") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child_id_isbns";
					return false;
				}
			}
			$i++;
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_isbns")	. " where article_id = $item_id and id_isbns_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_isbns")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( !empty( $detail_id_dois ) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_dois") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$myts =& MyTextSanitizer::getInstance();
		$id_dois = explode( "\n", $detail_id_dois );
		$i = 0;
		foreach ( $id_dois as  $value ){
			$id_dois_1 = ( $value != " " ) ? $value : "";
			$sql = implode( ',', array(
				'id_dois'           ."='".$myts->addSlashes(trim($id_dois_1))."'",
			) );
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_id_dois") . " set $sql where article_id = $item_id and id_dois_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'id_dois'      ,
					'id_dois_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($id_dois_1))."'",
					$i
				) );
				
				// Registration of the "DetailInformation Child Dois"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_dois") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child_id_dois";
					return false;
				}
			}
			$i++;
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_dois")	. " where article_id = $item_id and id_dois_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_dois")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( !empty( $detail_id_uris ) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_uris") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$myts =& MyTextSanitizer::getInstance();
		$id_uris = explode( "\n", $detail_id_uris );
		$i = 0;
		foreach ( $id_uris as  $value ){
			$id_uris_1 = ( $value != " " ) ? $value : "";
			$sql = implode( ',', array(
				'id_uris'           ."='".$myts->addSlashes(trim($id_uris_1))."'",
			) );
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_id_uris") . " set $sql where article_id = $item_id and id_uris_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'id_uris'      ,
					'id_uris_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($id_uris_1))."'",
					$i
				) );
				
				// Registration of the "DetailInformation Child Uris"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_uris") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child_id_uris";
					return false;
				}
			}
			$i++;
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_uris")	. " where article_id = $item_id and id_uris_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_uris")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( !empty( $detail_id_locals ) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_locals") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$myts =& MyTextSanitizer::getInstance();
		$id_locals = explode( "\n", $detail_id_locals );
		$i = 0;
		foreach ( $id_locals as  $value ){
			$id_locals_1 = ( $value != " " ) ? $value : "";
			$sql = implode( ',', array(
				'id_locals'           ."='".$myts->addSlashes(trim($id_locals_1))."'",
			) );
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_id_locals") . " set $sql where article_id = $item_id and id_locals_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'id_locals'      ,
					'id_locals_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($id_locals_1))."'",
					$i
				) );
				
				// Registration of the "DetailInformation Child Locals"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_locals") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child_id_locals";
					return false;
				}
			}
			$i++;
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_locals")	. " where article_id = $item_id and id_locals_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_locals")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	if ( !empty( $detail_uris ) ){
		$myts =& MyTextSanitizer::getInstance();
		$sql = "select count(*) from " . $xoopsDB->prefix("xnparticle_item_detail_child_uris") . " where article_id=$item_id";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		
		$myts =& MyTextSanitizer::getInstance();
		$uris = explode( "\n", $detail_uris );
		$i = 0;
		foreach ( $uris as  $value ){
			$uris_1 = ( $value != " " ) ? $value : "";
			$sql = implode( ',', array(
				'uris'           ."='".$myts->addSlashes(trim($uris_1))."'",
			) );
			if ($i < $count) {
				$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnparticle_item_detail_child_uris") . " set $sql where article_id = $item_id and uris_order = $i " );
				if ( $result == false ){
					return false;
				}
			}
			else {
				$keys = implode( ",", array(
					'uris'      ,
					'uris_order'
				) );
				$vals = implode( ",", array(
					"'".$myts->addSlashes(trim($uris_1))."'",
					$i
				) );
				
				// Registration of the "DetailInformation Child URIs"
				$myts =& MyTextSanitizer::getInstance();
				$sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_uris") . " ( article_id, $keys ) values ( $item_id, $vals ) ";
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){
					echo "cannot insert item_detail_child_uris";
					return false;
				}
			}
			$i++;
		}
		if ($i < $count) {
			for ($j = $i; $j < $count; $j++) {
				$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_uris")	. " where article_id = $item_id and uris_order = $j";
				$xoopsDB->queryF( $sql );
			}
		}
	}else{
                $sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_uris")	. " where article_id = $item_id";
                $xoopsDB->queryF( $sql );
        }

	return true;
}

function xnparticleDeleteItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// Delete the "BasicInformation, Index, Preview, Attachment"
	if( !xnpDeleteBasicInformation( $item_id ) ){
		echo "cannot delete model item";
		return false;
	}
	
	// Delete the DetailInformation
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild SubTitle
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_sub_title")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild Author
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_author")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild Keywords
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_keywords")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild NdcClassification
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_ndc_classifications")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild PhysicalDescription
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_physical_descriptions")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild Langs
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_langs")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild IdIssns
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_issns")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild IdIsbns
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_isbns")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild IdDois
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_dois")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild IdUris
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_uris")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild IdLocals
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_id_locals")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	// Delete the DetailInformationChild Uris
	$sql = "delete from " . $xoopsDB->prefix("xnparticle_item_detail_child_uris")
		. " where article_id=$item_id";
	$xoopsDB->queryF( $sql );

	return true;
}


function xnparticleGetDetailInformationQuickSearchQuery(&$wheres, &$join, $keywords){
	global $xoopsDB;
	$article_table = $xoopsDB->prefix('xnparticle_item_detail');
	//$article_child_sub_title_table = $xoopsDB->prefix('xnparticle_item_detail_child_sub_title');
	$article_child_author_table = $xoopsDB->prefix('xnparticle_item_detail_child_author');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
        //$join  .= " left join $article_child_sub_title_table on $article_child_sub_title_table.article_id = $article_table.article_id ";
        $join  .= " left join $article_child_author_table on $article_child_author_table.article_id = $article_table.article_id ";
	//$wheres = xnpGetKeywordsQueries( array("$article_child_sub_title_table.sub_title_name", "$article_child_author_table.author_name", "$article_child_author_table.author_role", "$article_child_author_table.author_affiliation", "$article_table.publisher", "$article_table.abstract","$article_table.table_of_contents","$article_table.jtitle"), $keywords );
        $wheres = xnpGetKeywordsQueries( array("$article_child_author_table.author_name", "$article_child_author_table.author_role", "$article_child_author_table.author_affiliation", "$article_table.publisher","$article_table.jtitle"), $keywords );
	return true;
}


function xnparticleGetAdvancedSearchQuery(&$where, &$join){
	global $xoopsDB;
	$article_table = $xoopsDB->prefix('xnparticle_item_detail');
	//$article_child_sub_title_table = $xoopsDB->prefix('xnparticle_item_detail_child_sub_title');
	$article_child_author_table = $xoopsDB->prefix('xnparticle_item_detail_child_author');
	$article_child_keyword_table = $xoopsDB->prefix('xnparticle_item_detail_child_keywords');
	//$article_child_ndc_classification_table = $xoopsDB->prefix('xnparticle_item_detail_child_ndc_classifications');
	//$article_child_physical_description_table = $xoopsDB->prefix('xnparticle_item_detail_child_physical_descriptions');
	//$article_child_lang_table = $xoopsDB->prefix('xnparticle_item_detail_child_langs');
	//$article_child_id_issn_table = $xoopsDB->prefix('xnparticle_item_detail_child_id_issns');
	//$article_child_id_isbn_table = $xoopsDB->prefix('xnparticle_item_detail_child_id_isbns');
	//$article_child_id_doi_table = $xoopsDB->prefix('xnparticle_item_detail_child_id_dois');
	//$article_child_id_uri_table = $xoopsDB->prefix('xnparticle_item_detail_child_id_uris');
	//$article_child_id_local_table = $xoopsDB->prefix('xnparticle_item_detail_child_id_locals');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$wheres = array();
	$w = xnpGetBasicInformationAdvancedSearchQuery('xnparticle');                  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_sub_title_table.'.sub_title_name'              ,'xnparticle_sub_title_name'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_sub_title_table.'.sub_title_kana'              ,'xnparticle_sub_title_kana'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_sub_title_table.'.sub_title_romaji'            ,'xnparticle_sub_title_romaji'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_child_author_table.'.author_id'                    ,'xnparticle_author_id'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_child_author_table.'.author_name'                    ,'xnparticle_author_name'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_child_author_table.'.author_kana'                    ,'xnparticle_author_kana'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_child_author_table.'.author_romaji'                  ,'xnparticle_author_romaji'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_child_author_table.'.author_affiliation'             ,'xnparticle_author_affiliation'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_child_author_table.'.author_affiliation_translation' ,'xnparticle_author_affiliation_translation'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_child_author_table.'.author_role'                    ,'xnparticle_author_role'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_child_author_table.'.author_link'                    ,'xnparticle_author_link'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.publisher'            ,'xnparticle_publisher'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.publisher_kana'       ,'xnparticle_publisher_kana'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.publisher_romaji'     ,'xnparticle_publisher_romaji'  );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_table.'.year_f'     ,'xnparticle_year_f'  );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_table.'.year_t'     ,'xnparticle_year_t'  );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_table.'.date_create'     ,'xnparticle_date_create'  );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_table.'.date_update'     ,'xnparticle_date_update'  );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_table.'.date_record'     ,'xnparticle_date_record'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.jtitle'     ,'xnparticle_jtitle'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.jtitle_translation'     ,'xnparticle_jtitle_translation'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.jtitle_volume'     ,'xnparticle_jtitle_volume'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.jtitle_issue'     ,'xnparticle_jtitle_issue'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.jtitle_year'     ,'xnparticle_jtitle_year'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.jtitle_month'     ,'xnparticle_jtitle_month'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.jtitle_spage'     ,'xnparticle_jtitle_spage'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.jtitle_epage'     ,'xnparticle_jtitle_epage'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.abstract'     		,'xnparticle_abstract'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_table.'.table_of_contents'     	,'xnparticle_table_of_contents'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_table.'.edition'     		,'xnparticle_edition'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_table.'.publish_place'     		,'xnparticle_publish_place'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_table.'.type_of_resource'     ,'xnparticle_type_of_resource'     );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_table.'.genre'      			,'xnparticle_genre'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_table.'.access_condition'     	,'xnparticle_access_condition'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($article_child_keyword_table.'.keywords'     	,'xnparticle_keywords'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_ndc_classification_table.'.ndc_classifications'     	,'xnparticle_ndc_classifications'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_physical_description_table.'.physical_descriptions'     	,'xnparticle_physical_descriptions'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_lang_table.'.langs'     	,'xnparticle_langs'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_id_issn_table.'.id_issns'     	,'xnparticle_id_issns'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_id_isbn_table.'.id_isbns'     	,'xnparticle_id_isbns'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_id_doi_table.'.id_dois'     	,'xnparticle_id_dois'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_id_uri_table.'.id_uris'     	,'xnparticle_id_uris'   );  if ( $w ) $wheres[] = $w;
	//$w = xnpGetKeywordQuery($article_child_id_local_table.'.id_locals'     	,'xnparticle_id_locals'   );  if ( $w ) $wheres[] = $w;
	
	$w = xnpGetKeywordQuery( $file_table.'.caption', 'xnparticle_caption' );
	if( $w ){
		$wheres[] = $w;
		$wheres[] = " $file_table.file_type_id = 1";
	}
	if ( !empty($_POST['xnparticle_article_attachment' ]) ){
		list( $pattern, $errorMessage ) = xnpKeywordsToFulltextSql($_POST['xnparticle_article_attachment']);
		if ( !$errorMessage )
			$wheres[] = "match ( $file_table.search_text ) against ( '$pattern' in boolean mode )";
	}

	$where = implode( ' and ', $wheres );
        //$join  = " left join $article_child_sub_title_table on $article_child_sub_title_table.article_id = $article_table.article_id ";
        $join  .= " left join $article_child_author_table on $article_child_author_table.article_id = $article_table.article_id ";
        $join  .= " left join $article_child_keyword_table on $article_child_keyword_table.article_id = $article_table.article_id ";
        //$join  .= " left join $article_child_ndc_classification_table on $article_child_ndc_classification_table.article_id = $article_table.article_id ";
        //$join  .= " left join $article_child_physical_description_table on $article_child_physical_description_table.article_id = $article_table.article_id ";
        //$join  .= " left join $article_child_lang_table on $article_child_lang_table.article_id = $article_table.article_id ";
        //$join  .= " left join $article_child_id_issn_table on $article_child_id_issn_table.article_id = $article_table.article_id ";
        //$join  .= " left join $article_child_id_isbn_table on $article_child_id_isbn_table.article_id = $article_table.article_id ";
        //$join  .= " left join $article_child_id_doi_table on $article_child_id_doi_table.article_id = $article_table.article_id ";
        //$join  .= " left join $article_child_id_uri_table on $article_child_id_uri_table.article_id = $article_table.article_id ";
        //$join  .= " left join $article_child_id_local_table on $article_child_id_local_table.article_id = $article_table.article_id ";
}

function xnparticleGetAdvancedSearchBlock(&$search_var){
	// Get blocks of "BasicInformation / Preview / IndexKeywords"
	$basic   = xnpGetBasicInformationAdvancedSearchBlock('xnparticle',$search_var);
	$search_var[] = 'xnparticle_sub_title_name'   ;
	$search_var[] = 'xnparticle_sub_title_kana'   ;
	$search_var[] = 'xnparticle_sub_title_romaji'   ;
	$search_var[] = 'xnparticle_author_id'   ;
	$search_var[] = 'xnparticle_author_name'   ;
	$search_var[] = 'xnparticle_author_kana'   ;
	$search_var[] = 'xnparticle_author_romaji'   ;
	$search_var[] = 'xnparticle_author_affiliation'   ;
	$search_var[] = 'xnparticle_author_affiliation_translation'   ;
	$search_var[] = 'xnparticle_author_role'   ;
	$search_var[] = 'xnparticle_author_link'   ;
	$search_var[] = 'xnparticle_publisher'  ;
	$search_var[] = 'xnparticle_publisher_kana'  ;
	$search_var[] = 'xnparticle_publisher_romaji'  ;
	$search_var[] = 'xnparticle_year_f'  ;
	$search_var[] = 'xnparticle_year_t'  ;
	$search_var[] = 'xnparticle_date_create'  ;
	$search_var[] = 'xnparticle_date_update'  ;
	$search_var[] = 'xnparticle_date_record'  ;
	$search_var[] = 'xnparticle_jtitle'  ;
	$search_var[] = 'xnparticle_jtitle_translation'  ;
	$search_var[] = 'xnparticle_jtitle_volume'  ;
	$search_var[] = 'xnparticle_jtitle_issue'  ;
	$search_var[] = 'xnparticle_jtitle_year'  ;
	$search_var[] = 'xnparticle_jtitle_month'  ;
	$search_var[] = 'xnparticle_jtitle_spage'  ;
	$search_var[] = 'xnparticle_jtitle_epage'  ;
	$search_var[] = 'xnparticle_abstract';
	$search_var[] = 'xnparticle_table_of_contents';
	$search_var[] = 'xnparticle_edition';
	$search_var[] = 'xnparticle_publish_place';
	$search_var[] = 'xnparticle_type_of_resource';
	$search_var[] = 'xnparticle_genre';
	$search_var[] = 'xnparticle_access_condition';
	$search_var[] = 'xnparticle_article_attachment';
	$search_var[] = 'xnparticle_caption';
	
	// Set into the template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTplにセットされた変数($xoops_urlとか)を、$tplにコピーする。
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnparticle' );
	$tpl->assign( 'module_display_name', 'Article' ); // Get from "todo:db"
	
	// Return as HTML
	return $tpl->fetch( "db:xnparticle_search_block.html" );
}

function xnparticleGetDetailInformationTotalSize($iids){
	return xnpGetTotalFileSize($iids);
}

/**
 * 
 * アイテムのDetailInformatinoをExportするXMLを作成する
 * 
 * @param fhdl 結果を書き出すファイルハンドル
 * @param item_id ExportしたいアイテムのID
 * @param attachment 添付ファイル・画像ファイルをExportするときtrue．未指定時false．
 * @return true:成功，false:失敗
 */
function xnparticleExportItem($export_path, $fhdl, $item_id, $attachment )
{
    if( !$fhdl ) return false;

    $detail = xnparticleGetDetailInformation( $item_id );
    $detail_child_sub_title = xnparticleGetDetailChildSubTitleInformation( $item_id );
    $detail_child_author    = xnparticleGetDetailChildAuthorInformation( $item_id );
    $detail_child_keywords  = xnparticleGetDetailChildKeywordsInformation( $item_id );
    $detail_child_ndc_classifications    = xnparticleGetDetailChildNdcClassificationsInformation( $item_id );
    $detail_child_physical_descriptions  = xnparticleGetDetailChildPhysicalDescriptionsInformation( $item_id );
    $detail_child_langs     = xnparticleGetDetailChildLangsInformation( $item_id );
    $detail_child_id_issns  = xnparticleGetDetailChildIdIssnsInformation( $item_id );
    $detail_child_id_isbns  = xnparticleGetDetailChildIdIsbnsInformation( $item_id );
    $detail_child_id_dois   = xnparticleGetDetailChildIdDoisInformation( $item_id );
    $detail_child_id_uris   = xnparticleGetDetailChildIdUrisInformation( $item_id );
    $detail_child_id_locals = xnparticleGetDetailChildIdLocalsInformation( $item_id );
    $detail_child_uris = xnparticleGetDetailChildUrisInformation( $item_id );

    $detail['sub_title_str'] = xnparticleCreateModsXml($detail, $detail_child_sub_title, $detail_child_author, $detail_child_keywords, $detail_child_ndc_classifications, $detail_child_physical_descriptions, $detail_child_langs, $detail_child_id_issns, $detail_child_id_isbns, $detail_child_id_dois, $detail_child_id_uris, $detail_child_id_locals, $detail_child_uris);
   
	$detail['author_str'] = '';
	while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $detail_child_author ) ){
		$detail['author_str'] .= "<author>\n<author_id>".xnpHtmlspecialchars( $author_id, ENT_QUOTES )."</author_id>\n<author_name>".xnpHtmlspecialchars( $author_name, ENT_QUOTES )."</author_name>\n<author_kana>".xnpHtmlspecialchars( $author_kana, ENT_QUOTES )."</author_kana>\n<author_romaji>".xnpHtmlspecialchars( $author_romaji, ENT_QUOTES )."</author_romaji>\n<author_affiliation>".xnpHtmlspecialchars( $author_affiliation, ENT_QUOTES )."</author_affiliation>\n<author_affiliation_translation>".xnpHtmlspecialchars( $author_affiliation_translation, ENT_QUOTES )."</author_affiliation_translation>\n<author_role>".xnpHtmlspecialchars( $author_role, ENT_QUOTES )."</author_role>\n<author_link>".xnpHtmlspecialchars( $author_link, ENT_QUOTES )."</author_link>\n</author>\n";
	}
	$detail['keywords_str'] = "";
        while( list( $key, list( $article_child_keywords_id, $article_id, $keywords, $keywords_order ) ) = each( $detail_child_keywords ) ){
		$detail['keywords_str'] .= "<keyword>".xnpHtmlspecialchars( $keywords, ENT_QUOTES )."</keyword>\n";
	}
	$detail['ndc_classifications_str'] = "";
	while ( list( $key, list( $article_child_ndc_classifications_id, $article_id, $ndc_classifications, $ndc_classifications_order ) ) = each( $detail_child_ndc_classifications ) ){
		$detail['ndc_classifications_str'] .= "<ndc_classification>".xnpHtmlspecialchars( $ndc_classifications, ENT_QUOTES )."</ndc_classification>\n";
	}
	$detail['physical_descriptions_str'] = "";
	while ( list( $key, list( $article_child_physical_descriptions_id, $article_id, $physical_descriptions, $physical_descriptions_order ) ) = each( $detail_child_physical_descriptions ) ){
		$detail['physical_descriptions_str'] .= "<physical_description>".xnpHtmlspecialchars( $physical_descriptions, ENT_QUOTES )."</physical_description>\n";
	}
	$detail['langs_str'] = "";
	while ( list( $key, list( $article_child_langs_id, $article_id, $langs, $langs_order ) ) = each( $detail_child_langs ) ){
		$detail['langs_str'] .= "<lang>".xnpHtmlspecialchars( $langs, ENT_QUOTES )."</lang>\n";
	}
	$detail['id_issns_str'] = "";
	while ( list( $key, list( $article_child_id_issns_id, $article_id, $id_issns, $id_issns_order ) ) = each( $detail_child_id_issns ) ){
		$detail['id_issns_str'] .= "<id_issn>".xnpHtmlspecialchars( $id_issns, ENT_QUOTES )."</id_issn>\n";
	}
	$detail['id_isbns_str'] = "";
	while ( list( $key, list( $article_child_id_isbns_id, $article_id, $id_isbns, $id_isbns_order ) ) = each( $detail_child_id_isbns ) ){
		$detail['id_isbns_str'] .= "<id_isbn>".xnpHtmlspecialchars( $id_isbns, ENT_QUOTES )."</id_isbn>\n";
	}
	$detail['id_dois_str'] = "";
	while ( list( $key, list( $article_child_id_dois_id, $article_id, $id_dois, $id_dois_order ) ) = each( $detail_child_id_dois ) ){
		$detail['id_dois_str'] .= "<id_doi>".xnpHtmlspecialchars( $id_dois, ENT_QUOTES )."</id_doi>\n";
	}
	$detail['id_uris_str'] = "";
	while ( list( $key, list( $article_child_id_uris_id, $article_id, $id_uris, $id_uris_order ) ) = each( $detail_child_id_uris ) ){
		$detail['id_uris_str'] .= "<id_uri>".xnpHtmlspecialchars( $id_uris, ENT_QUOTES )."</id_uri>\n";
	}
	$detail['id_locals_str'] = "";
	while ( list( $key, list( $article_child_id_locals_id, $article_id, $id_locals, $id_locals_order ) ) = each( $detail_child_id_locals ) ){
		$detail['id_locals_str'] .= "<id_local>".xnpHtmlspecialchars( $id_locals, ENT_QUOTES )."</id_local>\n";
	}
	$detail['uris_str'] = "";
	while ( list( $key, list( $article_child_uris_id, $article_id, $uris, $uris_order ) ) = each( $detail_child_uris ) ){
		$detail['uris_str'] .= "<uri>".xnpHtmlspecialchars( $uris, ENT_QUOTES )."</uri>\n";
	}

	if( !fwrite( $fhdl, "<detail id=\"${item_id}\">\n"
        ."<title>".xnpHtmlspecialchars( $detail['title'], ENT_QUOTES )."</title>\n"
        ."<title_kana>".xnpHtmlspecialchars( $detail['title_kana'], ENT_QUOTES )."</title_kana>\n"
        ."<title_romaji>".xnpHtmlspecialchars( $detail['title_romaji'], ENT_QUOTES )."</title_romaji>\n"
        .$detail['sub_title_str']
        .$detail['author_str']
        ."<edition>".xnpHtmlspecialchars( $detail['edition'], ENT_QUOTES )."</edition>\n"
        ."<publish_place>".xnpHtmlspecialchars( $detail['publish_place'], ENT_QUOTES )."</publish_place>\n"
        ."<publisher>".xnpHtmlspecialchars( $detail['publisher'], ENT_QUOTES )."</publisher>\n"
        ."<publisher_kana>".xnpHtmlspecialchars( $detail['publisher_kana'], ENT_QUOTES )."</publisher_kana>\n"
        ."<publisher_romaji>".xnpHtmlspecialchars( $detail['publisher_romaji'], ENT_QUOTES )."</publisher_romaji>\n"
        ."<year_f>".xnpHtmlspecialchars( $detail['year_f'], ENT_QUOTES )."</year_f>\n"
        ."<year_t>".xnpHtmlspecialchars( $detail['year_t'], ENT_QUOTES )."</year_t>\n"
        ."<date_create>".xnpHtmlspecialchars( $detail['date_create'], ENT_QUOTES )."</date_create>\n"
        ."<date_update>".xnpHtmlspecialchars( $detail['date_update'], ENT_QUOTES )."</date_update>\n"
        ."<date_record>".xnpHtmlspecialchars( $detail['date_record'], ENT_QUOTES )."</date_record>\n"
        ."<jtitle>".xnpHtmlspecialchars( $detail['jtitle'], ENT_QUOTES )."</jtitle>\n"
        ."<jtitle_translation>".xnpHtmlspecialchars( $detail['jtitle_translation'], ENT_QUOTES )."</jtitle_translation>\n"
        ."<jtitle_volume>".xnpHtmlspecialchars( $detail['jtitle_volume'], ENT_QUOTES )."</jtitle_volume>\n"
        ."<jtitle_issue>".xnpHtmlspecialchars( $detail['jtitle_issue'], ENT_QUOTES )."</jtitle_issue>\n"
        ."<jtitle_year>".xnpHtmlspecialchars( $detail['jtitle_year'], ENT_QUOTES )."</jtitle_year>\n"
        ."<jtitle_month>".xnpHtmlspecialchars( $detail['jtitle_month'], ENT_QUOTES )."</jtitle_month>\n"
        ."<jtitle_spage>".xnpHtmlspecialchars( $detail['jtitle_spage'], ENT_QUOTES )."</jtitle_spage>\n"
        ."<jtitle_epage>".xnpHtmlspecialchars( $detail['jtitle_epage'], ENT_QUOTES )."</jtitle_epage>\n"
        ."<abstract>".xnpHtmlspecialchars( $detail['abstract'], ENT_QUOTES )."</abstract>\n"
        ."<table_of_contents>".xnpHtmlspecialchars( $detail['table_of_contents'], ENT_QUOTES )."</table_of_contents>\n"
        ."<keywords>\n".$detail['keywords_str']."</keywords>\n"
        ."<ndc_classifications>\n".$detail['ndc_classifications_str']."</ndc_classifications>\n"
        ."<physical_descriptions>\n".$detail['physical_descriptions_str']."</physical_descriptions>\n"
        ."<langs>\n".$detail['langs_str']."</langs>\n"
        ."<id_issns>\n".$detail['id_issns_str']."</id_issns>\n"
        ."<id_isbns>\n".$detail['id_isbns_str']."</id_isbns>\n"
        ."<id_dois>\n".$detail['id_dois_str']."</id_dois>\n"
        ."<id_uris>\n".$detail['id_uris_str']."</id_uris>\n"
        ."<id_locals>\n".$detail['id_locals_str']."</id_locals>\n"
        ."<uris>\n".$detail['uris_str']."</uris>\n"
        ."<type_of_resource>".xnpHtmlspecialchars( $detail['type_of_resource'], ENT_QUOTES )."</type_of_resource>\n"
        ."<genre>".xnpHtmlspecialchars( $detail['genre'], ENT_QUOTES )."</genre>\n"
        ."<access_condition>".xnpHtmlspecialchars( $detail['access_condition'], ENT_QUOTES )."</access_condition>\n"
 ) ) return false;
    if( !( $attachment ? xnpExportFile( $export_path, $fhdl, $item_id ) : true ) ) return false;
    if( !fwrite( $fhdl, "</detail>\n" ) ) return false;

    return true;
}

function xnparticleStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );

//echo "xnparticleStartElement=".$tags;
    switch( $tags ){
    case '/ITEM/DETAIL/SUB_TITLE/SUB_TITLE_NAME':
		if (!isset($parser_hash['detail']['sub_title']['sub_title_name'])) $parser_hash['detail']['sub_title']['sub_title_name'] = array();
        break; 
    case '/ITEM/DETAIL/SUB_TITLE/SUB_TITLE_KANA':
		if (!isset($parser_hash['detail']['sub_title']['sub_title_kana'])) $parser_hash['detail']['sub_title']['sub_title_kana'] = array();
        break; 
    case '/ITEM/DETAIL/SUB_TITLE/SUB_TITLE_ROMAJI':
        if (!isset($parser_hash['detail']['sub_title']['sub_title_romaji'])) $parser_hash['detail']['sub_title']['sub_title_romaji'] = array();
        break; 
    case '/ITEM/DETAIL/AUTHOR/AUTHOR_ID':
		if (!isset($parser_hash['detail']['author']['author_id'])) $parser_hash['detail']['author']['author_id'] = array();
        break; 
    case '/ITEM/DETAIL/AUTHOR/AUTHOR_NAME':
		if (!isset($parser_hash['detail']['author']['author_name'])) $parser_hash['detail']['author']['author_name'] = array();
        break; 
    case '/ITEM/DETAIL/AUTHOR/AUTHOR_KANA':
		if (!isset($parser_hash['detail']['author']['author_kana'])) $parser_hash['detail']['author']['author_kana'] = array();
        break; 
    case '/ITEM/DETAIL/AUTHOR/AUTHOR_ROMAJI':
        if (!isset($parser_hash['detail']['author']['author_romaji'])) $parser_hash['detail']['author']['author_romaji'] = array();
        break; 
    case '/ITEM/DETAIL/AUTHOR/AUTHOR_AFFILIATION':
        if (!isset($parser_hash['detail']['author']['author_affiliation'])) $parser_hash['detail']['author']['author_affiliation'] = array();
        break; 
    case '/ITEM/DETAIL/AUTHOR/AUTHOR_AFFILIATION_TRANSLATION':
        if (!isset($parser_hash['detail']['author']['author_affiliation_translation'])) $parser_hash['detail']['author']['author_affiliation_translation'] = array();
        break; 
    case '/ITEM/DETAIL/AUTHOR/AUTHOR_ROLE':
		if (!isset($parser_hash['detail']['author']['author_role'])) $parser_hash['detail']['author']['author_role'] = array();
        break; 
    case '/ITEM/DETAIL/AUTHOR/AUTHOR_LINK':
		if (!isset($parser_hash['detail']['author']['author_link'])) $parser_hash['detail']['author']['author_link'] = array();
        break; 
    case '/ITEM/DETAIL/KEYWORDS/KEYWORD':
        if (!isset($parser_hash['detail']['keywords']['keyword'])) $parser_hash['detail']['keywords']['keyword'] = array();
        break; 
    case '/ITEM/DETAIL/NDC_CLASSIFICATIONS/NDC_CLASSIFICATION':
        if (!isset($parser_hash['detail']['ndc_classifications']['ndc_classification'])) $parser_hash['detail']['ndc_classifications']['ndc_classification'] = array();
        break; 
    case '/ITEM/DETAIL/PHYSICAL_DESCRIPTIONS/PHYSICAL_DESCRIPTION':
        if (!isset($parser_hash['detail']['physical_descriptions']['physical_description'])) $parser_hash['detail']['physical_descriptions']['physical_description'] = array();
        break; 
    case '/ITEM/DETAIL/LANGS/LANG':
        if (!isset($parser_hash['detail']['langs']['lang'])) $parser_hash['detail']['langs']['lang'] = array();
        break; 
    case '/ITEM/DETAIL/ID_ISSNS/ID_ISSN':
        if (!isset($parser_hash['detail']['id_issns']['id_issn'])) $parser_hash['detail']['id_issns']['id_issn'] = array();
        break; 
    case '/ITEM/DETAIL/ID_ISBNS/ID_ISBN':
        if (!isset($parser_hash['detail']['id_isbns']['id_isbn'])) $parser_hash['detail']['id_isbns']['id_isbn'] = array();
        break; 
    case '/ITEM/DETAIL/ID_DOIS/ID_DOI':
        if (!isset($parser_hash['detail']['id_dois']['id_doi'])) $parser_hash['detail']['id_dois']['id_doi'] = array();
        break; 
    case '/ITEM/DETAIL/ID_URIS/ID_URI':
        if (!isset($parser_hash['detail']['id_uris']['id_uri'])) $parser_hash['detail']['id_uris']['id_uri'] = array();
        break; 
    case '/ITEM/DETAIL/ID_LOCALS/ID_LOCAL':
        if (!isset($parser_hash['detail']['id_locals']['id_local'])) $parser_hash['detail']['id_locals']['id_local'] = array();
        break; 
    case '/ITEM/DETAIL/URIS/URI':
        if (!isset($parser_hash['detail']['uris']['uri'])) $parser_hash['detail']['uris']['uri'] = array();
        break; 
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    }
    //echo("<b><font color=\"#0000ff\">&lt$name&gt</font></b><br>"); 
}

function xnparticleEndElement($parser, $name, &$parser_hash)
{
    global $xoopsDB;
    
//var_dump($parser_hash);
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
//var_dump($tags);
    
    switch( $tags ){
    case '/ITEM/DETAIL':
		if (isset($parser_hash['detail']['sub_title']['sub_title_name'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'                   ,
	            'sub_title_name'                   ,
	            'sub_title_kana'                   ,
	            'sub_title_romaji'                 ,
	            'sub_title_order'
	            ) );

			$sub_title_name = $parser_hash['detail']['sub_title']['sub_title_name'];
			$sub_title_kana = $parser_hash['detail']['sub_title']['sub_title_kana'];
			$sub_title_romaji = $parser_hash['detail']['sub_title']['sub_title_romaji'];
			reset($sub_title_kana);
			reset($sub_title_romaji);
			$i = 0;
			foreach ( $sub_title_name as  $value ){
		        $ar = array(
	                'sub_title_name'                    =>  encodeClient2Server( $value                                   ),
	                'sub_title_kana'                    =>  encodeClient2Server( current($sub_title_kana                   ) ),
	                'sub_title_romaji'                  =>  encodeClient2Server( current($sub_title_romaji                 ) ),
		        );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_sub_title' );
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['sub_title_name'                   ] )."'",
		            "'".addSlashes( $ar['sub_title_kana'                   ] )."'",
		            "'".addSlashes( $ar['sub_title_romaji'                 ] )."'",
		            "'".$i."'"
		            ) );

		        // Registration of the DetailInformation
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_sub_title") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				next($sub_title_kana);
				next($sub_title_romaji);
				$i++;
			}
		}
		if (isset($parser_hash['detail']['author']['author_name'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'                   ,
	            'author_id'                   ,
	            'author_name'                   ,
	            'author_kana'                   ,
	            'author_romaji'                 ,
	            'author_affiliation'            ,
	            'author_affiliation_translation',
	            'author_role'                   ,
	            'author_link'                   ,
	            'author_order'
	            ) );

			$author_id   = $parser_hash['detail']['author']['author_id'];
			$author_name = $parser_hash['detail']['author']['author_name'];
			$author_kana = $parser_hash['detail']['author']['author_kana'];
			$author_romaji = $parser_hash['detail']['author']['author_romaji'];
			$author_affiliation = $parser_hash['detail']['author']['author_affiliation'];
			$author_affiliation_translation = $parser_hash['detail']['author']['author_affiliation_translation'];
			$author_role = $parser_hash['detail']['author']['author_role'];
			$author_link = $parser_hash['detail']['author']['author_link'];
			reset($author_id);
			reset($author_kana);
			reset($author_romaji);
			reset($author_affiliation);
			reset($author_affiliation_translation);
			reset($author_role);
			reset($author_link);
			$i = 0;
			foreach ( $author_name as  $value ){
		        $ar = array(
	                'author_id'                      =>  encodeClient2Server( current($author_id                     ) ),
	                'author_name'                    =>  encodeClient2Server( $value                                   ),
	                'author_kana'                    =>  encodeClient2Server( current($author_kana                   ) ),
	                'author_romaji'                  =>  encodeClient2Server( current($author_romaji                 ) ),
	                'author_affiliation'             =>  encodeClient2Server( current($author_affiliation            ) ),
	                'author_affiliation_translation' =>  encodeClient2Server( current($author_affiliation_translation) ),
	                'author_role'                    =>  encodeClient2Server( current($author_role                   ) ),
	                'author_link'                    =>  encodeClient2Server( current($author_link                   ) ),
		        );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_author' );
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['author_id'                     ] )."'",
		            "'".addSlashes( $ar['author_name'                   ] )."'",
		            "'".addSlashes( $ar['author_kana'                   ] )."'",
		            "'".addSlashes( $ar['author_romaji'                 ] )."'",
		            "'".addSlashes( $ar['author_affiliation'            ] )."'",
		            "'".addSlashes( $ar['author_affiliation_translation'] )."'",
		            "'".addSlashes( $ar['author_role'                   ] )."'",
		            "'".addSlashes( $ar['author_link'                   ] )."'",
		            "'".$i."'"
		            ) );

		        // Registration of the DetailInformation
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_author") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				next($author_id);
				next($author_kana);
				next($author_romaji);
				next($author_affiliation);
				next($author_affiliation_translation);
				next($author_role);
				next($author_link);
				$i++;
			}
		}

		if (isset($parser_hash['detail']['keywords']['keyword'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'   ,
	            'keywords'      ,
	            'keywords_order'
	            ) );

			$keywords = $parser_hash['detail']['keywords']['keyword'];
//			$keywords_order = $parser_hash['detail']['keywords']['keywords_order'];
			$i = 0;
			foreach ( $keywords as  $value ){
		        $ar = array( 'keywords' => encodeClient2Server( $value ) );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_keywords' );
		        
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['keywords'] )."'",
		            "'".$i."'"
	            ) );

		        // 
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_keywords") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				$i++;
			}
		}

		if (isset($parser_hash['detail']['ndc_classifications']['ndc_classification'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'   ,
	            'ndc_classifications'      ,
	            'ndc_classifications_order'
	            ) );

			$ndc_classifications = $parser_hash['detail']['ndc_classifications']['ndc_classification'];
			$i = 0;
			foreach ( $ndc_classifications as  $value ){
		        $ar = array( 'ndc_classifications' => encodeClient2Server( $value ) );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_ndc_classifications' );
		        
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['ndc_classifications'] )."'",
		            "'".$i."'"
	            ) );

		        // 
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_ndc_classifications") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				$i++;
			}
                }

		if (isset($parser_hash['detail']['physical_descriptions']['physical_description'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'   ,
	            'physical_descriptions'      ,
	            'physical_descriptions_order'
	            ) );

			$physical_descriptions = $parser_hash['detail']['physical_descriptions']['physical_description'];
			$i = 0;
			foreach ( $physical_descriptions as  $value ){
		        $ar = array( 'physical_descriptions' => encodeClient2Server( $value ) );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_physical_descriptions' );
		        
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['physical_descriptions'] )."'",
		            "'".$i."'"
	            ) );

		        // 
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_physical_descriptions") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				$i++;
			}
                }

		if (isset($parser_hash['detail']['langs']['lang'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'   ,
	            'langs'      ,
	            'langs_order'
	            ) );

			$langs = $parser_hash['detail']['langs']['lang'];
			$i = 0;
			foreach ( $langs as  $value ){
		        $ar = array( 'langs' => encodeClient2Server( $value ) );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_langs' );
		        
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['langs'] )."'",
		            "'".$i."'"
	            ) );

		        // 
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_langs") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				$i++;
			}
                }

		if (isset($parser_hash['detail']['id_issns']['id_issn'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'   ,
	            'id_issns'      ,
	            'id_issns_order'
	            ) );

			$id_issns = $parser_hash['detail']['id_issns']['id_issn'];
			$i = 0;
			foreach ( $id_issns as  $value ){
		        $ar = array( 'id_issns' => encodeClient2Server( $value ) );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_id_issns' );
		        
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['id_issns'] )."'",
		            "'".$i."'"
	            ) );

		        // 
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_issns") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				$i++;
			}
                }

		if (isset($parser_hash['detail']['id_isbns']['id_isbn'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'   ,
	            'id_isbns'      ,
	            'id_isbns_order'
	            ) );

			$id_isbns = $parser_hash['detail']['id_isbns']['id_isbn'];
			$i = 0;
			foreach ( $id_isbns as  $value ){
		        $ar = array( 'id_isbns' => encodeClient2Server( $value ) );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_id_isbns' );
		        
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['id_isbns'] )."'",
		            "'".$i."'"
	            ) );

		        // 
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_isbns") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				$i++;
			}
                }

		if (isset($parser_hash['detail']['id_dois']['id_doi'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'   ,
	            'id_dois'      ,
	            'id_dois_order'
	            ) );

			$id_dois = $parser_hash['detail']['id_dois']['id_doi'];
			$i = 0;
			foreach ( $id_dois as  $value ){
		        $ar = array( 'id_dois' => encodeClient2Server( $value ) );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_id_dois' );
		        
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['id_dois'] )."'",
		            "'".$i."'"
	            ) );

		        // 
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_dois") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				$i++;
			}
                }

		if (isset($parser_hash['detail']['id_uris']['id_uri'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'   ,
	            'id_uris'      ,
	            'id_uris_order'
	            ) );

			$id_uris = $parser_hash['detail']['id_uris']['id_uri'];
			$i = 0;
			foreach ( $id_uris as  $value ){
		        $ar = array( 'id_uris' => encodeClient2Server( $value ) );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_id_uris' );
		        
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['id_uris'] )."'",
		            "'".$i."'"
	            ) );

		        // 
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_uris") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				$i++;
			}
                }

		if (isset($parser_hash['detail']['id_locals']['id_local'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'   ,
	            'id_locals'      ,
	            'id_locals_order'
	            ) );

			$id_locals = $parser_hash['detail']['id_locals']['id_local'];
			$i = 0;
			foreach ( $id_locals as  $value ){
		        $ar = array( 'id_locals' => encodeClient2Server( $value ) );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_id_locals' );
		        
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['id_locals'] )."'",
		            "'".$i."'"
	            ) );

		        // 
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_id_locals") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				$i++;
			}
                }

		if (isset($parser_hash['detail']['uris']['uri'])) {
	        $myts =& MyTextSanitizer::getInstance();
	        $keys = implode( ",", array(
	            'article_id'   ,
	            'uris'      ,
	            'uris_order'
	            ) );

			$uris = $parser_hash['detail']['uris']['uri'];
			$i = 0;
			foreach ( $uris as  $value ){
		        $ar = array( 'uris' => encodeClient2Server( $value ) );
		        xnpTrimColumn( $ar, 'xnparticle_item_detail_child_uris' );
		        
		        $vals = implode( ",", array(
		            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
		            "'".addSlashes( $ar['uris'] )."'",
		            "'".$i."'"
	            ) );

		        // 
		        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail_child_uris") . " ( $keys ) values ( $vals ) ";
		        $result = $xoopsDB->queryF( $sql );
		        if ( $result == false ){
		            //echo "cannot insert item_detai ". $xoopsDB -> error();
		            break;
		        }
				$i++;
			}
                }

		if (!isset($parser_hash['detail']['TITLE_ROMAJI'])) {
			$str = $parser_hash['detail']['TITLE_KANA'];
			$parser_hash['detail']['TITLE_ROMAJI'] = xnpKana2Roma($str);
		}
        $myts =& MyTextSanitizer::getInstance();
        $keys = implode( ",", array(
            'article_id'         ,
            'title'               ,
            'title_kana'          ,
            'title_romaji'        ,
            'publisher'           ,
            'publisher_kana'      ,
            'publisher_romaji'    ,
            'year_f'              ,
            'year_t'              ,
            'date_create'         ,
            'date_update'         ,
            'date_record'         ,
            'jtitle'              ,
            'jtitle_translation'  ,
            'jtitle_volume'       ,
            'jtitle_issue'        ,
            'jtitle_year'         ,
            'jtitle_month'        ,
            'jtitle_spage'        ,
            'jtitle_epage'        ,
            'abstract'            ,
            'table_of_contents'   ,
            'edition'             ,
            'publish_place'       ,
            'type_of_resource'    ,
            'genre'               ,
            'access_condition'
            ) );

        $ar = array(
            'title'                => encodeClient2Server($parser_hash['detail']['TITLE'               ]),
            'title_kana'           => encodeClient2Server($parser_hash['detail']['TITLE_KANA'          ]),
            'title_romaji'         => encodeClient2Server($parser_hash['detail']['TITLE_ROMAJI'        ]),
            'publisher'            => encodeClient2Server($parser_hash['detail']['PUBLISHER'           ]),
            'publisher_kana'       => encodeClient2Server($parser_hash['detail']['PUBLISHER_KANA'      ]),
            'publisher_romaji'     => encodeClient2Server($parser_hash['detail']['PUBLISHER_ROMAJI'    ]),
            'year_f'               => encodeClient2Server($parser_hash['detail']['YEAR_F'              ]),
            'year_t'               => encodeClient2Server($parser_hash['detail']['YEAR_T'              ]),
            'date_create'          => encodeClient2Server($parser_hash['detail']['DATE_CREATE'         ]),
            'date_update'          => encodeClient2Server($parser_hash['detail']['DATE_UPDATE'         ]),
            'date_record'          => encodeClient2Server($parser_hash['detail']['DATE_RECORD'         ]),
            'jtitle'               => encodeClient2Server($parser_hash['detail']['JTITLE'              ]),
            'jtitle_translation'   => encodeClient2Server($parser_hash['detail']['JTITLE_TRANSLATION'  ]),
            'jtitle_volume'        => encodeClient2Server($parser_hash['detail']['JTITLE_VOLUME'       ]),
            'jtitle_issue'         => encodeClient2Server($parser_hash['detail']['JTITLE_ISSUE'        ]),
            'jtitle_year'          => encodeClient2Server($parser_hash['detail']['JTITLE_YEAR'         ]),
            'jtitle_month'         => encodeClient2Server($parser_hash['detail']['JTITLE_MONTH'        ]),
            'jtitle_spage'         => encodeClient2Server($parser_hash['detail']['JTITLE_SPAGE'        ]),
            'jtitle_epage'         => encodeClient2Server($parser_hash['detail']['JTITLE_EPAGE'        ]),
            'abstract'             => encodeClient2Server($parser_hash['detail']['ABSTRACT'            ]),
            'table_of_contents'    => encodeClient2Server($parser_hash['detail']['TABLE_OF_CONTENTS'   ]),
            'edition'              => encodeClient2Server($parser_hash['detail']['EDITION'             ]),
            'publish_place'        => encodeClient2Server($parser_hash['detail']['PUBLISH_PLACE'       ]),
            'type_of_resource'     => encodeClient2Server($parser_hash['detail']['TYPE_OF_RESOURCE'    ]),
            'genre'                => encodeClient2Server($parser_hash['detail']['GENRE'               ]),
            'access_condition'     => encodeClient2Server($parser_hash['detail']['ACCESS_CONDITION'    ]),
        );
        xnpTrimColumn( $ar, 'xnparticle_item_detail' );
        
        $vals = implode( ",", array(
            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
            "'".addslashes( $ar['title'               ] )."'",
            "'".addslashes( $ar['title_kana'          ] )."'",
            "'".addslashes( $ar['title_romaji'        ] )."'",
            "'".addslashes( $ar['publisher'           ] )."'",
            "'".addslashes( $ar['publisher_kana'      ] )."'",
            "'".addslashes( $ar['publisher_romaji'    ] )."'",
            "'".addslashes( $ar['year_f'              ] )."'",
            "'".addslashes( $ar['year_t'              ] )."'",
            "'".addslashes( $ar['date_create'         ] )."'",
            "'".addslashes( $ar['date_update'         ] )."'",
            "'".addslashes( $ar['date_record'         ] )."'",
            "'".addslashes( $ar['jtitle'              ] )."'",
            "'".addslashes( $ar['jtitle_translation'  ] )."'",
            "'".addslashes( $ar['jtitle_volume'       ] )."'",
            "'".addslashes( $ar['jtitle_issue'        ] )."'",
            "'".addslashes( $ar['jtitle_year'         ] )."'",
            "'".addslashes( $ar['jtitle_month'        ] )."'",
            "'".addslashes( $ar['jtitle_spage'        ] )."'",
            "'".addslashes( $ar['jtitle_epage'        ] )."'",
            "'".addslashes( $ar['abstract'            ] )."'",
            "'".addslashes( $ar['table_of_contents'   ] )."'",
            "'".addslashes( $ar['edition'             ] )."'",
            "'".addslashes( $ar['publish_place'       ] )."'",
            "'".addslashes( $ar['type_of_resource'    ] )."'",
            "'".addslashes( $ar['genre'               ] )."'",
            "'".addslashes( $ar['access_condition'         ] )."'"
            ) );

        // Registration of the DetailInformation
        $sql = "insert into " . $xoopsDB->prefix("xnparticle_item_detail") . " ( $keys ) values ( $vals ) ";
        $result = $xoopsDB->queryF( $sql );
        if ( $result == false ){
            //echo "cannot insert item_detai ". $xoopsDB -> error();
            break;
        }
        break;
    }
    //echo("<br><b><font color=\"#0000ff\">&lt/$name&gt</font></b><br><br>"); 
}

function xnparticleCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/SUB_TITLE/SUB_TITLE_NAME":
        array_push( $parser_hash['detail']['sub_title']['sub_title_name'], $data );
        break; 
    case "/ITEM/DETAIL/SUB_TITLE/SUB_TITLE_KANA":
        array_push( $parser_hash['detail']['sub_title']['sub_title_kana'], $data );
        break; 
    case "/ITEM/DETAIL/SUB_TITLE/SUB_TITLE_ROMAJI":
        array_push( $parser_hash['detail']['sub_title']['sub_title_romaji'], $data );
        break; 
    case "/ITEM/DETAIL/AUTHOR/AUTHOR_ID":
        array_push( $parser_hash['detail']['author']['author_id'], $data );
        break; 
    case "/ITEM/DETAIL/AUTHOR/AUTHOR_NAME":
        array_push( $parser_hash['detail']['author']['author_name'], $data );
        break; 
    case "/ITEM/DETAIL/AUTHOR/AUTHOR_KANA":
        array_push( $parser_hash['detail']['author']['author_kana'], $data );
        break; 
    case "/ITEM/DETAIL/AUTHOR/AUTHOR_ROMAJI":
        array_push( $parser_hash['detail']['author']['author_romaji'], $data );
        break; 
    case "/ITEM/DETAIL/AUTHOR/AUTHOR_AFFILIATION":
        array_push( $parser_hash['detail']['author']['author_affiliation'], $data );
        break; 
    case "/ITEM/DETAIL/AUTHOR/AUTHOR_AFFILIATION_TRANSLATION":
        array_push( $parser_hash['detail']['author']['author_affiliation_translation'], $data );
        break; 
    case "/ITEM/DETAIL/AUTHOR/AUTHOR_ROLE":
        array_push( $parser_hash['detail']['author']['author_role'], $data );
        break; 
    case "/ITEM/DETAIL/AUTHOR/AUTHOR_LINK":
        array_push( $parser_hash['detail']['author']['author_link'], $data );
        break; 
    case "/ITEM/DETAIL/KEYWORDS/KEYWORD":
        array_push( $parser_hash['detail']['keywords']['keyword'], $data );
        break; 
    case "/ITEM/DETAIL/NDC_CLASSIFICATIONS/NDC_CLASSIFICATION":
        array_push( $parser_hash['detail']['ndc_classifications']['ndc_classification'], $data );
        break; 
    case "/ITEM/DETAIL/PHYSICAL_DESCRIPTIONS/PHYSICAL_DESCRIPTION":
        array_push( $parser_hash['detail']['physical_descriptions']['physical_description'], $data );
        break; 
    case "/ITEM/DETAIL/LANGS/LANG":
        array_push( $parser_hash['detail']['langs']['lang'], $data );
        break; 
    case "/ITEM/DETAIL/ID_ISSNS/ID_ISSN":
        array_push( $parser_hash['detail']['id_issns']['id_issn'], $data );
        break; 
    case "/ITEM/DETAIL/ID_ISBNS/ID_ISBN":
        array_push( $parser_hash['detail']['id_isbns']['id_isbn'], $data );
        break; 
    case "/ITEM/DETAIL/ID_DOIS/ID_DOI":
        array_push( $parser_hash['detail']['id_dois']['id_doi'], $data );
        break; 
    case "/ITEM/DETAIL/ID_URIS/ID_URI":
        array_push( $parser_hash['detail']['id_uris']['id_uri'], $data );
        break; 
    case "/ITEM/DETAIL/ID_LOCALS/ID_LOCAL":
        array_push( $parser_hash['detail']['id_locals']['id_local'], $data );
        break; 
    case "/ITEM/DETAIL/URIS/URI":
        array_push( $parser_hash['detail']['uris']['uri'], $data );
        break; 
    case "/ITEM/DETAIL/TITLE":
    case "/ITEM/DETAIL/TITLE_KANA":
    case "/ITEM/DETAIL/TITLE_ROMAJI":
    case "/ITEM/DETAIL/PUBLISHER":
    case "/ITEM/DETAIL/PUBLISHER_KANA":
    case "/ITEM/DETAIL/PUBLISHER_ROMAJI":
    case "/ITEM/DETAIL/YEAR_F":
    case "/ITEM/DETAIL/YEAR_T":
    case "/ITEM/DETAIL/DATE_CREATE":
    case "/ITEM/DETAIL/DATE_UPDATE":
    case "/ITEM/DETAIL/DATE_RECORD":
    case "/ITEM/DETAIL/JTITLE":
    case "/ITEM/DETAIL/JTITLE_TRANSLATION":
    case "/ITEM/DETAIL/JTITLE_VOLUME":
    case "/ITEM/DETAIL/JTITLE_ISSUE":
    case "/ITEM/DETAIL/JTITLE_YEAR":
    case "/ITEM/DETAIL/JTITLE_MONTH":
    case "/ITEM/DETAIL/JTITLE_SPAGE":
    case "/ITEM/DETAIL/JTITLE_EPAGE":
    case "/ITEM/DETAIL/ABSTRACT":
    case "/ITEM/DETAIL/TABLE_OF_CONTENTS":
    case "/ITEM/DETAIL/EDITION":
    case "/ITEM/DETAIL/PUBLISH_PLACE":
    case "/ITEM/DETAIL/TYPE_OF_RESOURCE": 
    case "/ITEM/DETAIL/GENRE":
    case "/ITEM/DETAIL/ACCESS_CONDITION":
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
}

function xnparticleGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnparticleStartElement", "xnparticleEndElement", "xnparticleCharacterData" ) );
}

/**
 * bool xnparticleGetLicenseRequired( int item_id )
 * 
 * 
 */
/*
function xnparticleGetLicenseRequired( $item_id )
{
    return false;
}
*/

/**
 * string xnparticleGetLicenseStatement( int item_id )
 * 
 * 
 */
/*
function xnparticleGetLicenseStatement( $item_id )
{
    return ''
}
*/


function xnparticleCheckItemLengthEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail' );
        
        $values = array(
            'title'               => encodeClient2Server( $parser_hash['detail']['TITLE'               ] ),
            'title_kana'          => encodeClient2Server( $parser_hash['detail']['TITLE_KANA'          ] ),
            'title_romaji'        => encodeClient2Server( $parser_hash['detail']['TITLE_ROMAJI'        ] ),
            'publisher'           => encodeClient2Server( $parser_hash['detail']['PUBLISHER'           ] ),
            'publisher_kana'      => encodeClient2Server( $parser_hash['detail']['PUBLISHER_KANA'      ] ),
            'publisher_romaji'    => encodeClient2Server( $parser_hash['detail']['PUBLISHER_ROMAJI'    ] ),
            'year_f'              => encodeClient2Server( $parser_hash['detail']['YEAR_F'              ] ),
            'year_t'              => encodeClient2Server( $parser_hash['detail']['YEAR_T'              ] ),
            'date_create'         => encodeClient2Server( $parser_hash['detail']['DATE_CREATE'         ] ),
            'date_update'         => encodeClient2Server( $parser_hash['detail']['DATE_UPDATE'         ] ),
            'date_record'         => encodeClient2Server( $parser_hash['detail']['DATE_RECORD'         ] ),
            'jtitle'              => encodeClient2Server( $parser_hash['detail']['JTITLE'              ] ),
            'jtitle_translation'  => encodeClient2Server( $parser_hash['detail']['JTITLE_TRANSLATION'  ] ),
            'jtitle_volume'       => encodeClient2Server( $parser_hash['detail']['JTITLE_VOLUME'       ] ),
            'jtitle_issue'        => encodeClient2Server( $parser_hash['detail']['JTITLE_ISSUE'        ] ),
            'jtitle_year'         => encodeClient2Server( $parser_hash['detail']['JTITLE_YEAR'         ] ),
            'jtitle_month'        => encodeClient2Server( $parser_hash['detail']['JTITLE_MONTH'        ] ),
            'jtitle_spage'        => encodeClient2Server( $parser_hash['detail']['JTITLE_SPAGE'        ] ),
            'jtitle_epage'        => encodeClient2Server( $parser_hash['detail']['JTITLE_EPAGE'        ] ),
            'abstract'            => encodeClient2Server( $parser_hash['detail']['ABSTRACT'            ] ),
            'table_of_contents'   => encodeClient2Server( $parser_hash['detail']['TABLE_OF_CONTENTS'   ] ),
            'edition'            => encodeClient2Server( $parser_hash['detail']['EDITION'              ] ),
            'publish_place'      => encodeClient2Server( $parser_hash['detail']['PUBLISH_PLACE'        ] ),
            'type_of_resource'    => encodeClient2Server( $parser_hash['detail']['TYPE_OF_RESOURCE'    ] ),
            'genre'               => encodeClient2Server( $parser_hash['detail']['GENRE'               ] ),
            'access_condition'    => encodeClient2Server( $parser_hash['detail']['ACCESS_CONDITION'    ] ),
        );
        $names = array(
            'title'               => _MD_XNPARTICLE_TITLE_LABEL,
            'title_kana'          => _MD_XNPARTICLE_KANA_LABEL,
            'title_romaji'        => _MD_XNPARTICLE_ROMAJI_LABEL,
            'publisher'           => _MD_XNPARTICLE_PUBLISHER_LABEL,
            'publisher_kana'      => _MD_XNPARTICLE_KANA_LABEL,
            'publisher_romaji'    => _MD_XNPARTICLE_ROMAJI_LABEL,
            'year_f'              => _MD_XNPARTICLE_PUBLISH_YEAR_LABEL,
            'year_t'              => _MD_XNPARTICLE_PUBLISH_YEAR_LABEL,
            'date_create'         => _MD_XNPARTICLE_DATE_CREATE_LABEL,
            'date_update'         => _MD_XNPARTICLE_DATE_UPDATE_LABEL,
            'date_record'         => _MD_XNPARTICLE_DATE_RECORD_LABEL,
            'jtitle'              => _MD_XNPARTICLE_JTITLE_LABEL,
            'jtitle_translation'  => _MD_XNPARTICLE_TRANSLATION_LABEL,
            'jtitle_volume'       => _MD_XNPARTICLE_JTITLE_VOLUME_LABEL,
            'jtitle_issue'        => _MD_XNPARTICLE_JTITLE_ISSUE_LABEL,
            'jtitle_year'         => _MD_XNPARTICLE_JTITLE_YEAR_LABEL,
            'jtitle_month'        => _MD_XNPARTICLE_JTITLE_MONTH_LABEL,
            'jtitle_spage'        => _MD_XNPARTICLE_JTITLE_SPAGE_LABEL,
            'jtitle_epage'        => _MD_XNPARTICLE_JTITLE_EPAGE_LABEL,
            'abstract'            => _MD_XNPARTICLE_ABSTRACT_LABEL,
            'table_of_contents'   => _MD_XNPARTICLE_TABLE_OF_CONTENTS_LABEL,
            'edition'             => _MD_XNPARTICLE_EDITION_LABEL,
            'publish_place'            => _MD_XNPARTICLE_PUBLISH_PLACE_LABEL,
            'type_of_resource'    => _MD_XNPARTICLE_TYPE_OF_RESOURCE_LABEL,
            'genre'               => _MD_XNPARTICLE_GENRE_LABEL,
            'access_condition'    => _MD_XNPARTICLE_ACCESS_CONDITION_LABEL,
        );
        foreach ( $values as $key => $value ){
            if ( strlen($value) > $lengths[$key] ){
                list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                $parser_hash['exceeds'][$key] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
            }
        }
        
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_sub_title' );
        $ct = count( $parser_hash['detail']['sub_title']['sub_title_name'] );
        $names = array(
            'sub_title_name'                    => _MD_XNPARTICLE_SUB_TITLE_LABEL . " - " . _MD_XNPARTICLE_AUTHOR_NAME_LABEL            ,
            'sub_title_kana'                    => _MD_XNPARTICLE_SUB_TITLE_LABEL . " - " . _MD_XNPARTICLE_KANA_LABEL                   ,
            'sub_title_romaji'                  => _MD_XNPARTICLE_SUB_TITLE_LABEL . " - " . _MD_XNPARTICLE_ROMAJI_LABEL                 ,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'sub_title_name'                    => encodeClient2Server( $parser_hash['detail']['sub_title']['sub_title_name'                   ][$i] ),
                'sub_title_kana'                    => encodeClient2Server( $parser_hash['detail']['sub_title']['sub_title_kana'                   ][$i] ),
                'sub_title_romaji'                  => encodeClient2Server( $parser_hash['detail']['sub_title']['sub_title_romaji'                 ][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }

        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_author' );
        $ct = count( $parser_hash['detail']['author']['author_name'] );
        $names = array(
            'author_id'                      => _MD_XNPARTICLE_AUTHOR_LABEL . " - " . _MD_XNPARTICLE_AUTHOR_ID_LABEL              ,
            'author_name'                    => _MD_XNPARTICLE_AUTHOR_LABEL . " - " . _MD_XNPARTICLE_AUTHOR_NAME_LABEL            ,
            'author_kana'                    => _MD_XNPARTICLE_AUTHOR_LABEL . " - " . _MD_XNPARTICLE_KANA_LABEL                   ,
            'author_romaji'                  => _MD_XNPARTICLE_AUTHOR_LABEL . " - " . _MD_XNPARTICLE_ROMAJI_LABEL                 ,
            'author_affiliation'             => _MD_XNPARTICLE_AUTHOR_LABEL . " - " . _MD_XNPARTICLE_AUTHOR_AFFILIATION_LABEL            ,
            'author_affiliation_translation' => _MD_XNPARTICLE_AUTHOR_LABEL . " - " . _MD_XNPARTICLE_AUTHOR_AFFILIATION_TRANSLATION_LABEL,
            'author_role'                    => _MD_XNPARTICLE_AUTHOR_LABEL . " - " . _MD_XNPARTICLE_AUTHOR_ROLE_LABEL                   ,
            'author_link'                    => _MD_XNPARTICLE_AUTHOR_LABEL . " - " . _MD_XNPARTICLE_AUTHOR_LINK_LABEL                   ,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'author_id'                      => encodeClient2Server( $parser_hash['detail']['author']['author_id'                   ][$i] ),
                'author_name'                    => encodeClient2Server( $parser_hash['detail']['author']['author_name'                   ][$i] ),
                'author_kana'                    => encodeClient2Server( $parser_hash['detail']['author']['author_kana'                   ][$i] ),
                'author_romaji'                  => encodeClient2Server( $parser_hash['detail']['author']['author_romaji'                 ][$i] ),
                'author_affiliation'             => encodeClient2Server( $parser_hash['detail']['author']['author_affiliation'            ][$i] ),
                'author_affiliation_translation' => encodeClient2Server( $parser_hash['detail']['author']['author_affiliation_translation'][$i] ),
                'author_role'                    => encodeClient2Server( $parser_hash['detail']['author']['author_role'                   ][$i] ),
                'author_link'                    => encodeClient2Server( $parser_hash['detail']['author']['author_link'                   ][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_keywords' );
        $ct = count( $parser_hash['detail']['keywords']['keyword'] );
        $names = array(
            'keywords' => _MD_XNPARTICLE_KEYWORDS_LABEL,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'keywords' => encodeClient2Server( $parser_hash['detail']['keywords']['keyword'][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_ndc_classifications' );
        $ct = count( $parser_hash['detail']['ndc_classifications']['ndc_classification'] );
        $names = array(
            'ndc_classifications' => _MD_XNPARTICLE_NDC_CLASSIFICATIONS_LABEL,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'ndc_classifications' => encodeClient2Server( $parser_hash['detail']['ndc_classifications']['ndc_classification'][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_physical_descriptions' );
        $ct = count( $parser_hash['detail']['physical_descriptions']['physical_description'] );
        $names = array(
            'physical_descriptions' => _MD_XNPARTICLE_PHYSICAL_DESCRIPTIONS_LABEL,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'physical_descriptions' => encodeClient2Server( $parser_hash['detail']['physical_descriptions']['physical_description'][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_langs' );
        $ct = count( $parser_hash['detail']['langs']['lang'] );
        $names = array(
            'langs' => _MD_XNPARTICLE_LANGS_LABEL,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'langs' => encodeClient2Server( $parser_hash['detail']['langs']['lang'][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_id_issns' );
        $ct = count( $parser_hash['detail']['id_issns']['id_issn'] );
        $names = array(
            'id_issns' => _MD_XNPARTICLE_ISSN_LABEL,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'id_issns' => encodeClient2Server( $parser_hash['detail']['id_issns']['id_issn'][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_id_isbns' );
        $ct = count( $parser_hash['detail']['id_isbns']['id_isbn'] );
        $names = array(
            'id_isbns' => _MD_XNPARTICLE_ISBN_LABEL,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'id_isbns' => encodeClient2Server( $parser_hash['detail']['id_isbns']['id_isbn'][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_id_dois' );
        $ct = count( $parser_hash['detail']['id_dois']['id_doi'] );
        $names = array(
            'id_dois' => _MD_XNPARTICLE_DOI_LABEL,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'id_dois' => encodeClient2Server( $parser_hash['detail']['id_dois']['id_doi'][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_id_uris' );
        $ct = count( $parser_hash['detail']['id_uris']['id_uri'] );
        $names = array(
            'id_uris' => _MD_XNPARTICLE_ID_URI_LABEL,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'id_uris' => encodeClient2Server( $parser_hash['detail']['id_uris']['id_uri'][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_id_locals' );
        $ct = count( $parser_hash['detail']['id_locals']['id_local'] );
        $names = array(
            'id_locals' => _MD_XNPARTICLE_OTHER_LABEL,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'id_locals' => encodeClient2Server( $parser_hash['detail']['id_locals']['id_local'][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        $lengths = xnpGetColumnLengths( 'xnparticle_item_detail_child_uris' );
        $ct = count( $parser_hash['detail']['uris']['uri'] );
        $names = array(
            'uris' => _MD_XNPARTICLE_URI_LABEL,
        );
        for ( $i = 0; $i < $ct; $i++ ){
            $values = array(
                'uris' => encodeClient2Server( $parser_hash['detail']['uris']['uri'][$i] ),
            );
            foreach ( $values as $key => $value ){
                if ( strlen($value) > $lengths[$key] ){
                    list( $within, $without ) = xnpTrimString( $value, $lengths[$key] );
                    $parser_hash['exceeds'][$key . $i] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
                }
            }
        }
        break;
    }
}

function xnparticleGetCheckItemLengthHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnparticleStartElement", "xnparticleCheckItemLengthEndElement", "xnparticleCharacterData" ) );
}

function xnparticleGetModifiedFields( $item_id )
{
    $ret = array();
    $basic = xnpGetBasicInformationArray($item_id);
    $detail = xnparticleGetDetailInformation( $item_id );
    if( $detail ){
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'title'			  =>_MD_XNPARTICLE_TITLE_LABEL." "._MD_XOONIPS_ITEM_TITLE_LABEL,
                        'title_kana'		  =>_MD_XNPARTICLE_TITLE_LABEL." "._MD_XNPARTICLE_KANA_LABEL,
                        'title_romaji'		  =>_MD_XNPARTICLE_TITLE_LABEL." "._MD_XNPARTICLE_ROMAJI_LABEL,
                        'publisher'		  =>_MD_XNPARTICLE_PUBLISHER_LABEL,
                        'publisher_kana'          =>_MD_XNPARTICLE_PUBLISHER_LABEL." "._MD_XNPARTICLE_KANA_LABEL,
                        'publisher_romaji'        =>_MD_XNPARTICLE_PUBLISHER_LABEL." "._MD_XNPARTICLE_ROMAJI_LABEL,
                        'year_f'                  =>_MD_XNPARTICLE_PUBLISH_YEAR_LABEL,
                        'year_t'                  =>_MD_XNPARTICLE_PUBLISH_YEAR_LABEL,
                        'date_create'             =>_MD_XNPARTICLE_DATE_CREATE_LABEL,
                        'date_update'             =>_MD_XNPARTICLE_DATE_UPDATE_LABEL,
                        'date_record'             =>_MD_XNPARTICLE_DATE_RECORD_LABEL,
                        'jtitle'                  =>_MD_XNPARTICLE_JTITLE_LABEL,
                        'jtitle_translation'      =>_MD_XNPARTICLE_TRANSLATION_LABEL,
                        'jtitle_volume'           =>_MD_XNPARTICLE_JTITLE_VOLUME_LABEL,
                        'jtitle_issue'            =>_MD_XNPARTICLE_JTITLE_ISSUE_LABEL,
                        'jtitle_year'             =>_MD_XNPARTICLE_JTITLE_YEAR_LABEL,
                        'jtitle_month'            =>_MD_XNPARTICLE_JTITLE_MONTH_LABEL,
                        'jtitle_spage'            =>_MD_XNPARTICLE_JTITLE_SPAGE_LABEL,
                        'jtitle_epage'            =>_MD_XNPARTICLE_JTITLE_EPAGE_LABEL,
                        'abstract'		  =>_MD_XNPARTICLE_ABSTRACT_LABEL,
                        'table_of_contents'	  =>_MD_XNPARTICLE_TABLE_OF_CONTENTS_LABEL,
                        'edition'		  =>_MD_XNPARTICLE_EDITION_LABEL,
                        'publish_place'		  =>_MD_XNPARTICLE_PUBLISH_PLACE_LABEL,
                        'type_of_resource'	  =>_MD_XNPARTICLE_TYPE_OF_RESOURCE_LABEL,
                        'genre'			  =>_MD_XNPARTICLE_GENRE_LABEL,
                        'access_condition'	  =>_MD_XNPARTICLE_ACCESS_CONDITION_LABEL
      ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        
        // pdfファイルの変更があるか?
        if( xnpIsAttachmentModified( 'article_attachment', $item_id ) ){
            array_push( $ret, _MD_XNPARTICLE_ATTACHMENT_LABEL );
        }
    }

	$detail_child_sub_title = xnparticleGetDetailChildSubTitleInformation( $item_id );
	$i = count($detail_child_sub_title);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_sub_title_id, $article_id, $sub_title_name, $sub_title_kana, $sub_title_romaji, $sub_title_order ) ) = each( $detail_child_sub_title ) ){
			if ( (!empty($detail['sub_title_name'])) || (!empty($detail['sub_title_kana'])) || (!empty($detail['sub_title_romaji']))  ){
				$detail['sub_title_name'] .= "\n";
				$detail['sub_title_kana'] .= "\n";
				$detail['sub_title_romaji'] .= "\n";
			$detail['sub_title_name'] .= ( !empty( $sub_title_name ) ) ? $sub_title_name : " ";
			$detail['sub_title_kana'] .= ( !empty( $sub_title_kana ) ) ? $sub_title_kana : " ";
			$detail['sub_title_romaji'] .= ( !empty( $sub_title_romaji ) ) ? $sub_title_romaji : " ";
			}
		}
		$flg = 0;
        foreach( array( 'sub_title_name'				    =>_MD_XNPARTICLE_SUB_TITLE_LABEL,
                        'sub_title_kana'				    =>_MD_XNPARTICLE_SUB_TITLE_LABEL,
                        'sub_title_romaji'				    =>_MD_XNPARTICLE_SUB_TITLE_LABEL) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
    	}
   	}

	$detail_child_author = xnparticleGetDetailChildAuthorInformation( $item_id );
	$i = count($detail_child_author);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $detail_child_author ) ){
			if ( (!empty($detail['author_id'])) || (!empty($detail['author_name'])) || (!empty($detail['author_kana'])) || (!empty($detail['author_romaji'])) || (!empty($detail['author_affiliation'])) || (!empty($detail['author_affiliation_translation'])) || (!empty($detail['author_role'])) || (!empty($detail['author_link'])) ){
				$detail['author_id'] .= "\n";
				$detail['author_name'] .= "\n";
				$detail['author_kana'] .= "\n";
				$detail['author_romaji'] .= "\n";
				$detail['author_affiliation'] .= "\n";
				$detail['author_affiliation_translation'] .= "\n";
				$detail['author_role'] .= "\n";
				$detail['author_link'] .= "\n";
			$detail['author_id']   .= ( !empty( $author_id ) )   ? $author_id : " ";
			$detail['author_name'] .= ( !empty( $author_name ) ) ? $author_name : " ";
			$detail['author_kana'] .= ( !empty( $author_kana ) ) ? $author_kana : " ";
			$detail['author_romaji'] .= ( !empty( $author_romaji ) ) ? $author_romaji : " ";
			$detail['author_affiliation'] .= ( !empty( $author_affiliation ) ) ? $author_affiliation : " ";
			$detail['author_affiliation_translation'] .= ( !empty( $author_affiliation_translation ) ) ? $author_affiliation_translation : " ";
			$detail['author_role'] .= ( !empty( $author_role ) ) ? $author_role : " ";
			$detail['author_link'] .= ( !empty( $author_link ) ) ? $author_link : " ";
			}
		}
		$flg = 0;
        foreach( array( 'author_id'				    =>_MD_XNPARTICLE_AUTHOR_LABEL,
                        'author_name'				    =>_MD_XNPARTICLE_AUTHOR_LABEL,
                        'author_kana'				    =>_MD_XNPARTICLE_AUTHOR_LABEL,
                        'author_romaji'				    =>_MD_XNPARTICLE_AUTHOR_LABEL,
                        'author_affiliation'		    =>_MD_XNPARTICLE_AUTHOR_LABEL,
                        'author_affiliation_translation'    =>_MD_XNPARTICLE_AUTHOR_LABEL,
                        'author_role'				    =>_MD_XNPARTICLE_AUTHOR_LABEL,
                        'author_link'=>_MD_XNPARTICLE_AUTHOR_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
    	}
   	}
	$detail_child_keywords = xnparticleGetDetailChildKeywordsInformation( $item_id );
	$detail['keywords'] = "";
	$i = count($detail_child_keywords);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_keywords_id, $article_id, $keywords, $keywords_order ) ) = each( $detail_child_keywords ) ){
			if ( !empty( $detail['keywords'] ) ){
				$detail['keywords'] .= "\n";
			}
			$detail['keywords'] .= $keywords;
		}
		$flg = 0;
        foreach( array( 'keywords'				  =>_MD_XNPARTICLE_KEYWORDS_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
	    }
        }

	$detail_child_ndc_classifications = xnparticleGetDetailChildNdcClassificationsInformation( $item_id );
	$detail['ndc_classifications'] = "";
	$i = count($detail_child_ndc_classifications);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_ndc_classifications_id, $article_id, $ndc_classifications, $ndc_classifications_order ) ) = each( $detail_child_ndc_classifications ) ){
			if ( !empty( $detail['ndc_classifications'] ) ){
				$detail['ndc_classifications'] .= "\n";
			}
			$detail['ndc_classifications'] .= $ndc_classifications;
		}
		$flg = 0;
        foreach( array( 'ndc_classifications'				  =>_MD_XNPARTICLE_NDC_CLASSIFICATIONS_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
	    }
        }

	$detail_child_physical_descriptions = xnparticleGetDetailChildPhysicalDescriptionsInformation( $item_id );
	$detail['physical_descriptions'] = "";
	$i = count($detail_child_physical_descriptions);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_physical_descriptions_id, $article_id, $physical_descriptions, $physical_descriptions_order ) ) = each( $detail_child_physical_descriptions ) ){
			if ( !empty( $detail['physical_descriptions'] ) ){
				$detail['physical_descriptions'] .= "\n";
			}
			$detail['physical_descriptions'] .= $physical_descriptions;
		}
		$flg = 0;
        foreach( array( 'physical_descriptions'				  =>_MD_XNPARTICLE_PHYSICAL_DESCRIPTIONS_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
	    }
        }

	$detail_child_langs = xnparticleGetDetailChildLangsInformation( $item_id );
	$detail['langs'] = "";
	$i = count($detail_child_langs);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_langs_id, $article_id, $langs, $langs_order ) ) = each( $detail_child_langs ) ){
			if ( !empty( $detail['langs'] ) ){
				$detail['langs'] .= "\n";
			}
			$detail['langs'] .= $langs;
		}
		$flg = 0;
        foreach( array( 'langs'				  =>_MD_XNPARTICLE_LANGS_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
	    }
    }

	$detail_child_id_issns = xnparticleGetDetailChildIdIssnsInformation( $item_id );
	$detail['id_issns'] = "";
	$i = count($detail_child_id_issns);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_id_issns_id, $article_id, $id_issns, $id_issns_order ) ) = each( $detail_child_id_issns ) ){
			if ( !empty( $detail['id_issns'] ) ){
				$detail['id_issns'] .= "\n";
			}
			$detail['id_issns'] .= $id_issns;
		}
		$flg = 0;
        foreach( array( 'id_issns'				  =>_MD_XNPARTICLE_ISSN_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
	    }
    }

	$detail_child_id_isbns = xnparticleGetDetailChildIdIsbnsInformation( $item_id );
	$detail['id_isbns'] = "";
	$i = count($detail_child_id_isbns);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_id_isbns_id, $article_id, $id_isbns, $id_isbns_order ) ) = each( $detail_child_id_isbns ) ){
			if ( !empty( $detail['id_isbns'] ) ){
				$detail['id_isbns'] .= "\n";
			}
			$detail['id_isbns'] .= $id_isbns;
		}
		$flg = 0;
        foreach( array( 'id_isbns'				  =>_MD_XNPARTICLE_ISBN_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
	    }
    }

	$detail_child_id_dois = xnparticleGetDetailChildIdDoisInformation( $item_id );
	$detail['id_dois'] = "";
	$i = count($detail_child_id_dois);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_id_dois_id, $article_id, $id_dois, $id_dois_order ) ) = each( $detail_child_id_dois ) ){
			if ( !empty( $detail['id_dois'] ) ){
				$detail['id_dois'] .= "\n";
			}
			$detail['id_dois'] .= $id_dois;
		}
		$flg = 0;
        foreach( array( 'id_dois'				  =>_MD_XNPARTICLE_DOI_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
	    }
    }

	$detail_child_id_uris = xnparticleGetDetailChildIdUrisInformation( $item_id );
	$detail['id_uris'] = "";
	$i = count($detail_child_id_uris);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_id_uris_id, $article_id, $id_uris, $id_uris_order ) ) = each( $detail_child_id_uris ) ){
			if ( !empty( $detail['id_uris'] ) ){
				$detail['id_uris'] .= "\n";
			}
			$detail['id_uris'] .= $id_uris;
		}
		$flg = 0;
        foreach( array( 'id_uris'				  =>_MD_XNPARTICLE_URI_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
	    }
    }

	$detail_child_id_locals = xnparticleGetDetailChildIdLocalsInformation( $item_id );
	$detail['id_locals'] = "";
	$i = count($detail_child_id_locals);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_id_locals_id, $article_id, $id_locals, $id_locals_order ) ) = each( $detail_child_id_locals ) ){
			if ( !empty( $detail['id_locals'] ) ){
				$detail['id_locals'] .= "\n";
			}
			$detail['id_locals'] .= $id_locals;
		}
		$flg = 0;
        foreach( array( 'id_locals'				  =>_MD_XNPARTICLE_OTHER_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
	    }
    }

	$detail_child_uris = xnparticleGetDetailChildUrisInformation( $item_id );
	$detail['uris'] = "";
	$i = count($detail_child_uris);
	if ($i > 0) {
        $myts =& MyTextSanitizer::getInstance( );
		while ( list( $key, list( $article_child_uris_id, $article_id, $uris, $uris_order ) ) = each( $detail_child_uris ) ){
			if ( !empty( $detail['uris'] ) ){
				$detail['uris'] .= "\n";
			}
			$detail['uris'] .= $uris;
		}
		$flg = 0;
        foreach( array( 'uris'				  =>_MD_XNPARTICLE_URI_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) {
				if ($flg == 0) array_push( $ret, $v );
				$flg = 1;
			}
	    }
    }

    return $ret;
}

function xnparticleGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_article.gif', _MD_XNPARTICLE_EXPLANATION, false, false );
}

function xnparticleSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' ||  $metadataPrefix == 'junii2' ) return true;
    return false;
}

//OAI-PMH
function xnparticleGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK ) return false;
	        $detail = xnparticleGetDetailInformation( $item_id );
		$lines = array();

		//JuNii oldの場合(利用なし)
		if( $metadataPrefix == 'junii_old' ){
            		$lines[] = "<metadata>";
            		$lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
			$lines[] = $meta_basic;
			$lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii(1)."</type>";
			$detail_child_sub_title = xnparticleGetDetailChildSubTitleInformation( $item_id );
			$i = count($detail_child_sub_title);
			if ($i > 0) {
		        $myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_sub_title_id, $article_id, $sub_title_name, $sub_title_kana, $sub_title_romaji, $sub_title_order ) ) = each( $detail_child_sub_title ) ){
					if (!empty($sub_title_name)) {
						$sub_title = $sub_title_name;
					}
					if (!empty($sub_title_kana)) {
						$sub_title .= "(".$sub_title_kana.")";
					}
					if (!empty($sub_title_romaji)) {
						$sub_title .= " (".$sub_title_romaji.")";
					}
					$lines[] = "<sub title>".xnpHtmlspecialchars($sub_title)."</sub title>";
				}
		   	}
			$detail_child_author = xnparticleGetDetailChildAuthorInformation( $item_id );
			$i = count($detail_child_author);
			if ($i > 0) {
		        $myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $detail_child_author ) ){
					if (!empty($author_id)) {
						$author = $author_id.":";
					}
					if (!empty($author_name)) {
						$author .= $author_name;
					}
					if (!empty($author_kana)) {
						$author .= "(".$author_kana.")";
					}
					if (!empty($author_romaji)) {
						$author .= " (".$author_romaji.")";
					}
			                $lines[] = "<creator>".xnpHtmlspecialchars($author)."</creator>";
				}
		   	}
            		//$lines[] = "<identifier>bibliographicCitation:".xnpHtmlspecialchars(
                	//sprintf( "%s %s(%s), %s. (%s)",
                        //$basic['publication_year'] ) )."</identifier>";
            		$lines[] = "<date xsi:type=\"ISO8601\">".xnpISO8601($basic['publication_year'], $basic['publication_month'], $basic['publication_mday'])."</date>";
            		$lines[] = "</meta>";
            		$lines[] = "</metadata>";

		//JuNii(1)の場合
		}else if( $metadataPrefix == 'junii' ){
			$lines = array();
			$lines[] = "<metadata>";
            		$lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';

			//$lines[] = $meta_basic;

			//institution
			$lines[] = "<institution>"._MD_XNPARTICLE_INSTITUTION_NAME."</institution>";

			//title
			if(!empty($detail['title']))
				$lines[] = "<title>".xnpHtmlspecialchars($detail['title'])."</title>";
			if(!empty($detail['title_kana']))
				$lines[] = "<alternative>".xnpHtmlspecialchars($detail['title_kana'])."</alternative>";
			if(!empty($detail['title_romaji']))
				$lines[] = "<alternative>".xnpHtmlspecialchars($detail['title_romaji'])."</alternative>";
			$detail_child_sub_title = xnparticleGetDetailChildSubTitleInformation( $item_id );
			$num_sub_title = count($detail_child_sub_title);
			if ($num_sub_title > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_sub_title_id, $article_id, $sub_title_name, $sub_title_kana, $sub_title_romaji, $sub_title_order ) ) = each( $detail_child_sub_title ) ){
					if(!empty($sub_title_name)) $lines[] = "<alternative>".xnpHtmlspecialchars($sub_title_name)."</alternative>";
					if(!empty($sub_title_kana)) $lines[] = "<alternative>".xnpHtmlspecialchars($sub_title_kana)."</alternative>";
					if(!empty($sub_title_romaji)) $lines[] = "<alternative>".xnpHtmlspecialchars($sub_title_romaji)."</alternative>";
				}
			}
			//jtitle
			if(!empty($detail['jtitle']))
				$lines[] = "<jtitle>".xnpHtmlspecialchars($detail['jtitle'])."</jtitle>";
			if(!empty($detail['jtitle_translation']))
				$lines[] = "<jtitle>".xnpHtmlspecialchars($detail['jtitle_translation'])."</jtitle>";
			if(!empty($detail['jtitle_volume']))
				$lines[] = "<volume>".xnpHtmlspecialchars($detail['jtitle_volume'])."</volume>";
			if(!empty($detail['jtitle_issue']))
				$lines[] = "<issue>".xnpHtmlspecialchars($detail['jtitle_issue'])."</issue>";
			if(!empty($detail['jtitle_year']) && !empty($detail['jtitle_month'])){
				$lines[] = "<dateofissued>".xnpHtmlspecialchars($detail['jtitle_year'])."-".xnpHtmlspecialchars($detail['jtitle_month'])."</dateofissued>";
			}else if(!empty($detail['jtitle_year'])){
				$lines[] = "<dateofissued>".xnpHtmlspecialchars($detail['jtitle_year'])."</dateofissued>";
			}
			if(!empty($detail['jtitle_spage']))
				$lines[] = "<spage>".xnpHtmlspecialchars($detail['jtitle_spage'])."</spage>";
			if(!empty($detail['jtitle_epage']))
				$lines[] = "<epage>".xnpHtmlspecialchars($detail['jtitle_epage'])."</epage>";
			//creator
			$detail_child_author = xnparticleGetDetailChildAuthorInformation( $item_id );
			$num_author = count($detail_child_author);
			if ($num_author > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $detail_child_author ) ){
					if(!empty($author_name)) $lines[] = "<creator>".xnpHtmlspecialchars($author_name)."</creator>";
					if(!empty($author_kana)) $lines[] = "<creator>".xnpHtmlspecialchars($author_kana)."</creator>";
					if(!empty($author_romaji)) $lines[] = "<creator>".xnpHtmlspecialchars($author_romaji)."</creator>";
					if(!empty($author_affilication)) $lines[] = "<contributor>".xnpHtmlspecialchars($author_affiliation)."</contributor>";
					if(!empty($author_affiliation_translation)) $lines[] = "<contributor>".xnpHtmlspecialchars($author_affiliation_translation)."</contributor>";
					if(!empty($author_role)) $lines[] = "<description>".xnpHtmlspecialchars($author_role)."</description>";
					if(!empty($author_link)) $lines[] = "<relation>".xnpHtmlspecialchars($author_link)."</relation>";
				}
			}
			//subject
			$detail_child_keywords = xnparticleGetDetailChildKeywordsInformation( $item_id );
			$num_keywords = count($detail_child_keywords);
			if ($num_keywords > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_keywords_id, $article_id, $keywords, $keywords_order ) ) = each( $detail_child_keywords) ){
					if(!empty($keywords)) $lines[] = "<subject>".xnpHtmlspecialchars($keywords)."</subject>";
				}
			}
			//format
			$detail_child_physical_descriptions = xnparticleGetDetailChildPhysicalDescriptionsInformation( $item_id );
			$num_physical_descriptions = count($detail_child_physical_descriptions);
			if ($num_physical_descriptions > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_physical_descriptions_id, $article_id, $physical_descriptions, $physical_descriptions_order ) ) = each( $detail_child_physical_descriptions) ){
					if(!empty($physical_descriptions)) $lines[] = "<format>".xnpHtmlspecialchars($physical_descriptions)."</format>";
				}
			}
			//NDC
			$detail_child_ndc_classifications = xnparticleGetDetailChildNdcClassificationsInformation( $item_id );
			$num_ndc_classifications = count($detail_child_ndc_classifications);
			if ($num_ndc_classifications > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_ndc_classifications_id, $article_id, $ndc_classifications, $ndc_classifications_order ) ) = each( $detail_child_ndc_classifications) ){
					if(!empty($ndc_classifications)) $lines[] = "<subject xsi:type=\"NDC\">".xnpHtmlspecialchars($ndc_classifications)."</subject>";
				}
			}
			//publisher
			if(!empty($detail['publisher']))
				$lines[] = "<publisher>".xnpHtmlspecialchars($detail['publisher'])."</publisher>";
			if(!empty($detail['publisher_kana']))
				$lines[] = "<publisher>".xnpHtmlspecialchars($detail['publisher_kana'])."</publisher>";
			if(!empty($detail['publisher_romaji']))
				$lines[] = "<publisher>".xnpHtmlspecialchars($detail['publisher_romaji'])."</publisher>";
			//lang
			$detail_child_langs = xnparticleGetDetailChildLangsInformation( $item_id );
			$num_langs = count($detail_child_langs);
			if ($num_langs > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_langs_id, $article_id, $langs, $langs_order ) ) = each( $detail_child_langs) ){
					if(!empty($langs)) $lines[] = "<language>".xnpHtmlspecialchars($langs)."</language>";
				}
			}
			//type
			if(!empty($detail['type_of_resource']))
				$lines[] = "<type>".xnpHtmlspecialchars($detail['type_of_resource'])."</type>";
			//NIIType
			if(!empty($detail['genre']))
				$lines[] = "<NIItype>".xnpHtmlspecialchars($detail['genre'])."</NIItype>";
			//date
			if(!empty($detail['year_f']) && !empty($detail['year_t'])){
				$lines[] = "<date>".xnpHtmlspecialchars($detail['year_f'])."-".xnpHtmlspecialchars($detail['year_t'])."</date>";
			}else if(!empty($detail['year_f'])){
				$lines[] = "<date>".xnpHtmlspecialchars($detail['year_f'])."</date>";
			}else if(!empty($detail['year_t'])){
				$lines[] = "<date>".xnpHtmlspecialchars($detail['year_t'])."</date>";
			}
			if(!empty($detail['date_create']))
				$lines[] = "<adate>".xnpHtmlspecialchars($detail['date_create'])."</adate>";
			if(!empty($detail['date_update']))
				$lines[] = "<udate>".xnpHtmlspecialchars($detail['date_update'])."</udate>";
			if(!empty($detail['date_record']))
				$lines[] = "<adate>".xnpHtmlspecialchars($detail['date_record'])."</adate>";
			//rights
			if(!empty($detail['access_condtion']))
				$lines[] = "<rights>".xnpHtmlspecialchars($detail['access_condition'])."</rights>";
			//description
			if(!empty($detail['edition']))
				$lines[] = "<description>".xnpHtmlspecialchars($detail['edition'])."</description>";
			if(!empty($detail['publish_place']))
				$lines[] = "<description>".xnpHtmlspecialchars($detail['publish_place'])."</description>";
			if(!empty($basic['description']))
				$lines[] = "<description>".xnpHtmlspecialchars($basic['description'])."</description>";
			if(!empty($detail['table_of_contents']))
				$lines[] = "<description>".xnpHtmlspecialchars($detail['table_of_contents'])."</description>";
			if(!empty($detail['abstract']))
				$lines[] = "<description>".xnpHtmlspecialchars($detail['abstract'])."</description>";
			//identifier
                        if($basic['doi'] =="" ) $identifier = XOOPS_URL . "/modules/xoonips/detail.php?item_id=".xnpHtmlspecialchars($item_id);
                        else $identifier = XOOPS_URL . "/modules/xoonips/detail.php?" . XNP_CONFIG_DOI_FIELD_PARAM_NAME . "=" . xnpHtmlspecialchars($basic['doi']);
                        $lines[] = "<URI>" . $identifier . "</URI>";
			$detail_child_id_isbns = xnparticleGetDetailChildIdIsbnsInformation( $item_id );
			//isbn
			$num_id_isbns = count($detail_child_id_isbns);
			if ($num_id_isbns > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_isbns_id, $article_id, $id_isbns, $id_isbns_order ) ) = each( $detail_child_id_isbns) ){
					if(!empty($id_isbns)) $lines[] = "<isbn>".xnpHtmlspecialchars($id_isbns)."</isbn>";
				}
			}
			//issn
			$detail_child_id_issns = xnparticleGetDetailChildIdIssnsInformation( $item_id );
			$num_id_issns = count($detail_child_id_issns);
			if ($num_id_issns > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_issns_id, $article_id, $id_issns, $id_issns_order ) ) = each( $detail_child_id_issns) ){
					if(!empty($id_issns)) $lines[] = "<issn>".xnpHtmlspecialchars($id_issns)."</issn>";
				}
			}
			//doi
			$detail_child_id_dois = xnparticleGetDetailChildIdDoisInformation( $item_id );
			$num_id_dois = count($detail_child_id_dois);
			if ($num_id_dois > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_dois_id, $article_id, $id_dois, $id_dois_order ) ) = each( $detail_child_id_dois) ){
					if(!empty($id_dois)) $lines[] = "<doi>".xnpHtmlspecialchars($id_dois)."</doi>";
				}
			}
			//identifier
			$detail_child_id_uris = xnparticleGetDetailChildIdUrisInformation( $item_id );
			$num_id_uris = count($detail_child_id_uris);
			if ($num_id_uris > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_uris_id, $article_id, $id_uris, $id_uris_order ) ) = each( $detail_child_id_uris) ){
					if(!empty($id_uris)) $lines[] = "<identifier>".xnpHtmlspecialchars($id_uris)."</identifier>";
				}
			}
			$detail_child_id_locals = xnparticleGetDetailChildIdLocalsInformation( $item_id );
			$num_id_locals = count($detail_child_id_locals);
			if ($num_id_locals > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_locals_id, $article_id, $id_locals, $id_locals_order ) ) = each( $detail_child_id_locals) ){
					if(!empty($id_locals)) $lines[] = "<identifier>".xnpHtmlspecialchars($id_locals)."</identifier>";
				}
			}
			$lines[] = "</meta>";
			$lines[] = "</metadata>";

		//JuNii2の場合
		}else if( $metadataPrefix == 'junii2' ){
			$lines = array();
			$lines[] = "<metadata>";
            		$lines[] = '<meta xmlns="http://ju.nii.ac.jp/junii2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://ju.nii.ac.jp/junii2 http://ju.nii.ac.jp/oai/junii2.xsd　">';
			//$lines[] = $meta_basic;
			//title
			if(!empty($detail['title']))
				$lines[] = "<title>".xnpHtmlspecialchars($detail['title'])."</title>";
			if(!empty($detail['title_kana']))
				$lines[] = "<alternative>".xnpHtmlspecialchars($detail['title_kana'])."</alternative>";
			if(!empty($detail['title_romaji']))
				$lines[] = "<alternative>".xnpHtmlspecialchars($detail['title_romaji'])."</alternative>";
			$detail_child_sub_title = xnparticleGetDetailChildSubTitleInformation( $item_id );
			$num_sub_title = count($detail_child_sub_title);
			if ($num_sub_title > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_sub_title_id, $article_id, $sub_title_name, $sub_title_kana, $sub_title_romaji, $sub_title_order ) ) = each( $detail_child_sub_title ) ){
					if(!empty($sub_title_name)) $lines[] = "<alternative>".xnpHtmlspecialchars($sub_title_name)."</alternative>";
					if(!empty($sub_title_kana)) $lines[] = "<alternative>".xnpHtmlspecialchars($sub_title_kana)."</alternative>";
					if(!empty($sub_title_romaji)) $lines[] = "<alternative>".xnpHtmlspecialchars($sub_title_romaji)."</alternative>";
				}
			}
			//jtitle
			if(!empty($detail['jtitle']))
				$lines[] = "<jtitle>".xnpHtmlspecialchars($detail['jtitle'])."</jtitle>";
			if(!empty($detail['jtitle_translation']))
				$lines[] = "<jtitle>".xnpHtmlspecialchars($detail['jtitle_translation'])."</jtitle>";
			if(!empty($detail['jtitle_volume']))
				$lines[] = "<volume>".xnpHtmlspecialchars($detail['jtitle_volume'])."</volume>";
			if(!empty($detail['jtitle_issue']))
				$lines[] = "<issue>".xnpHtmlspecialchars($detail['jtitle_issue'])."</issue>";
			if(!empty($detail['jtitle_year']) && !empty($detail['jtitle_month'])){
				$lines[] = "<dateofissued>".xnpHtmlspecialchars($detail['jtitle_year'])."-".xnpHtmlspecialchars($detail['jtitle_month'])."</dateofissued>";
			}else if(!empty($detail['jtitle_year'])){
				$lines[] = "<dateofissued>".xnpHtmlspecialchars($detail['jtitle_year'])."</dateofissued>";
			}
			if(!empty($detail['jtitle_spage']))
				$lines[] = "<spage>".xnpHtmlspecialchars($detail['jtitle_spage'])."</spage>";
			if(!empty($detail['jtitle_epage']))
				$lines[] = "<epage>".xnpHtmlspecialchars($detail['jtitle_epage'])."</epage>";
			//creator
			$detail_child_author = xnparticleGetDetailChildAuthorInformation( $item_id );
			$num_author = count($detail_child_author);
			if ($num_author > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $detail_child_author ) ){
					if(!empty($author_name)) $lines[] = "<creator>".xnpHtmlspecialchars($author_name)."</creator>";
					if(!empty($author_kana)) $lines[] = "<creator>".xnpHtmlspecialchars($author_kana)."</creator>";
					if(!empty($author_romaji)) $lines[] = "<creator>".xnpHtmlspecialchars($author_romaji)."</creator>";
					if(!empty($author_affilication)) $lines[] = "<contributor>".xnpHtmlspecialchars($author_affiliation)."</contributor>";
					if(!empty($author_affiliation_translation)) $lines[] = "<contributor>".xnpHtmlspecialchars($author_affiliation_translation)."</contributor>";
					if(!empty($author_role)) $lines[] = "<description>".xnpHtmlspecialchars($author_role)."</description>";
					if(!empty($author_link)) $lines[] = "<relation>".xnpHtmlspecialchars($author_link)."</relation>";
				}
			}
			//subject
			$detail_child_keywords = xnparticleGetDetailChildKeywordsInformation( $item_id );
			$num_keywords = count($detail_child_keywords);
			if ($num_keywords > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_keywords_id, $article_id, $keywords, $keywords_order ) ) = each( $detail_child_keywords) ){
					if(!empty($keywords)) $lines[] = "<subject>".xnpHtmlspecialchars($keywords)."</subject>";
				}
			}
			//format
			$detail_child_physical_descriptions = xnparticleGetDetailChildPhysicalDescriptionsInformation( $item_id );
			$num_physical_descriptions = count($detail_child_physical_descriptions);
			if ($num_physical_descriptions > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_physical_descriptions_id, $article_id, $physical_descriptions, $physical_descriptions_order ) ) = each( $detail_child_physical_descriptions) ){
					if(!empty($physical_descriptions)) $lines[] = "<format>".xnpHtmlspecialchars($physical_descriptions)."</format>";
				}
			}
			//NDC
			$detail_child_ndc_classifications = xnparticleGetDetailChildNdcClassificationsInformation( $item_id );
			$num_ndc_classifications = count($detail_child_ndc_classifications);
			if ($num_ndc_classifications > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_ndc_classifications_id, $article_id, $ndc_classifications, $ndc_classifications_order ) ) = each( $detail_child_ndc_classifications) ){
					if(!empty($ndc_classifications)) $lines[] = "<NDC>".xnpHtmlspecialchars($ndc_classifications)."</NDC>";
				}
			}
			//publisher
			if(!empty($detail['publisher']))
				$lines[] = "<publisher>".xnpHtmlspecialchars($detail['publisher'])."</publisher>";
			if(!empty($detail['publisher_kana']))
				$lines[] = "<publisher>".xnpHtmlspecialchars($detail['publisher_kana'])."</publisher>";
			if(!empty($detail['publisher_romaji']))
				$lines[] = "<publisher>".xnpHtmlspecialchars($detail['publisher_romaji'])."</publisher>";
			//lang
			$detail_child_langs = xnparticleGetDetailChildLangsInformation( $item_id );
			$num_langs = count($detail_child_langs);
			if ($num_langs > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_langs_id, $article_id, $langs, $langs_order ) ) = each( $detail_child_langs) ){
					if(!empty($langs)) $lines[] = "<language>".xnpHtmlspecialchars($langs)."</language>";
				}
			}
			//type
			if(!empty($detail['type_of_resource']))
				$lines[] = "<type>".xnpHtmlspecialchars($detail['type_of_resource'])."</type>";
			//NIIType
			if(!empty($detail['genre']))
				$lines[] = "<NIItype>".xnpHtmlspecialchars($detail['genre'])."</NIItype>";
			//date
			if(!empty($detail['year_f']) && !empty($detail['year_t'])){
				$lines[] = "<date>".xnpHtmlspecialchars($detail['year_f'])."-".xnpHtmlspecialchars($detail['year_t'])."</date>";
			}else if(!empty($detail['year_f'])){
				$lines[] = "<date>".xnpHtmlspecialchars($detail['year_f'])."</date>";
			}else if(!empty($detail['year_t'])){
				$lines[] = "<date>".xnpHtmlspecialchars($detail['year_t'])."</date>";
			}
			if(!empty($detail['date_create']))
				$lines[] = "<date>".xnpHtmlspecialchars($detail['date_create'])."</date>";
			if(!empty($detail['date_update']))
				$lines[] = "<date>".xnpHtmlspecialchars($detail['date_update'])."</date>";
			if(!empty($detail['date_record']))
				$lines[] = "<date>".xnpHtmlspecialchars($detail['date_record'])."</date>";
			//rights
			if(!empty($detail['access_condtion']))
				$lines[] = "<rights>".xnpHtmlspecialchars($detail['access_condition'])."</rights>";
			//description
			if(!empty($detail['edition']))
				$lines[] = "<description>".xnpHtmlspecialchars($detail['edition'])."</description>";
			if(!empty($detail['publish_place']))
				$lines[] = "<description>".xnpHtmlspecialchars($detail['publish_place'])."</description>";
			if(!empty($basic['description']))
				$lines[] = "<description>".xnpHtmlspecialchars($basic['description'])."</description>";
			if(!empty($detail['table_of_contents']))
				$lines[] = "<description>".xnpHtmlspecialchars($detail['table_of_contents'])."</description>";
			if(!empty($detail['abstract']))
				$lines[] = "<description>".xnpHtmlspecialchars($detail['abstract'])."</description>";
			//identifier
                        if($basic['doi'] == "" ) $identifier = XOOPS_URL . "/modules/xoonips/detail.php?item_id=".xnpHtmlspecialchars($item_id);
                        else $identifier =  XOOPS_URL . "/modules/xoonips/detail.php?" . XNP_CONFIG_DOI_FIELD_PARAM_NAME . "=" . xnpHtmlspecialchars($basic['doi']);
                        $lines[] = "<URI>" . $identifier . "</URI>";
			$detail_child_id_isbns = xnparticleGetDetailChildIdIsbnsInformation( $item_id );
			//isbn
			$num_id_isbns = count($detail_child_id_isbns);
			if ($num_id_isbns > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_isbns_id, $article_id, $id_isbns, $id_isbns_order ) ) = each( $detail_child_id_isbns) ){
					if(!empty($id_isbns)) $lines[] = "<isbn>".xnpHtmlspecialchars($id_isbns)."</isbn>";
				}
			}
			//issn
			$detail_child_id_issns = xnparticleGetDetailChildIdIssnsInformation( $item_id );
			$num_id_issns = count($detail_child_id_issns);
			if ($num_id_issns > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_issns_id, $article_id, $id_issns, $id_issns_order ) ) = each( $detail_child_id_issns) ){
					if(!empty($id_issns)) $lines[] = "<issn>".xnpHtmlspecialchars($id_issns)."</issn>";
				}
			}
			//doi
			$detail_child_id_dois = xnparticleGetDetailChildIdDoisInformation( $item_id );
			$num_id_dois = count($detail_child_id_dois);
			if ($num_id_dois > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_dois_id, $article_id, $id_dois, $id_dois_order ) ) = each( $detail_child_id_dois) ){
					if(!empty($id_dois)) $lines[] = "<doi>".xnpHtmlspecialchars($id_dois)."</doi>";
				}
			}
			//identifier
			$detail_child_id_uris = xnparticleGetDetailChildIdUrisInformation( $item_id );
			$num_id_uris = count($detail_child_id_uris);
			if ($num_id_uris > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_uris_id, $article_id, $id_uris, $id_uris_order ) ) = each( $detail_child_id_uris) ){
					if(!empty($id_uris)) $lines[] = "<identifier>".xnpHtmlspecialchars($id_uris)."</identifier>";
				}
			}
			$detail_child_id_locals = xnparticleGetDetailChildIdLocalsInformation( $item_id );
			$num_id_locals = count($detail_child_id_locals);
			if ($num_id_locals > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_locals_id, $article_id, $id_locals, $id_locals_order ) ) = each( $detail_child_id_locals) ){
					if(!empty($id_locals)) $lines[] = "<identifier>".xnpHtmlspecialchars($id_locals)."</identifier>";
				}
			}
			$lines[] = "</meta>";
			$lines[] = "</metadata>";

		//OAI_DCの場合
        	} else if ( $metadataPrefix == 'oai_dc' ) {
			$lines = array();
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			//$lines[] = $meta_basic;
			//dc:title
			if(!empty($detail['title']))
				$lines[] = "<dc:title>".xnpHtmlspecialchars($detail['title'])."</dc:title>";
			if(!empty($detail['title_kana']))
				$lines[] = "<dc:title>".xnpHtmlspecialchars($detail['title_kana'])."</dc:title>";
			if(!empty($detail['title_romaji']))
				$lines[] = "<dc:title>".xnpHtmlspecialchars($detail['title_romaji'])."</dc:title>";
			$detail_child_sub_title = xnparticleGetDetailChildSubTitleInformation( $item_id );
			$num_sub_title = count($detail_child_sub_title);
			if ($num_sub_title > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_sub_title_id, $article_id, $sub_title_name, $sub_title_kana, $sub_title_romaji, $sub_title_order ) ) = each( $detail_child_sub_title ) ){
					if(!empty($sub_title_name)) $lines[] = "<dc:title>".xnpHtmlspecialchars($sub_title_name)."</dc:title>";
					if(!empty($sub_title_kana)) $lines[] = "<dc:title>".xnpHtmlspecialchars($sub_title_kana)."</dc:title>";
					if(!empty($sub_title_romaji)) $lines[] = "<dc:title>".xnpHtmlspecialchars($sub_title_romaji)."</dc:title>";
				}
			}
			//dc:identifier
			if(!empty($detail['jtitle']) && !empty($detail['jtitle_spage'])){
				$lines[] = "<dc:identifier>".xnpHtmlspecialchars($detail['jtitle'])." ".xnpHtmlspecialchars($detail['jtitle_translation'])." ".xnpHtmlspecialchars($detail['jtitle_volume'])." (".xnpHtmlspecialchars($detail['jtitle_issue'])."), ".xnpHtmlspecialchars($detail['jtitle_spage'])."-".xnpHtmlspecialchars($detail['jtitle_epage']).". (".xnpHtmlspecialchars($detail['jtitle_year'])."".xnpHtmlspecialchars($detail['jtitle_month']).")</dc:identifier>";
			}else if(!empty($detail['jtitle'])){
				$lines[] = "<dc:identifier>".xnpHtmlspecialchars($detail['jtitle'])." ".xnpHtmlspecialchars($detail['jtitle_translation'])." ".xnpHtmlspecialchars($detail['jtitle_volume'])." (".xnpHtmlspecialchars($detail['jtitle_issue'])."), (".xnpHtmlspecialchars($detail['jtitle_year'])."".xnpHtmlspecialchars($detail['jtitle_month']).")</dc:identifier>";
			}
			//dc:creator
			$detail_child_author = xnparticleGetDetailChildAuthorInformation( $item_id );
			$num_author = count($detail_child_author);
			if ($num_author > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_author_id, $article_id, $author_id, $author_name, $author_kana, $author_romaji, $author_affiliation, $author_affiliation_translation, $author_role, $author_link, $author_order ) ) = each( $detail_child_author ) ){
					if(!empty($author_name)) $lines[] = "<dc:creator>".xnpHtmlspecialchars($author_name)."</dc:creator>";
					if(!empty($author_kana)) $lines[] = "<dc:creator>".xnpHtmlspecialchars($author_kana)."</dc:creator>";
					if(!empty($author_romaji)) $lines[] = "<dc:creator>".xnpHtmlspecialchars($author_romaji)."</dc:creator>";
					if(!empty($author_affilication)) $lines[] = "<dc:contributor>".xnpHtmlspecialchars($author_affiliation)."</dc:contributor>";
					if(!empty($author_affiliation_translation)) $lines[] = "<dc:contributor>".xnpHtmlspecialchars($author_affiliation_translation)."</dc:contributor>";
					if(!empty($author_role)) $lines[] = "<dc:description>".xnpHtmlspecialchars($author_role)."</dc:description>";
					if(!empty($author_link)) $lines[] = "<dc:relation>".xnpHtmlspecialchars($author_link)."</dc:relation>";
				}
			}
			//dc:subject
			$detail_child_keywords = xnparticleGetDetailChildKeywordsInformation( $item_id );
			$num_keywords = count($detail_child_keywords);
			if ($num_keywords > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_keywords_id, $article_id, $keywords, $keywords_order ) ) = each( $detail_child_keywords) ){
					if(!empty($keywords)) $lines[] = "<dc:subject>".xnpHtmlspecialchars($keywords)."</dc:subject>";
				}
			}
			$detail_child_ndc_classifications = xnparticleGetDetailChildNdcClassificationsInformation( $item_id );
			$num_ndc_classifications = count($detail_child_ndc_classifications);
			if ($num_ndc_classifications > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_ndc_classifications_id, $article_id, $ndc_classifications, $ndc_classifications_order ) ) = each( $detail_child_ndc_classifications) ){
					if(!empty($ndc_classifications)) $lines[] = "<dc:subject>".xnpHtmlspecialchars($ndc_classifications)."</dc:subject>";
				}
			}
			//dc:publisher
			if(!empty($detail['publisher']))
				$lines[] = "<dc:publisher>".xnpHtmlspecialchars($detail['publisher'])."</dc:publisher>";
			if(!empty($detail['publisher_kana']))
				$lines[] = "<dc:publisher>".xnpHtmlspecialchars($detail['publisher_kana'])."</dc:publisher>";
			if(!empty($detail['publisher_romaji']))
				$lines[] = "<dc:publisher>".xnpHtmlspecialchars($detail['publisher_romaji'])."</dc:publisher>";
			//dc:lang
			$detail_child_langs = xnparticleGetDetailChildLangsInformation( $item_id );
			$num_langs = count($detail_child_langs);
			if ($num_langs > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_langs_id, $article_id, $langs, $langs_order ) ) = each( $detail_child_langs) ){
					if(!empty($langs)) $lines[] = "<dc:language>".xnpHtmlspecialchars($langs)."</dc:language>";
				}
			}
			//dc:type
			if(!empty($detail['type_of_resource']))
				$lines[] = "<dc:type>".xnpHtmlspecialchars($detail['type_of_resource'])."</dc:type>";
			if(!empty($detail['genre']))
				$lines[] = "<dc:type>".xnpHtmlspecialchars($detail['genre'])."</dc:type>";
			//dc:date
			if(!empty($detail['year_f']) && !empty($detail['year_t'])){
				$lines[] = "<dc:date>".xnpHtmlspecialchars($detail['year_f'])."-".xnpHtmlspecialchars($detail['year_t'])."</dc:date>";
			}else if(!empty($detail['year_f'])){
				$lines[] = "<dc:date>".xnpHtmlspecialchars($detail['year_f'])."</dc:date>";
			}else if(!empty($detail['year_t'])){
				$lines[] = "<dc:date>".xnpHtmlspecialchars($detail['year_t'])."</dc:date>";
			}
			if(!empty($detail['date_create']))
				$lines[] = "<dc:date>".xnpHtmlspecialchars($detail['date_create'])."</dc:date>";
			if(!empty($detail['date_update']))
				$lines[] = "<dc:date>".xnpHtmlspecialchars($detail['date_update'])."</dc:date>";
			if(!empty($detail['date_record']))
				$lines[] = "<dc:date>".xnpHtmlspecialchars($detail['date_record'])."</dc:date>";
			//dc:description
			if(!empty($detail['edition']))
				$lines[] = "<dc:description>".xnpHtmlspecialchars($detail['edition'])."</dc:description>";
			if(!empty($detail['publish_place']))
				$lines[] = "<dc:description>".xnpHtmlspecialchars($detail['publish_place'])."</dc:description>";
			if(!empty($basic['description']))
				$lines[] = "<dc:description>".xnpHtmlspecialchars($basic['description'])."</dc:description>";
			if(!empty($detail['table_of_contents']))
				$lines[] = "<dc:description>".xnpHtmlspecialchars($detail['table_of_contents'])."</dc:description>";
			if(!empty($detail['abstract']))
				$lines[] = "<dc:description>".xnpHtmlspecialchars($detail['abstract'])."</dc:description>";
			//dc:identifier
                        if($basic['doi'] == "" ) $identifier = XOOPS_URL . "/modules/xoonips/detail.php?item_id=".xnpHtmlspecialchars($item_id);
                        else $identifier = XOOPS_URL . "/modules/xoonips/detail.php?" . XNP_CONFIG_DOI_FIELD_PARAM_NAME . "=" . xnpHtmlspecialchars($basic['doi']);
                        $lines[] = "<dc:identifier>" . $identifier . "</dc:identifier>";
			$detail_child_id_isbns = xnparticleGetDetailChildIdIsbnsInformation( $item_id );
			$num_id_isbns = count($detail_child_id_isbns);
			if ($num_id_isbns > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_isbns_id, $article_id, $id_isbns, $id_isbns_order ) ) = each( $detail_child_id_isbns) ){
					if(!empty($id_isbns)) $lines[] = "<dc:identifier>".xnpHtmlspecialchars($id_isbns)."</dc:identifier>";
				}
			}
			$detail_child_id_issns = xnparticleGetDetailChildIdIssnsInformation( $item_id );
			$num_id_issns = count($detail_child_id_issns);
			if ($num_id_issns > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_issns_id, $article_id, $id_issns, $id_issns_order ) ) = each( $detail_child_id_issns) ){
					if(!empty($id_issns)) $lines[] = "<dc:identifier>".xnpHtmlspecialchars($id_issns)."</dc:identifier>";
				}
			}
			$detail_child_id_dois = xnparticleGetDetailChildIdDoisInformation( $item_id );
			$num_id_dois = count($detail_child_id_dois);
			if ($num_id_dois > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_dois_id, $article_id, $id_dois, $id_dois_order ) ) = each( $detail_child_id_dois) ){
					if(!empty($id_dois)) $lines[] = "<dc:identifier>".xnpHtmlspecialchars($id_dois)."</dc:identifier>";
				}
			}
			$detail_child_id_uris = xnparticleGetDetailChildIdUrisInformation( $item_id );
			$num_id_uris = count($detail_child_id_uris);
			if ($num_id_uris > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_uris_id, $article_id, $id_uris, $id_uris_order ) ) = each( $detail_child_id_uris) ){
					if(!empty($id_uris)) $lines[] = "<dc:identifier>".xnpHtmlspecialchars($id_uris)."</dc:identifier>";
				}
			}
			$detail_child_id_locals = xnparticleGetDetailChildIdLocalsInformation( $item_id );
			$num_id_locals = count($detail_child_id_locals);
			if ($num_id_locals > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_id_locals_id, $article_id, $id_locals, $id_locals_order ) ) = each( $detail_child_id_locals) ){
					if(!empty($id_locals)) $lines[] = "<dc:identifier>".xnpHtmlspecialchars($id_locals)."</dc:identifier>";
				}
			}
			//dc:format
			$detail_child_physical_descriptions = xnparticleGetDetailChildPhysicalDescriptionsInformation( $item_id );
			$num_physical_descriptions = count($detail_child_physical_descriptions);
			if ($num_physical_descriptions > 0) {
		        	$myts =& MyTextSanitizer::getInstance( );
				while ( list( $key, list( $article_child_physical_descriptions_id, $article_id, $physical_descriptions, $physical_descriptions_order ) ) = each( $detail_child_physical_descriptions) ){
					if(!empty($physical_descriptions)) $lines[] = "<dc:format>".xnpHtmlspecialchars($physical_descriptions)."</dc:format>";
				}
			}
			//dc:rights
			if(!empty($detail['access_condtion']))
				$lines[] = "<dc:rights>".xnpHtmlspecialchars($detail['access_condition'])."</dc:rights>";
			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines );
    }
    return false;
}

function xnparticleCreateXooNIpsImportItem(){
    return new XooNIpsArticle();
}

?>
