/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Random;
import org.tanukisoftware.wrapper.WrapperJNIError;
import org.tanukisoftware.wrapper.WrapperLicenseError;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.WrapperProcessConfig;

public class RuntimeExec {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Random rand = new Random();
        System.out.println("Is DYNAMIC supported? A:" + WrapperProcessConfig.isSupported((int)4));
        System.out.println("Is FORK_EXEC supported? A:" + WrapperProcessConfig.isSupported((int)2));
        System.out.println("Is VFORK_EXEC supported? A:" + WrapperProcessConfig.isSupported((int)3));
        System.out.println("Is POSIX_SPAWN supported? A:" + WrapperProcessConfig.isSupported((int)1));
        block50: for (int i = 1; i < 8; ++i) {
            switch (i) {
                case 1: {
                    WrapperProcess proc;
                    System.out.println(i + " start a small child, dont care about output but call waitfor...");
                    try {
                        proc = WrapperManager.exec((String)"../test/simplewaiter 65 1");
                        proc.getOutputStream().close();
                        System.out.println(i + " small child " + proc.getPID() + " is alive " + proc.isAlive());
                        System.out.println(i + " process (PID= " + proc.getPID() + ") finished with code " + proc.waitFor());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 2: {
                    WrapperProcess proc;
                    System.out.println(i + " start longrunning child dont wait...");
                    try {
                        System.out.println(i + " first, try to vfork...");
                        if (WrapperProcessConfig.isSupported((int)3)) {
                            System.out.println(i + " vfork is supported");
                            proc = WrapperManager.exec((String)("../test/simplewaiter " + (rand.nextInt(200) + 1) + " " + rand.nextInt(30)), (WrapperProcessConfig)new WrapperProcessConfig().setStartType(3));
                        } else {
                            System.out.println(i + " vfork is not supported");
                            proc = WrapperManager.exec((String)("../test/simplewaiter " + (rand.nextInt(200) + 1) + " " + rand.nextInt(30)));
                        }
                        System.out.println(i + " long prc " + proc.getPID() + " is alive " + proc.isAlive());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 3: {
                    Object p;
                    try {
                        System.out.println(i + " spawn a small command...");
                        if (WrapperProcessConfig.isSupported((int)1)) {
                            System.out.println(i + " spawn is supported.");
                            p = WrapperManager.exec((String)"../test/simplewaiter 0 15", (WrapperProcessConfig)new WrapperProcessConfig().setStartType(1));
                        } else {
                            System.out.println(i + " spawn is not supported.");
                            p = WrapperManager.exec((String)"../test/simplewaiter 0 15");
                        }
                        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        try {
                            String line = "";
                            while ((line = br.readLine()) != null) {
                                System.out.println(i + " out..:" + line);
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 4: {
                    WrapperProcessConfig wpm;
                    System.out.println(i + " start a small child, change the environment and read output...");
                    try {
                        String line;
                        wpm = new WrapperProcessConfig();
                        Map environment = wpm.getEnvironment();
                        System.out.println(i + " size of Environment map (before calling clear()) = " + environment.size());
                        environment.clear();
                        environment.put("TEST", "TEST123");
                        System.out.println(i + " size of Environment map = " + environment.size());
                        WrapperProcess proc = WrapperManager.exec((String)("../test/simplewaiter " + rand.nextInt(200) + " 3"), (WrapperProcessConfig)wpm);
                        proc.getOutputStream().close();
                        System.out.println(i + " small child " + proc.getPID() + " is alive " + proc.isAlive());
                        BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        try {
                            line = "";
                            while ((line = br.readLine()) != null) {
                                System.out.println(i + " out..:" + line);
                            }
                        }
                        finally {
                            br.close();
                        }
                        br = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        try {
                            line = "";
                            while ((line = br.readLine()) != null) {
                                System.out.println(line);
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 5: {
                    String line;
                    BufferedReader br;
                    WrapperProcess proc;
                    WrapperProcessConfig wpm;
                    System.out.println(i + " start longrunning child, change working dir, call waitFor and finally read output...");
                    try {
                        wpm = new WrapperProcessConfig();
                        if (WrapperProcessConfig.isSupported((int)2) || WrapperProcessConfig.isSupported((int)3)) {
                            wpm.setStartType(WrapperProcessConfig.isSupported((int)2) ? 2 : 3);
                            System.out.println(i + " changing the working directory is supported");
                            wpm.setWorkingDirectory(new File(".."));
                        } else {
                            System.out.println(i + " changing the working directory is not supported");
                        }
                        try {
                            System.out.println(i + " try to call dir");
                            proc = WrapperManager.exec((String)"cmd.exe /c dir", (WrapperProcessConfig)wpm);
                        }
                        catch (IOException e) {
                            System.out.println(i + " dir failed. most likely we are not on Windows, try ls -l before giving up.");
                            proc = WrapperManager.exec((String)"ls -l", (WrapperProcessConfig)wpm);
                        }
                        System.out.println(i + " PID = " + proc.getPID());
                        System.out.println(i + " process (PID= " + proc.getPID() + ") finished with code " + proc.waitFor());
                        System.out.println(i + " now read the output");
                        br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        try {
                            line = "";
                            while ((line = br.readLine()) != null) {
                                System.out.println(i + " out..:" + line);
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 6: {
                    String line;
                    BufferedReader br;
                    WrapperProcess proc;
                    Object p;
                    try {
                        System.out.println(i + " start a small command by Runtime.exec and put a wrapperexec in between..");
                        p = Runtime.getRuntime().exec("../test/simplewaiter " + (rand.nextInt(200) + 1) + " " + (rand.nextInt(20) + 1));
                        proc = WrapperManager.exec((String)"../test/simplewaiter 4 4");
                        proc.getOutputStream().close();
                        System.out.println(i + " small child " + proc.getPID() + " is alive " + proc.isAlive());
                        br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        try {
                            line = "";
                            while ((line = br.readLine()) != null) {
                                System.out.println(i + " out..:" + line);
                            }
                        }
                        finally {
                            br.close();
                        }
                        System.out.println(i + " " + p.toString() + " Runtime.exec exit " + ((Process)p).waitFor());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue block50;
                }
                case 7: {
                    WrapperProcess proc;
                    System.out.println(i + " start invalid child...");
                    try {
                        proc = WrapperManager.exec((String)"invalid");
                        System.out.println(i + " invalid childz is alive " + proc.isAlive());
                        continue block50;
                    }
                    catch (IOException e) {
                        System.out.println(i + " caught an invalid child...");
                    }
                }
            }
        }
        try {
            System.out.println("finally start a long-running application attached to the wrapper, the wrapper will shut down soon, so the app should get killed by the wrapper...");
            WrapperProcess p = WrapperManager.exec((String)"../test/simplewaiter 2 1000", (WrapperProcessConfig)new WrapperProcessConfig().setDetached(true));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WrapperJNIError e) {
            e.printStackTrace();
        }
        catch (WrapperLicenseError e) {
            e.printStackTrace();
        }
        System.out.println("All Done.");
    }
}

