<?php
/*
Plugin Name: Change Post Status
Version: 0.1.0
Plugin URI: http://wppluginsj.sourceforge.jp/chg-post-status/
Description: エントリのコメントとトラックバック/ピンバックの許可を一括変更します。
Author: wokamoto
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2008 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

class ChgPostStatusController {
  var $plugin_dir, $plugin_file, $plugin_url;
//  var $textdomain_name;
  var $admin_option, $admin_action;
  var $note, $error;

  /*
  * Constructor
  */
  function QuickCommentsController() {
    $this->setPluginDir();
//    $this->loadTextdomain();

    $this->note = '';
    $this->error = 0;

    $this->admin_option    = $this->plugin_file;
    $this->admin_action    = trailingslashit(get_bloginfo('wpurl'))."wp-admin/admin.php?page=".$this->admin_option;
  }

  function setPluginDir() {
    $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
    $filename = explode("/", __FILE__);
    if(count($filename) <= 1) $filename = explode("\\", __FILE__);
    $this->plugin_dir  = $filename[count($filename) - 2];
    $this->plugin_file = $filename[count($filename) - 1];
    $this->plugin_url  = trailingslashit(trailingslashit(defined('WP_PLUGIN_URL') ? WP_PLUGIN_URL : trailingslashit(get_bloginfo('wpurl')).$plugins_dir).$this->plugin_dir);
    unset($filename);
  }

  function loadTextdomain( $sub_dir = '/language' ) {
    global $wp_version;
    $this->textdomain_name = $this->plugin_dir;
    $textdomain_dir = trailingslashit(trailingslashit($this->plugin_dir).$sub_dir);
    if (version_compare($wp_version, "2.6", ">=") && defined('WP_PLUGIN_DIR')) {
      load_plugin_textdomain($this->textdomain_name, false, $textdomain_dir);
    } else {
      $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
      load_plugin_textdomain($this->textdomain_name, $plugins_dir.$textdomain_dir);
    }
  }

  // Handles Add/strips slashes to the given array
  function stripArray($array) {
    if(is_array($array)) {
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  // Make Nonce field
  function makeNonceField($action = -1, $name = "_wpnonce", $referer = true , $echo = true ) {
    if ( !function_exists('wp_nonce_field') ) {
      return;
    } else {
      return wp_nonce_field($action, $name, $referer, $echo);
    }
  }

  // Add Admin Menu
  function addAdminMenu() {
    add_submenu_page('edit.php'
                     ,__('Comments &amp; Pings')
                     ,__('Comments &amp; Pings')
                     ,9
                     ,$this->admin_option
                     ,array($this,'optionPage')
                    );
  }

  // Show Option Page
  function optionPage() {
    global $wp_version, $wpdb, $comment, $post;

    // check referer (Wordpress 2.5+)
    $check_referer = version_compare($wp_version, "2.5", ">=");

    if (isset($_POST['update'])) {
      if ($check_referer) check_admin_referer("update_options", "_wpnonce_update_options");

      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $comment_status = (isset($_POST['comment_status']) && $_POST['comment_status'] == 'open' ? 'open' : 'closed');
      $ping_status    = (isset($_POST['ping_status']) && $_POST['ping_status'] == 'open' ? 'open' : 'closed');
      $post_date      = (isset($_POST['post_date']) && preg_match('/^\d{4}\-[01][0-9]\-[0-3][0-9]$/', $_POST['post_date']) ? $_POST['post_date'] : '1900-01-01').' 23:59:59';
      $_POST = '';

      // Post Status update
      $num_rows = $wpdb->query($wpdb->prepare(
          "UPDATE $wpdb->posts"
         ." SET comment_status = %s"
         ."   , ping_status = %s"
         ." WHERE (comment_status = %s OR ping_status = %s)"
         ." AND post_date <= cast(%s as date)"
        , $comment_status
        , $ping_status
        , $comment_status == 'open' ? 'closed' : 'open'
        , $ping_status == 'open' ? 'closed' : 'open'
        , $post_date)
      );

      // Done!
      $this->note .= '<strong>'.__('Post updated.')."({$num_rows})</strong>";
    }

    $out  = '';

    $out .= "<div class=\"wrap\">\n";
    $out .= "<h2>".__('Comments &amp; Pings')."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";
    if ($check_referer) $out .= $this->makeNonceField("update_options", "_wpnonce_update_options", true, false);

    $out .= "<table class=\"optiontable form-table\" style=\"margin-top:0;\">\n";

    $out .= "<tbody><tr><td>\n";

    // Allow Comments
    $out .= '<label for="comment_status" class="selectit">';
    $out .= '<input name="comment_status" id="comment_status" value="open" checked="checked" type="checkbox" />&nbsp;';
    $out .= __('Allow Comments');
    $out .= '</label><br />';
    $out .= "\n";

    // Allow Pings
    $out .= '<label for="ping_status" class="selectit">';
    $out .= '<input name="ping_status" id="ping_status" value="open" checked="checked" type="checkbox" />&nbsp;';
    $out .= __('Allow Pings');
    $out .= '</label><br />';
    $out .= "\n";

    // Post Date
    $out .= '<strong>';
    $out .= preg_replace('/^([^:]*:).*$/', '$1', __('Published on:<br />%1$s at %2$s'));
    $out .= '</strong>&nbsp;';
    $out .= '<input type="text" name="post_date" id="post_date" size="10" value="'.date('Y-m-d').'" />';
    $out .= '&nbsp;以前のエントリを一括変更';
    $out .= "\n";

    $out .= "\n</td></tr></tbody>\n";

    $out .= "</table>\n";

    // Add Update Button
    $out .= '<p style="margin-top:1em"><input type="submit" name="update" value="'.__('Update').' &raquo;" class="button" /></p>';
    $out .= "</form></div>\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = "<div id=\"message\" class=\"updated fade\"><p>".$this->note."</p></div>\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

}//class

if(!function_exists('get_option')) {
  $path = (defined('ABSPATH') ? ABSPATH : dirname(dirname(dirname(dirname(__FILE__)))) . '/');
  require_once(file_exists($path.'wp-load.php') ? $path.'wp-load.php' : $path.'wp-config.php');
}

$ChgPostStatus = new ChgPostStatusController();
add_action('admin_menu', array(&$ChgPostStatus,'addAdminMenu'));
unset($ChgPostStatus);
?>