<?php

/* ==================================================
 *   Ktai_Entry_Post class
   ================================================== */

// ----- Settings -------------------------
define('KE_SET_CATEGORY',        'CAT:');
define('KE_ADD_CATEGORY',        'CAT+');
define('KE_CHANGE_CATEGORY',     'CAT>');
define('KE_ADD_CHANGE_CATEGORY', 'CAT+>');
define('KE_SET_TAGS',            'TAG:');
define('KE_ROTATE_IMAGE',        'ROT:');
define('KE_DELIM_STR',           '-- ');

define('KE_IMAGES_HEADER', '<div class="photo">');
define('KE_IMAGES_FOOTER', "</div>\n");
define('KE_TEXT_HEADER', '<p>');
define('KE_TEXT_FOOTER', "</p>\n<div class=\"photo-end\"> </div>");

define('KE_IMAGE_PERM', 0666);

/* ----- Put this style into your style.css -----
.photo {
	padding-right:6px;
	float:left;
	line-height:110%;
	font-size:0.85em;
	text-indent:0;
}
.photo img {
	background:white;
	margin:0 4px 4px 0;
	padding:3px;
	border:1px solid #999;
}
.photo-end {
	clear:left;
}
---------- */
// ----- End of settings

/* ==================================================
 *   Ktai_Entry_Post class
   ================================================== */

class Ktai_Entry_Post extends Ktai_Entry {
	public $type;

/* ==================================================
 * @param	string   $type
 * @return	object   $this
 */
public function __construct ($type = 'pop3') {
	$this->type = $type;
	
	$level = error_reporting(E_ALL ^ E_WARNING ^ E_NOTICE);
	require_once ABSPATH . 'wp-admin/admin-functions.php';
	if (! include_once 'Mail/mimeDecode.php') { // try to use PEAR in the server.
		require_once dirname(__FILE__) . '/Mail_mimeDecode.php'; // use local version
	}
	error_reporting($level);

	// ----- Remove filters of Change Max Thumbnail Length (http://www.yuriko.net/arc/2008/03/27d)
	if (defined('MY_THUMBNAIL_MAX_SIDE_LENGTH')) {
		remove_filter('wp_thumbnail_max_side_length', array('Change_Thumb_Max_Length', 'decide_length'));
		remove_filter('wp_thumbnail_max_side_length', 'change_thumb_max_length', 10, 3);
	}
	add_filter('wp_thumbnail_max_side_length', create_function('$size,$id,$file', 'return ' . intval($this->get_option('ke_thumb_size')) . ';'), 11, 3);
	add_filter('wp_create_thumbnail', create_function('$path', 'chmod($path, KE_IMAGE_PERM); return $path;'), 11);
	
	global $allowedposttags, $allowedtags;
	if (! defined('CUSTOM_TAGS')) {
		define('CUSTOM_TAGS', true);
	}
	if (! CUSTOM_TAGS) {
		$allowedposttags = array (
			'address' => array (), 
			'a' => array (
				'href' => array (), 'title' => array (), 'rel' => array (), 
				'rev' => array (), 'name' => array ()
				), 
			'abbr' => array ('title' => array ()), 
			'acronym' => array ('title' => array ()),
			'b' => array (),
			'big' => array (), 
			'blockquote' => array ('cite' => array ()), 
			'br' => array ('class' => array ()), 
			'button' => array (
				'disabled' => array (), 'name' => array (), 'type' => array (), 
				'value' => array ()
				), 
			'caption' => array ('align' => array ()), 
			'code' => array (), 
			'col' => array (
				'align' => array (), 'char' => array (), 'charoff' => array (), 
				'span' => array (), 'valign' => array (), 'width' => array ()
				), 
			'del' => array ('datetime' => array ()), 
			'dd' => array (), 
			'div' => array (
				'align' => array (), 'class' => array()
				), 
			'dl' => array (), 
			'dt' => array (), 
			'em' => array (), 
			'fieldset' => array (), 
			'font' => array (
				'color' => array (), 'size' => array ()
				), 
			'form' => array (
				'action' => array ('type' => 'uri'), 'accept' => array (), 
				'accept-charset' => array (), 'enctype' => array (), 
				'method' => array (), 'name' => array (), 'target' => array ()
				), 
			'h1' => array ('align' => array ()), 
			'h2' => array ('align' => array ()), 
			'h3' => array ('align' => array ()), 
			'h4' => array ('align' => array ()), 
			'h5' => array ('align' => array ()), 
			'h6' => array ('align' => array ()), 
			'hr' => array (
				'align' => array (),  'color' => array(), 'noshade' => array (), 
				'size' => array (), 'width' => array ()
				), 
			'i' => array (), 
			'img' => array (
				'alt' => array (), 'align' => array (), 'border' => array (), 
				'class' => array(), 'copyright' => array(), 'height' => array (), 
				'hspace' => array (), 'localsrc' => array (), 
				'longdesc' => array (), 'vspace' => array (), 
				'src' => array ('type' => 'uri'), 'title' => array(), 
				'vspace' => array(), 'width' => array ()
				), 
			'input' => array(
				'accesskey' => array(), 'checked' => array(), 'emptyok' => array(),
				'format' => array(), 'istyle' => array(), 'localsrc' => array(),
				'maxlength' => array(), 'mode' => array(), 'name' => array(), 
				'size' => array(), 'type' => array(), 'value' => array(),
				),
			'ins' => array (
				'datetime' => array(), 'cite' => array('type' => 'uri')
				),
			'kbd' => array (), 
			'label' => array ('for' => array ()), 
			'legend' => array ('align' => array ()), 
			'li' => array (), 
			'ol' => array(
				'start' => array(), 'type' => array()
				),
			'option' => array(
				'value' => array(), 'selected' => array()
				),
			'p' => array (
				'align' => array (), 'class' => array()
				), 
			'param' => array(
				'name' => array(), 'value' => array(), 'valuetype' => array()
				),
			'pre' => array ('width' => array ()), 
			'q' => array('cite' => array('type' => 'uri')),
			's' => array (), 
			'select' => array(
				'name' => array(), 'size' => array(), 'multiple' => array()
				),
			'strike' => array (), 
			'strong' => array (), 
			'sub' => array (), 
			'sup' => array (), 
			'table' => array (
				'align' => array (), 'bgcolor' => array (), 'border' => array (), 
				'cellpadding' => array (), 'cellspacing' => array (), 
				'rules' => array (), 'summary' => array (), 'width' => array ()
				), 
			'tbody' => array (
				'align' => array (), 'char' => array (), 'charoff' => array (), 
				'valign' => array ()), 
			'td' => array (
				'abbr' => array (), 'align' => array (), 'axis' => array (), 
				'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 
				'colspan' => array (), 'headers' => array (), 'height' => array (), 
				'nowrap' => array (), 'rowspan' => array (), 'scope' => array (), 
				'valign' => array (), 'width' => array ()
				), 
			'textarea' => array (
				'cols' => array (), 'rows' => array (), 'disabled' => array (), 
				'name' => array (), 'readonly' => array ()
				), 
			'tfoot' => array (
				'align' => array (), 'char' => array (), 'charoff' => array (), 
				'valign' => array ()
				), 
			'th' => array (
				'abbr' => array (), 'align' => array (), 'axis' => array (), 
				'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 
				'colspan' => array (), 'headers' => array (), 'height' => array (), 
				'nowrap' => array (), 'rowspan' => array (), 'scope' => array (), 
				'valign' => array (), 'width' => array ()
				), 
			'thead' => array (
				'align' => array (), 'char' => array (), 'charoff' => array (), 
				'valign' => array ()
				), 
			'title' => array (), 
			'tr' => array (
				'align' => array (), 'bgcolor' => array (), 'char' => array (), 
				'charoff' => array (), 'valign' => array ()
				), 
			'tt' => array (), 
			'u' => array (), 
			'ul' => array (), 
			'var' => array () 
		);

		$allowedtags = array (
			'a' => array ('href' => array (), 'title' => array ()),
			'abbr' => array ('title' => array ()),
			'acronym' => array ('title' => array ()),
			'b' => array (),
			'blockquote' => array ('cite' => array ()),
			//	'br' => array(),
			'code' => array (),
			//	'del' => array('datetime' => array()),
			'div' => array ('align' => array (), 'class' => array()), 
			//	'dd' => array(),
			//	'dl' => array(),
			//	'dt' => array(),
			'em' => array (),
			'i' => array (),
			'img' => array (
				'alt' => array (), 'align' => array (), 'border' => array (), 
				'class' => array(), 'height' => array (), 'hspace' => array (), 
				'localsrc' => array (), 'longdesc' => array (), 'vspace' => array (), 
				'src' => array (), 'title' => array (),  'width' => array ()),
			//	'ins' => array('datetime' => array(), 'cite' => array()),
			//	'li' => array(),
			//	'ol' => array(),
			'p' => array ('align' => array (), 'class' => array()), 
			//	'q' => array(),
 			'strike' => array (),
 			'strong' => array (),
			//	'sub' => array(),
			//	'sup' => array(),
			//	'u' => array(),
			//	'ul' => array(),
		);
	}
}

/* ==================================================
 * @param	string   $input
 * @return	array    $contents
 */
public function parse($input) {
	global $allowedposttags, $allowedtags;

	try {
		$structure = $this->decode_message($input);
		if (is_email($this->get_option('ke_posting_addr'))) {
			$recipients = $this->read_recipients($structure);
			if (! in_array($this->get_option('ke_posting_addr'), $recipients)) {
				throw new Ktai_Error('Invalid recipient address.');
			}
		}
		$from = $this->read_sender($structure);
		if (! $from || preg_match('/^MAILER-DAEMON@/i', $from)) {
			throw new Ktai_Error('No sender address found.');
		}
		$post_author = $this->validate_address($from);
		if (! $post_author) {
			throw new Ktai_Error("Sender address is not registered: $from");
		}
		$user = set_current_user($post_author);
		if (current_user_can('publish_posts')) {
			$post_status    = 'publish';
		} elseif (version_compare($this->get_wp_version(), 2.3, '>=')) {
			$post_status    = 'pending';
		} else {
			$post_status    = 'draft';
		}
		$time_difference = get_option('gmt_offset');
		$post_time_gmt = strtotime(trim($structure->headers['date']));
		if (! $post_time_gmt) {
			throw new Ktai_Error('There is no Date: field.');
		} elseif ($this->check_duplication($post_time_gmt)) {
			throw new Ktai_Error('The mail at "' . $structure->headers['date'] . '" was already posted.');
		}

		$contents = $this->get_mime_parts($structure);
		$this->debug_print(sprintf('Text %d bytes, Attachment %d part(s)', strlen($contents->text), count($contents->images)));
		$contents->from            = $from;
		$contents->post_time_gmt   = $post_time_gmt;
		$contents->post_time_local = $post_time_gmt + ($time_difference * 3600);
		$post_title    = xmlrpc_getposttitle($content_text);
		if (! $post_title) {
			$subject = mb_convert_encoding($structure->headers['subject'], get_option('blog_charset'), 'auto');
			$post_title = trim(str_replace(get_option('subjectprefix'), '', $subject));
		}
		$contents->post_title  = $post_title;
		$contents->post_author = $post_author;
		$contents->post_status = $post_status;
		return $contents;

	} catch (Ktai_Error $e) {
		if (! $e->getCode()) {
			$e->setCode(QMAIL_DELIVERY_FAILED_PERMANENTLY);
		}
		return $e;
	}
}

/* ==================================================
 * @param	array    $contents
 * @return	int      $status
 * based on wp-mail.php of WordPress 2.0.5
 */
public function insert($contents) {
	global $wpdb;
	try {
		$post = get_default_post_to_edit();
		$this->chop_signature($contents);
		$post_category  = $this->decide_category($contents);
		$tags_input     = $this->decide_keywords($contents);
		$rotations      = $this->decide_rotations($contents);
		$post_date      = gmdate('Y-m-d H:i:s', $contents->post_time_local);
		$post_date_gmt  = gmdate('Y-m-d H:i:s', $contents->post_time_gmt);
		$post_name      = gmdate('His', $contents->post_time_local);
		$post_title     = $contents->post_title;
		$post_author    = $contents->post_author;
		$comment_status = $post->comment_status;
		$ping_status    = $post->ping_status;
		$post_content   = apply_filters('phone_content', $contents->text);
		if (count($contents->images)) {
			$post_status  = 'draft';
		} else {
			$post_status  = $contents->post_status;
		}
		$post_data = compact('post_title', 'post_name', 'post_date', 'post_date_gmt', 'post_author', 'post_category', 'tags_input', 'post_status', 'comment_status', 'ping_status', 'post_content');
		$post_data = add_magic_quotes($post_data);
		if (defined('KE_DEBUG') && KE_DEBUG) {
			$poster_info = get_userdata($post_author);
			$log  = "From    : {$contents->from}\n";
			$log .= "Author  : {$poster_info->user_nicename} (ID: {$post_data['post_author']})\n";
			$log .= "Date    : {$post_data['post_date']}\n";
			$log .= "Date GMT: {$post_data['post_date_gmt']}\n";
			$log .= "Title   : {$post_data['post_title']}\n";
			$log .=   "+-- Content -------------------\n";			
			$log .= preg_replace('/^/m', '|', $post_data['post_content']);
			$log .= "\n+------------------------------";
			$this->debug_print($log);
		}
	
		$post_ID = wp_insert_post($post_data);
		if (! $post_ID) {
			throw new Ktai_Error("We couldn't post, for whatever reason.");
		}
		$this->debug_print(sprintf('Inserted a post with ID: %d, status: %s', $post_ID, $post_status));

		if (count($contents->images)) {
			if ($image_ids = $this->upload_images($contents, $rotations, $post_ID)) {
				$post = get_post($post_ID);
				$content = $this->images_to_html($contents->text, $image_ids);
				$content = apply_filters('phone_content', $content);
				$post_data['post_content'] = $wpdb->escape($content);
			}
			$post_data['ID'] = $post_ID;
			$post_data['post_status'] = $contents->post_status;
			wp_update_post($post_data);
			$this->debug_print(sprintf('Updated the post to status "%s" with %d image(s).',  $contents->post_status, count($image_ids)));
		}

		if ($post_data['post_status'] == 'publish') {
			do_action('publish_phone', $post_ID);
		}
		return QMAIL_DELIVERY_SUCCESSFUL;

	} catch (Ktai_Error $e) {
		if (! $e->getCode()) {
			$e->setCode(QMAIL_DELIVERY_FAILED_PERMANENTLY);
		}
		return $e;
	}
}

/* ==================================================
 * @param	string   $message
 * @return	object   $structure
 */
private function decode_message($message) {
	$params['include_bodies'] = true;
	$params['decode_bodies']  = true;
	$params['decode_headers'] = true;
	$params['input'] = $message;
	$structure = Mail_mimeDecode::decode($params);
	return $structure;
}

/* ==================================================
 * @param	string   $field
 * @return	array    $addresses
 */
private function pickup_rfc2822_address($field) {
	$addresses = array();
	$quoted    = array();
	// ----- save quoted text -----
	while (1) {
		preg_match('/(^|[^\\\\])("([^\\\\"]|\\\\.)*")/', $field, $m);
		if (! $m[2]) {
			break;
		}
		$field = preg_replace("/(^|[^\\\\])$m[2]/", "$1\376\376\376" . count($quoted) . "\376\376\376", $field, 1);
		$quoted[] = $m[2];
	}
	// ---- remove comments -----
	$field = preg_replace('/\([^)]*[^\\\\]\)/', '', $field);
	// ----- remove group name -----
	$field = preg_replace('/[-\w ]+:([^;]*);/', '$1', $field);
	// ----- split into each address -----
	foreach (explode(',', $field) as $a) {
		$a = str_replace(' ', '', $a);
		preg_match('/<([^>]*)>/', $a, $m);
		if ($m[1]) {
			$a = $m[1];
		}
		// ----- restore quoted text -----
		$a = preg_replace('/\376\376\376(\d+)\376\376\376/e', '$quoted[$1]', $a);
		// ----- got address -----
		if ($a) {
			$addresses[] = $a;
		}
	}
	return $addresses;
}

/* ==================================================
 * @param	object   $structure
 * @return	string   $sender
 */
private function read_sender($structure) {
	$senders = $this->pickup_rfc2822_address(trim($structure->headers['from']));
	$sender = $senders[0];
	if (! $sender) {
		$senders = $this->pickup_rfc2822_address($_ENV['SENDER']);
		$sender = $senders[0];
	}
	return $sender;
}

/* ==================================================
 * @param	object   $structure
 * @return	array    $recipients
 */
private function read_recipients($structure) {
	$recipients = $this->pickup_rfc2822_address(trim($structure->headers['to'])) 
	            + $this->pickup_rfc2822_address(trim($structure->headers['cc']));
	return $recipients;
}

/* ==================================================
 * @param	string   $address
 * @return	int      $user_id
 */
private function validate_address($address) {
	$user_id = 0;
	if (function_exists('get_user_by_email')) {
		$user = get_user_by_email($address);
		if ($user) {
			$user_id = $user->ID;
		}
	} else {
		global $wpdb;
		$email4sql = $wpdb->escape($address);
		$user_id = $wpdb->get_var("SELECT ID FROM {$wpdb->users} WHERE user_email = '$email4sql' LIMIT 1");
	}

	$user_id = apply_filters('validate_address/ktai_entry.php', $user_id, $address);
	if (! $user_id) {
		return NULL;
	}
	return $user_id;
}

/* ==================================================
 * @param	string   $post_time_gmt
 * @return	int      $ID
 */
private function check_duplication($post_time_gmt) {
	global $wpdb;
	$time4sql = gmdate('Y-m-d H:i:s', $post_time_gmt);
	$result = $wpdb->get_var("SELECT ID FROM {$wpdb->posts} WHERE post_date_gmt = '$time4sql' LIMIT 1");
	return $result;
}

/* ==================================================
 * @param	object   $part
 * @return	array    $contents
 */
private function get_mime_parts($part) {
	$contents = new stdClass;
	$contents->text = '';
	$contents->images = array();
	switch (strtolower($part->ctype_primary)) {
		case 'multipart':
			foreach ($part->parts as $p) {
				$part_content = $this->get_mime_parts($p);
				$contents->text .= $part_content->text;
				$contents->images = array_merge($contents->images, $part_content->images);
			}
			break;
		case 'text':
			if ($part->ctype_secondary == 'plain') {
				$text = trim($part->body);
			} elseif ($part->ctype_secondary == 'html') {
				$text = trim(strip_tags($part->body));
			}
			$contents->text .= mb_convert_encoding($text, get_option('blog_charset'), 'auto');
			break;
		case 'image':
			$name = $part->d_parameters['filename'] ? $part->d_parameters['filename'] : $part->ctype_parameters['name'];
			$contents->images[] = array($name, $part->ctype_secondary, $part->body);
			break;
	}		
	return $contents;
}

/* ==================================================
 * @param	array    $contents
 * @return	array    $categories
 */
private function decide_category(&$contents) {
	$categories = array();
	if (preg_match('/^' . preg_quote(KE_SET_CATEGORY) . '(.*)$/m', $contents->text, $m) ) {
		$contents->text = preg_replace('/^' . preg_quote($m[0]) . '[ \t\r]*\n/m', '', $contents->text, 1);
		$categories = $this->cat_name2id($m[1]);
	} elseif (preg_match('/^' . preg_quote(KE_ADD_CATEGORY) . '(.*)$/m', $contents->text, $m) ) {
		$contents->text = preg_replace('/^' . preg_quote($m[0]) . '[ \t\r]*\n/m', '', $contents->text, 1);
		$categories = $this->cat_name2id($m[1]);
		array_unshift($categories, get_option('default_email_category'));
	}
	if (preg_match('/^(' . preg_quote(KE_CHANGE_CATEGORY, '/') . '|(' . preg_quote(KE_ADD_CHANGE_CATEGORY, '/') . '))(.*)$/m', $contents->text, $m)) {
		$contents->text = preg_replace('/^' . preg_quote($m[0], '/') . '[ \t\r]*\n/m', '', $contents->text, 1);
		$cats = $this->cat_name2id($m[3]);
		$cat_change = $cats[0];
		$categories = array_merge($categories, $cats);
		if ($m[2]) {
			array_unshift($categories, get_option('default_email_category'));
		}
	} 
	if (count($categories) < 1) {
		$categories[] = get_option('default_email_category');
	}
	$this->debug_print('Category: ' . implode(', ', array_map('get_catname', $categories)));
	return $categories;
}

/* ==================================================
 * @param	string   $cat_names
 * @return	array    $categories
 */
private function cat_name2id($cat_names) {
	$categories = array();
	foreach (explode(',', $cat_names) as $c) {
		$c = trim($c);
		if (is_numeric($c)) {
			$c = intval($c);
		} else {
			$c = get_cat_ID($c);
		}
		if ($c) {
			$categories[] = $c;
		}
	}
	if (count($categories)) {
		$this->debug_print("Assign cats: '$cat_names' -> ", implode(',',$categories));
	}
	return $categories;
}

/* ==================================================
 * @param	array    $contents
 * @return	string   $keywords
 */
private function decide_keywords(&$contents) {
	$keywords = '';
	if (preg_match('/^' . preg_quote(KE_SET_TAGS) . '(.*)$/m', $contents->text, $m) ) {
		$contents->text = preg_replace('/^' . preg_quote($m[0]) . '[ \t\r]*\n/m', '', $contents->text, 1);
		$keywords = trim($m[1]);
		$this->debug_print("Tags: '$keywords'");
	}
	return $keywords;
}

/* ==================================================
 * @param	array    $contents
 * @return	array    $rotations
 */
private function decide_rotations(&$contents) {
	if (preg_match('/^' . preg_quote(KE_ROTATE_IMAGE) . '(.*)$/m', $contents->text, $m) ) {
		$contents->text = preg_replace('/^' . preg_quote($m[0]) . '[ \t\r]*\n/m', '', $contents->text, 1);
		$rotations = $this->parse_rotation(strtoupper($m[1]), count($contents->images));
	} else {
		$rotations = $this->parse_rotation('', count($contents->images));
	}
	if (isset($rotations) && count($rotations)) {
		$this->debug_print('Rotation: ' . implode(',', $rotations));
	}
	return $rotations;
}

/* ==================================================
 * @param	string   $rotations
 * @param	int      $num_images
 * @return	array    $rotations
 */
private function parse_rotation($rot_desc, $num_images) {
	if ($num_images < 1) {
		return NULL;
	}
	$rot_desc = trim($rot_desc);
	// ----- Single 'L' or 'R' means rotating all image to the same direction.
	if ($rot_desc == 'L' || $rot_desc == 'R' || $rot_desc == 'N') {
		$rotations = array_fill(0, $num_images, $rot_desc);
	// ----- Continuous of 'N', 'L', or 'R' string means rotating each image to such direction.
	} elseif (preg_match('/^[NLR]+$/', $rot_desc)) {
		$rotations = str_split($rot_desc) + array_fill(0, $num_images, 'N');
	// ----- Number and 'L'/'R' means to rotate the numbered images to the desired direction.
	} elseif (preg_match('/^(\d+[LR])+/', $rot_desc)) {
		$rotations = array_fill(0, $num_images, 'N');
		preg_match_all('/(\d+)([LR])/', $rot_desc, $m, PREG_SET_ORDER);
		foreach ($m as $n) {
			$rotations[$n[1] -1] = $n[2];
		}
	// ----- Default is no rotation.
	} else {
		$rotations = array_fill(0, $num_images, 'N');
	}
	return $rotations;
}

/* ==================================================
 * @param	object   $contents
 * @return	none
 */
private function chop_signature(&$contents) {
	if (defined('KE_DELIM_STR')) {
		$text = $contents->text;
		$sig_match = strripos($text, "\n" . KE_DELIM_STR);
		if ($sig_match > 0) {
			$text = substr($text, 0, $sig_match);
			$this->debug_print("Signature chopped at position: $sig_match");
		}
		$contents->text = $text;
	}
	return;
}

/* ==================================================
 * @param	object   $contents
 * @param	array    $rotations
 * @param	int      $post_id
 * @return	array    $image_ids
 * based on wp_handle_upload() at wp-admin/includes/file.php of WP 2.5
 */
private function upload_images($contents, $rotations, $post_id = 0) {
	if (count($contents->images) < 1) {
		return NULL;
	}
	$image_ids = array();
	foreach ($contents->images as $count => $img) {
		if ( ! ( ( $uploads = wp_upload_dir() ) && false === $uploads['error'] ) ) {
			$this->logging(@$uploads['error']);
			return NULL;
		}
		$filename = $this->unique_filename($uploads['path'], $img[0]);
		$new_file = $uploads['path'] . "/$filename";
		$this->debug_print("Saving file: $new_file");
		$result = $this->save_image($new_file, $img[1], $img[2], @$rotations[$count]);
		if (is_ktai_error($result)) {
			$this->logging($result->getMessage());
			return NULL;
		}
		$url = $uploads['url'] . "/$filename";
		$file = apply_filters('wp_handle_upload', array('file' => $new_file, 'url' => $url, 'type' => "image/{$img[1]}"));

		$url  = $file['url'];
		$type = $file['type'];
		$file = $file['file'];
		$title = preg_replace('/\.[^.]+$/', '', basename($file));
		$content = '';

		if ( function_exists('wp_read_image_metadata') 
		 && $image_meta = @wp_read_image_metadata($file) ) {
			if ( trim($image_meta['title']) )
				$title = $image_meta['title'];
			if ( trim($image_meta['caption']) )
				$content = $image_meta['caption'];
		}

		$attachment = array(
			'post_mime_type' => $type,
			'guid'           => $url,
			'post_parent'    => $post_id,
			'post_title'     => $title,
			'post_content'   => $content,
			'post_excerpt'   => ($content ? $content : basename($file)),
		);

		$id = wp_insert_attachment($attachment, $file, $post_id);
		if ((function_exists('is_wp_error') && is_wp_error($id)) || $id <= 0) {
			$this->logging(sprintf('Failed inserting attachment for post#%d: %s', $post_id,  $file));
		} else {
			if (function_exists('wp_generate_attachment_metadata')) {
				wp_update_attachment_metadata($id, wp_generate_attachment_metadata($id, $file));
			} else {
				$this->update_attachment_metadata($attachment, $id, $file);
			}
			$this->debug_print("Inserted attachment: $id for post $post_id");
			$image_ids[] = $id;
		}
	}
	return $image_ids;
}


/* ==================================================
 * @param	string   $dir
 * @param	string   $filename
 * @param	string   $new_file
 */
// If $file is exists, change filename to $file_2, $file_3, ...
private function unique_filename($dir, $filename) {
	$parts = pathinfo($filename);
	$ext = $parts['extension'];
	$name = preg_replace("/\.{$ext}\$/", '', $parts['basename']);
	$name = preg_replace('/[^-_.~+a-zA-Z0-9]/', '', $name);
	$count = '';
	while (file_exists("$dir/$name$count.$ext")) {
		$count = $count ? preg_replace('/(\d+)/e', "intval('$1') + 1", $count) : "_2";
	}
	return "$name$count.$ext";
}

/* ==================================================
 * @param	string   $filepath
 * @param	string   $type
 * @param	string   $image_string
 * @param	string   $rotation
 * @return	boolean  $result
 */
private function save_image($filepath, $type, $image_string, $rotation) {
	try {
		$image  = imagecreatefromstring($image_string);
		$width  = imagesx($image);
		$height = imagesy($image);
		if ($rotation != 'L' && $rotation != 'R') {
			$fp = fopen($filepath, 'w');
			if (! $fp) {throw new Ktai_Error("Can't create a file: $filepath");}
			if (! fwrite($fp, $image_string)) {throw new Ktai_Error("Can't write to file: $filepath");}
			if (! fclose($fp)) {throw new Ktai_Error("Can't close the file: $filepath");}
			if (! chmod($filepath, KE_IMAGE_PERM)) {throw new Ktai_Error("Can't chmod the file: $filepath");}
			$this->debug_print("Image without rotation: {$width}x{$height} type:$type");
		} else {
			$rotated = $this->rotate_image($image, $type, $rotation, $filepath);
			if (is_ktai_error($rotated)) {
				return $rotated;
			}
			if (! chmod($filepath, KE_IMAGE_PERM)) {throw new Ktai_Error("Can't chmod the file: $filepath");}
			imagedestroy($rotated);
			$this->debug_print("Image with rotation($rotation): {$width}x{$height} type:$type");
		}
		imagedestroy($image);
		return TRUE;

	} catch (Ktai_Error $e) {
		return $e;
	}
}

/* ==================================================
 * @param	resource $image
 * @param	string   $type
 * @param	string   $direction
 * @param	string   $filepath
 * @return	resource $rotated
 */
private function rotate_image($image, $type, $direction, $filepath) {	
	$angle = $direction == 'L' ? 90: 270;
	$rotated = imagerotate($image, $angle, 0);
	switch (strtolower($type)) {
	case 'gif':
		$result = imagegif($rotated, $filepath);
		break;
	case 'png':
		$result = imagepng($rotated, $filepath);
		break;
	case 'jpeg':
	default:
		$result = imagejpeg($rotated, $filepath);
		break;
	}
	if (! $result || ! file_exists($filepath)) {
		return new Ktai_Error("Can't write rotated image: $filepath");
	}
	return $rotated;
}

/* ==================================================
 * @param	object   $attachment
 * @param	int      $id
 * @param	string   $file
 * @return	object   $this
 * based on line 78-105 at inline-uploading.php of WP ME 2.0.11
 */
private function update_attachment_metadata($attachment, $id, $file) {
	if ( preg_match('!^image/!', $attachment['post_mime_type']) ) {
		// Generate the attachment's postmeta.
		$imagesize = getimagesize($file);
		$imagedata['width'] = $imagesize['0'];
		$imagedata['height'] = $imagesize['1'];
		list($uwidth, $uheight) = get_udims($imagedata['width'], $imagedata['height']);
		$imagedata['hwstring_small'] = "height='$uheight' width='$uwidth'";
		$imagedata['file'] = $file;

		add_post_meta($id, '_wp_attachment_metadata', $imagedata);

		$max_length = intval($this->get_option('ke_thumb_size'));
		if ($max_length < 10) {
			$max_length = 128;
		}
		if ( $imagedata['width'] * $imagedata['height'] < 3 * 1024 * 1024 ) {
			if ( $imagedata['width'] > $max_length 
			&& $imagedata['width'] >= $imagedata['height'] * 4 / 3 )
				$thumb = wp_create_thumbnail($file, $max_length);
			elseif ( $imagedata['height'] > $max_length )
				$thumb = wp_create_thumbnail($file, $max_length);

			if ( @file_exists($thumb) ) {
				chmod($thumb, KE_IMAGE_PERM);
				$newdata = $imagedata;
				$newdata['thumb'] = basename($thumb);
				update_post_meta($id, '_wp_attachment_metadata', $newdata, $imagedata);
			} else {
				$error = $thumb;
			}
		}
	} else {
		add_post_meta($id, '_wp_attachment_metadata', array());
	}
}

/* ==================================================
 * @param	array    $html
 * @param	array    $image_ids
 * @return	string   $html
 */
private function images_to_html($content, $image_ids) {
	if (is_array($image_ids) && count($image_ids)) {
		$img = array();
		if (function_exists('wp_get_attachment_link')) {
			$link_func = 'wp_get_attachment_link';
			$size      = ($this->get_option('ke_thumb_size') == 'medium') ? 'medium' : 'thumbnail';
		} else {
			$link_func = 'get_the_attachment_link';
			$size      = FALSE;
		}
		foreach ($image_ids as $id) {
			if (! $id) continue;
			$html = $link_func($id, $size);
			if (! preg_match('/href=(["\'])([^"\']*)\\1/', $html, $file)) {
				preg_match('/src=(["\'])([^"\']*)\\1/', $html, $file);
			}
			if (preg_match('/alt=(""|\'\')/', $html, $match)) {
				$html = str_replace($match[0], 'alt="' . basename($file[2]) . '"', $html);
			} elseif (! preg_match('/alt=/', $html)) {
				$html = str_replace('<img ', '<img alt="' . basename($file[2]) . '" ', $html);
			}
			$img[] = apply_filters('image_link/ktai_entry.php', $html, $id, $size);
		}
		if (count($img)) {
			$content = apply_filters('images_to_link/ktai_entry.php', 
				KE_IMAGES_HEADER . implode(' ', $img) . KE_IMAGES_FOOTER
				. KE_TEXT_HEADER . $content . KE_TEXT_FOOTER, $content, $img);
		}
	}
	return $content;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Error class
   ================================================== */

if (! class_exists('Ktai_Error')) :

function is_ktai_error($thing) {
	return (is_object($thing) && is_a($thing, 'Ktai_Error'));
}

class Ktai_Error extends Exception {

public function setCode($code) {
	$this->code = $code;
}

// ===== End of class ====================
}
endif;

?>