<?php
/* ==================================================
 *   Redirect to external sites
   ================================================== */

if (defined('ABSPATH')) {
	require_once ABSPATH . 'wp-config.php';
} else {
	require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';
}

if (! isset($Ktai_Style) || ! $Ktai_Style->is_ktai()) {
	wp_redirect(get_bloginfo('url'));
} else {
	$Redir = new Ktai_Style_Redir;
}
exit();

/* ==================================================
 *   Ktai_Style_Redir class
   ================================================== */

class Ktai_Style_Redir {
	private $url = NULL;

// ==================================================
public function __construct() {
	if (isset($_GET['url']) && ! empty($_GET['url'])) {
		$this->url = clean_url($_GET['url']);
		$this->output();
	} else {
		wp_redirect(get_bloginfo('url'));
	}
}

// ==================================================
private function output() {
	global $Ktai_Style;
	$charset = $Ktai_Style->ktai->get('charset');
	$title = __('Confirm connecting to external sites', 'ktai_style');
	$full_url = $this->url;
	if (preg_match('|^/|', $this->url)) {
		$full_url = preg_replace('|^(https?://[^/]*)/.*$|', '$1', get_bloginfo('url')) . $this->url;
	}
	$html = '<p>' . __('You are about to visit a website for PC:', 'ktai_style') . "<br />\n"
	      . '<a href="' . attribute_escape($this->url) . '">' . attribute_escape($full_url) . "</a>";
	if ($Ktai_Style->is_ktai() == 'KDDI' && $Ktai_Style->get('type') == 'WAP2.0') {
		$html .= '<br />'. sprintf(__('(<a %s>View the site by PC Site Viewer.</a>)', 'ktai_style'), ' href="device:pcsiteviewer?url=' . attribute_escape($full_url) . '"');
	} elseif ($Ktai_Style->is_ktai() == 'DoCoMo' && $Ktai_Style->get('type') == 'FOMA') {
		$html .= '<br />'. sprintf(__('(<a %s>View the site by Full Browser.</a>)', 'ktai_style'), 'href="' . attribute_escape($this->url) . '" ifb="' . attribute_escape($full_url) . '"');
	}
	$html .= "</p>\n<p>" . __('If you are sure, follow above link. If not, go to the previous page with browser\'s back button.', 'ktai_style') . '</p>';
	$html .='<form action=""><div>' . __('To copy the URL, use below text field:', 'ktai_style') . '<br /><input type="text" name="url" size="80" maxlength="255" value="' . attribute_escape($full_url) . '" /></div></form>';
	nocache_headers();
	$Ktai_Style->ks_die(apply_filters('redir/ktai_style.php', $html, $full_url), $title, FALSE);
}

// ===== End of class ====================
}
?>