<?php
/*
Plugin Name: WP Plugins Tracker
Plugin URI: http://wp-plugins-db.org/wp-plugins-tracker
Description: This plugin helps webmasters to track the new releases of the plugins they are using in their website from admin panel.
Author: Sugan Shan
Version: 0.2
Author URI: http://www.wp-plugins-db.org/
*/ 

/*  Copyright 2006/2007  Andy Staines http://www.yellowswordfish.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// We need some CSS to position the paragraph
function wpp_tracker_list_plugins() {
	$plugins = get_plugins();

if (empty($plugins)) {
	echo '<p>';
	_e("Couldn't open plugins directory or there are no plugins available."); 
	echo '</p>';
} else {

?>
<div class="wrap">
<h2><?php _e('Plugin Release Tracker'); ?></h2>
<p> <?php _e('あなたが使用されているプラグインのバージョンを追跡します。'); ?></p>

<?php

  $option = 'wp_plugins_tracker_location';
  $value = (get_option ($option) == 1) ? 0 : 1;
  if($value == 1)
     $value_string = "'プラグインのサブメニューに格納'";
  else
     $value_string = "'メインメニューに格納'";

  $action = "<center><FORM action='admin.php?page=wp-plugins-tracker.php' method=post>
             <INPUT name=$option type=hidden value='$value'>
             <INPUT class=button type=submit value=$value_string name=Submit> </FORM> </center>";

  echo $action."<br><br>";
?>

<table width="100%" cellpadding="3" cellspacing="3">
	<tr>
		<th><?php _e('Plugin'); ?></th>
		<th><?php _e('Your Version'); ?></th>
		<th><?php _e('WPPDB Version'); ?></th>
		<th><?php _e('Status'); ?></th>
	</tr>
<?php
	$style = '';

	$current_plugins = get_settings('active_plugins');

	function wpp_tracker_sort_plugins($plug1, $plug2) {
		return strnatcasecmp($plug1['Name'], $plug2['Name']);
	}
	
	uksort($plugins, 'wpp_tracker_sort_plugins');

	foreach($plugins as $plugin_file => $plugin_data) {
		$style = ('class="alternate"' == $style|| 'class="alternate active"' == $style) ? '' : 'alternate';

		if (!empty($current_plugins) && in_array($plugin_file, $current_plugins)) {
			//$action = "<a href='" . wp_nonce_url("plugins.php?action=deactivate&amp;plugin=$plugin_file", 'deactivate-plugin_' . $plugin_file) . "' title='".__('Deactivate this plugin')."' class='delete'>".__('Deactivate')."</a>";
                  $action = "Active";
		  $plugin_data['Title'] = "<strong>{$plugin_data['Title']}</strong>";
		  $style .= $style == 'alternate' ? ' active' : 'active';
		} else {
		  //$action = "<a href='" . wp_nonce_url("plugins.php?action=activate&amp;plugin=$plugin_file", 'activate-plugin_' . $plugin_file) . "' title='".__('Activate this plugin')."' class='edit'>".__('Activate')."</a>";
                  $action = "Not Active";
		}
		$plugin_data['Description'] = wp_kses($plugin_data['Description'], array('a' => array('href' => array(),'title' => array()),'abbr' => array('title' => array()),'acronym' => array('title' => array()),'code' => array(),'em' => array(),'strong' => array()) ); ;
            
		if ($style != '') $style = 'class="' . $style . '"';

                $return_data = wppdb_check_plugin_version($plugin_data['Title'],$plugin_data['Version']);
                list($status, $current_version) = split(',', $return_data);

                if($status == -1) {
                     $action = " Error at WP-Plugins-DB.org : Try Later";
                } else if ($status == 1) {
                     if((trim($plugin_data['Version']) != trim($current_version))) {
                           $action = " <font color=red><b>バージョンは一致しませんでした。</b></font>";
		     } else
                        $action = "<font color=green><b>バージョンが一致しました。</b></font>";
                } else {
                     $action = "<font color=brown>Wp-Plugins-Db.org に、このプラグインは登録されていません。</font>";
                }

		echo " 	<tr $style>
		<td class='name'>{$plugin_data['Title']}</td>
		<td class='vers'>{$plugin_data['Version']}</td>
                <td class='vers'>{$current_version}</td>
		<!-- <td class='desc'>{$plugin_data['Description']} <cite>".sprintf(__('By %s'), $plugin_data['Author']).".</cite></td> -->
		<td class='togl'>$action</td>
	</tr>";

	}
?>

</table>
</div>
<?php
}
	
}

add_action('admin_menu', 'wpp_tracker_page');

function wpp_tracker_page () {
    global $wpdb;
    $option = 'wp_plugins_tracker_location';

    if(isset($_POST[$option])) {
       update_option($option,$_POST[$option]);  
    }

    if(get_option($option) == 0) { 
       if ( function_exists('add_menu_page') )
         add_menu_page(__('WP Plugins Tracker'), __('WP Plugins Tracker'), 10, __FILE__, 'wpp_tracker_list_plugins');
    } else {
       if ( function_exists('add_submenu_page') )
       	 add_submenu_page('plugins.php', __('WP Plugins Tracker'), __('WP Plugins Tracker'), 10, __FILE__, 'wpp_tracker_list_plugins');
    }
}

$wppdb_user_agent = 'Wordpress/$wp_version |  WP Plugins Tracker/0.1';
$wppdb_host           = 'www.wp-plugins-db.org';
$wppdb_port  = 80;
$wppdb_path = '/check.php';

function wppdb_check_plugin_version( $plugin, $plugin_version ) {
 global $wppdb_host, $wppdb_port, $wppdb_path;
 global $wp_version;

 $blog = urlencode( get_option('home') );

 $response = wppdb_http_post  
   ("plugin=$plugin&plugin_version=$plugin_version&blog=$blog&wp_version=$wp_version",
    $wppdb_host, $wppdb_path,$wppdb_port);

 //echo "Request : $response[0] <br> Response : $response[1]";

 return $response[1];
}


function wppdb_http_post($request, $host, $path, $port = 80) {
 
 global $wpp_user_agent;

 $http_request  = "POST $path HTTP/1.0\r\n";
 $http_request .= "Host: $host\r\n";
 $http_request .= "Content-Type: application/x-www-form-urlencoded; charset=" . get_settings('blog_charset') . "\r\n";
 $http_request .= "Content-Length: " . strlen($request) . "\r\n";
 $http_request .= "User-Agent: $wppdb_user_agent\r\n";
 $http_request .= "\r\n";
 $http_request .= $request;

 $response = '';
 if( false !== ( $fs = @fsockopen($host, $port, $errno, $errstr, 100) ) ) {
  fwrite($fs, $http_request);

  while ( !feof($fs) )
   $response .= fgets($fs, 1160); // One TCP-IP packet
  fclose($fs);
  $response = explode("\r\n\r\n", $response, 2);
 } else {
     echo "host : $host <br> port : $port <br> errorno : $errno <br> errstr : $errstr";

 }
 // echo "<br>Request : $response[0] <br> Response : $response[1]<br>";

 return $response;
}



?>
