/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorContext {
    private String id;
    private Map<String, List<Object>> inputMap;
    private final List<String> messageList;
    private final Map<String, List<String>> messageMap;
    private String tmpKey;
    private int tmpIndex;

    public ValidatorContext() {
        this.messageList = new ArrayList<String>();
        this.messageMap = new LinkedHashMap<String, List<String>>();
    }

    public ValidatorContext(ValidatorContext base) {
        this.id = base.id;
        this.inputMap = base.inputMap;
        this.messageList = base.messageList;
        this.messageMap = base.messageMap;
        this.tmpKey = base.tmpKey;
        this.tmpIndex = base.tmpIndex;
    }

    public ValidatorContext copy() {
        return new ValidatorContext(this);
    }

    public void appendTo(Appendable sb) throws IOException {
        sb.append("ValidatorContext dump information:");
        ValidatorContext.appendTo(sb, "id", this.id);
        ValidatorContext.appendTo(sb, "inputMap", this.inputMap);
        ValidatorContext.appendTo(sb, "messageList", this.messageList);
        ValidatorContext.appendTo(sb, "messageMap", this.messageMap);
        ValidatorContext.appendTo(sb, "tmpKey", this.tmpKey);
        ValidatorContext.appendTo(sb, "tmpIndex", this.tmpIndex);
    }

    private static void appendTo(Appendable sb, String label, Object o) throws IOException {
        sb.append('\n');
        sb.append(',');
        sb.append(label);
        sb.append(':');
        if (o != null) {
            sb.append(o.toString());
        }
    }

    public void add(String message) {
        List<String> list = this.messageMap.get(this.tmpKey);
        if (list == null) {
            list = new ArrayList<String>();
            this.messageMap.put(this.tmpKey, list);
        }
        list.add(message);
        this.messageList.add(message);
    }

    public Map<String, List<String>> getMessageMap() {
        return this.messageMap;
    }

    public List<String> getMessageList() {
        return this.messageList;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, List<Object>> getInputMap() {
        return this.inputMap;
    }

    public void setInputMap(Map<String, List<Object>> inputMap) {
        this.inputMap = inputMap;
    }

    public String getTmpKey() {
        return this.tmpKey;
    }

    public void setTmpKey(String tmpKey) {
        this.tmpKey = tmpKey;
    }

    public int getTmpIndex() {
        return this.tmpIndex;
    }

    public void setTmpIndex(int tmpIndex) {
        this.tmpIndex = tmpIndex;
    }

    public Object getTmpValue() {
        List<Object> list = this.inputMap.get(this.tmpKey);
        if (list == null || list.size() <= this.tmpIndex) {
            return null;
        }
        return list.get(this.tmpIndex);
    }

    public void setTmpValue(Object value) {
        List<Object> list = this.inputMap.get(this.tmpKey);
        if (list == null) {
            list = new ArrayList<Object>();
            this.inputMap.put(this.tmpKey, list);
        }
        if (list.size() == 0 && this.tmpIndex == 0) {
            list.add(value);
        } else {
            list.set(this.tmpIndex, value);
        }
    }
}

