/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static String toJavaName(String s) {
        return PropertyUtils.toJavaName(s, '_');
    }

    public static String toJavaName(String s, char separator) {
        if (s == null || s.indexOf(separator) < 0) {
            if (s != null && s.length() >= 1) {
                return String.valueOf(Character.toLowerCase(s.charAt(0))) + s.substring(1);
            }
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        boolean separateFlag = false;
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (c == separator) {
                separateFlag = true;
                sb.delete(i, i + 1);
                continue;
            }
            if (separateFlag) {
                c = Character.toUpperCase(c);
                separateFlag = false;
            } else {
                c = Character.toLowerCase(c);
            }
            sb.setCharAt(i, c);
            ++i;
        }
        return sb.toString();
    }

    public static String toSQLName(String s) {
        return PropertyUtils.toSQLName(s, '_');
    }

    public static String toSQLName(String s, char separator) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int length = s.length();
        boolean upper = false;
        int i = length - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (Character.isLowerCase(c) && upper) {
                sb.insert(0, separator);
            }
            upper = Character.isUpperCase(c);
            sb.insert(0, Character.toUpperCase(c));
            --i;
        }
        return sb.toString();
    }
}

