/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.InsertElementToParent;
import woolpack.dom.RemoveAttr;
import woolpack.dom.Serial;
import woolpack.dom.UpdateAttrValue;
import woolpack.dom.XPath;
import woolpack.dom.XPathAttrValue;
import woolpack.el.FixEL;
import woolpack.html.Frame2TableFramesetCol;
import woolpack.utils.XPathWrapper;

public class FrameToTable
implements DomExpression {
    private static final DomExpression BODY = new InsertElementToParent("BODY", DomConstants.NULL);
    static final DomExpression TABLE = new InsertElementToParent("TABLE", new UpdateAttrValue("width", new FixEL("100%")));
    static final DomExpression TR = new InsertElementToParent("TR", DomConstants.NULL);
    private static final DomExpression TD = new InsertElementToParent("TD", new Serial(new UpdateAttrValue("align", new FixEL("left")), new UpdateAttrValue("valign", new FixEL("top"))));
    private static final XPathWrapper XPATH_BODY = new XPathWrapper("//BODY");
    private static final XPathWrapper XPATH_HTML_BODY = new XPathWrapper("/HTML/BODY");
    private static final XPathWrapper XPATH_FRAME = new XPathWrapper("//FRAME");
    static final XPathWrapper XPATH_FRAMESET_ROWS = new XPathWrapper("FRAMESET[@rows]");
    static final XPathWrapper XPATH_FRAMESET_COLS = new XPathWrapper("FRAMESET[@cols]");
    private static final XPathWrapper XPATH_HTML = new XPathWrapper("/HTML");
    static final XPathWrapper XPATH_FRAME2 = new XPathWrapper("FRAME");
    private final String frameId;
    private final DomExpression nodeMaker;
    private final DomExpression framesetRow;
    private final DomExpression root;

    public FrameToTable(String frameId, final String targetName, final DomExpression nodeMaker) {
        frameId.charAt(0);
        targetName.charAt(0);
        nodeMaker.getClass();
        this.nodeMaker = nodeMaker;
        this.frameId = frameId;
        final XPathAttrValue removeTargetAttr = new XPathAttrValue("target", targetName, (DomExpression)new RemoveAttr("target"));
        DomExpression processFrame = new DomExpression(){

            public void interpret(DomContext context) {
                Element element = (Element)context.getNode();
                if (targetName.equals(element.getAttribute("name"))) {
                    return;
                }
                DomContext newContext = context.copy();
                newContext.setId(element.getAttribute("src"));
                nodeMaker.interpret(newContext);
                removeTargetAttr.interpret(newContext);
                Node target = XPATH_BODY.evaluateOne(newContext.getNode());
                Node child = target.getFirstChild();
                while (child != null) {
                    context.getNode().getParentNode().insertBefore(DomConstants.getDocumentNode(context.getNode()).importNode(child, true), context.getNode());
                    child = child.getNextSibling();
                }
                DomConstants.REMOVE_THIS.interpret(context);
            }
        };
        DomExpression processRow = new DomExpression(){

            public void interpret(DomContext context) {
                FrameToTable.this.framesetRow.interpret(context);
            }
        };
        this.framesetRow = new Serial(new XPath(XPATH_FRAMESET_ROWS, (DomExpression)new Serial(TR, TD, TABLE, processRow, DomConstants.RETAIN_CHILDREN)), new XPath(XPATH_FRAMESET_COLS, (DomExpression)new Serial(TR, TD, TABLE, TR, new Frame2TableFramesetCol(processRow, processFrame), DomConstants.RETAIN_CHILDREN)), new XPath(XPATH_FRAME2, (DomExpression)new Serial(TR, TD, processFrame)));
        this.root = new XPath(XPATH_HTML, (DomExpression)new Serial(new XPath(XPATH_FRAMESET_ROWS, (DomExpression)new Serial(BODY, TABLE, processRow, DomConstants.RETAIN_CHILDREN)), new XPath(XPATH_FRAMESET_COLS, (DomExpression)new Serial(BODY, TABLE, TR, new Frame2TableFramesetCol(processRow, processFrame), DomConstants.RETAIN_CHILDREN))));
    }

    public void interpret(DomContext context) {
        DomContext frameContext = context.copy();
        frameContext.setId(this.frameId);
        this.nodeMaker.interpret(frameContext);
        this.root.interpret(frameContext);
        Node base = frameContext.getNode();
        this.nodeMaker.interpret(context);
        Node baseBody = DomConstants.getDocumentNode(context.getNode()).importNode(XPATH_HTML_BODY.evaluateOne(base), true);
        Node baseFrame = XPATH_FRAME.evaluateOne(baseBody);
        Node targetBody = XPATH_HTML_BODY.evaluateOne(context.getNode());
        Node child = targetBody.getFirstChild();
        while (child != null) {
            baseFrame.getParentNode().insertBefore(child, baseFrame);
            child = targetBody.getFirstChild();
        }
        Node baseTd = baseFrame.getParentNode();
        baseTd.removeChild(baseFrame);
        Node child2 = baseBody.getFirstChild();
        while (child2 != null) {
            targetBody.appendChild(child2);
            child2 = baseBody.getFirstChild();
        }
    }
}

