/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.util.HashMap;
import java.util.Map;
import woolpack.el.EL;
import woolpack.el.ELAdapter;
import woolpack.el.ELConstants;
import woolpack.el.ELTargetRuntimeException;
import woolpack.el.GettingEL;
import woolpack.el.MapEL;
import woolpack.el.PropertyELFactory;
import woolpack.el.ReflectionPropertyELFactory;
import woolpack.el.TypeConverter;

public class PropertyEL
extends ELAdapter {
    private static final Map<Class, Map<String, GettingEL>> getterMap = new HashMap<Class, Map<String, GettingEL>>();
    private static final Map<Class, Map<String, EL>> setterMap = new HashMap<Class, Map<String, EL>>();
    private final String propertyName;
    private final TypeConverter converter;
    private final PropertyELFactory factory;
    private final EL mapEL;

    public PropertyEL(String propertyName, TypeConverter converter, PropertyELFactory factory) {
        propertyName.charAt(0);
        converter.getClass();
        factory.getClass();
        this.propertyName = propertyName;
        this.converter = converter;
        this.factory = factory;
        this.mapEL = new MapEL(propertyName);
    }

    public PropertyEL(String propertyName, TypeConverter converter) {
        this(propertyName, converter, new ReflectionPropertyELFactory(converter));
    }

    public PropertyEL(String propertyName) {
        this(propertyName, ELConstants.COLLECTION_CONVERTER);
    }

    public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
        if (root instanceof Map) {
            Object result = this.mapEL.getValue(root, clazz);
            return this.converter.convert(this.propertyName, result, clazz);
        }
        GettingEL getter = null;
        Class<?> rootClass = root.getClass();
        Map<String, GettingEL> map1 = getterMap.get(rootClass);
        if (map1 != null) {
            getter = map1.get(this.propertyName);
        }
        if (getter == null) {
            getter = this.factory.newGetter(rootClass, this.propertyName);
            if (map1 == null) {
                map1 = new HashMap<String, GettingEL>();
                getterMap.put(rootClass, map1);
            }
            map1.put(this.propertyName, getter);
        }
        return getter.getValue(root, clazz);
    }

    public void setValue(Object root, Object value) throws ELTargetRuntimeException {
        if (root instanceof Map) {
            this.mapEL.setValue(root, value);
            return;
        }
        EL setter = null;
        Class<?> rootClass = root.getClass();
        Map<String, EL> map1 = setterMap.get(rootClass);
        if (map1 != null) {
            setter = map1.get(this.propertyName);
        }
        if (setter == null) {
            setter = this.factory.newSetter(rootClass, this.propertyName);
            if (map1 == null) {
                map1 = new HashMap<String, EL>();
                setterMap.put(rootClass, map1);
            }
            map1.put(this.propertyName, setter);
        }
        setter.setValue(root, value);
    }

    public int hashCode() {
        return this.propertyName.hashCode() + 3 * this.converter.hashCode() + 5 * this.factory.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof PropertyEL) {
            PropertyEL o = (PropertyEL)other;
            return this.propertyName.equals(o.propertyName) && this.converter.equals(o.converter) && this.factory.equals(o.factory);
        }
        return false;
    }
}

