/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoSemaphoreSession
implements DomExpression {
    public static final String KEY = "woolpack.dom.DO_SEMAPHORE";
    private final String key;
    private final int permits;
    private final DomExpression trueExpression;
    private final DomExpression falseExpression;

    public DoSemaphoreSession(String key, int permits, DomExpression trueExpression, DomExpression falseExpression) {
        key.charAt(0);
        trueExpression.getClass();
        falseExpression.getClass();
        this.key = key;
        this.permits = permits;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public DoSemaphoreSession(int permits, DomExpression trueExpression, DomExpression falseExpression) {
        this(KEY, permits, trueExpression, falseExpression);
    }

    private Semaphore createPerSession(ConcurrentMap<String, Object> session) {
        Semaphore semaphore;
        while ((semaphore = (Semaphore)session.get(this.key)) == null) {
            session.putIfAbsent(this.key, new Semaphore(this.permits, true));
        }
        return semaphore;
    }

    @Override
    public void interpret(DomContext context) {
        Semaphore semaphore = this.createPerSession(context.getSession());
        try {
            semaphore.acquire();
            try {
                this.trueExpression.interpret(context);
            }
            finally {
                semaphore.release();
            }
        }
        catch (InterruptedException e) {
            this.falseExpression.interpret(context);
        }
    }
}

