/*
 * Decompiled with CFR 0.152.
 */
package woolpack.config;

import java.util.LinkedHashMap;
import java.util.Map;
import woolpack.config.ConfigContext;
import woolpack.config.ConfigExpression;

public class CacheMap
implements ConfigExpression {
    private static final Object DEFAULT_KEY = new Object();
    private final ConfigExpression mapMaker;
    private final Map<Object, Map<String, Object>> cacheMap;

    public CacheMap(final int maxEntries, ConfigExpression mapMaker) {
        mapMaker.getClass();
        this.mapMaker = mapMaker;
        this.cacheMap = maxEntries > 0 ? new LinkedHashMap<Object, Map<String, Object>>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > maxEntries;
            }
        } : null;
    }

    public void interpret(ConfigContext context) {
        if (this.cacheMap == null) {
            this.mapMaker.interpret(context);
        } else {
            Object key = this.getCacheKey();
            Map<String, Object> map = this.cacheMap.get(key);
            if (map == null) {
                this.mapMaker.interpret(context);
                map = context.getMap();
                this.cacheMap.put(key, map);
            }
            context.setMap(map);
        }
    }

    public Object getCacheKey() {
        return DEFAULT_KEY;
    }
}

