/*
 * Decompiled with CFR 0.152.
 */
package mukiebi.weblaunch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;

public class MakePageMojo
extends AbstractMavenReport {
    private static final int BUFFER_SIZE = 65536;
    protected static final String EOL = "\r\n";
    public static final String SUBPARAM_TITLE = "title";
    public static final String SUBPARAM_VENDOR = "vendor";
    public static final String SUBPARAM_HOMEPAGE = "homepage";
    public static final String SUBPARAM_DESCRIPTION_ONE_LINE = "description-one-line";
    public static final String SUBPARAM_DESCRIPTION_SHORT = "description-short";
    public static final String SUBPARAM_DESCRIPTION_TOOLTIP = "description-tooltip";
    public static final String SUBPARAM_ICON = "icon";
    public static final String SUBPARAM_ICON_SPLASH = "icon-splash";
    public static final String SUBPARAM_SHORTCUT_DESKTOP = "shortcut-desktop";
    public static final String SUBPARAM_SHORTCUT_MENU = "shortcut-menu";
    public static final String SUBPARAM_RELATED_CONTENTS = "related-contents";
    private MavenProject project;
    private SiteRenderer siteRenderer;
    private final String reportName = "WebLaunch Info";
    private final String reportOutputName = "weblaunch-report";
    private String outputDirectory;
    List dependencies;
    List runtimeClasspathElemenmts;
    List systemClasspathElemenmts;
    File artifactFile;
    Map artifactMap;
    String targetDir;
    final String launcherOutputEncoding = "UTF-8";
    String siteDirectory;
    String codebase;
    String appletLauncherFilename;
    String webstartLauncherFilename;
    String jarsDirectoryRelativeURL;
    String webstartMainClass;
    List webstartArgs;
    boolean webstartOfflineAllowed;
    String appletMainClass;
    String appletName;
    Map appletArgs;
    int appletWidth;
    int appletHeight;
    Map localizedResources;
    boolean localCodebase;
    String webstartSpec;
    boolean allPermissions;
    private boolean defaultLocaleHasBeenExecuted = false;

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.project.getDescription();
    }

    public String getName(Locale locale) {
        return "WebLaunch Info";
    }

    public String getOutputName() {
        return "weblaunch-report";
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        try {
            List jars = this.getJARList(locale);
            if (!this.defaultLocaleHasBeenExecuted) {
                this.defaultLocaleHasBeenExecuted = true;
                File dir = new File(this.siteDirectory);
                this.generateAppletHtml(jars, null, locale);
                this.generateWebstartJnlp(jars, null, locale);
            }
            String genDir = locale.toString();
            this.generateAppletHtml(jars, genDir, locale);
            this.generateWebstartJnlp(jars, genDir, locale);
            this.copyJARsAndGenerateReport(jars, locale);
        }
        catch (MavenReportException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            MavenReportException wex = new MavenReportException("Unsupecified Error");
            wex.initCause(ex);
            throw wex;
        }
    }

    protected List getJARList(Locale locale) throws MavenReportException {
        File distDir = new File(this.siteDirectory, this.jarsDirectoryRelativeURL);
        distDir.mkdir();
        if (this.artifactFile == null) {
            throw new MavenReportException("Must specify \"package\" and \"site\" at the same time.");
        }
        ArrayList<Jar> jars = new ArrayList<Jar>();
        Jar jar = new Jar();
        jar.name = this.artifactFile.getName();
        jar.from = this.artifactFile;
        jar.to = new File(distDir, jar.name);
        jar.description = this.project.getName();
        jar.projectUrl = this.project.getUrl();
        jar.artifact = this.project.getArtifact();
        jars.add(jar);
        Iterator i = this.runtimeClasspathElemenmts.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            if (path == null || path.startsWith(this.targetDir + File.separator) || path.startsWith(this.targetDir + "/")) continue;
            Jar jar2 = new Jar();
            jar2.from = new File(path);
            jar2.name = jar2.from.getName();
            jar2.to = new File(distDir, jar2.name);
            jar2.description = " ";
            jar2.projectUrl = null;
            Iterator a = this.artifactMap.values().iterator();
            while (a.hasNext()) {
                Artifact af = (Artifact)a.next();
                if (!jar2.name.startsWith(af.getArtifactId() + "-" + af.getVersion())) continue;
                jar2.artifact = af;
                jar2.projectUrl = "dependencies.html#" + jar2.artifact.getGroupId() + ":" + jar2.artifact.getArtifactId() + ":" + jar2.artifact.getType();
                break;
            }
            jars.add(jar2);
        }
        return jars;
    }

    protected long copy(File from, File to) throws MavenReportException, IOException {
        int len;
        this.getLog().debug((CharSequence)(" Copy \"" + from + "\" to \"" + to + "\"."));
        long size = from.length();
        byte[] buf = new byte[65536];
        FileInputStream fi = new FileInputStream(from);
        FileOutputStream fo = new FileOutputStream(to);
        while ((len = fi.read(buf)) >= 0) {
            fo.write(buf, 0, len);
        }
        return size;
    }

    protected void copyJARsAndGenerateReport(List jars, Locale locale) throws MavenReportException {
        try {
            this.getLog().info((CharSequence)("Copy jars to directory \"" + this.jarsDirectoryRelativeURL + "\"."));
            Iterator i = jars.iterator();
            while (i.hasNext()) {
                Jar jar = (Jar)i.next();
                jar.size = this.copy(jar.from, jar.to);
            }
            new WebLaunchRenderer(jars, locale).render();
        }
        catch (IOException ex) {
            this.getLog().error((Throwable)ex);
            throw new MavenReportException("Fails coping jars", (Exception)ex);
        }
    }

    private void putSubparameter(Map map, Locale locale, String subparam, Object dflt) {
        Map res = this.localizedResources;
        map.put(subparam, dflt);
        if (res != null) {
            Object o = res.get(subparam);
            if (o != null) {
                map.put(subparam, o);
            }
            if ((o = res.get(subparam + "." + locale.getLanguage())) != null) {
                map.put(subparam, o);
            }
            if ((o = res.get(subparam + "." + locale.toString())) != null) {
                map.put(subparam, o);
            }
        }
    }

    protected Map getLocalizedSubparameters(Locale locale) {
        this.getLog().info((CharSequence)("  LocalizedResources: " + this.localizedResources));
        Map res = this.localizedResources;
        HashMap map = new HashMap();
        this.putSubparameter(map, locale, SUBPARAM_TITLE, this.project.getName());
        this.putSubparameter(map, locale, SUBPARAM_VENDOR, this.project.getGroupId());
        this.putSubparameter(map, locale, SUBPARAM_DESCRIPTION_TOOLTIP, this.project.getName());
        this.putSubparameter(map, locale, SUBPARAM_DESCRIPTION_ONE_LINE, this.project.getDescription());
        this.putSubparameter(map, locale, SUBPARAM_DESCRIPTION_SHORT, this.project.getDescription());
        this.putSubparameter(map, locale, SUBPARAM_HOMEPAGE, this.project.getUrl());
        this.putSubparameter(map, locale, SUBPARAM_ICON, null);
        this.putSubparameter(map, locale, SUBPARAM_ICON_SPLASH, null);
        this.putSubparameter(map, locale, SUBPARAM_SHORTCUT_DESKTOP, null);
        this.putSubparameter(map, locale, SUBPARAM_SHORTCUT_MENU, null);
        this.putSubparameter(map, locale, SUBPARAM_RELATED_CONTENTS, null);
        this.getLog().info((CharSequence)"  Effective LocalizedParameters:");
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.getLog().info((CharSequence)("    " + key + "=" + map.get(key)));
        }
        return map;
    }

    protected void generateAppletHtml(List jars, String genDir, Locale locale) throws MavenReportException {
        File genFileName = new File(this.siteDirectory, this.appletLauncherFilename);
        this.getLog().info((CharSequence)("Generate applet html \"" + genFileName + "\"."));
    }

    protected void generateWebstartJnlp(final List jars, final String genDir, final Locale locale) throws MavenReportException {
        File outputDir = genDir != null ? new File(this.siteDirectory, genDir) : new File(this.siteDirectory);
        outputDir.mkdir();
        final File outputFile = new File(outputDir, this.webstartLauncherFilename);
        final Map subparams = this.getLocalizedSubparameters(locale);
        this.getLog().info((CharSequence)("Generate Webstart JNLP launcher \"" + outputFile + "\"."));
        LauncherGnerator g = new LauncherGnerator(){

            protected File getOutputFile() throws MavenReportException {
                return outputFile;
            }

            protected Locale getLocale() throws MavenReportException {
                return locale;
            }

            private String createJarElements() {
                StringBuffer sb = new StringBuffer();
                if (jars != null) {
                    Iterator i = jars.iterator();
                    while (i.hasNext()) {
                        Jar jar = (Jar)i.next();
                        sb.append("    <jar href=\"");
                        sb.append(MakePageMojo.this.jarsDirectoryRelativeURL);
                        sb.append("/");
                        sb.append(jar.name);
                        sb.append("\" />");
                        sb.append(MakePageMojo.EOL);
                    }
                }
                return sb.toString();
            }

            private String createApplicationDesc() {
                StringBuffer sb = new StringBuffer();
                if (MakePageMojo.this.webstartMainClass != null) {
                    sb.append("  <application-desc main-class=\"");
                    sb.append(MakePageMojo.this.webstartMainClass);
                    sb.append("\" />");
                    sb.append(MakePageMojo.EOL);
                    if (MakePageMojo.this.webstartArgs != null) {
                        Iterator j = MakePageMojo.this.webstartArgs.iterator();
                        while (j.hasNext()) {
                            String arg = (String)j.next();
                            sb.append("    <argument>");
                            sb.append(arg == null ? "" : arg);
                            sb.append("</argument>");
                            sb.append(MakePageMojo.EOL);
                        }
                    }
                    sb.append("  </application-desc>");
                    sb.append(MakePageMojo.EOL);
                }
                return sb.toString();
            }

            private String createAppletDesc() {
                StringBuffer sb = new StringBuffer();
                if (MakePageMojo.this.appletMainClass != null) {
                    sb.append("  <applet-desc main-class=\"");
                    sb.append(MakePageMojo.this.appletMainClass);
                    sb.append("\" name=\"");
                    sb.append(MakePageMojo.this.appletName);
                    sb.append("\" width=\"");
                    sb.append(MakePageMojo.this.appletWidth);
                    sb.append("\" height=\"");
                    sb.append(MakePageMojo.this.appletHeight);
                    sb.append("\" />");
                    sb.append(MakePageMojo.EOL);
                    if (MakePageMojo.this.webstartArgs != null) {
                        Iterator j = MakePageMojo.this.appletArgs.keySet().iterator();
                        while (j.hasNext()) {
                            String name = (String)j.next();
                            String value = (String)MakePageMojo.this.appletArgs.get(name);
                            if (name == null || value == null) continue;
                            sb.append("    <param name=\"");
                            sb.append(name);
                            sb.append("\" value=\"");
                            sb.append(value);
                            sb.append("\">");
                            sb.append(MakePageMojo.EOL);
                        }
                    }
                    sb.append("  </applet-desc>");
                    sb.append(MakePageMojo.EOL);
                }
                return sb.toString();
            }

            private String createShortcutAndRelatedContents() {
                StringBuffer sb = new StringBuffer();
                String desktop = (String)subparams.get(MakePageMojo.SUBPARAM_SHORTCUT_DESKTOP);
                String menu = (String)subparams.get(MakePageMojo.SUBPARAM_SHORTCUT_DESKTOP);
                List conts = (List)subparams.get(MakePageMojo.SUBPARAM_RELATED_CONTENTS);
                if (desktop != null || menu != null) {
                    sb.append("    <shortcut online=\"false\">");
                    sb.append(MakePageMojo.EOL);
                    if (desktop != null) {
                        sb.append("      <desktop/>");
                    }
                    sb.append(MakePageMojo.EOL);
                    if (menu != null) {
                        sb.append("      <menu submenu=\"" + menu + "\"/>");
                    }
                    sb.append(MakePageMojo.EOL);
                    sb.append("    </shortcut>");
                    sb.append(MakePageMojo.EOL);
                }
                return sb.toString();
            }

            protected void writeTo(Writer w) throws MavenReportException, IOException {
                String icon = (String)subparams.get(MakePageMojo.SUBPARAM_ICON);
                String icon_splash = (String)subparams.get(MakePageMojo.SUBPARAM_ICON_SPLASH);
                String wscodebase = MakePageMojo.this.localCodebase ? "file:///" + MakePageMojo.this.siteDirectory.replace(File.separator, "/") : MakePageMojo.this.codebase;
                String jnlp = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<!-- Encoding Fixer: \u5384 \u866b \u9000 \u6563 -->\r\n<!-- WebLaunch generated JNLP File  Locale=" + locale + " -->" + MakePageMojo.EOL + "<jnlp" + "  spec=\"" + MakePageMojo.this.webstartSpec + "\"" + MakePageMojo.EOL + "  codebase=\"" + wscodebase + "\"" + MakePageMojo.EOL + "  href=\"" + (genDir != null ? genDir + "/" : "") + MakePageMojo.this.webstartLauncherFilename + "\">" + MakePageMojo.EOL + "  <information>" + MakePageMojo.EOL + "    <title>" + subparams.get(MakePageMojo.SUBPARAM_TITLE) + "</title>" + MakePageMojo.EOL + "    <vendor>" + subparams.get(MakePageMojo.SUBPARAM_VENDOR) + "</vendor>" + MakePageMojo.EOL + "    <homepage href=\"" + subparams.get(MakePageMojo.SUBPARAM_HOMEPAGE) + "\"/>" + MakePageMojo.EOL + "    <description kind=\"short\">" + subparams.get(MakePageMojo.SUBPARAM_DESCRIPTION_SHORT) + "</description>" + MakePageMojo.EOL + "    <description>" + subparams.get(MakePageMojo.SUBPARAM_DESCRIPTION_ONE_LINE) + "</description>" + MakePageMojo.EOL + "    <description kind=\"tooptip\">" + subparams.get(MakePageMojo.SUBPARAM_DESCRIPTION_TOOLTIP) + "</description>" + (icon != null ? "\r\n    <icon href=\"images/swingset2.jpg\"/>" : "") + (icon_splash != null ? "\r\n    <icon kind=\"splash\" href=\"images/splash.gif\"/>" : "") + (MakePageMojo.this.webstartOfflineAllowed ? "\r\n    <offline-allowed/> " : "") + MakePageMojo.EOL + MakePageMojo.EOL + this.createShortcutAndRelatedContents() + "  </information>" + MakePageMojo.EOL + "  <resources>" + MakePageMojo.EOL + "    <j2se version=\"1.2+\" />" + MakePageMojo.EOL + this.createJarElements() + "  </resources>" + MakePageMojo.EOL + MakePageMojo.EOL + this.createApplicationDesc() + MakePageMojo.EOL + this.createAppletDesc() + MakePageMojo.EOL + "</jnlp> " + MakePageMojo.EOL;
                w.write(jnlp);
            }
        };
        g.generate();
    }

    protected abstract class LauncherGnerator {
        protected LauncherGnerator() {
        }

        protected abstract File getOutputFile() throws MavenReportException;

        protected abstract Locale getLocale() throws MavenReportException;

        protected abstract void writeTo(Writer var1) throws MavenReportException, IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void generate() throws MavenReportException {
            MakePageMojo.this.getLog().info((CharSequence)(" Generate the launcher \"" + this.getOutputFile().getName() + "\"."));
            MakePageMojo.this.getLog().debug((CharSequence)(" writing \"" + this.getOutputFile() + "\"."));
            try {
                Writer w = null;
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(this.getOutputFile());
                    w = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                    this.writeTo(w);
                    w.flush();
                }
                finally {
                    try {
                        if (w != null) {
                            w.close();
                        }
                    }
                    finally {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                MakePageMojo.this.getLog().error((Throwable)ex);
                throw new MavenReportException("Fails coping jars", (Exception)ex);
            }
        }
    }

    protected class WebLaunchRenderer
    extends AbstractMavenReportRenderer {
        private final Locale locale;
        private List jars;

        public WebLaunchRenderer(List jars, Locale locale) {
            super(MakePageMojo.this.getSink());
            this.jars = jars;
            this.locale = locale;
        }

        public String getTitle() {
            return "Launcher Info of " + MakePageMojo.this.project.getName();
        }

        public void renderBody() {
            Sink sink = MakePageMojo.this.getSink();
            this.startSection(this.getTitle());
            sink.section2();
            sink.sectionTitle2();
            this.text("Supported type of launching");
            sink.sectionTitle2_();
            this.startTable();
            this.tableHeader(new String[]{"Launch Type", "Launch Test"});
            sink.text(MakePageMojo.EOL);
            sink.rawText("<!-- WebStartApplication -->");
            sink.tableRow();
            this.tableCell("WebStart application");
            sink.tableCell();
            if (MakePageMojo.this.webstartMainClass != null) {
                sink.rawText("[<a href=\"" + MakePageMojo.this.webstartLauncherFilename + "\">launch</a>]");
            } else {
                sink.text("N/A");
            }
            sink.tableCell_();
            sink.tableRow_();
            sink.text(MakePageMojo.EOL);
            sink.text(MakePageMojo.EOL);
            sink.rawText("<!-- WebStart applet -->");
            sink.tableRow();
            this.tableCell("WebStart applet");
            sink.tableCell();
            if (MakePageMojo.this.appletMainClass != null) {
                sink.rawText("[<a href=\"" + MakePageMojo.this.webstartLauncherFilename + "\">launch</a>]");
            } else {
                sink.text("N/A");
            }
            sink.tableCell_();
            sink.tableRow_();
            sink.text(MakePageMojo.EOL);
            sink.text(MakePageMojo.EOL);
            sink.rawText("<!-- Raw Applet -->");
            sink.tableRow();
            this.tableCell("Raw Applet");
            sink.tableCell();
            sink.text("N/A");
            sink.tableCell_();
            sink.tableRow_();
            sink.text(MakePageMojo.EOL);
            sink.text(MakePageMojo.EOL);
            sink.rawText("<!--Binaries  -->");
            this.endTable();
            sink.section2_();
            sink.section2();
            sink.sectionTitle2();
            this.text("The binaries");
            sink.sectionTitle2_();
            this.startTable();
            this.tableHeader(new String[]{"Jar", "Byte", "Version"});
            Iterator i = this.jars.iterator();
            while (i.hasNext()) {
                Jar jar = (Jar)i.next();
                sink.tableRow();
                sink.tableCell();
                if (jar.artifact == null) {
                    this.text(jar.name);
                } else {
                    this.link(jar.projectUrl, jar.name);
                }
                sink.tableCell_();
                this.tableCell(MessageFormat.format("{0}", new Long(jar.size)));
                if (jar.artifact == null) {
                    this.tableCell(" ");
                } else {
                    this.tableCell(jar.artifact.getVersion());
                }
                sink.tableRow_();
            }
            this.endTable();
            sink.section2_();
            this.endSection();
        }
    }

    protected static class Jar {
        String name;
        File from;
        File to;
        Artifact artifact = null;
        String description;
        String projectUrl;
        long size;

        protected Jar() {
        }
    }
}

