<?php
/*
Casual Web API Programig Library
PHP Web Search
Web検索API類
class php_web_search・・・Web検索
*/

/*
php_item_search
あらゆるAPIからの商品情報検索のclass
*/

// エラー表示しない。デバッグの時はコメントアウトすること
//ini_set('error_reporting', E_ALL | E_STRICT);
//ini_set('display_errors', 'off');

class php_web_search {

/*
Web検索返り値初期設定
*/
public $hits="";
public $resultcount="";
public $totalpage="";
public $title= array();
public $clickurl= array();
public $directlinkurl= array();
public $cachelinkurl= array();
public $refererlinkurl= array();
public $imgurl= array();
public $description= array();

/*
request_webapi
あらゆるWeb検索系APIのメソッド
*/
function request_webapi($useapi,$params) {

/*
外部ファイルロード
*/
require_once("php_api_func.php");
require_once("php_apikey_define.php");
require_once("php_api_baseurl.php");
require_once("php_api_version.php");

switch ($useapi) {
    case "yahoo_web_premium_search":
/*
YAHOO!Web検索API（プレミアム会員）の場合
*/
// リクエストURLの組み立て
$baseurl = WAPL_YP_WEBSEARCH_BASEURL;
$params['appid'] = $yahoo_upgrade_appid;
$canonical_string = '';
foreach ($params as $k => $v) {
    $canonical_string .= '&'.urlencode_rfc3986($k).'='.urlencode_rfc3986($v);
}
$canonical_string = substr($canonical_string, 1);
$ywsurl = $baseurl.'?'.$canonical_string;

// リクエスト
$ywsBuff = file_get_contents($ywsurl);
$xml = simplexml_load_string ($ywsBuff);

// プロパティ定義
$this->hits = $xml->Result;
$this->resultcount = intval($xml["totalResultsAvailable"]);
$this->totalpage = intval($xml["totalResultsAvailable"]/10);

// YAHOO!Web検索API（プレミアム会員）検索結果を配列変数に代入するメソッドを呼び出し
$this->yahoopremiumwebhit();
break;// YAHOO!Web検索API（プレミアム会員）ここまで


    case "yahoo_img_premium_search":
/*
YAHOO!画像検索API（プレミアム会員）の場合
*/
// リクエストURLの組み立て
$baseurl = WAPL_YP_IMGSEARCH_BASEURL;
$params['appid'] = $yahoo_upgrade_appid;
$canonical_string = '';
foreach ($params as $k => $v) {
    $canonical_string .= '&'.urlencode_rfc3986($k).'='.urlencode_rfc3986($v);
}
$canonical_string = substr($canonical_string, 1);
$ywsurl = $baseurl.'?'.$canonical_string;

// リクエスト
$ywsBuff = file_get_contents($ywsurl);
$xml = simplexml_load_string ($ywsBuff);

// プロパティ定義
$this->hits = $xml->Result;
$this->resultcount = intval($xml["totalResultsAvailable"]);
$this->totalpage = intval($xml["totalResultsAvailable"]/10);

// YAHOO!画像検索API（プレミアム会員）検索結果を配列変数に代入するメソッドを呼び出し
$this->yahoopremiumimghit();
break;// YAHOO!画像検索API（プレミアム会員）ここまで



    case "yahoo_video_search":
/*
YAHOO!動画検索APIの場合
*/
// リクエストURLの組み立て
$baseurl = WAPL_Y_VIDEOSEARCH_BASEURL;
$params['appid'] = $yahooappid;
$canonical_string = '';
foreach ($params as $k => $v) {
    $canonical_string .= '&'.urlencode_rfc3986($k).'='.urlencode_rfc3986($v);
}
$canonical_string = substr($canonical_string, 1);
$ywsurl = $baseurl.'?'.$canonical_string;

// リクエスト
$ywsBuff = file_get_contents($ywsurl);
$xml = simplexml_load_string ($ywsBuff);

// プロパティ定義
$this->hits = $xml->Result;
$this->resultcount = intval($xml["totalResultsAvailable"]);
$this->totalpage = intval($xml["totalResultsAvailable"]/10);

// YAHOO!動画検索API検索結果を配列変数に代入するメソッドを呼び出し
$this->yahoovideohit();
break;// YAHOO動画検索APIここまで

}

// xmlの値を返す
return $xml;
}//request_webapi function(method)


// リクエスト後のYAHOO!Web検索API（プレミアム会員）検索データを配列変数に格納
function yahoopremiumwebhit() {
foreach ($this->hits as $hit) {

$this->title[] = h($hit->Title);
$this->clickurl[] = h($hit->ClickUrl);
$this->directlinkurl[] = h($hit->Url);
$this->cachelinkurl[] = h($hit->Cache->Url);
$this->refererlinkurl[] = "";
$this->imgurl[] = "";//画像キャプチャー系のAPI使用するとか
$this->description[]= h($hit->Summary);

}// foreach
}// function yahoopremiumwebhit

// リクエスト後のYAHOO!画像検索API（プレミアム会員）検索データを配列変数に格納
function yahoopremiumimghit() {
foreach ($this->hits as $hit) {

$this->title[] = h($hit->Title);
$this->clickurl[] = h($hit->ClickUrl);
$this->directlinkurl[] = h($hit->Url);
$this->cachelinkurl[] = h($hit->Cache->Url);
$this->refererlinkurl[] = h($hit->RefererUrl);
$this->imgurl[] = h($hit->Url);
$this->description[]= h($hit->Summary);

}// foreach
}// function yahoopremiumimghit


// リクエスト後のYAHOO!動画検索API検索データを配列変数に格納
function yahoovideohit() {
foreach ($this->hits as $hit) {

$this->title[] = h($hit->Title);
$this->clickurl[] = h($hit->RefererUrl);
$this->directlinkurl[] = h($hit->RefererUrl);
$this->cachelinkurl[] = h($hit->Cache->Url);
$this->refererlinkurl[] = h($hit->RefererUrl);
$this->imgurl[] = h($hit->Thumbnail->Url);
$this->description[]= h($hit->Summary);

}// foreach
}// function yahoopremiumimghit


function DrawPageItem () {
$ret ="";
foreach ($this->title as $key => $value) {
// 通常テンプレートの場合
$ret .= '<a href="'. $this->clickurl[$key].'" target="_blank">';
$ret .="<h3>{$this->title[$key]}</h3>";
$ret .= '</a>';
if (!$this->imgurl[$key]=="") {
$ret .= '<a href="'. $this->clickurl[$key].'" target="_blank"><img src="'.$this->imgurl[$key].'"></a><br>';
$ret .= '<a href="'. $this->refererlinkurl[$key].'" target="_blank">参照元：'.$this->refererlinkurl[$key].'</a><br>';
}
$ret .=  $this->description[$key];
$ret .=  "<br />";
$ret .= '<a href="'. $this->clickurl[$key].'" target="_blank">';
$ret .=  $this->directlinkurl[$key];
$ret .= '</a>';
$ret .=  '<div class="vc-pic">&nbsp;</div>';
} //foreach

return $ret;
}// DrawPageItem func

}// class php_item_search




?>