<?php
/*
Casual Web API Programig Library
PHP Item Search
商品検索API類
class php_item_search・・・商品検索
*/

/*
php_item_search
あらゆるAPIからの商品情報検索のclass
*/

// エラー表示しない。デバッグの時はコメントアウトすること
ini_set('error_reporting', E_ALL | E_STRICT);
ini_set('display_errors', 'off');

class php_item_search {

/*
商品情報検索返り値初期設定
*/
public $hits="";
public $resultcount="";
public $totalpage="";
public $aflinkurl= array();
public $imgurl= array();
public $price= array();
public $description= array();
public $shopname= array();
public $vcpvimg= array();
public $directlinkurl= array();
public $jancode= array();
public $souryou= array();
public $reviewnum= array();
public $reviewavr= array();
public $reviewurl= array();
public $faviconurl= array();

/*
request_webapi
あらゆる商品検索系APIのメソッド
*/
function request_webapi($useapi,$params) {

/*
外部ファイルロード
*/
require_once("php_api_func.php");
require_once("php_apikey_define.php");
require_once("php_api_baseurl.php");
require_once("php_api_version.php");

switch ($useapi) {
    case "rws_item_search":
/*
楽天市場の場合
*/
// リクエストURLの組み立て
$baseurl = WAPL_RWS_ITEMSEARCH_BASEURL;
$params['developerId'] = $rwsdevid;
$params['operation'] = 'ItemSearch';
$params['version'] = WAPL_RWS_ITEMSEARCH_VER;
$params['affiliateId'] = $rwsaffid;
$canonical_string = '';
foreach ($params as $k => $v) {
    $canonical_string .= '&'.urlencode_rfc3986($k).'='.urlencode_rfc3986($v);
}
$canonical_string = substr($canonical_string, 1);
$rwsurl = $baseurl.'?'.$canonical_string;

// リクエスト
$rwsBuff = file_get_contents($rwsurl);
$rwsBuff = str_replace('header:Header','headerHeader',$rwsBuff);
$rwsBuff = str_replace('itemSearch:ItemSearch','itemSearchItemSearch',$rwsBuff);
$xml = simplexml_load_string ($rwsBuff);

// プロパティ定義
$this->hits = $xml->Body->itemSearchItemSearch->Items->Item;
$this->resultcount = intval($xml->Body->itemSearchItemSearch->count);
$this->totalpage = intval($xml->Body->itemSearchItemSearch->pageCount);

// 楽天市場商品検索結果を配列変数に代入するメソッドを呼び出し
$this->rakutenichibaitemhit();
break;// 楽天市場ここまで

    case "ls_crossover_search":
/*
リンクシェアの場合
*/
// リクエストURLの組み立て
$baseurl = WAPL_LS_CROSSOVERSEARCH_BASEURL;
$params['token'] = $lstoken;
$canonical_string = '';
foreach ($params as $k => $v) {
    $canonical_string .= '&'.urlencode_rfc3986($k).'='.urlencode_rfc3986($v);
}
$canonical_string = substr($canonical_string, 1);
$lsurl = $baseurl.'?'.$canonical_string;

// リクエスト
$lsBuff = file_get_contents($lsurl);
$xml = simplexml_load_string ($lsBuff);

// プロパティ定義
$this->hits = $xml->item;
$this->resultcount = intval($xml->TotalMatches);
$this->totalpage = intval($xml->TotalPages);

// リンクシェア商品検索結果を配列変数に代入するメソッドを呼び出し
$this->linkshareitemhit();
break;// リンクシェアここまで

    case "vc_item_search":
/*
バリューコマースの場合
*/
// リクエストURLの組み立て
$baseurl = WAPL_VC_ITEMSEARCH_BASEURL;
$params['token'] = $vctoken;
$canonical_string = '';
foreach ($params as $k => $v) {
    $canonical_string .= '&'.urlencode_rfc3986($k).'='.urlencode_rfc3986($v);
}
$canonical_string = substr($canonical_string, 1);
$vcurl = $baseurl.'?'.$canonical_string;

// リクエスト
$vcBuff = file_get_contents($vcurl);
$vcBuff = str_replace('vc:', 'vc', $vcBuff);
$vcBuff = str_replace('&', '&amp;', $vcBuff);
$xml = simplexml_load_string ($vcBuff);

// プロパティ定義
$this->hits = $xml->channel->item;
$this->resultcount = intval($xml->channel->vcresultcount);
$this->totalpage = intval($xml->channel->vcpagecount);

// バリューコマース商品検索結果を配列変数に代入するメソッドを呼び出し
$this->valuecommerceitemhit();
break;// バリューコマースここまで


    case "ys_item_search":
/*
YAHOO!ショッピング商品検索の場合
*/
// リクエストURLの組み立て
$baseurl = WAPL_YS_ITEMSEARCH_BASEURL;
$params['appid'] = $yahooappid;
$params['affiliate_from'] = "2.0";
$params['affiliate_type'] = "vc";
$params['affiliate_id'] = "http%3A%2F%2Fck.jp.ap.valuecommerce.com%2Fservlet%2Freferral%3Fsid%3D" . $ysh_sid . "%26pid%3D" . $ysh_pid . "%26vc_url%3D";

$canonical_string = '';
foreach ($params as $k => $v) {
    $canonical_string .= '&'.urlencode_rfc3986($k).'='.urlencode_rfc3986($v);
}
$canonical_string = substr($canonical_string, 1);
$ysurl = $baseurl.'?'.$canonical_string;

// リクエスト
$ysBuff = file_get_contents($ysurl);
$xml = simplexml_load_string ($ysBuff);

// プロパティ定義
$this->hits = $xml->Result->Hit;
$this->resultcount = intval($xml["totalResultsAvailable"]);
$this->totalpage = intval($xml["totalResultsAvailable"]/10);//1ページあたりの表示件数要調整
// YAHOO!ショッピング商品検索結果を配列変数に代入するメソッドを呼び出し
$this->yshopping_itemhit();
break;// YAHOO!ショッピング商品検索ここまで


    case "amazon_item_search":
/*
Amazon商品検索の場合
*/
// リクエストURLの組み立て
$baseurl = WAPL_AMAZON_ITEMSEARCH_BASEURL;
$params['Service']        = 'AWSECommerceService';
$params['Version']        = '2009-10-01';
$params['AWSAccessKeyId'] = $awsacckey;
$params['AssociateTag']   = $awsassid;
$params['Operation']      = 'ItemSearch';
$params['ContentType']   = 'text/xml';
$params['Timestamp'] = gmdate('Y-m-d\TH:i:s\Z');
// パラメータの順序を昇順に並び替えます
ksort($params);
$canonical_string = '';
foreach ($params as $k => $v) {
    $canonical_string .= '&'.urlencode_rfc3986($k).'='.urlencode_rfc3986($v);
}
$canonical_string = substr($canonical_string, 1);

$parsed_url = parse_url($baseurl);
$string_to_sign = "GET\n{$parsed_url['host']}\n{$parsed_url['path']}\n{$canonical_string}";
$signature = base64_encode(hash_hmac('sha256', $string_to_sign, $awsseckey, true));
$awsurl = $baseurl.'?'.$canonical_string.'&Signature='.urlencode_rfc3986($signature);

// リクエスト
$awsBuff = file_get_contents($awsurl);
$xml = simplexml_load_string ($awsBuff);

// プロパティ定義
$this->hits = $xml->Items->Item;
$this->resultcount = intval($xml->Items->TotalResults);
$this->totalpage = intval($xml->Items->TotalPages);//1ページあたりの表示件数要調整

// Amazon商品検索結果を配列変数に代入するメソッドを呼び出し
$this->amazon_itemhit();
break;// Amazon商品検索ここまで
}

// xmlの値を返す
return $xml;
}//request_webapi function(method)


// リクエスト後の楽天市場商品検索データを配列変数に格納
function rakutenichibaitemhit() {
foreach ($this->hits as $hit) {
$this->itemname[] = h($hit->itemName);
$this->aflinkurl[] = h($hit->affiliateUrl);
if (strlen($hit->mediumImageUrl)) {
	$this->imgurl[] = h($hit->mediumImageUrl);
} else {
	$this->imgurl[] = "c_img/noimage.gif";
}
$this->price[] = h($hit->itemPrice);
$this->description[] = h($hit->itemCaption);
$this->shopname[] = h($hit->shopName);
$this->vcpvimg[]=" ";
$this->directlinkurl[]="";
$this->jancode[]="";
//送料フラグ 	postageFlag 	0：送料込
//1：送料別
if ($hit->postageFlag == 0) {
	$this->souryou[] = "送料無料";
} else {
	$this->souryou[] = "送料別";
}
$this->reviewnum[] = h($hit->reviewCount);
$this->reviewavr[] = h($hit->reviewAverage);
$this->reviewurl[] = "";
$this->faviconurl[] = "http://www.rakuten.co.jp/";
}// foreach
}// function rakutenichibaitemhit


// リクエスト後のリンクシェア商品検索データを配列変数に格納
function linkshareitemhit() {
foreach ($this->hits as $hit) {
if (!is_numeric(mb_strpos($hit->merchantname,"携帯"))) {
$this->itemname[] = h($hit->productname);
$this->aflinkurl[] = $hit->linkurl;
if (strlen($hit->imageurl)) {
	$this->imgurl[] = h($hit->imageurl);
} else {
	$this->imgurl[] = "c_img/noimage.gif";
}

$this->price[] = h($hit->price);
$this->description[] = h($hit->description->long);
$this->shopname[] = h($hit->merchantname);
$this->vcpvimg[]="";
$this->directlinkurl[]="";
$this->jancode[]="";
$this->souryou[] = "";
$this->reviewnum[] = "";
$this->reviewavr[] = "";
$this->reviewurl[] = "";
$this->faviconurl[] = h($hit->imageurl);

}// 携帯除外
}// foreach
}// function linkshareitemhit


// リクエスト後のバリューコマース商品データを配列変数に格納
function valuecommerceitemhit() {
foreach ($this->hits as $hit) {
$this->itemname[] = h($hit->title);
$this->aflinkurl[] = str_replace('&amp;', '&' ,h($hit->link));

// 画像URL取り出し
$img = array();
foreach($hit->vcimage as $vcimg) {
    $img[]=$vcimg["url"];
}

if (strlen($img[1])) {
	$this->imgurl[] = h($img[1]);
} else {
	if (strlen($img[2])) {
		$this->imgurl[] = h($img[2]);
	} else {
		$this->imgurl[] = "/c_img/noimage.gif";
	}
}
$this->price[] = h($hit->vcprice);
$this->description[] = h($hit->description);
// ストア名とサブストア名が一緒ならサブストア名は使わない（ビッダーズとか）
if ($hit->vcmerchantName == $hit->vcsubStoreName) {
$this->shopname[]=h($hit->vcmerchantName);
} else {
$this->shopname[] = h($hit->vcmerchantName) . h($hit->vcsubStoreName);
}
$this->vcpvimg[] = $hit->vcpvImg;
$this->directlinkurl[] = h($hit->directlinkurl);
$this->jancode[] = h($hit->vcjanCode);
$this->souryou[]="";
$this->reviewnum[]="";
$this->reviewavr[]="";
$this->reviewurl[]="";
$this->faviconurl[]=h($hit->directlinkurl);
}//foreach

return;
}// function valuecommerceitemhit



// リクエスト後のYahooショッピング商品データを配列変数に格納
function yshopping_itemhit() {
foreach ($this->hits as $hit) {
$this->itemname[] = h($hit->Name);
$this->aflinkurl[] = h($hit->Url);

// 画像URL取り出し
$img = array();
foreach($hit->vcimage as $vcimg) {
    $img[]=$vcimg["url"];
}

if ($hit->Store->Id == "engei" or $hit->Store->Id == "dinos" or $hit->Store->Id == "fobcoop" or $hit->Store->Id == "ottojapan") {
	$this->imgurl[] = "c_img/linksakidegazo.gif";
} else {
	$this->imgurl[] = h($hit->Image->Medium);
}

$this->price[] = h($hit->Price);
$this->description[] = h($hit->Description);
$this->shopname[]=h($hit->Store->Name);
$this->vcpvimg[] = $hit->vcpvImg;
$this->directlinkurl[] = h($hit->directlinkurl);
$this->jancode[] = h($hit->vcjanCode);
$this->souryou[]=h($hit->Shipping->Name);
$this->reviewnum[]=h($hit->Review->Count);
$this->reviewavr[]=h($hit->Review->Rate);
$this->reviewurl[]=h($hit->Review->Url);
$this->faviconurl[]="http://shopping.yahoo.co.jp/";
}//foreach

return;
}// function yshopping_itemhit



// リクエスト後のAmazon商品データを配列変数に格納
function amazon_itemhit() {
foreach ($this->hits as $hit) {
$this->itemname[] = h($hit->ItemAttributes->Title);
$this->aflinkurl[] = h($hit->DetailPageURL);
$this->imgurl[] = h($hit->MediumImage->URL);
$this->price[] = h($hit->OfferSummary->LowestNewPrice->Amount);
$this->description[] = h($hit->EditorialReviews->EditorialReview->Content);
$this->shopname[] = "Amazon.co.jp";
$this->vcpvimg[]="";
$this->directlinkurl[]="";
$this->jancode[]= "";
$this->souryou[] = "";
$this->reviewnum[] = h($hit->CustomerReviews->TotalReviews);
$this->reviewavr[] = h($hit->CustomerReviews->AverageRating);
$this->reviewurl[] = "";
$this->faviconurl[] = "http://www.amazon.co.jp/";

}//foreach

return;
}// function yshopping_itemhit


function DrawPageItem () {
/*
$this->itemname,$this->imgurl,$this->linkurl,$this->price,$this->jancode,$this->description,$this->vcpvimg,$this->directlinkurl,$this->shopname,$this->reviewnum,$this->reviewavr,$this->reviewurl,$this->favicon)
*/
$ret ="";
foreach ($this->price as $key => $value) {
// 通常テンプレートの場合
$ret .="<h3>{$this->itemname[$key]}</h3>";
$ret .= '<a href="'. $this->aflinkurl[$key].'" target="_blank"><img src="'.$this->imgurl[$key].'"></a><br>';
 if (!$this->price[$key] == 0) { 
$ret .= '参考価格：<span class="vc-price">'. number_format($this->price[$key]).'円</span><br />';
}
$ret .=  mb_substr ($this->description[$key],0,200,"utf-8");
$ret .=  "...<br />";
if (!$this->reviewnum[$key]=="") {
$ret .=  "レビュー件数".$this->reviewnum[$key]."件　";
}
if (!$this->reviewavr[$key]=="") {
$ret .=  "レビュー平均点".$this->reviewavr[$key]."点　";
}

$ret .=  "<br />";
//$ret .=  $this->jancode[$key];
$ret .=  '<a href="'. $this->aflinkurl[$key].'" target="_blank">この商品の詳細はこちら'.$this->vcpvimg[$key].'</a><br />';
$ret .=  '<img src="http://favicon.hatena.ne.jp/?url='.urlencode($this->faviconurl[$key]).'" />'.$this->shopname[$key]; 
$ret .=  '<div class="vc-pic">&nbsp;</div>';
} //foreach

return $ret;
}// DrawPageItem func



function DrawShowCase () {
/*
$this->itemname,$this->imgurl,$this->linkurl,$this->price,$this->jancode,$this->description,$this->vcpvimg,$this->directlinkurl,$this->shopname,$this->reviewnum,$this->reviewavr,$this->reviewurl,$this->favicon)
*/
$ret ="";
foreach ($this->price as $key => $value) {
// ショーケースの場合

$ret .='<div class="span3" style="height:400px;">';
$ret .= '<a href="'. $this->aflinkurl[$key].'" target="_blank"><img src="'.$this->imgurl[$key].'"></a><br>';
$ret .="<h4>{$this->itemname[$key]}</h4>";

 if (!$this->price[$key] == 0) { 
$ret .= '参考価格：<span class="vc-price">'. number_format($this->price[$key]).'円</span><br />';
}
$ret .=  mb_substr ($this->description[$key],0,50,"utf-8");
$ret .=  "...<br />";

$ret .=  '<a href="'. $this->aflinkurl[$key].'" target="_blank">この商品の詳細はこちら'.$this->vcpvimg[$key].'</a><br />';
$ret .=  '<img src="http://favicon.hatena.ne.jp/?url='.urlencode($this->faviconurl[$key]).'" />'.$this->shopname[$key]; 
$ret .=  '</div>';
} //foreach

return $ret;
}// DrawShowCase func

}// class php_item_search

/*
共通的に使う配列について

$hits・・・商品情報の配列全体
$itemname・・・商品名
$aflinkurl・・・アフィリエイトリンク
$imgurl・・・画像URL
$price・・・値段、参考価格
$description・・・商品説明
$shopname・・・ECサイト名
$vcpvimg・・・バリューコマースPV計測用用タグ
$directlinkurl・・・商品ページの URL（直リンク）
$jancode・・・JANコード
$souryou・・・送料情報
$reviewnum・・・レビュー数
$reviewavr・・・レビュー平均点
$reviewurl・・・レビューURL
$faviconurl・・・ファビコンURL
$genzai_page, $totalpage, $params, $resultcount
*/


?>