/*
 * Decompiled with CFR 0.152.
 */
package in.lapin.fenrir.WCCFTB;

import in.lapin.fenrir.WCCFTB.MainControl;
import in.lapin.fenrir.WCCFTB.Player;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TeamFrame
implements SelectionListener {
    protected Object result;
    protected Display display;
    protected Shell shell;
    private Table table;
    private TableColumn col1;
    private TableColumn col2;
    private TableColumn col3;
    private TableColumn col4;
    private TableColumn col5;
    private TableColumn col6;
    private TableColumn col7;
    private TableColumn col8;
    private TableColumn col9;
    private TableColumn col10;
    private TableColumn col11;
    private TableColumn col12;
    private TableColumn col13;
    private TableColumn col14;
    private TableColumn col15;
    private TableColumn col16;
    private TableColumn col17;
    private TableColumn col18;
    private TableColumn col19;
    private TableColumn col20;
    private TableColumn col21;
    private TableColumn col22;
    private TableColumn col23;
    private MainControl mcont = null;

    public Object open(final MainControl mcont) {
        this.mcont = mcont;
        this.display = Display.getDefault();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        this.shell.addShellListener(new ShellAdapter(){

            @Override
            public void shellClosed(ShellEvent e) {
                mcont.setTf(null);
            }
        });
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.result;
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.close();
        }
    }

    private void createContents() {
        this.shell = new Shell(this.display, 224);
        this.shell.setSize(1000, 560);
        this.shell.setText("WCCF Team Builder");
        Menu menu = new Menu(this.shell, 8);
        MenuItem itemRed = new MenuItem(menu, 8);
        itemRed.setText("\u30c1\u30fc\u30e0\u304b\u3089\u524a\u9664");
        itemRed.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (TeamFrame.this.mcont.getTeamList().isEmpty()) {
                    return;
                }
                TableItem[] items = TeamFrame.this.table.getSelection();
                Player vo = new Player();
                vo.setVer(items[0].getText(0));
                vo.setNo(items[0].getText(1));
                vo.setName(items[0].getText(2));
                vo.setRarity(items[0].getText(5));
                vo.setKp(items[0].getText(14));
                vo = TeamFrame.this.mcont.getTeamListPlayer(vo);
                TeamFrame.this.mcont.removeTeamList(vo);
                TeamFrame.this.table.removeAll();
                TeamFrame.this.displayData();
                if (TeamFrame.this.mcont.getFf() != null) {
                    TeamFrame.this.mcont.getFf().displayData();
                }
                TeamFrame.this.mcont.setChangeData(true);
            }
        });
        MenuItem itemRed2 = new MenuItem(menu, 8);
        itemRed2.setText("\u3059\u3079\u3066\u524a\u9664");
        itemRed2.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (TeamFrame.this.mcont.getTeamList().isEmpty()) {
                    return;
                }
                ArrayList target = new ArrayList();
                TeamFrame.this.mcont.getTeamList().stream().forEach(vo -> target.add(vo));
                target.stream().forEach(vo -> TeamFrame.this.mcont.removeTeamList((Player)vo));
                TeamFrame.this.table.removeAll();
                TeamFrame.this.displayData();
                if (TeamFrame.this.mcont.getFf() != null) {
                    TeamFrame.this.mcont.getFf().displayData();
                }
                TeamFrame.this.mcont.setChangeData(true);
            }
        });
        this.table = new Table(this.shell, 67584);
        this.table.setBounds(10, 10, 950, 500);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setMenu(menu);
        DragSource source = new DragSource(this.table, 3);
        source.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        source.addDragListener(new DragSourceAdapter(){

            @Override
            public void dragSetData(DragSourceEvent event) {
                event.data = "dummy";
                TableItem[] items = TeamFrame.this.table.getSelection();
                Player vo = new Player();
                vo.setVer(items[0].getText(0));
                vo.setNo(items[0].getText(1));
                vo.setName(items[0].getText(2));
                vo.setRarity(items[0].getText(5));
                vo.setKp(items[0].getText(14));
                vo = TeamFrame.this.mcont.getTeamListPlayer(vo);
                TeamFrame.this.mcont.setPlayer(vo);
            }
        });
        this.addColumn(this.col1, "VER", 80);
        this.addColumn(this.col21, "NO", 80);
        this.addColumn(this.col2, "\u540d\u524d", 240);
        this.addColumn(this.col23, "\u56fd\u7c4d", 180);
        this.addColumn(this.col3, "\u30c1\u30fc\u30e0", 240);
        this.addColumn(this.col4, "\u30ec\u30a2\u30ea\u30c6\u30a3", 100);
        this.addColumn(this.col5, "POS", 50);
        this.addColumn(this.col6, "OFF", 50);
        this.addColumn(this.col7, "DEF", 50);
        this.addColumn(this.col8, "TEC", 50);
        this.addColumn(this.col9, "POW", 50);
        this.addColumn(this.col10, "SPE", 50);
        this.addColumn(this.col11, "STA", 50);
        this.addColumn(this.col12, "TOTAL", 80);
        this.addColumn(this.col13, "KP", 200);
        this.addColumn(this.col22, "SKILL", 200);
        this.addColumn(this.col14, "SS", 40);
        this.addColumn(this.col15, "BP", 40);
        this.addColumn(this.col16, "GK", 40);
        this.addColumn(this.col17, "CAP", 40);
        this.addColumn(this.col18, "FK", 40);
        this.addColumn(this.col19, "CK", 40);
        this.addColumn(this.col20, "PK", 40);
        this.displayData();
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void addColumn(TableColumn tc, String colHeader, int colWidth) {
        tc = new TableColumn(this.table, 0);
        tc.setWidth(colWidth);
        tc.setText(colHeader);
        tc.addSelectionListener(this);
    }

    private String toString(int val) {
        return val == 0 ? "" : String.valueOf(val);
    }

    protected void displayData() {
        List<Player> gAr = this.mcont.getTeamList();
        gAr.stream().forEach(vo -> {
            TableItem item1 = new TableItem(this.table, 0);
            item1.setText(0, vo.getVer());
            item1.setText(1, vo.getNo());
            item1.setText(2, vo.getName());
            item1.setText(3, vo.getCountry());
            item1.setText(4, vo.getTeam());
            item1.setText(5, vo.getRarity());
            item1.setBackground(5, this.mcont.selectColor3(vo.getRarity(), this.display));
            item1.setForeground(5, this.mcont.selectColor4(vo.getRarity(), this.display));
            item1.setText(6, vo.getPos());
            item1.setBackground(6, this.mcont.selectColor1(vo.getPos(), this.display));
            item1.setForeground(6, this.mcont.selectColor2(vo.getPos(), this.display));
            item1.setText(7, this.toString(vo.getOff()));
            item1.setText(8, this.toString(vo.getDef()));
            item1.setText(9, this.toString(vo.getTec()));
            item1.setText(10, this.toString(vo.getPow()));
            item1.setText(11, this.toString(vo.getSpe()));
            item1.setText(12, this.toString(vo.getSta()));
            item1.setText(13, this.toString(vo.getTotal()));
            item1.setText(14, vo.getKp());
            String Skill = this.mcont.getSkill((Player)vo);
            if (!"".equals(Skill) && this.mcont.isUseColor()) {
                item1.setBackground(14, new Color(this.display, 255, 250, 205));
            }
            item1.setText(15, Skill);
            item1.setText(16, vo.getSs());
            item1.setText(17, vo.getBp());
            item1.setText(18, vo.getGk());
            item1.setText(19, vo.getCap());
            item1.setText(20, vo.getFk());
            item1.setText(21, vo.getCk());
            item1.setText(22, vo.getPk());
        });
    }

    protected void removeData() {
        this.table.removeAll();
    }
}

