/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: colrctrl.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: obo $ $Date: 2006/10/12 11:39:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVX_COLRCTRL_HXX
#define _SVX_COLRCTRL_HXX

#ifndef _SFXDOCKWIN_HXX //autogen
#include <sfx2/dockwin.hxx>
#endif
#ifndef _SFX_CHILDWIN_HXX //autogen
#include <sfx2/childwin.hxx>
#endif
#ifndef _VALUESET_HXX //autogen
#include <svtools/valueset.hxx>
#endif
#ifndef _TRANSFER_HXX //autogen
#include <svtools/transfer.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

class XColorTable;
class SvData;

/*************************************************************************
|*
|* SvxColorValueSet
|*
\************************************************************************/

class SvxColorValueSet : public ValueSet, public DragSourceHelper
{
	using ValueSet::StartDrag;

private:

	BOOL			bLeft;
	Point           aDragPosPixel;

protected:

	void            DoDrag();

	// ValueSet
	virtual void	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void	MouseButtonUp( const MouseEvent& rMEvt );
	virtual void    Command(const CommandEvent& rCEvt );

	// DragSourceHelper
	virtual void	StartDrag( sal_Int8 nAction, const Point& rPtPixel );

					DECL_STATIC_LINK(SvxColorValueSet, ExecDragHdl, void*);

public:
					SvxColorValueSet( Window* pParent, WinBits nWinStyle = WB_ITEMBORDER );
					SvxColorValueSet( Window* pParent, const ResId& rResId );

	BOOL			IsLeftButton() const { return bLeft; }
};

/*************************************************************************
|*
|* Ableitung vom SfxChildWindow als "Behaelter" fuer Controller
|*
\************************************************************************/

class SVX_DLLPUBLIC SvxColorChildWindow : public SfxChildWindow
{
 public:
	SvxColorChildWindow( Window*, USHORT, SfxBindings*,
						 SfxChildWinInfo* );

	SFX_DECL_CHILDWINDOW(SvxColorChildWindow);
};

/*************************************************************************
|*
|* SvxColorDockingWindow
|*
\************************************************************************/

class SvxColorDockingWindow : public SfxDockingWindow, public SfxListener
{
 friend class SvxColorChildWindow;

private:
	XColorTable*		pColorTable;
	SvxColorValueSet	aColorSet;
	USHORT				nLeftSlot;
	USHORT				nRightSlot;
	USHORT				nCols;
	USHORT				nLines;
	long				nCount;
	Size				aColorSize;
	Size				aItemSize;

#if 0 // _SOLAR__PRIVATE
	void				FillValueSet();
	void 				SetSize();
						DECL_LINK( SelectHdl, void * );

    /** This function is called when the window gets the focus.  It grabs
        the focus to the color value set so that it can be controlled with
        the keyboard.
    */
	virtual void GetFocus (void);
#endif

protected:
	virtual BOOL	Close();
	virtual void	Resize();
	virtual void	Resizing( Size& rSize );

public:
					SvxColorDockingWindow( SfxBindings* pBindings,
										   SfxChildWindow *pCW,
										   Window* pParent,
										   const ResId& rResId );
					~SvxColorDockingWindow();

	virtual void 	SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							const SfxHint& rHint, const TypeId& rHintType );

	void			SetSlotIDs( USHORT nLeft, USHORT nRight )
						{ nLeftSlot = nLeft; nRightSlot = nRight; }

	virtual long	Notify( NotifyEvent& rNEvt );
};

#endif

