/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.XMLProcessorEx;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.Result;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLProcessorImpl
implements XMLProcessorEx {
    private Parser parser;
    private ErrorHandler errorHandler;

    public XMLProcessorImpl(Parser parser) {
        this.parser = parser;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Node load(InputSource source, int documentIndex, LoadContext context, NameTable nameTable) throws IOException, XSLException {
        try {
            BuilderImpl builder = new BuilderImpl(context, source.getSystemId(), documentIndex, nameTable.getEmptyNamespacePrefixMap(), source);
            this.parser.setDocumentHandler(builder);
            this.parser.setDTDHandler(builder);
            this.parser.parse(source);
            return builder.getRootNode();
        }
        catch (SAXParseException e) {
            throw new XSLException(e);
        }
        catch (SAXException e) {
            Exception wrapped = e.getException();
            if (wrapped == null) {
                throw new XSLException(e.getMessage());
            }
            if (wrapped instanceof XSLException) {
                throw (XSLException)e.getException();
            }
            throw new XSLException(wrapped);
        }
    }

    public Node load(URL url, int documentIndex, LoadContext context, NameTable nameTable) throws IOException, XSLException {
        return this.load(new InputSource(url.toString()), documentIndex, context, nameTable);
    }

    private static Builder createBuilder(String systemId, int documentIndex, LoadContext context, NameTable nameTable) {
        return new BuilderImpl(context, systemId, documentIndex, nameTable.getEmptyNamespacePrefixMap(), null);
    }

    public Result createResult(Node baseNode, int documentIndex, LoadContext loadContext, Node[] rootNode) throws XSLException {
        URL baseURL = null;
        if (baseNode != null) {
            baseURL = baseNode.getURL();
        }
        String base = baseURL == null ? null : baseURL.toString();
        Builder builder = XMLProcessorImpl.createBuilder(base, documentIndex, loadContext, baseNode.getNamespacePrefixMap().getNameTable());
        rootNode[0] = builder.getRootNode();
        return new MultiNamespaceResult(builder, this.errorHandler);
    }

    private static class BuilderImpl
    implements Builder {
        char[] dataBuf = new char[1024];
        int dataBufUsed = 0;
        RootNodeImpl rootNode;
        ContainerNodeImpl currentNode;
        int currentIndex = 1;
        boolean includeProcessingInstructions;
        boolean includeComments;
        LoadContext context;
        InputSource input;
        Locator locator = new NullLocator();

        BuilderImpl(LoadContext context, String systemId, int documentIndex, NamespacePrefixMap nsMap, InputSource input) {
            this.context = context;
            this.input = input;
            this.includeProcessingInstructions = context.getIncludeProcessingInstructions();
            this.includeComments = context.getIncludeComments();
            this.rootNode = new RootNodeImpl(systemId, documentIndex, nsMap);
            this.currentNode = this.rootNode;
        }

        public void startDocument() {
            if (this.rootNode.getURL() == null && this.input != null) {
                String newSysId = this.input.getSystemId();
                this.rootNode.setSystemId(newSysId);
            }
        }

        public void endDocument() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String name, AttributeList atts) throws SAXException {
            ElementNodeImpl element;
            String havelocator;
            this.flushData();
            String space = atts.getValue("xml:space");
            String string = havelocator = this.locator == null ? "n" : "y";
            boolean preserve = space == null ? this.currentNode.preserveSpace() : (space.equals("default") ? false : (space.equals("preserve") ? true : this.currentNode.preserveSpace()));
            try {
                element = preserve ? new PreserveElementNodeImpl(name, atts, this.locator, this.currentIndex++, this.currentNode) : new ElementNodeImpl(name, atts, this.locator, this.currentIndex++, this.currentNode);
            }
            catch (XSLException e) {
                throw new SAXException(e);
            }
            this.currentIndex += atts.getLength();
            this.currentNode = element;
        }

        public void characters(char[] ch, int start, int length) {
            int need = length + this.dataBufUsed;
            if (need > this.dataBuf.length) {
                int newLength;
                for (newLength = this.dataBuf.length << 1; need > newLength; newLength <<= 1) {
                }
                char[] tem = this.dataBuf;
                this.dataBuf = new char[newLength];
                if (this.dataBufUsed > 0) {
                    System.arraycopy(tem, 0, this.dataBuf, 0, this.dataBufUsed);
                }
            }
            while (length > 0) {
                this.dataBuf[this.dataBufUsed++] = ch[start++];
                --length;
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
            if (this.dataBufUsed > 0 || this.currentNode.preserveSpace() || !this.context.getStripSource(this.currentNode.getName())) {
                this.characters(ch, start, length);
            }
        }

        public void endElement(String name) {
            this.flushData();
            this.currentNode = this.currentNode.parent;
        }

        public void processingInstruction(String target, String data) {
            if (target == null) {
                this.comment(data);
            } else if (this.includeProcessingInstructions) {
                this.flushData();
                int n = this.currentIndex++;
                new ProcessingInstructionNodeImpl(target, data, this.locator, n, this.currentNode);
            }
        }

        public void comment(String contents) {
            if (this.includeComments) {
                this.flushData();
                int n = this.currentIndex++;
                new CommentNodeImpl(contents, n, this.currentNode);
            }
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
            this.rootNode.unparsedEntityURITable.put(name, systemId);
        }

        public void notationDecl(String name, String publicId, String systemId) {
        }

        public Node getRootNode() {
            return this.rootNode;
        }

        private static boolean isWhitespace(char[] buf, int len) {
            block3: for (int i = 0; i < len; ++i) {
                switch (buf[i]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        }

        private final void flushData() {
            if (this.dataBufUsed > 0) {
                if (!BuilderImpl.isWhitespace(this.dataBuf, this.dataBufUsed) || this.currentNode.preserveSpace() || !this.context.getStripSource(this.currentNode.getName())) {
                    int n = this.currentIndex++;
                    new TextNodeImpl(this.dataBuf, 0, this.dataBufUsed, n, this.currentNode);
                }
                this.dataBufUsed = 0;
            }
        }
    }

    static interface Builder
    extends DocumentHandler,
    CommentHandler,
    DTDHandler {
        public Node getRootNode();
    }

    private static class ProcessingInstructionNodeImpl
    extends NodeImpl {
        private Name name;
        private String data;
        private String systemId;

        public ProcessingInstructionNodeImpl(String name, String data, Locator loc, int index, ContainerNodeImpl parent) {
            super(index, parent);
            this.systemId = loc.getSystemId();
            this.name = parent.getNamespacePrefixMap().getNameTable().createName(name);
            this.data = data;
        }

        public Name getName() {
            return this.name;
        }

        public byte getType() {
            return 4;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public URL getURL() {
            if (this.systemId != null) {
                try {
                    return new URL(this.systemId);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class CommentNodeImpl
    extends NodeImpl {
        private String data;

        public CommentNodeImpl(String data, int index, ContainerNodeImpl parent) {
            super(index, parent);
            this.data = data;
        }

        public byte getType() {
            return 5;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }
    }

    private static class StripTextNodeImpl
    extends TextNodeImpl {
        public StripTextNodeImpl(char[] buf, int off, int len, int index, ContainerNodeImpl parent) {
            super(buf, off, len, index, parent);
        }

        boolean canStrip() {
            return true;
        }
    }

    private static class TextNodeImpl
    extends NodeImpl {
        private String data;

        public TextNodeImpl(char[] buf, int off, int len, int index, ContainerNodeImpl parent) {
            super(index, parent);
            this.data = new String(buf, off, len);
        }

        public byte getType() {
            return 1;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }
    }

    private static class AttributeNodeImpl
    extends NodeImpl {
        private Name name;
        private String value;

        AttributeNodeImpl(int index, ContainerNodeImpl parent, Name name, String value) {
            this.index = index;
            this.parent = parent;
            this.root = parent.root;
            this.name = name;
            this.value = value;
        }

        public byte getType() {
            return 2;
        }

        public String getData() {
            return this.value;
        }

        public Name getName() {
            return this.name;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof AttributeNodeImpl && ((AttributeNodeImpl)obj).index == this.index;
        }
    }

    private static class PreserveElementNodeImpl
    extends ElementNodeImpl {
        PreserveElementNodeImpl(String name, AttributeList atts, Locator loc, int index, ContainerNodeImpl parent) throws XSLException {
            super(name, atts, loc, index, parent);
        }

        boolean preserveSpace() {
            return true;
        }
    }

    private static class ElementNodeImpl
    extends ContainerNodeImpl {
        private Name name;
        private Object[] atts;
        private int lineNumber;
        private String systemId;

        ElementNodeImpl(String name, AttributeList attList, Locator loc, int index, ContainerNodeImpl parent) throws XSLException {
            super(index, parent);
            this.lineNumber = loc.getLineNumber();
            this.systemId = loc.getSystemId();
            int nAtts = attList.getLength();
            if (nAtts > 0) {
                int nNsAtts = 0;
                for (int i = 0; i < nAtts; ++i) {
                    String tem = attList.getName(i);
                    if (!tem.startsWith("xmlns")) continue;
                    ++nNsAtts;
                    if (tem.length() == 5) {
                        String ns = attList.getValue(i);
                        if (ns.length() == 0) {
                            this.nsMap = this.nsMap.unbindDefault();
                            continue;
                        }
                        this.nsMap = this.nsMap.bindDefault(ns);
                        continue;
                    }
                    if (tem.charAt(5) != ':') continue;
                    this.nsMap = this.nsMap.bind(tem.substring(6), attList.getValue(i));
                }
                int n = nAtts - nNsAtts;
                if (n > 0) {
                    Object[] vec = new Object[n * 2];
                    int j = 0;
                    for (int i = 0; i < nAtts; ++i) {
                        String tem = attList.getName(i);
                        if (!tem.startsWith("xmlns")) {
                            vec[j++] = this.nsMap.expandAttributeName(tem, this);
                            vec[j++] = attList.getValue(i);
                        }
                        if (attList.getType(i).length() != 2) continue;
                        parent.addId(attList.getValue(i), this);
                    }
                    this.atts = vec;
                }
            }
            this.name = this.nsMap.expandElementTypeName(name, this);
        }

        public Name getName() {
            return this.name;
        }

        public byte getType() {
            return 0;
        }

        public SafeNodeIterator getNamespaces() {
            return new NamespaceNodeIterator(this.getNamespacePrefixMap(), this);
        }

        public SafeNodeIterator getAttributes() {
            return new SafeNodeIterator(){
                private int i = 0;

                public Node next() {
                    if (ElementNodeImpl.this.atts == null) {
                        return null;
                    }
                    int i2 = this.i * 2;
                    if (i2 == ElementNodeImpl.this.atts.length) {
                        return null;
                    }
                    return new AttributeNodeImpl(ElementNodeImpl.this.index + ++this.i, ElementNodeImpl.this, (Name)ElementNodeImpl.this.atts[i2], (String)ElementNodeImpl.this.atts[i2 + 1]);
                }
            };
        }

        public Node getAttribute(Name name) {
            if (this.atts != null) {
                for (int i = 0; i < this.atts.length; i += 2) {
                    if (!this.atts[i].equals(name)) continue;
                    return new AttributeNodeImpl(this.index + (i >> 1) + 1, this, name, (String)this.atts[i + 1]);
                }
            }
            return null;
        }

        public String getAttributeValue(Name name) {
            if (this.atts != null) {
                for (int i = 0; i < this.atts.length; i += 2) {
                    if (!this.atts[i].equals(name)) continue;
                    return (String)this.atts[i + 1];
                }
            }
            return null;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public URL getURL() {
            if (this.systemId != null) {
                try {
                    return new URL(this.systemId);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean isId(String name) {
            return this.equals(this.getElementWithId(name));
        }
    }

    private static class NullLocator
    implements Locator {
        private NullLocator() {
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }
    }

    private static class RootNodeImpl
    extends ContainerNodeImpl {
        String systemId;
        int documentIndex;
        Hashtable idTable = new Hashtable();
        Hashtable unparsedEntityURITable = new Hashtable();

        RootNodeImpl(String systemId, int documentIndex, NamespacePrefixMap nsMap) {
            super(nsMap);
            this.systemId = systemId;
            this.documentIndex = documentIndex;
            this.root = this;
        }

        public byte getType() {
            return 3;
        }

        public URL getURL() {
            if (this.systemId != null) {
                try {
                    return new URL(this.systemId);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        public void setSystemId(String sysId) {
            this.systemId = sysId;
        }

        public int getLineNumber() {
            return 1;
        }

        public Node getElementWithId(String name) {
            return (Node)this.idTable.get(name);
        }

        void addId(String id, NodeImpl node) {
            if (this.idTable.get(id) == null) {
                this.idTable.put(id, node);
            }
        }

        public String getUnparsedEntityURI(String name) {
            return (String)this.unparsedEntityURITable.get(name);
        }

        int compareRootTo(RootNodeImpl r) {
            if (this.systemId == null) {
                if (r.systemId == null) {
                    return this.documentIndex - r.documentIndex;
                }
                return -1;
            }
            if (r.systemId == null) {
                return 1;
            }
            int n = this.systemId.compareTo(r.systemId);
            if (n != 0) {
                return n;
            }
            return this.documentIndex - r.documentIndex;
        }

        int getDocumentIndex() {
            return this.documentIndex;
        }
    }

    private static abstract class ContainerNodeImpl
    extends NodeImpl {
        NodeImpl firstChild;
        NodeImpl lastChild;
        NamespacePrefixMap nsMap;

        ContainerNodeImpl(NamespacePrefixMap nsMap) {
            this.nsMap = nsMap;
        }

        ContainerNodeImpl(int index, ContainerNodeImpl parent) {
            super(index, parent);
            this.nsMap = parent.nsMap;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(this.firstChild);
        }

        public String getData() {
            return null;
        }

        boolean preserveSpace() {
            return false;
        }

        public NamespacePrefixMap getNamespacePrefixMap() {
            return this.nsMap;
        }

        void addId(String id, NodeImpl node) {
            this.parent.addId(id, node);
        }
    }

    private static class NamespaceNode
    extends NodeImpl {
        String _prefix;
        String _uri;

        public byte getType() {
            return 6;
        }

        NamespaceNode(String prefix, String uri, ContainerNodeImpl parent) {
            this._prefix = prefix;
            this._uri = uri;
            this.parent = parent;
        }

        public Name getName() {
            return new Name(){

                public String getNamespace() {
                    return null;
                }

                public String getLocalPart() {
                    return NamespaceNode.this._prefix;
                }

                public String getPrefix() {
                    return null;
                }

                public Object getCreator() {
                    return null;
                }

                public String toString() {
                    return NamespaceNode.this._prefix;
                }
            };
        }

        public String getData() {
            return this._uri;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }
    }

    private static class NamespaceNodeIterator
    implements SafeNodeIterator {
        private NamespacePrefixMap _namespaces;
        private int _index = 0;
        private ContainerNodeImpl _parent;

        NamespaceNodeIterator(NamespacePrefixMap map, ContainerNodeImpl parent) {
            this._namespaces = map;
            this._parent = parent;
            this._index = map.getSize();
        }

        public Node next() {
            NamespaceNode ns = null;
            if (this._index > 0) {
                --this._index;
                ns = new NamespaceNode(this._namespaces.getPrefix(this._index), this._namespaces.getNamespace(this._index), this._parent);
            }
            return ns;
        }
    }

    private static class NodeIteratorImpl
    implements SafeNodeIterator {
        private NodeImpl nextNode;

        NodeIteratorImpl(NodeImpl nextNode) {
            this.nextNode = nextNode;
        }

        public Node next() {
            NodeImpl tem = this.nextNode;
            if (tem != null) {
                this.nextNode = tem.nextSibling;
            }
            return tem;
        }
    }

    private static abstract class NodeImpl
    implements Node {
        ContainerNodeImpl parent;
        RootNodeImpl root;
        int index;
        NodeImpl nextSibling;

        NodeImpl() {
            this.index = 0;
            this.parent = null;
            this.nextSibling = null;
        }

        NodeImpl(int index, ContainerNodeImpl parent) {
            this.index = index;
            this.parent = parent;
            this.root = parent.root;
            this.nextSibling = null;
            if (parent.lastChild == null) {
                parent.firstChild = parent.lastChild = this;
            } else {
                parent.lastChild.nextSibling = this;
                parent.lastChild = this;
            }
        }

        public Node getParent() {
            return this.parent;
        }

        public SafeNodeIterator getFollowingSiblings() {
            return new NodeIteratorImpl(this.nextSibling);
        }

        public URL getURL() {
            return this.parent.getURL();
        }

        boolean canStrip() {
            return false;
        }

        public Node getAttribute(Name name) {
            return null;
        }

        public String getAttributeValue(Name name) {
            return null;
        }

        public SafeNodeIterator getAttributes() {
            return new NodeIteratorImpl(null);
        }

        public SafeNodeIterator getNamespaces() {
            return new NodeIteratorImpl(null);
        }

        public Name getName() {
            return null;
        }

        public NamespacePrefixMap getNamespacePrefixMap() {
            return this.parent.nsMap;
        }

        public int compareTo(Node node) {
            NodeImpl ni = (NodeImpl)node;
            if (this.root == ni.root) {
                return this.index - ((NodeImpl)node).index;
            }
            return this.root.compareRootTo(ni.root);
        }

        public Node getElementWithId(String name) {
            return this.root.getElementWithId(name);
        }

        public String getUnparsedEntityURI(String name) {
            return this.root.getUnparsedEntityURI(name);
        }

        public boolean isId(String name) {
            return false;
        }

        public String getGeneratedId() {
            int d = this.root.getDocumentIndex();
            if (d == 0) {
                return "N" + String.valueOf(this.index);
            }
            return "N" + String.valueOf(d) + "_" + String.valueOf(this.index);
        }

        public Node getRoot() {
            return this.root;
        }

        public int getLineNumber() {
            return this.parent.getLineNumber();
        }

        public int getColumnNumber() {
            return -1;
        }

        public String getSystemId() {
            return this.getRoot().getSystemId();
        }

        public String getPublicId() {
            return null;
        }
    }
}

