/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.AddExpr;
import com.jclark.xsl.expr.AlternativesPattern;
import com.jclark.xsl.expr.AncestorAxisExpr;
import com.jclark.xsl.expr.AncestorOrSelfAxisExpr;
import com.jclark.xsl.expr.AndExpr;
import com.jclark.xsl.expr.AppendExpr;
import com.jclark.xsl.expr.AttributeAxisExpr;
import com.jclark.xsl.expr.AttributeTest;
import com.jclark.xsl.expr.AxisExpr;
import com.jclark.xsl.expr.BooleanExpr;
import com.jclark.xsl.expr.BooleanFunction;
import com.jclark.xsl.expr.BooleanRelationalExpr;
import com.jclark.xsl.expr.CeilingFunction;
import com.jclark.xsl.expr.ChildAxisExpr;
import com.jclark.xsl.expr.ConcatFunction;
import com.jclark.xsl.expr.ContainsFunction;
import com.jclark.xsl.expr.Converter;
import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleNodeSetExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.CountFunction;
import com.jclark.xsl.expr.CurrentFunction;
import com.jclark.xsl.expr.DecodeURIFunction;
import com.jclark.xsl.expr.DescendantAxisExpr;
import com.jclark.xsl.expr.DescendantOrSelfAxisExpr;
import com.jclark.xsl.expr.DifferenceFunction;
import com.jclark.xsl.expr.DivideExpr;
import com.jclark.xsl.expr.DocumentFunction;
import com.jclark.xsl.expr.ElementAvailableFunction;
import com.jclark.xsl.expr.ElementTest;
import com.jclark.xsl.expr.EmptyVariableSet;
import com.jclark.xsl.expr.EncodeURIFunction;
import com.jclark.xsl.expr.EqualsRelation;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.ExprTokenizer;
import com.jclark.xsl.expr.ExtensionFunctionCallExpr;
import com.jclark.xsl.expr.FalseFunction;
import com.jclark.xsl.expr.FilterExpr;
import com.jclark.xsl.expr.FilterPattern;
import com.jclark.xsl.expr.FloorFunction;
import com.jclark.xsl.expr.FollowingAxisExpr;
import com.jclark.xsl.expr.FollowingSiblingAxisExpr;
import com.jclark.xsl.expr.FormatNumberFunction;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.FunctionAvailableFunction;
import com.jclark.xsl.expr.GenerateIdFunction;
import com.jclark.xsl.expr.GlobalVariableRefExpr;
import com.jclark.xsl.expr.GreaterThanEqualsRelation;
import com.jclark.xsl.expr.GreaterThanRelation;
import com.jclark.xsl.expr.IdFunction;
import com.jclark.xsl.expr.IdPattern;
import com.jclark.xsl.expr.InheritPattern;
import com.jclark.xsl.expr.IntersectionFunction;
import com.jclark.xsl.expr.KeyFunction;
import com.jclark.xsl.expr.KeyPattern;
import com.jclark.xsl.expr.LangFunction;
import com.jclark.xsl.expr.LastFunction;
import com.jclark.xsl.expr.LiteralExpr;
import com.jclark.xsl.expr.LocalNameFunction;
import com.jclark.xsl.expr.LocalVariableRefExpr;
import com.jclark.xsl.expr.ModuloExpr;
import com.jclark.xsl.expr.MultiplyExpr;
import com.jclark.xsl.expr.NameFunction;
import com.jclark.xsl.expr.NamespaceAttributeTest;
import com.jclark.xsl.expr.NamespaceAxisExpr;
import com.jclark.xsl.expr.NamespaceElementTest;
import com.jclark.xsl.expr.NamespaceUriFunction;
import com.jclark.xsl.expr.NegateExpr;
import com.jclark.xsl.expr.NodeSetExpr;
import com.jclark.xsl.expr.NodeSetFunction;
import com.jclark.xsl.expr.NodeTestExpr;
import com.jclark.xsl.expr.NodeTypeTest;
import com.jclark.xsl.expr.NormalizeSpaceFunction;
import com.jclark.xsl.expr.NotEqualsRelation;
import com.jclark.xsl.expr.NotFunction;
import com.jclark.xsl.expr.NumberConstantExpr;
import com.jclark.xsl.expr.NumberExpr;
import com.jclark.xsl.expr.NumberFunction;
import com.jclark.xsl.expr.NumberRelationalExpr;
import com.jclark.xsl.expr.NumericRelation;
import com.jclark.xsl.expr.ObjectTypeFunction;
import com.jclark.xsl.expr.OrExpr;
import com.jclark.xsl.expr.ParentAxisExpr;
import com.jclark.xsl.expr.ParentPattern;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.expr.PathPatternBase;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.expr.PositionFunction;
import com.jclark.xsl.expr.PrecedingAxisExpr;
import com.jclark.xsl.expr.PrecedingSiblingAxisExpr;
import com.jclark.xsl.expr.ProcessingInstructionTest;
import com.jclark.xsl.expr.RegexpMatchFunction;
import com.jclark.xsl.expr.RegexpReplaceFunction;
import com.jclark.xsl.expr.RegexpTestFunction;
import com.jclark.xsl.expr.Relation;
import com.jclark.xsl.expr.RootExpr;
import com.jclark.xsl.expr.RoundFunction;
import com.jclark.xsl.expr.SelfAxisExpr;
import com.jclark.xsl.expr.SplitFunction;
import com.jclark.xsl.expr.StartsWithFunction;
import com.jclark.xsl.expr.StringExpr;
import com.jclark.xsl.expr.StringFunction;
import com.jclark.xsl.expr.StringLengthFunction;
import com.jclark.xsl.expr.StringRelationalExpr;
import com.jclark.xsl.expr.SubstringAfterFunction;
import com.jclark.xsl.expr.SubstringBeforeFunction;
import com.jclark.xsl.expr.SubstringFunction;
import com.jclark.xsl.expr.SubtractExpr;
import com.jclark.xsl.expr.SumFunction;
import com.jclark.xsl.expr.SystemPropertyFunction;
import com.jclark.xsl.expr.TopLevelPattern;
import com.jclark.xsl.expr.TranslateFunction;
import com.jclark.xsl.expr.TrueFunction;
import com.jclark.xsl.expr.UnionExpr;
import com.jclark.xsl.expr.UnparsedEntityURIFunction;
import com.jclark.xsl.expr.VariableSet;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.expr.VariantRelationalExpr;
import com.jclark.xsl.expr.WithCurrentExpr;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespaceConstants;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import java.util.Hashtable;

public class ExprParser
extends ExprTokenizer
implements NamespaceConstants {
    private NamespacePrefixMap prefixMap;
    private Node node;
    private VariableSet locals;
    private boolean usesCurrentFunction = false;
    private static final Hashtable axisTable = new Hashtable();
    private static final AxisExpr childAxis = new ChildAxisExpr();
    private static final AxisExpr parentAxis = new ParentAxisExpr();
    private static final AxisExpr selfAxis = new SelfAxisExpr();
    private static final AxisExpr attributeAxis = new AttributeAxisExpr();
    private static final AxisExpr descendantOrSelfAxis = new DescendantOrSelfAxisExpr();
    private static final Hashtable functionTable = new Hashtable();
    private static final Hashtable extensionFunctionTable = new Hashtable();
    private static final Hashtable exsltCommonFunctionTable = new Hashtable();
    private static final Hashtable exsltMathFunctionTable = new Hashtable();
    private static final Hashtable exsltDateTimeFunctionTable = new Hashtable();
    private static final Hashtable exsltDynamicFunctionTable = new Hashtable();
    private static final Hashtable exsltFunctionsFunctionTable = new Hashtable();
    private static final Hashtable exsltSetsFunctionTable = new Hashtable();
    private static final Hashtable exsltStringsFunctionTable = new Hashtable();
    private static final Hashtable exsltRegexFunctionTable = new Hashtable();
    private static final Relation equalsRelation = new EqualsRelation();
    private static final Relation notEqualsRelation = new NotEqualsRelation();
    private static final Relation greaterThanEqualsRelation = new GreaterThanEqualsRelation();
    private static final Relation greaterThanRelation = new GreaterThanRelation();
    private static final Function currentFunction = new CurrentFunction();

    public static StringExpr parseValueExpr(Node node, String value, VariableSet locals) throws XSLException {
        try {
            ConvertibleStringExpr prev = null;
            StringBuffer buf = new StringBuffer();
            int valueLen = value.length();
            block6: for (int i = 0; i < valueLen; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '{': {
                        if (i + 1 < valueLen && value.charAt(i + 1) == '{') {
                            ++i;
                            buf.append('{');
                            continue block6;
                        }
                        int n = ExprParser.findExprEnd(value, i + 1);
                        if (n < 0) {
                            throw new XSLException("missing }", node);
                        }
                        ConvertibleStringExpr expr = ExprParser.parseConvertibleExpr(node, value.substring(i + 1, n), locals).makeStringExpr();
                        if (buf.length() > 0) {
                            prev = prev == null ? new LiteralExpr(buf.toString()) : new AppendExpr(prev, new LiteralExpr(buf.toString()));
                            buf.setLength(0);
                        }
                        prev = prev == null ? expr : new AppendExpr(prev, expr);
                        i = n;
                        continue block6;
                    }
                    case '}': {
                        buf.append('}');
                        if (i + 1 >= valueLen || value.charAt(i + 1) != '}') continue block6;
                        ++i;
                        continue block6;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            if (buf.length() > 0) {
                if (prev == null) {
                    return new LiteralExpr(buf.toString());
                }
                return new AppendExpr(prev, new LiteralExpr(buf.toString()));
            }
            if (prev != null) {
                return prev;
            }
            return new LiteralExpr("");
        }
        catch (ParseException e) {
            throw ExprParser.makeXSLException(e, node);
        }
    }

    public static NodeSetExpr getChildrenExpr() {
        return new ChildAxisExpr();
    }

    public static TopLevelPattern parsePattern(Node node, String pattern) throws XSLException {
        return new ExprParser(pattern, node, new EmptyVariableSet()).parseTopLevelPattern(node);
    }

    public static TopLevelPattern parsePattern(Node node, String pattern, VariableSet locals) throws XSLException {
        return new ExprParser(pattern, node, locals).parseTopLevelPattern(node);
    }

    public static NodeSetExpr parseNodeSetExpr(Node node, String expr, VariableSet locals) throws XSLException {
        try {
            return ExprParser.parseConvertibleExpr(node, expr, locals).makeNodeSetExpr();
        }
        catch (ParseException e) {
            throw ExprParser.makeXSLException(e, node);
        }
    }

    public static StringExpr parseStringExpr(Node node, String expr, VariableSet locals) throws XSLException {
        try {
            return ExprParser.parseConvertibleExpr(node, expr, locals).makeStringExpr();
        }
        catch (ParseException e) {
            throw ExprParser.makeXSLException(e, node);
        }
    }

    public static NumberExpr parseNumberExpr(Node node, String expr, VariableSet locals) throws XSLException {
        try {
            return ExprParser.parseConvertibleExpr(node, expr, locals).makeNumberExpr();
        }
        catch (ParseException e) {
            throw ExprParser.makeXSLException(e, node);
        }
    }

    public static BooleanExpr parseBooleanExpr(Node node, String expr, VariableSet locals) throws XSLException {
        try {
            return ExprParser.parseConvertibleExpr(node, expr, locals).makeBooleanExpr();
        }
        catch (ParseException e) {
            throw ExprParser.makeXSLException(e, node);
        }
    }

    public static VariantExpr parseVariantExpr(Node node, String expr, VariableSet locals) throws XSLException {
        try {
            return ExprParser.parseConvertibleExpr(node, expr, locals).makeVariantExpr();
        }
        catch (ParseException e) {
            throw ExprParser.makeXSLException(e, node);
        }
    }

    private static ConvertibleExpr parseConvertibleExpr(Node node, String expr, VariableSet locals) throws ParseException {
        return new ExprParser(expr, node, locals).parseExpr();
    }

    private ExprParser(String expr, Node node, VariableSet locals) {
        super(expr);
        this.node = node;
        if (node != null) {
            this.prefixMap = node.getNamespacePrefixMap();
        }
        this.locals = locals;
    }

    private ConvertibleExpr parseExpr() throws ParseException {
        this.next();
        ConvertibleExpr expr = this.parseOrExpr();
        if (this.currentToken != 0) {
            throw new ParseException("unexpected token");
        }
        if (this.usesCurrentFunction) {
            return new WithCurrentExpr(expr);
        }
        return expr;
    }

    private static XSLException makeXSLException(ParseException e, Node node) {
        return new XSLException(e.getMessage(), node);
    }

    private ConvertibleExpr parseOrExpr() throws ParseException {
        ConvertibleExpr expr = this.parseAndExpr();
        while (this.currentToken == 35) {
            this.next();
            expr = new OrExpr(expr.makeBooleanExpr(), this.parseAndExpr().makeBooleanExpr());
        }
        return expr;
    }

    private ConvertibleExpr parseAndExpr() throws ParseException {
        ConvertibleExpr expr = this.parseEqualityExpr();
        while (this.currentToken == 34) {
            this.next();
            expr = new AndExpr(expr.makeBooleanExpr(), this.parseEqualityExpr().makeBooleanExpr());
        }
        return expr;
    }

    private ConvertibleExpr parseEqualityExpr() throws ParseException {
        ConvertibleExpr expr = this.parseRelationalExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 28: {
                    this.next();
                    expr = this.makeRelationalExpr(equalsRelation, expr, this.parseRelationalExpr());
                    continue block4;
                }
                case 29: {
                    this.next();
                    expr = this.makeRelationalExpr(notEqualsRelation, expr, this.parseRelationalExpr());
                    continue block4;
                }
            }
            break;
        }
        return expr;
    }

    private ConvertibleExpr parseRelationalExpr() throws ParseException {
        ConvertibleExpr expr = this.parseAdditiveExpr();
        block6: while (true) {
            switch (this.currentToken) {
                case 30: {
                    this.next();
                    expr = this.makeRelationalExpr(greaterThanRelation, expr, this.parseAdditiveExpr());
                    continue block6;
                }
                case 32: {
                    this.next();
                    expr = this.makeRelationalExpr(greaterThanEqualsRelation, expr, this.parseAdditiveExpr());
                    continue block6;
                }
                case 31: {
                    this.next();
                    expr = this.makeRelationalExpr(greaterThanRelation, this.parseAdditiveExpr(), expr);
                    continue block6;
                }
                case 33: {
                    this.next();
                    expr = this.makeRelationalExpr(greaterThanEqualsRelation, this.parseAdditiveExpr(), expr);
                    continue block6;
                }
            }
            break;
        }
        return expr;
    }

    private ConvertibleExpr parseAdditiveExpr() throws ParseException {
        ConvertibleExpr expr = this.parseMultiplicativeExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 26: {
                    this.next();
                    expr = new AddExpr(expr.makeNumberExpr(), this.parseMultiplicativeExpr().makeNumberExpr());
                    continue block4;
                }
                case 27: {
                    this.next();
                    expr = new SubtractExpr(expr.makeNumberExpr(), this.parseMultiplicativeExpr().makeNumberExpr());
                    continue block4;
                }
            }
            break;
        }
        return expr;
    }

    private ConvertibleExpr parseMultiplicativeExpr() throws ParseException {
        ConvertibleExpr expr = this.parseUnaryExpr();
        block5: while (true) {
            switch (this.currentToken) {
                case 37: {
                    this.next();
                    expr = new DivideExpr(expr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
                case 36: {
                    this.next();
                    expr = new ModuloExpr(expr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
                case 11: {
                    this.next();
                    expr = new MultiplyExpr(expr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
            }
            break;
        }
        return expr;
    }

    private ConvertibleExpr parseUnaryExpr() throws ParseException {
        if (this.currentToken == 27) {
            this.next();
            return new NegateExpr(this.parseUnaryExpr().makeNumberExpr());
        }
        return this.parseUnionExpr();
    }

    private ConvertibleExpr parseUnionExpr() throws ParseException {
        ConvertibleExpr expr = this.parsePathExpr();
        while (this.currentToken == 24) {
            this.next();
            expr = new UnionExpr(expr.makeNodeSetExpr(), this.parsePathExpr().makeNodeSetExpr());
        }
        return expr;
    }

    private ConvertibleExpr parsePathExpr() throws ParseException {
        if (this.tokenStartsStep()) {
            return this.parseRelativeLocationPath();
        }
        if (this.currentToken == 22) {
            this.next();
            if (this.tokenStartsStep()) {
                return new RootExpr(this.parseRelativeLocationPath());
            }
            return new RootExpr(selfAxis);
        }
        if (this.currentToken == 23) {
            this.next();
            return new RootExpr(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        ConvertibleExpr expr = this.parsePrimaryExpr();
        while (this.currentToken == 14) {
            this.next();
            expr = new FilterExpr(expr.makeNodeSetExpr(), this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        if (this.currentToken == 22) {
            this.next();
            return expr.makeNodeSetExpr().compose(this.parseRelativeLocationPath());
        }
        if (this.currentToken == 23) {
            this.next();
            return expr.makeNodeSetExpr().compose(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        return expr;
    }

    private ConvertibleNodeSetExpr parseRelativeLocationPath() throws ParseException {
        ConvertibleNodeSetExpr step = this.parseStep();
        if (this.currentToken == 22) {
            this.next();
            return step.compose(this.parseRelativeLocationPath());
        }
        if (this.currentToken == 23) {
            this.next();
            return step.compose(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        return step;
    }

    private ConvertibleNodeSetExpr parseStep() throws ParseException {
        switch (this.currentToken) {
            case 18: {
                AxisExpr axis = (AxisExpr)axisTable.get(this.currentTokenValue);
                if (axis == null) {
                    throw new ParseException("no such axis");
                }
                boolean isAttribute = this.currentTokenValue.equals("attribute");
                this.next();
                return this.parsePredicates(axis, this.parseNodeTest(isAttribute));
            }
            case 5: {
                this.next();
                return selfAxis;
            }
            case 6: {
                this.next();
                return parentAxis;
            }
            case 4: {
                this.next();
                return this.parsePredicates(attributeAxis, this.parseNodeTest(true));
            }
        }
        return this.parsePredicates(childAxis, this.parseNodeTest(false));
    }

    private ConvertibleNodeSetExpr parsePredicates(AxisExpr axis, Pattern nodeTest) throws ParseException {
        ConvertibleNodeSetExpr expr = axis;
        if (nodeTest != null) {
            expr = new NodeTestExpr(expr, nodeTest);
        }
        while (this.currentToken == 14) {
            this.next();
            expr = new FilterExpr(expr, this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        return axis.makeDocumentOrderExpr(expr);
    }

    private PathPatternBase parseNodeTest(boolean isAttributeAxis) throws ParseException {
        PathPatternBase nodeTest;
        switch (this.currentToken) {
            case 1: {
                if (isAttributeAxis) {
                    nodeTest = new AttributeTest(this.expandName());
                    break;
                }
                nodeTest = new ElementTest(this.expandName());
                break;
            }
            case 2: {
                nodeTest = isAttributeAxis ? null : new NodeTypeTest(0);
                break;
            }
            case 3: {
                if (isAttributeAxis) {
                    nodeTest = new NamespaceAttributeTest(this.expandPrefix());
                    break;
                }
                nodeTest = new NamespaceElementTest(this.expandPrefix());
                break;
            }
            case 8: {
                PathPatternBase nodeTest2;
                this.next();
                if (this.currentToken == 16) {
                    nodeTest2 = new ProcessingInstructionTest(this.expandName());
                    this.next();
                } else {
                    nodeTest2 = new NodeTypeTest(4);
                }
                this.expectRpar();
                return nodeTest2;
            }
            case 7: {
                this.next();
                this.expectRpar();
                return new NodeTypeTest(5);
            }
            case 9: {
                this.next();
                this.expectRpar();
                return new NodeTypeTest(1);
            }
            case 10: {
                this.next();
                this.expectRpar();
                if (isAttributeAxis) {
                    return new NodeTypeTest(2);
                }
                return new NodeTypeTest(7);
            }
            default: {
                throw new ParseException("expected node test");
            }
        }
        this.next();
        return nodeTest;
    }

    private final void expectRpar() throws ParseException {
        if (this.currentToken != 13) {
            throw new ParseException("expected )");
        }
        this.next();
    }

    private final void expectRsqb() throws ParseException {
        if (this.currentToken != 15) {
            throw new ParseException("expected ]");
        }
        this.next();
    }

    private ConvertibleExpr parsePrimaryExpr() throws ParseException {
        ConvertibleExpr expr2;
        switch (this.currentToken) {
            case 21: {
                Name name = this.expandName();
                if (this.locals.contains(name)) {
                    expr2 = new LocalVariableRefExpr(name);
                    break;
                }
                expr2 = new GlobalVariableRefExpr(name, this.node);
                break;
            }
            case 12: {
                this.next();
                ConvertibleExpr expr2 = this.parseOrExpr();
                this.expectRpar();
                return expr2;
            }
            case 16: {
                expr2 = new LiteralExpr(this.currentTokenValue);
                break;
            }
            case 17: {
                expr2 = new NumberConstantExpr(Converter.toNumber(this.currentTokenValue));
                break;
            }
            case 19: {
                Function function = (Function)functionTable.get(this.currentTokenValue);
                if (function == null) {
                    if (!this.currentTokenValue.equals("current")) {
                        throw new ParseException("no such function: " + this.currentTokenValue);
                    }
                    this.usesCurrentFunction = true;
                    function = currentFunction;
                }
                this.next();
                return function.makeCallExpr(this.parseArgs(), this.node);
            }
            case 20: {
                Function function;
                Name name = this.expandName();
                this.next();
                if ("http://www.jclark.com/xt".equals(name.getNamespace()) ? (function = (Function)extensionFunctionTable.get(name.getLocalPart())) != null : ("http://exslt.org/common".equals(name.getNamespace()) ? (function = (Function)exsltCommonFunctionTable.get(name.getLocalPart())) != null : ("http://exslt.org/regular-expressions".equals(name.getNamespace()) ? (function = (Function)exsltRegexFunctionTable.get(name.getLocalPart())) != null : "http://exslt.org/strings".equals(name.getNamespace()) && (function = (Function)exsltStringsFunctionTable.get(name.getLocalPart())) != null))) {
                    return function.makeCallExpr(this.parseArgs(), this.node);
                }
                ConvertibleExpr[] args = this.parseArgs();
                VariantExpr[] variantArgs = new VariantExpr[args.length];
                for (int i = 0; i < args.length; ++i) {
                    variantArgs[i] = args[i].makeVariantExpr();
                }
                return new ExtensionFunctionCallExpr(name, variantArgs);
            }
            default: {
                throw new ParseException("syntax error");
            }
        }
        this.next();
        return expr2;
    }

    private ConvertibleExpr[] parseArgs() throws ParseException {
        if (this.currentToken == 13) {
            this.next();
            return new ConvertibleExpr[0];
        }
        ConvertibleExpr[] args = new ConvertibleExpr[1];
        while (true) {
            args[args.length - 1] = this.parseOrExpr();
            if (this.currentToken != 25) break;
            this.next();
            ConvertibleExpr[] oldArgs = args;
            args = new ConvertibleExpr[oldArgs.length + 1];
            System.arraycopy(oldArgs, 0, args, 0, oldArgs.length);
        }
        this.expectRpar();
        return args;
    }

    private boolean tokenStartsNodeTest() {
        switch (this.currentToken) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private boolean tokenStartsStep() {
        switch (this.currentToken) {
            case 4: 
            case 5: 
            case 6: 
            case 18: {
                return true;
            }
        }
        return this.tokenStartsNodeTest();
    }

    private Name expandName() throws ParseException {
        try {
            if (this.prefixMap != null) {
                return this.prefixMap.expandAttributeName(this.currentTokenValue, null);
            }
            return null;
        }
        catch (XSLException e) {
            throw new ParseException("undefined prefix");
        }
    }

    private String expandPrefix() throws ParseException {
        if (this.prefixMap == null) {
            return null;
        }
        String ns = this.prefixMap.getNamespace(this.currentTokenValue);
        if (ns == null) {
            throw new ParseException("undefined prefix");
        }
        return ns;
    }

    ConvertibleExpr makeRelationalExpr(Relation rel, ConvertibleExpr e1, ConvertibleExpr e2) throws ParseException {
        if (e1 instanceof NodeSetExpr || e2 instanceof NodeSetExpr || e1 instanceof VariantExpr || e2 instanceof VariantExpr) {
            return new VariantRelationalExpr(rel, e1.makeVariantExpr(), e2.makeVariantExpr());
        }
        if (rel instanceof NumericRelation) {
            return new NumberRelationalExpr(rel, e1.makeNumberExpr(), e2.makeNumberExpr());
        }
        if (e1 instanceof BooleanExpr || e2 instanceof BooleanExpr) {
            return new BooleanRelationalExpr(rel, e1.makeBooleanExpr(), e2.makeBooleanExpr());
        }
        if (e1 instanceof NumberExpr || e2 instanceof NumberExpr) {
            return new NumberRelationalExpr(rel, e1.makeNumberExpr(), e2.makeNumberExpr());
        }
        return new StringRelationalExpr(rel, e1.makeStringExpr(), e2.makeStringExpr());
    }

    private static int findExprEnd(String value, int i) {
        int valueLen = value.length();
        char quote = '\u0000';
        while (i < valueLen) {
            char c = value.charAt(i);
            switch (c) {
                case '}': {
                    if (quote != '\u0000') break;
                    return i;
                }
                case '\"': 
                case '\'': {
                    if (quote == c) {
                        quote = '\u0000';
                        break;
                    }
                    if (quote != '\u0000') break;
                    quote = c;
                }
            }
            ++i;
        }
        return -1;
    }

    private TopLevelPattern parseTopLevelPattern(Node node) throws XSLException {
        try {
            this.next();
            TopLevelPattern pattern = this.parsePathPattern();
            while (this.currentToken == 24) {
                this.next();
                pattern = new AlternativesPattern(pattern, this.parsePathPattern());
            }
            if (this.currentToken != 0) {
                throw new ParseException("unexpected token");
            }
            if (this.usesCurrentFunction) {
                throw new ParseException("current() in match pattern");
            }
            return pattern;
        }
        catch (ParseException e) {
            throw ExprParser.makeXSLException(e, node);
        }
    }

    private PathPatternBase parsePathPattern() throws ParseException {
        PathPatternBase tem;
        Pattern parent = null;
        switch (this.currentToken) {
            case 23: {
                this.next();
                break;
            }
            case 22: {
                this.next();
                if (!this.tokenStartsStep()) {
                    return new NodeTypeTest(3);
                }
                parent = new NodeTypeTest(3);
                break;
            }
            case 19: {
                if (this.currentTokenValue.equals("id")) {
                    this.next();
                    if (this.currentToken != 16) {
                        throw new ParseException("expected literal");
                    }
                    tem = new IdPattern(this.currentTokenValue);
                    this.next();
                    this.expectRpar();
                    if (this.currentToken == 22) {
                        parent = tem;
                    } else if (this.currentToken == 23) {
                        parent = new InheritPattern(tem);
                    } else {
                        return tem;
                    }
                    this.next();
                    break;
                }
                if (this.currentTokenValue.equals("key")) {
                    this.next();
                    if (this.currentToken != 16) {
                        throw new ParseException("key pattern: expected literal arg 1");
                    }
                    String keyName = this.currentTokenValue;
                    this.next();
                    if (this.currentToken != 25) {
                        throw new ParseException("key pattern: expected comma between two literals");
                    }
                    this.next();
                    if (this.currentToken != 16) {
                        throw new ParseException("key pattern: expected literal arg 2");
                    }
                    KeyPattern tem2 = new KeyPattern(keyName, this.currentTokenValue);
                    this.next();
                    this.expectRpar();
                    if (this.currentToken == 22) {
                        parent = tem2;
                    } else if (this.currentToken == 23) {
                        parent = new InheritPattern(tem2);
                    } else {
                        return tem2;
                    }
                    this.next();
                    break;
                }
                throw new ParseException("function illegal in pattern");
            }
        }
        while (true) {
            tem = this.parseStepPattern();
            if (parent != null) {
                tem = new ParentPattern(tem, parent);
            }
            if (this.currentToken == 22) {
                parent = tem;
            } else if (this.currentToken == 23) {
                parent = new InheritPattern(tem);
            } else {
                return tem;
            }
            this.next();
        }
    }

    private PathPatternBase parseStepPattern() throws ParseException {
        PathPatternBase pattern;
        if (this.currentToken == 4 || this.currentToken == 18 && this.currentTokenValue.equals("attribute")) {
            this.next();
            pattern = this.parseNodeTest(true);
            if (pattern == null) {
                pattern = new NodeTypeTest(2);
            }
        } else {
            if (this.currentToken == 18 && this.currentTokenValue.equals("child")) {
                this.next();
            }
            if ((pattern = this.parseNodeTest(false)) == null) {
                throw new ParseException("node() in step pattern not implemented");
            }
        }
        while (this.currentToken == 14) {
            this.next();
            pattern = new FilterPattern(pattern, this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        return pattern;
    }

    static boolean functionAvailable(Name name, ExprContext context) throws XSLException {
        String ns = name.getNamespace();
        if (ns == null) {
            return functionTable.get(name.getLocalPart()) != null;
        }
        if (ns.equals("http://www.jclark.com/xt") && extensionFunctionTable.get(name.getLocalPart()) != null) {
            return true;
        }
        if (ns.equals("http://exslt.org/common") && exsltCommonFunctionTable.get(name.getLocalPart()) != null) {
            return true;
        }
        if (ns.equals("http://exslt.org/regular-expressions") && exsltRegexFunctionTable.get(name.getLocalPart()) != null) {
            return true;
        }
        if (ns.equals("http://exslt.org/strings") && exsltStringsFunctionTable.get(name.getLocalPart()) != null) {
            return true;
        }
        return context.getExtensionContext(ns).available(name.getLocalPart());
    }

    static {
        axisTable.put("child", childAxis);
        axisTable.put("parent", parentAxis);
        axisTable.put("self", selfAxis);
        axisTable.put("attribute", attributeAxis);
        axisTable.put("descendant-or-self", descendantOrSelfAxis);
        axisTable.put("descendant", new DescendantAxisExpr());
        axisTable.put("ancestor-or-self", new AncestorOrSelfAxisExpr());
        axisTable.put("ancestor", new AncestorAxisExpr());
        axisTable.put("following-sibling", new FollowingSiblingAxisExpr());
        axisTable.put("preceding-sibling", new PrecedingSiblingAxisExpr());
        axisTable.put("following", new FollowingAxisExpr());
        axisTable.put("preceding", new PrecedingAxisExpr());
        axisTable.put("namespace", new NamespaceAxisExpr());
        functionTable.put("boolean", new BooleanFunction());
        functionTable.put("ceiling", new CeilingFunction());
        functionTable.put("concat", new ConcatFunction());
        functionTable.put("contains", new ContainsFunction());
        functionTable.put("count", new CountFunction());
        functionTable.put("document", new DocumentFunction());
        functionTable.put("false", new FalseFunction());
        functionTable.put("floor", new FloorFunction());
        functionTable.put("format-number", new FormatNumberFunction());
        functionTable.put("function-available", new FunctionAvailableFunction());
        functionTable.put("element-available", new ElementAvailableFunction());
        functionTable.put("generate-id", new GenerateIdFunction());
        functionTable.put("id", new IdFunction());
        functionTable.put("key", new KeyFunction());
        functionTable.put("lang", new LangFunction());
        functionTable.put("last", new LastFunction());
        functionTable.put("local-name", new LocalNameFunction());
        functionTable.put("namespace-uri", new NamespaceUriFunction());
        functionTable.put("normalize-space", new NormalizeSpaceFunction());
        functionTable.put("not", new NotFunction());
        functionTable.put("number", new NumberFunction());
        functionTable.put("position", new PositionFunction());
        functionTable.put("name", new NameFunction());
        functionTable.put("round", new RoundFunction());
        functionTable.put("starts-with", new StartsWithFunction());
        functionTable.put("string", new StringFunction());
        functionTable.put("string-length", new StringLengthFunction());
        functionTable.put("substring", new SubstringFunction());
        functionTable.put("substring-after", new SubstringAfterFunction());
        functionTable.put("substring-before", new SubstringBeforeFunction());
        functionTable.put("sum", new SumFunction());
        functionTable.put("system-property", new SystemPropertyFunction());
        functionTable.put("translate", new TranslateFunction());
        functionTable.put("true", new TrueFunction());
        functionTable.put("unparsed-entity-uri", new UnparsedEntityURIFunction());
        extensionFunctionTable.put("node-set", new NodeSetFunction());
        extensionFunctionTable.put("intersection", new IntersectionFunction());
        extensionFunctionTable.put("difference", new DifferenceFunction());
        exsltCommonFunctionTable.put("node-set", new NodeSetFunction());
        exsltCommonFunctionTable.put("object-type", new ObjectTypeFunction());
        exsltRegexFunctionTable.put("test", new RegexpTestFunction());
        exsltRegexFunctionTable.put("replace", new RegexpReplaceFunction());
        exsltRegexFunctionTable.put("match", new RegexpMatchFunction());
        exsltStringsFunctionTable.put("encode-uri", new EncodeURIFunction());
        exsltStringsFunctionTable.put("decode-uri", new DecodeURIFunction());
        exsltStringsFunctionTable.put("split", new SplitFunction());
    }
}

