/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.tuple.MarshalledTupleData;
import com.sleepycat.bdb.bind.tuple.MarshalledTupleKeyEntity;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.bdb.bind.tuple.TupleTupleBinding;
import com.sleepycat.bdb.util.IOExceptionWrapper;
import java.io.IOException;

public class TupleTupleMarshalledBinding
extends TupleTupleBinding {
    private Class cls;

    public TupleTupleMarshalledBinding(TupleFormat keyFormat, TupleFormat valueFormat, Class cls) {
        super(keyFormat, valueFormat);
        this.cls = cls;
        if (!MarshalledTupleKeyEntity.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(cls.toString() + " does not implement MarshalledTupleKeyEntity");
        }
        if (!MarshalledTupleData.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(cls.toString() + " does not implement MarshalledTupleData");
        }
    }

    public Object dataToObject(TupleInput keyInput, TupleInput valueInput) throws IOException {
        MarshalledTupleData obj;
        try {
            obj = (MarshalledTupleData)this.cls.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IOExceptionWrapper(e);
        }
        catch (InstantiationException e) {
            throw new IOExceptionWrapper(e);
        }
        if (valueInput != null) {
            obj.unmarshalData(valueInput);
        }
        MarshalledTupleKeyEntity entity = (MarshalledTupleKeyEntity)((Object)obj);
        if (keyInput != null) {
            entity.unmarshalPrimaryKey(keyInput);
        }
        return entity;
    }

    public void objectToKey(Object object, TupleOutput output) throws IOException {
        MarshalledTupleKeyEntity entity = (MarshalledTupleKeyEntity)object;
        entity.marshalPrimaryKey(output);
    }

    public void objectToValue(Object object, TupleOutput output) throws IOException {
        MarshalledTupleData entity = (MarshalledTupleData)object;
        entity.marshalData(output);
    }
}

