/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.CurrentTransaction;
import com.sleepycat.bdb.util.RuntimeExceptionWrapper;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import java.util.WeakHashMap;

class DataEnvironment
extends CurrentTransaction {
    private static WeakHashMap envMap = new WeakHashMap();
    private int writeLockFlag;
    private boolean cdbMode;
    private boolean txnMode;
    private ThreadLocal currentTrans = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataEnvironment getEnvironment(DbEnv env) {
        WeakHashMap weakHashMap = envMap;
        synchronized (weakHashMap) {
            DataEnvironment myEnv = (DataEnvironment)envMap.get(env);
            if (myEnv == null) {
                myEnv = new DataEnvironment(env);
                envMap.put(env, myEnv);
            }
            return myEnv;
        }
    }

    private DataEnvironment(DbEnv dbEnv) {
        super(dbEnv);
        try {
            boolean bl = this.txnMode = (dbEnv.getOpenFlags() & Db.DB_INIT_TXN) != 0;
            if (this.txnMode || (dbEnv.getOpenFlags() & Db.DB_INIT_LOCK) != 0) {
                this.writeLockFlag = Db.DB_RMW;
            }
            this.cdbMode = (dbEnv.getOpenFlags() & Db.DB_INIT_CDB) != 0;
        }
        catch (DbException e) {
            throw new RuntimeExceptionWrapper(e);
        }
    }

    public final boolean isTxnMode() {
        return this.txnMode;
    }

    public final boolean isCdbMode() {
        return this.cdbMode;
    }

    public final int getWriteLockFlag() {
        return this.writeLockFlag;
    }
}

