/*
 * Decompiled with CFR 0.152.
 */
package connectivity.tools;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XCloseable;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XStatement;
import com.sun.star.sdbcx.XAppend;
import com.sun.star.sdbcx.XTablesSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import connectivity.tools.DataSource;
import connectivity.tools.HsqlColumnDescriptor;
import connectivity.tools.HsqlTableDescriptor;
import connectivity.tools.RowSet;
import java.io.File;
import java.util.HashMap;
import java.util.Set;

public class HsqlDatabase {
    XMultiServiceFactory m_orb;
    String m_databaseDocumentFile;
    XOfficeDatabaseDocument m_databaseDocument;
    DataSource m_dataSource;
    XConnection m_connection;

    public HsqlDatabase(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        this.m_orb = xMultiServiceFactory;
        this.createDBDocument();
    }

    private void createDBDocument() throws Exception {
        this.m_databaseDocumentFile = new String();
        String string = File.createTempFile("testdb", ".odb").getCanonicalPath();
        string = string.replaceAll(" ", "%20");
        string = "file:///" + string;
        this.m_databaseDocumentFile = string.replace('\\', '/');
        this.m_databaseDocument = (XOfficeDatabaseDocument)UnoRuntime.queryInterface(XOfficeDatabaseDocument.class, (Object)this.m_orb.createInstance("com.sun.star.sdb.OfficeDatabaseDocument"));
        this.m_dataSource = new DataSource(this.m_orb, this.m_databaseDocument.getDataSource());
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_databaseDocument.getDataSource());
        xPropertySet.setPropertyValue("URL", (Object)"sdbc:embedded:hsqldb");
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.m_databaseDocument);
        xStorable.storeAsURL(this.m_databaseDocumentFile, new PropertyValue[0]);
    }

    public XConnection defaultConnection() throws SQLException {
        if (this.m_connection != null) {
            return this.m_connection;
        }
        this.m_connection = this.m_databaseDocument.getDataSource().getConnection(new String(), new String());
        return this.m_connection;
    }

    public void executeSQL(String string) throws SQLException {
        XStatement xStatement = this.defaultConnection().createStatement();
        xStatement.execute(string);
    }

    public void close() {
        XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.m_connection);
        if (xCloseable != null) {
            try {
                xCloseable.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.m_connection = null;
        com.sun.star.util.XCloseable xCloseable2 = (com.sun.star.util.XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.m_databaseDocument);
        if (xCloseable2 != null) {
            try {
                xCloseable2.close(true);
            }
            catch (CloseVetoException closeVetoException) {
                // empty catch block
            }
        }
        this.m_databaseDocument = null;
    }

    public void closeAndDelete() {
        this.close();
        if (this.m_databaseDocumentFile != null) {
            try {
                File file = new File(this.m_databaseDocumentFile);
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_databaseDocumentFile = null;
        }
    }

    public void dropTable(String string, boolean bl) throws SQLException {
        String string2 = "DROP TABLE \"" + string;
        if (bl) {
            string2 = string2 + "\" IF EXISTS";
        }
        this.executeSQL(string2);
    }

    public void createTable(HsqlTableDescriptor hsqlTableDescriptor, boolean bl) throws SQLException {
        if (bl) {
            this.dropTable(hsqlTableDescriptor.getName(), true);
        }
        this.createTable(hsqlTableDescriptor);
    }

    public void createTable(HsqlTableDescriptor hsqlTableDescriptor) throws SQLException {
        String string = "CREATE CACHED TABLE \"";
        string = string + hsqlTableDescriptor.getName();
        string = string + "\" ( ";
        String string2 = "";
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
        HsqlColumnDescriptor[] hsqlColumnDescriptorArray = hsqlTableDescriptor.getColumns();
        for (int i = 0; i < hsqlColumnDescriptorArray.length; ++i) {
            String string3;
            String string4;
            if (i > 0) {
                string = string + ", ";
            }
            string = string + "\"" + hsqlColumnDescriptorArray[i].getName();
            string = string + "\" " + hsqlColumnDescriptorArray[i].getTypeName();
            if (hsqlColumnDescriptorArray[i].isRequired()) {
                string = string + " NOT NULL";
            }
            if (hsqlColumnDescriptorArray[i].isPrimaryKey()) {
                if (string2.length() > 0) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + "\"" + hsqlColumnDescriptorArray[i].getName() + "\"";
            }
            if (!hsqlColumnDescriptorArray[i].isForeignKey()) continue;
            String string5 = hsqlColumnDescriptorArray[i].getForeignTable();
            String string6 = string4 = hashMap.containsKey(string5) ? (String)hashMap.get(string5) : "";
            if (string4.length() > 0) {
                string4 = string4 + ", ";
            }
            string4 = string4 + "\"" + hsqlColumnDescriptorArray[i].getName() + "\"";
            hashMap.put(string5, string4);
            String string7 = string3 = hashMap2.containsKey(string5) ? (String)hashMap2.get(string5) : "";
            if (string3.length() > 0) {
                string3 = string3 + ", ";
            }
            string3 = string3 + "\"" + hsqlColumnDescriptorArray[i].getForeignColumn() + "\"";
            hashMap2.put(string5, string3);
        }
        if (string2.length() > 0) {
            string = string + ", PRIMARY KEY (";
            string = string + string2;
            string = string + ")";
        }
        Set set = hashMap.keySet();
        for (String string4 : set) {
            string = string + ", FOREIGN KEY (";
            string = string + (String)hashMap.get(string4);
            string = string + ") REFERENCES \"";
            string = string + string4;
            string = string + "\"(";
            string = string + (String)hashMap2.get(string4);
            string = string + ")";
        }
        string = string + ")";
        this.executeSQL(string);
    }

    public void createTableInSDBCX(HsqlTableDescriptor hsqlTableDescriptor) throws SQLException, ElementExistException {
        XPropertySet xPropertySet = hsqlTableDescriptor.createSdbcxDescriptor(this.defaultConnection());
        XTablesSupplier xTablesSupplier = (XTablesSupplier)UnoRuntime.queryInterface(XTablesSupplier.class, (Object)this.defaultConnection());
        XAppend xAppend = (XAppend)UnoRuntime.queryInterface(XAppend.class, (Object)xTablesSupplier.getTables());
        xAppend.appendByDescriptor(xPropertySet);
    }

    public String getDocumentURL() {
        return this.m_databaseDocumentFile;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public RowSet createRowSet(int n, String string) {
        return new RowSet(this.m_orb, this.getDocumentURL(), n, string);
    }

    protected void finalize() throws Throwable {
        this.closeAndDelete();
        super.finalize();
    }
}

