/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbt;
import com.sun.star.help.HelpCompiler;
import com.sun.star.help.HelpKeyword;
import com.sun.star.help.HelpURLStreamHandlerFactory;
import com.sun.xmlsearch.util.PrefixTranslator;
import com.sun.xmlsearch.xml.indexer.XmlIndexBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;

class HelpLinker {
    public static int locCount = 0;
    public static int totCount = 0;
    private JarOutputStream jarOutputStream;
    private Hashtable additionalFiles;
    private HashSet helpFiles;
    private String sourceRoot;
    private String embeddStylesheet;
    private String indexStylesheet;
    private String outputFile;
    private String module;
    private String lang;
    private String hid;
    private Hashtable hidlistTranslation = new Hashtable();
    private HelpURLStreamHandlerFactory _urlHandler = null;
    private String indexDirParentName = null;
    private File indexDirFile = null;
    private boolean init = true;
    private XmlIndexBuilder xmlIndexBuilder = null;
    private HelpURLStreamHandlerFactory urlHandler = null;

    public static void main(String[] stringArray) {
        CharSequence charSequence;
        Object object;
        HelpCompiler.initURLHandler();
        Hashtable<CharSequence, Object> hashtable = new Hashtable<CharSequence, Object>();
        HashSet<Object> hashSet = new HashSet<Object>();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (stringArray.length > 0 && stringArray[0].startsWith("@")) {
            try {
                String string8 = stringArray[0].substring(1);
                object = new FileReader(string8);
                charSequence = new StringBuffer();
                int n = 0;
                char[] cArray = new char[1024];
                while ((n = ((InputStreamReader)object).read(cArray, 0, 1024)) != -1) {
                    ((StringBuffer)charSequence).append(cArray, 0, n);
                }
                String string9 = ((StringBuffer)charSequence).toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string9);
                n = 0;
                String[] stringArray2 = new String[stringTokenizer.countTokens()];
                while (stringTokenizer.hasMoreElements()) {
                    stringArray2[n++] = stringTokenizer.nextToken();
                }
                stringArray = stringArray2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-src")) {
                if (++i >= stringArray.length) {
                    System.err.println("sourceroot missing");
                    System.exit(1);
                }
                string = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-sty")) {
                if (++i >= stringArray.length) {
                    System.err.println("embeddingStylesheet missing");
                    System.exit(1);
                }
                string2 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-idx")) {
                if (++i >= stringArray.length) {
                    System.err.println("indexstylesheet missing");
                    System.exit(1);
                }
                string3 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-o")) {
                if (++i >= stringArray.length) {
                    System.err.println("outputfilename missing");
                    System.exit(1);
                }
                string4 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-mod")) {
                if (++i >= stringArray.length) {
                    System.err.println("module name missing");
                    System.exit(1);
                }
                string5 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-lang")) {
                if (++i >= stringArray.length) {
                    System.err.println("language name missing");
                    System.exit(1);
                }
                string6 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-hid")) {
                if (++i >= stringArray.length) {
                    System.err.println("hid list missing");
                    System.exit(1);
                }
                string7 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-add")) {
                if (++i >= stringArray.length) {
                    System.err.println("pathname missing");
                    System.exit(1);
                }
                charSequence = stringArray[i];
                if (++i >= stringArray.length) {
                    System.err.println("pathname missing");
                    System.exit(1);
                }
                object = stringArray[i];
                if (((String)charSequence).length() == 0 || ((String)object).length() == 0) continue;
                hashtable.put(charSequence, object);
                continue;
            }
            object = stringArray[i];
            hashSet.add(object);
        }
        if (string3 == null) {
            System.err.println("no index file given");
            System.exit(1);
        }
        if (string2 == null) {
            System.err.println("no embedding resolving file given");
            System.exit(1);
        }
        if (string == null) {
            System.err.println("no sourceroot given");
            System.exit(1);
        }
        if (string4 == null) {
            System.err.println("no output file given");
            System.exit(1);
        }
        if (string5 == null) {
            System.err.println("module missing");
            System.exit(1);
        }
        if (string6 == null) {
            System.err.println("language missing");
            System.exit(1);
        }
        if (string7 == null) {
            System.err.println("hid list missing");
            System.exit(1);
        }
        try {
            new HelpLinker(string, string2, string3, string4, string5, string6, string7, hashSet, hashtable).link();
            System.out.println("number of local fetches: " + locCount);
            System.out.println("total number of fetches: " + totCount);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    void initXMLIndexBuilder() throws Exception {
        File file = File.createTempFile("temp", ".dir");
        this.indexDirParentName = file.getAbsolutePath();
        file.delete();
        file.mkdir();
        String string = this.indexDirParentName + File.separator + this.module.toLowerCase() + ".idx";
        this.indexDirFile = new File(string);
        if (this.indexDirFile.exists() && this.indexDirFile.isFile()) {
            this.indexDirFile.delete();
        }
        if (!this.indexDirFile.exists()) {
            this.indexDirFile.mkdir();
        }
        this.xmlIndexBuilder = new XmlIndexBuilder(string);
        String[] stringArray = new String[]{"vnd.sun.star.help://", "#HLP#"};
        PrefixTranslator prefixTranslator = PrefixTranslator.makePrefixTranslator((String[])stringArray);
        this.xmlIndexBuilder.setPrefixTranslator(prefixTranslator);
        String string2 = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"*|/\"/></xsl:stylesheet>";
        this.createFileFromBytes("default.xsl", string2.getBytes("UTF8"));
        this.xmlIndexBuilder.clearIndex();
        this.xmlIndexBuilder.setTransformLocation(this.indexDirParentName);
    }

    private void createFileFromBytes(String string, byte[] byArray) throws IOException {
        File file = new File(this.indexDirParentName + File.separator + string);
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    void closeXMLIndexBuilder() throws Exception {
        this.xmlIndexBuilder.close();
    }

    private static boolean removeTempDirectory(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!(fileArray[i].isDirectory() ? !HelpLinker.removeTempDirectory(string + File.separator + fileArray[i].getName()) : !fileArray[i].delete())) continue;
            return false;
        }
        return file.delete();
    }

    private void link() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = this.outputFile + ".tmp";
        File file = new File(string);
        file.createNewFile();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (fileOutputStream == null) {
            System.exit(1);
        }
        try {
            this.jarOutputStream = new JarOutputStream(fileOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        String string2 = this.module.toLowerCase();
        if (string2.startsWith("s")) {
            string2 = string2.substring(1);
        }
        File file2 = File.createTempFile("helptext", ".ht");
        file2.deleteOnExit();
        String string3 = file2.getAbsolutePath();
        Db db = new Db(null, 0);
        db.open(null, string3, null, 1, Db.DB_TRUNCATE, 420);
        File file3 = File.createTempFile("database", "db");
        file3.deleteOnExit();
        String string4 = file3.getAbsolutePath();
        Db db2 = new Db(null, 0);
        db2.open(null, string4, null, 1, Db.DB_TRUNCATE, 420);
        File file4 = File.createTempFile("keybase", "key");
        file4.deleteOnExit();
        String string5 = file4.getAbsolutePath();
        Db db3 = new Db(null, 0);
        db3.open(null, string5, null, 1, Db.DB_TRUNCATE, 420);
        HelpKeyword helpKeyword = new HelpKeyword();
        FileReader fileReader = new FileReader(this.hid);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        char[] cArray = new char[1024];
        while ((n = fileReader.read(cArray, 0, 1024)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        String string6 = stringBuffer.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string6);
        while (stringTokenizer.hasMoreTokens()) {
            object4 = stringTokenizer.nextToken();
            object3 = stringTokenizer.nextToken();
            this.hidlistTranslation.put(((String)object4).toUpperCase().replace(':', '_'), ((String)object3).trim());
        }
        if (!this.helpFiles.isEmpty()) {
            this.initXMLIndexBuilder();
        }
        object4 = this.helpFiles.iterator();
        while (object4.hasNext()) {
            Dbt dbt;
            LinkedList linkedList;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            object3 = new Hashtable();
            object2 = (File[])object4.next();
            if (!((String)object2).endsWith(".xhp")) {
                System.err.println("ERROR: input list entry '" + (String)object2 + "' has the wrong extension (only files with extension .xhp " + "are accepted)");
                continue;
            }
            HelpCompiler helpCompiler = new HelpCompiler((Hashtable)object3, (String)object2, this.sourceRoot + File.separator + this.lang + File.separator, this.embeddStylesheet, this.module, this.lang);
            try {
                boolean bl = helpCompiler.compile();
                if (!bl) {
                    System.err.println("\nERROR: compiling help particle '" + (String)object2 + "' for language '" + this.lang + "' failed!");
                    System.exit(1);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("\nERROR: unsupported Encoding Exception'': " + unsupportedEncodingException.getMessage());
                System.exit(1);
            }
            object = (byte[])((Hashtable)object3).get("document/id");
            String string7 = null;
            if (object != null) {
                string7 = new String((byte[])object, "UTF8");
            } else {
                System.err.println("corrupt compileroutput");
                System.exit(1);
            }
            String string8 = new String((byte[])((Hashtable)object3).get("document/path"), "UTF8");
            if (string8.startsWith("/")) {
                string8 = string8.substring(1);
            }
            String string9 = new String((byte[])((Hashtable)object3).get("document/module"), "UTF8") + ".jar";
            byte[] byArray = (byte[])((Hashtable)object3).get("document/title");
            String string10 = null;
            string10 = byArray != null ? new String(byArray, "UTF8") : "<notitle>";
            byte[] byArray2 = string8.getBytes("UTF8");
            byte[] byArray3 = string9.getBytes("UTF8");
            byte[] byArray4 = string10.getBytes("UTF8");
            this.addBookmark(db2, string8, byArray2, null, byArray3, byArray4);
            if (this.init) {
                object8 = new FileInputStream(this.indexStylesheet);
                int n2 = 0;
                object7 = new byte[2048];
                object6 = new ByteArrayOutputStream();
                while ((n2 = ((FileInputStream)object8).read((byte[])object7, 0, 2048)) != -1) {
                    ((ByteArrayOutputStream)object6).write((byte[])object7, 0, n2);
                }
                this.createFileFromBytes("index.xsl", ((ByteArrayOutputStream)object6).toByteArray());
                this.xmlIndexBuilder.init("index");
                this.init = false;
            }
            if ((object8 = ((Hashtable)object3).get(string2 + "/hidlist")) == null) {
                object8 = ((Hashtable)object3).get("default/hidlist");
            }
            if (object8 != null) {
                HashSet hashSet = (HashSet)object8;
                object7 = hashSet.iterator();
                while (object7.hasNext()) {
                    object6 = (String)object7.next();
                    object5 = null;
                    int n3 = ((String)object6).lastIndexOf(35);
                    if (n3 != -1) {
                        object5 = ((String)object6).substring(1 + n3).getBytes("UTF8");
                        object6 = ((String)object6).substring(0, n3);
                    }
                    this.addBookmark(db2, (String)object6, byArray2, (byte[])object5, byArray3, byArray4);
                }
            }
            if ((object8 = ((Hashtable)object3).get(string2 + "/keywords")) == null) {
                object8 = ((Hashtable)object3).get("default/keywords");
            }
            if (object8 != null) {
                Hashtable hashtable = (Hashtable)object8;
                object7 = hashtable.keys();
                object6 = URLEncoder.encode(string8);
                while (object7.hasMoreElements()) {
                    object5 = (String)object7.nextElement();
                    this.addBookmark(db2, string8, byArray2, ((String)object5).getBytes("UTF8"), byArray3, byArray4);
                    String string11 = (String)object6 + "#" + (String)object5;
                    linkedList = (LinkedList)hashtable.get(object5);
                    dbt = linkedList.iterator();
                    while (dbt.hasNext()) {
                        helpKeyword.insert((String)dbt.next(), string11);
                    }
                }
            }
            if ((object8 = ((Hashtable)object3).get(string2 + "/helptexts")) == null) {
                object8 = ((Hashtable)object3).get("default/helptexts");
            }
            if (object8 != null) {
                Hashtable hashtable = (Hashtable)object8;
                object7 = hashtable.keys();
                while (object7.hasMoreElements()) {
                    object6 = (String)object7.nextElement();
                    object5 = (String)hashtable.get(object6);
                    String string12 = (String)this.hidlistTranslation.get(((String)object6).toUpperCase().replace(':', '_'));
                    if (string12 != null) {
                        object6 = string12;
                    }
                    object6 = URLEncoder.encode((String)object6);
                    linkedList = new Dbt(((String)object6).getBytes("UTF8"));
                    dbt = new Dbt(((String)object5).getBytes("UTF8"));
                    db.put(null, (Dbt)linkedList, dbt, 0);
                }
            }
            if ((object8 = (Object)((byte[])((Hashtable)object3).get(string2 + "/text"))) == null) {
                object8 = (byte[])((Hashtable)object3).get("default/text");
            }
            if (object8 == null) continue;
            byte[] byArray5 = (byte[])object8;
            HelpURLStreamHandlerFactory.setMode(byArray5);
            this.xmlIndexBuilder.indexDocument(new URL("vnd.sun.star.help://" + this.module.toLowerCase() + "/" + URLEncoder.encode(string8)), "");
        }
        db.close(0);
        db2.close(0);
        helpKeyword.dump(db3);
        db3.close(0);
        if (!this.helpFiles.isEmpty()) {
            this.closeXMLIndexBuilder();
        }
        object3 = this.module.toLowerCase();
        this.copyFileToJarfile(string3, null, (String)object3 + ".ht");
        this.copyFileToJarfile(string4, null, (String)object3 + ".db");
        this.copyFileToJarfile(string5, null, (String)object3 + ".key");
        file2.delete();
        file3.delete();
        file4.delete();
        if (this.indexDirFile != null) {
            object2 = this.indexDirFile.listFiles();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                this.copyFileToJarfile(((File)object2[i]).getAbsolutePath(), (String)object3 + ".idx", ((File)object2[i]).getName());
            }
        }
        object2 = this.additionalFiles.keys();
        while (object2.hasMoreElements()) {
            String string13 = (String)object2.nextElement();
            object = (String)this.additionalFiles.get(string13);
            this.copyFileToJarfile((String)object, null, string13);
        }
        try {
            this.jarOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file5 = new File(this.outputFile);
        if (file5.exists() && !file5.delete()) {
            System.err.println("can't delete file '" + this.outputFile + "'");
            System.exit(1);
        }
        if (!file.renameTo(file5)) {
            System.err.println("can't rename file '" + string + "'");
            System.exit(1);
        }
        if (!this.helpFiles.isEmpty() && !HelpLinker.removeTempDirectory(this.indexDirParentName)) {
            System.err.println("can't remove temporary directory '" + this.indexDirParentName + "'");
            System.exit(1);
        }
    }

    private void copyFileToJarfile(String string, String string2, String string3) throws IOException {
        int n = 0;
        FileInputStream fileInputStream = new FileInputStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        this.addEntryToJarFile(string2, string3, byteArrayOutputStream.toByteArray());
    }

    private void addBookmark(Db db, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws DbException, UnsupportedEncodingException {
        int n;
        String string2 = (String)this.hidlistTranslation.get(string.toUpperCase().replace(':', '_'));
        if (string2 != null) {
            string = string2;
        }
        string = URLEncoder.encode(string);
        Dbt dbt = new Dbt(string.getBytes("UTF8"));
        int n2 = byArray.length;
        if (byArray2 != null) {
            n2 += 1 + byArray2.length;
        }
        int n3 = 1 + n2 + 1 + byArray3.length + 1 + byArray4.length;
        byte[] byArray5 = new byte[n3];
        int n4 = 0;
        byArray5[n4++] = (byte)n2;
        for (n = 0; n < byArray.length; ++n) {
            byArray5[n4++] = byArray[n];
        }
        if (byArray2 != null) {
            byArray5[n4++] = 35;
            for (n = 0; n < byArray2.length; ++n) {
                byArray5[n4++] = byArray2[n];
            }
        }
        byArray5[n4++] = (byte)byArray3.length;
        for (n = 0; n < byArray3.length; ++n) {
            byArray5[n4++] = byArray3[n];
        }
        byArray5[n4++] = (byte)byArray4.length;
        for (n = 0; n < byArray4.length; ++n) {
            byArray5[n4++] = byArray4[n];
        }
        Dbt dbt2 = new Dbt(byArray5);
        db.put(null, dbt, dbt2, 0);
    }

    private void addEntryToJarFile(String string, String string2, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        try {
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            JarEntry jarEntry = new JarEntry(string != null ? string + "/" + string2 : string2);
            jarEntry.setCrc(cRC32.getValue());
            jarEntry.setSize(byArray.length);
            jarEntry.setMethod(8);
            this.jarOutputStream.putNextEntry(jarEntry);
            if (byArray.length > 0) {
                this.jarOutputStream.write(byArray);
            }
            this.jarOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public HelpLinker(String string, String string2, String string3, String string4, String string5, String string6, String string7, HashSet hashSet, Hashtable hashtable) {
        this.sourceRoot = string;
        this.embeddStylesheet = string2;
        this.indexStylesheet = string3;
        this.outputFile = string4;
        this.module = string5;
        this.lang = string6;
        this.hid = string7;
        this.helpFiles = hashSet;
        this.additionalFiles = hashtable;
    }
}

