/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Impress;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XExporter;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLSettingsExporter
extends TestCase {
    XComponent xImpressDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating an impress document");
            this.xImpressDoc = sOfficeFactory.createImpressDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xImpressDoc ");
        this.xImpressDoc.dispose();
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        boolean bl;
        Object object;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        XInterface xInterface = null;
        FilterChecker filterChecker = new FilterChecker(printWriter);
        Any any = new Any(new Type(XDocumentHandler.class), (Object)filterChecker);
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstanceWithArguments("com.sun.star.comp.Impress.XMLSettingsExporter", new Object[]{any});
            object = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)xInterface);
            object.setSourceDocument(this.xImpressDoc);
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xImpressDoc);
            XController xController = xModel.getCurrentController();
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xController);
            bl = (Boolean)xPropertySet.getPropertyValue("IsLayerMode") == false;
            xPropertySet.setPropertyValue("IsLayerMode", new Boolean(bl));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        filterChecker.addTagEnclosed(new XMLTools.Tag("office:settings"), new XMLTools.Tag("office:document-settings"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("config:config-item-set"), new XMLTools.Tag("office:settings"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("config:config-item-map-indexed"), new XMLTools.Tag("config:config-item-set"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("config:config-item-map-entry"), new XMLTools.Tag("config:config-item-map-indexed"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("config:config-item"), new XMLTools.Tag("config:config-item-map-entry"));
        filterChecker.addCharactersEnclosed(String.valueOf(bl), new XMLTools.Tag("config:config-item", "config:name", "IsLayerMode"));
        printWriter.println("creating a new environment");
        object = new TestEnvironment(xInterface);
        ((TestEnvironment)object).addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"simpress: StarOffice XML (Impress)"}));
        ((TestEnvironment)object).addObjRelation("SourceDocument", this.xImpressDoc);
        ((TestEnvironment)object).addObjRelation("XFilter.Checker", filterChecker);
        return object;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter printWriter) {
            super(printWriter, false);
        }

        public boolean checkFilter() {
            return this.check();
        }
    }
}

