/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDevice;
import com.sun.star.awt.XGraphics;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XControlAccess;
import ifc.awt._XItemListener;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;
import util.utils;

public class UnoControlListBox
extends TestCase {
    private static XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(xTextDoc);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XControl xControl = null;
        XWindowPeer xWindowPeer = null;
        XToolkit xToolkit = null;
        XDevice xDevice = null;
        XGraphics xGraphics = null;
        XControl xControl2 = null;
        XControlShape xControlShape = FormTools.createUnoControlShape(xTextDoc, 3000, 4500, 15000, 10000, "ListBox", "UnoControlListBox");
        WriterTools.getDrawPage(xTextDoc).add(xControlShape);
        XControlModel xControlModel = xControlShape.getControl();
        XControlShape xControlShape2 = FormTools.createControlShape(xTextDoc, 3000, 4500, 5000, 10000, "TextField");
        WriterTools.getDrawPage(xTextDoc).add(xControlShape2);
        XControlModel xControlModel2 = xControlShape2.getControl();
        XControlAccess xControlAccess = (XControlAccess)UnoRuntime.queryInterface(XControlAccess.class, (Object)xTextDoc.getCurrentController());
        try {
            xControl = xControlAccess.getControl(xControlModel);
            xControl2 = xControlAccess.getControl(xControlModel2);
            xWindowPeer = xControlAccess.getControl(xControlModel).getPeer();
            xToolkit = xWindowPeer.getToolkit();
            xDevice = xToolkit.createScreenCompatibleDevice(200, 200);
            xGraphics = xDevice.createGraphics();
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get ListBoxControl");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get ListBoxControl", exception);
        }
        printWriter.println("creating a new environment for UnoControlListBox object");
        TestEnvironment testEnvironment = new TestEnvironment(xControl);
        testEnvironment.addObjRelation("GRAPHICS", xGraphics);
        testEnvironment.addObjRelation("CONTEXT", xTextDoc);
        testEnvironment.addObjRelation("WINPEER", xWindowPeer);
        testEnvironment.addObjRelation("TOOLKIT", xToolkit);
        testEnvironment.addObjRelation("MODEL", xControlModel);
        _XItemListener.TestItemListener testItemListener = new _XItemListener.TestItemListener();
        XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)xControl);
        xListBox.addItemListener(testItemListener);
        testEnvironment.addObjRelation("TestItemListener", testItemListener);
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xControl2);
        testEnvironment.addObjRelation("XWindow.AnotherWindow", xWindow);
        testEnvironment.addObjRelation("XWindow.ControlShape", xControlShape);
        System.out.println("ImplementationName: " + utils.getImplName(xControl));
        return testEnvironment;
    }
}

