/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XTabControllerModel;
import com.sun.star.drawing.XControlShape;
import com.sun.star.form.XForm;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XControlAccess;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.WriterTools;
import util.utils;

public class TabController
extends TestCase {
    private static XTextDocument xTextDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        try {
            printWriter.println("creating a textdocument");
            xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)testParameters.getMSF());
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xTextDoc");
        DesktopTools.closeDoc(xTextDoc);
    }

    public TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        XControl xControl = null;
        XTabControllerModel xTabControllerModel = null;
        XControlContainer xControlContainer = null;
        FormTools.insertForm(xTextDoc, FormTools.getForms(WriterTools.getDrawPage(xTextDoc)), "MyForm");
        XControlShape xControlShape = FormTools.createUnoControlShape(xTextDoc, 3000, 4500, 15000, 10000, "CommandButton", "UnoControlButton");
        WriterTools.getDrawPage(xTextDoc).add(xControlShape);
        XControlModel xControlModel = xControlShape.getControl();
        XControlAccess xControlAccess = (XControlAccess)UnoRuntime.queryInterface(XControlAccess.class, (Object)xTextDoc.getCurrentController());
        try {
            xControl = xControlAccess.getControl(xControlModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        XForm xForm = null;
        try {
            xForm = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)FormTools.getForms(WriterTools.getDrawPage(xTextDoc)).getByName("MyForm"));
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get Form");
            exception.printStackTrace(printWriter);
        }
        xTabControllerModel = (XTabControllerModel)UnoRuntime.queryInterface(XTabControllerModel.class, xForm);
        xControlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, xControl.getContext());
        try {
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.TabController");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        String string = "TabController";
        testEnvironment.addObjRelation("OBJNAME", "toolkit." + string);
        testEnvironment.addObjRelation("MODEL", xTabControllerModel);
        testEnvironment.addObjRelation("CONTAINER", xControlContainer);
        System.out.println("ImplementationName: " + utils.getImplName(xInterface));
        return testEnvironment;
    }
}

