/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleMenu
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            object = SOfficeFactory.getFactory(xMultiServiceFactory);
            xTextDoc = ((SOfficeFactory)object).createTextDoc(null);
        }
        catch (Exception exception) {
            throw new StatusException("Can't create document", exception);
        }
        object = null;
        try {
            object = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, object);
        this.shortWait();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getActiveTopWindow());
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)35);
        XAccessible xAccessible2 = null;
        try {
            object = xAccessibleContext.getAccessibleChild(2);
            xAccessible2 = xAccessibleContext.getAccessibleChild(1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        printWriter.println("ImplementationName " + utils.getImplName(object));
        TestEnvironment testEnvironment = new TestEnvironment((XInterface)object);
        final XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, object);
        final XAccessibleAction xAccessibleAction2 = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)xAccessible2);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    xAccessibleAction2.doAccessibleAction(0);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    xAccessibleAction.doAccessibleAction(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, object);
        testEnvironment.addObjRelation("XAccessibleText.Text", xAccessibleText.getText());
        testEnvironment.addObjRelation("EditOnly", "Can't change or select Text in Menu");
        testEnvironment.addObjRelation("LimitedBounds", "yes");
        testEnvironment.addObjRelation("XAccessibleSelection.OneAlwaysSelected", new Boolean(false));
        testEnvironment.addObjRelation("XAccessibleSelection.multiSelection", new Boolean(false));
        return testEnvironment;
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        try {
            DesktopTools.closeDoc(xTextDoc);
        }
        catch (DisposedException disposedException) {
            printWriter.println("Object already disposed");
        }
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("While waiting :" + interruptedException);
        }
    }
}

