/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.utils;

public class AccessibleFixedText
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;
    private static XWindow xWinDlg = null;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface;
        Object object;
        XInterface xInterface2;
        XInterface xInterface3 = null;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        XControlModel xControlModel = null;
        XControl xControl = null;
        XControlModel xControlModel2 = null;
        try {
            xControlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlDialogModel"));
            xInterface2 = (XControl)UnoRuntime.queryInterface(XControl.class, xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlDialog"));
            xInterface2.setModel(xControlModel);
            xControlModel2 = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlFixedTextModel"));
            xControl = (XControl)UnoRuntime.queryInterface(XControl.class, xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlFixedText"));
            xControl.setModel(xControlModel2);
            object = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)xControl);
            object.setText("FxedText");
            xInterface = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)xInterface2);
            xInterface.addControl("Text", xControl);
            xWinDlg = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xInterface2);
            xWinDlg.setVisible(true);
            xWinDlg.setPosSize(0, 0, 200, 100, (short)12);
        }
        catch (Exception exception) {
            printWriter.println("Error creating dialog :");
            exception.printStackTrace(printWriter);
        }
        try {
            xInterface3 = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        xInterface2 = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface3);
        this.shortWait();
        object = new AccessibilityTools();
        xInterface = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xInterface2.getActiveTopWindow());
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xInterface);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        xInterface3 = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)30);
        printWriter.println("ImplementationName " + utils.getImplName(xInterface3));
        TestEnvironment testEnvironment = new TestEnvironment(xInterface3);
        final XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xControl);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                xWindow.setEnable(false);
                xWindow.setEnable(true);
            }
        });
        XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)xInterface3);
        testEnvironment.addObjRelation("XAccessibleText.Text", xAccessibleText.getText());
        testEnvironment.addObjRelation("EditOnly", "This method isn't supported in this component");
        testEnvironment.addObjRelation("LimitedBounds", "yes");
        return testEnvironment;
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    Closing dialog ... ");
        xWinDlg.dispose();
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("While waiting :" + interruptedException);
        }
    }
}

