/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextSection;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XWordCursor;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XSelectionSupplier;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.WriterTools;

public class SwXTextDocument
extends TestCase {
    XTextDocument xTextDoc;
    XTextDocument xSecondTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xSecondTextDoc);
        DesktopTools.closeDoc(this.xTextDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XInterface xInterface;
        XInterface xInterface2;
        XInterface xInterface3;
        XInterface xInterface4;
        TestEnvironment testEnvironment = null;
        XTextTable xTextTable = null;
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)testParameters.getMSF());
            xInterface4 = this.xTextDoc.getText();
            xInterface3 = xInterface4.createTextCursor();
            printWriter.println("inserting some lines");
            try {
                int n;
                for (n = 0; n < 5; ++n) {
                    xInterface4.insertString((XTextRange)xInterface3, "Paragraph Number: " + n, false);
                    xInterface4.insertString((XTextRange)xInterface3, " The quick brown fox jumps over the lazy Dog: SwXParagraph", false);
                    xInterface4.insertControlCharacter((XTextRange)xInterface3, (short)0, false);
                    xInterface4.insertString((XTextRange)xInterface3, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG: SwXParagraph", false);
                    xInterface4.insertControlCharacter((XTextRange)xInterface3, (short)0, false);
                    xInterface4.insertControlCharacter((XTextRange)xInterface3, (short)1, false);
                }
                for (n = 0; n < 11; ++n) {
                    xInterface4.insertString((XTextRange)xInterface3, "xTextDoc ", false);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace(printWriter);
                throw new StatusException("Couldn't insert lines", illegalArgumentException);
            }
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
            XTextSectionsSupplier xTextSectionsSupplier = (XTextSectionsSupplier)UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.xTextDoc);
            XNameAccess xNameAccess = xTextSectionsSupplier.getTextSections();
            xInterface2 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.text.TextSection");
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xInterface2);
            xInterface4.insertTextContent((XTextRange)xInterface3, xTextContent, false);
            XWordCursor xWordCursor = (XWordCursor)UnoRuntime.queryInterface(XWordCursor.class, (Object)xInterface3);
            xInterface3.setString("End of TextSection");
            xInterface3.gotoStart(false);
            xInterface3.setString("Start of TextSection ");
            xWordCursor.gotoEndOfWord(false);
            XInterface xInterface5 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.text.TextSection");
            xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xInterface5);
            xInterface4.insertTextContent((XTextRange)xInterface3, xTextContent, false);
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xNameAccess);
            printWriter.println("getting a TextSection with the XTextSectionSupplier()");
            xInterface = (XTextSection)UnoRuntime.queryInterface(XTextSection.class, xIndexAccess.getByIndex(0));
            XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)xInterface);
            xNamed.setName("SwXTextSection");
            printWriter.println("    adding TextTable");
            xTextTable = SOfficeFactory.createTextTable(this.xTextDoc, 6, 4);
            XNamed xNamed2 = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)xTextTable);
            xNamed2.setName("SwXTextDocument");
            SOfficeFactory.insertTextContent(this.xTextDoc, xTextTable);
            printWriter.println("    adding ReferenceMark");
            XInterface xInterface6 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.text.ReferenceMark");
            xNamed2 = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)xInterface6);
            xNamed2.setName("SwXTextDocument");
            XTextContent xTextContent2 = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xInterface6);
            SOfficeFactory.insertTextContent(this.xTextDoc, xTextContent2);
            printWriter.println("    adding TextGraphic");
            WriterTools.insertTextGraphic(this.xTextDoc, xMultiServiceFactory, 5200, 4200, 4400, 4000, "space-metal.jpg", "SwXTextDocument");
            printWriter.println("    adding EndNote");
            XInterface xInterface7 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.text.Endnote");
            xTextContent2 = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xInterface7);
            SOfficeFactory.insertTextContent(this.xTextDoc, xTextContent2);
            printWriter.println("    adding Bookmark");
            SOfficeFactory.insertTextContent(this.xTextDoc, SOfficeFactory.createBookmark(this.xTextDoc));
            printWriter.println("    adding DocumentIndex");
            xTextContent2 = SOfficeFactory.createIndex(this.xTextDoc, "com.sun.star.text.DocumentIndex");
            SOfficeFactory.insertTextContent(this.xTextDoc, xTextContent2);
            printWriter.println("    adding TextFrame");
            XTextFrame xTextFrame = SOfficeFactory.createTextFrame(this.xTextDoc, 500, 500);
            xTextContent2 = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xTextFrame);
            SOfficeFactory.insertTextContent(this.xTextDoc, xTextContent2);
            printWriter.println("creating a second textdocument");
            this.xSecondTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)testParameters.getMSF());
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        if (this.xTextDoc != null) {
            printWriter.println("Creating instance...");
            xInterface4 = this.xTextDoc.getText();
            xInterface3 = xInterface4.createTextCursor();
            for (int i = 0; i < 11; ++i) {
                xInterface4.insertString((XTextRange)xInterface3, "xTextDoc ", false);
            }
        } else {
            printWriter.println("Failed to create instance.");
            return testEnvironment;
        }
        testEnvironment = new TestEnvironment(this.xTextDoc);
        xInterface4 = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        xInterface3 = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xSecondTextDoc);
        XController xController = xInterface4.getCurrentController();
        xInterface2 = xInterface3.getCurrentController();
        xController.getFrame().setName("cont1");
        xInterface2.getFrame().setName("cont2");
        xInterface = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xController);
        printWriter.println("Adding SelectionSupplier and Shape to select for XModel");
        testEnvironment.addObjRelation("SELSUPP", xInterface);
        testEnvironment.addObjRelation("TOSELECT", xTextTable);
        printWriter.println("adding Controller as ObjRelation for XModel");
        testEnvironment.addObjRelation("CONT1", xController);
        testEnvironment.addObjRelation("CONT2", xInterface2);
        return testEnvironment;
    }
}

