/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XViewSettingsSupplier;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.WriterTools;
import util.utils;

public class SwAccessibleEndnoteView
extends TestCase {
    XTextDocument xTextDoc = null;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XAccessibleContext xAccessibleContext = null;
        XInterface xInterface = null;
        printWriter.println("Creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        printWriter.println("creating a endnote");
        try {
            xInterface = (XInterface)UnoRuntime.queryInterface(XInterface.class, xMultiServiceFactory.createInstance("com.sun.star.text.Endnote"));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create endnote", exception);
        }
        XText xText = this.xTextDoc.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        printWriter.println("inserting the footnote into text document");
        XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xInterface);
        try {
            xText.insertTextContent(xTextCursor, xTextContent, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't insert the endnote", illegalArgumentException);
        }
        XController xController = this.xTextDoc.getCurrentController();
        XViewSettingsSupplier xViewSettingsSupplier = (XViewSettingsSupplier)UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)xController);
        XPropertySet xPropertySet = xViewSettingsSupplier.getViewSettings();
        try {
            xPropertySet.setPropertyValue("ZoomValue", new Short("10"));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set propertyValue...", wrappedTargetException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set propertyValue...", illegalArgumentException);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set propertyValue...", propertyVetoException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set propertyValue...", unknownPropertyException);
        }
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)testParameters.getMSF(), xModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)15);
        xAccessibleContext = AccessibilityTools.SearchedContext;
        printWriter.println("ImplementationName " + utils.getImplName(xAccessibleContext));
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        TestEnvironment testEnvironment = new TestEnvironment(xAccessibleContext);
        final XPropertySet xPropertySet2 = xViewSettingsSupplier.getViewSettings();
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    xPropertySet2.setPropertyValue("ZoomValue", new Short("15"));
                    xPropertySet2.setPropertyValue("ZoomValue", new Short("10"));
                }
                catch (WrappedTargetException wrappedTargetException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (PropertyVetoException propertyVetoException) {
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    // empty catch block
                }
            }
        });
        return testEnvironment;
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("dispose text document");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a text document");
        this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)testParameters.getMSF());
    }
}

