/*
 * Decompiled with CFR 0.152.
 */
package mod._svtools;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.view.XSelectionSupplier;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleBrowseBoxTable
extends TestCase {
    XDesktop the_Desk;
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        this.the_Desk = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)testParameters.getMSF()));
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xTextDoc");
        if (this.xTextDoc != null) {
            this.xTextDoc.dispose();
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a test environment");
        if (this.xTextDoc != null) {
            this.xTextDoc.dispose();
        }
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a text document");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        this.shortWait();
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        XController xController = xModel.getCurrentController();
        XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
        XDispatch xDispatch = null;
        printWriter.println("opening DatasourceBrowser");
        URL uRL = new URL();
        uRL.Complete = ".component:DB/DataSourceBrowser";
        xDispatch = xDispatchProvider.queryDispatch(uRL, "_beamer", 12);
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        xDispatch.dispatch(uRL, propertyValueArray);
        this.shortWait();
        XFrame xFrame = this.the_Desk.getCurrentFrame();
        if (xFrame == null) {
            printWriter.println("Current frame was not found !!!");
        }
        XFrame xFrame2 = xFrame.findFrame("_beamer", 4);
        XController xController2 = xFrame2.getController();
        xFrame2.setName("DatasourceBrowser");
        final PropertyValue[] propertyValueArray2 = new PropertyValue[3];
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "DataSourceName";
        propertyValue.Value = "Bibliography";
        propertyValueArray2[0] = propertyValue;
        PropertyValue propertyValue2 = new PropertyValue();
        propertyValue2.Name = "CommandType";
        propertyValue2.Value = new Integer(0);
        propertyValueArray2[1] = propertyValue2;
        PropertyValue propertyValue3 = new PropertyValue();
        propertyValue3.Name = "Command";
        propertyValue3.Value = "biblio";
        propertyValueArray2[2] = propertyValue3;
        final XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xController2);
        PropertyValue[] propertyValueArray3 = propertyValueArray2;
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface);
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getActiveTopWindow());
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        xInterface = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)58, "Table");
        printWriter.println("ImplementationName: " + utils.getImplName(xInterface));
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    xSelectionSupplier.select(propertyValueArray2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        return testEnvironment;
    }

    private void shortWait() {
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }
}

