/*
 * Decompiled with CFR 0.152.
 */
package mod._svtools;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.awt.Point;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.view.XSelectionSupplier;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleBrowseBoxHeaderBar
extends TestCase {
    XDesktop the_Desk;
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        this.the_Desk = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)testParameters.getMSF()));
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xTextDoc");
        if (this.xTextDoc != null) {
            this.xTextDoc.dispose();
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a test environment");
        if (this.xTextDoc != null) {
            this.xTextDoc.dispose();
        }
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a text document");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        this.shortWait();
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        XController xController = xModel.getCurrentController();
        XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
        XDispatch xDispatch = null;
        printWriter.println("opening DatasourceBrowser");
        URL uRL = new URL();
        uRL.Complete = ".component:DB/DataSourceBrowser";
        xDispatch = xDispatchProvider.queryDispatch(uRL, "_beamer", 12);
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        xDispatch.dispatch(uRL, propertyValueArray);
        PropertyValue[] propertyValueArray2 = new PropertyValue[3];
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "DataSourceName";
        propertyValue.Value = "Bibliography";
        propertyValueArray2[0] = propertyValue;
        PropertyValue propertyValue2 = new PropertyValue();
        propertyValue2.Name = "CommandType";
        propertyValue2.Value = new Integer(0);
        propertyValueArray2[1] = propertyValue2;
        PropertyValue propertyValue3 = new PropertyValue();
        propertyValue3.Name = "Command";
        propertyValue3.Value = "biblio";
        propertyValueArray2[2] = propertyValue3;
        this.shortWait();
        XFrame xFrame = this.the_Desk.getCurrentFrame();
        if (xFrame == null) {
            printWriter.println("Current frame was not found !!!");
        }
        XFrame xFrame2 = xFrame.findFrame("_beamer", 4);
        xFrame2.setName("DatasourceBrowser");
        XController xController2 = xFrame2.getController();
        XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xController2);
        try {
            xSelectionSupplier.select(propertyValueArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StatusException("Could not select Biblio-Database", illegalArgumentException);
        }
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface);
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getActiveTopWindow());
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        xInterface = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)58);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        printWriter.println("ImplementationName: " + utils.getImplName(xInterface));
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        this.shortWait();
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xInterface);
        final Point point = xAccessibleComponent.getLocationOnScreen();
        this.shortWait();
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    Robot robot = new Robot();
                    robot.mouseMove(point.X + 5, point.Y + 5);
                    robot.mousePress(16);
                }
                catch (AWTException aWTException) {
                    System.out.println("couldn't fire event");
                }
            }
        });
        return testEnvironment;
    }

    private void shortWait() {
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }
}

