/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.ConditionOperator;
import com.sun.star.sheet.XSheetConditionalEntries;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScTableConditionalFormat
extends TestCase {
    static XSpreadsheetDocument xSpreadsheetDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a sheetdocument");
            xSpreadsheetDoc = sOfficeFactory.createCalcDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xSheetDoc ");
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(xComponent);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        printWriter.println("getting sheets");
        XSpreadsheets xSpreadsheets = xSpreadsheetDoc.getSheets();
        printWriter.println("getting a sheet");
        XSpreadsheet xSpreadsheet = null;
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        try {
            xSpreadsheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get a spreadsheet", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get a spreadsheet", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get a spreadsheet", illegalArgumentException);
        }
        printWriter.println("filling some cells");
        try {
            xSpreadsheet.getCellByPosition(5, 5).setValue(15.0);
            xSpreadsheet.getCellByPosition(1, 4).setValue(10.0);
            xSpreadsheet.getCellByPosition(2, 0).setValue(-5.15);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            printWriter.println("Exception occurred while filling cells");
            indexOutOfBoundsException.printStackTrace(printWriter);
        }
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xSpreadsheet);
        try {
            xInterface = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)xPropertySet.getPropertyValue("ConditionalFormat"));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get ConditionalFromat", wrappedTargetException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get ConditionalFromat", unknownPropertyException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get ConditionalFromat", illegalArgumentException);
        }
        XSheetConditionalEntries xSheetConditionalEntries = (XSheetConditionalEntries)UnoRuntime.queryInterface(XSheetConditionalEntries.class, (Object)xInterface);
        xSheetConditionalEntries.addNew(this.Conditions(5));
        xSheetConditionalEntries.addNew(this.Conditions(2));
        printWriter.println("creating a new environment for object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        return testEnvironment;
    }

    public PropertyValue[] Conditions(int n) {
        PropertyValue[] propertyValueArray = new PropertyValue[5];
        CellAddress cellAddress = new CellAddress();
        cellAddress.Column = 1;
        cellAddress.Row = 5;
        cellAddress.Sheet = 0;
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "StyleName";
        propertyValueArray[0].Value = "Result2";
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "Formula1";
        propertyValueArray[1].Value = "$Sheet1.$B$" + n;
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "Formula2";
        propertyValueArray[2].Value = "";
        propertyValueArray[3] = new PropertyValue();
        propertyValueArray[3].Name = "Operator";
        propertyValueArray[3].Value = ConditionOperator.EQUAL;
        propertyValueArray[4] = new PropertyValue();
        propertyValueArray[4].Name = "SourcePosition";
        propertyValueArray[4].Value = cellAddress;
        return propertyValueArray;
    }
}

