/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import java.util.Comparator;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.ValueComparer;

public class ScTabViewObj
extends TestCase {
    public static XSpreadsheetDocument xSpreadsheetDoc;
    public static XSpreadsheetDocument xSpreadsheetDoc2;

    public void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating two spreadsheet documents");
            xSpreadsheetDoc = sOfficeFactory.createCalcDoc(null);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            xSpreadsheetDoc2 = sOfficeFactory.createCalcDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document ", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xSheetDoc ");
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(xComponent);
        XComponent xComponent2 = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc2);
        DesktopTools.closeDoc(xComponent2);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        XModel xModel2 = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc2);
        XController xController = xModel.getCurrentController();
        printWriter.println("getting sheets");
        XSpreadsheets xSpreadsheets = xSpreadsheetDoc.getSheets();
        printWriter.println("getting a sheet");
        XSpreadsheet xSpreadsheet = null;
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        try {
            xSpreadsheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xIndexAccess.getByIndex(1));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get a spreadsheet", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get a spreadsheet", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get a spreadsheet", illegalArgumentException);
        }
        TestEnvironment testEnvironment = new TestEnvironment(xController);
        testEnvironment.addObjRelation("XDispatchProvider.URL", ".uno:Copy");
        printWriter.println("adding 'Sheet' as ObjRelation");
        testEnvironment.addObjRelation("Sheet", xSpreadsheet);
        testEnvironment.addObjRelation("Frame", xModel.getCurrentController().getFrame());
        testEnvironment.addObjRelation("SecondModel", xModel2);
        testEnvironment.addObjRelation("FirstModel", xModel);
        testEnvironment.addObjRelation("DOCUMENT", UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc));
        testEnvironment.addObjRelation("XControlAccess.isSheet", Boolean.TRUE);
        XCell xCell = null;
        XCell xCell2 = null;
        XCellRange xCellRange = null;
        try {
            xCellRange = xSpreadsheet.getCellRangeByPosition(0, 0, 3, 3);
            xCell = xSpreadsheet.getCellByPosition(5, 5);
            xCell2 = xSpreadsheet.getCellByPosition(7, 7);
            xCell2.setValue(17.5);
            xCell.setValue(5.5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get some cell", indexOutOfBoundsException);
        }
        Object[] objectArray = new Object[]{xSpreadsheet, xCellRange, xCell, xCell2};
        testEnvironment.addObjRelation("Selections", objectArray);
        testEnvironment.addObjRelation("Comparer", new Comparator(){

            public int compare(Object object, Object object2) {
                CellRangeAddress cellRangeAddress;
                XCellRangeAddressable xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface(XCellRangeAddressable.class, object);
                XCellRangeAddressable xCellRangeAddressable2 = (XCellRangeAddressable)UnoRuntime.queryInterface(XCellRangeAddressable.class, object2);
                if (xCellRangeAddressable == null || xCellRangeAddressable2 == null) {
                    return -1;
                }
                CellRangeAddress cellRangeAddress2 = xCellRangeAddressable.getRangeAddress();
                return ValueComparer.equalValue(cellRangeAddress2, cellRangeAddress = xCellRangeAddressable2.getRangeAddress()) ? 0 : 1;
            }

            public boolean equals(Object object) {
                return this.compare(this, object) == 0;
            }
        });
        testEnvironment.addObjRelation("XUserInputInterception.XModel", xModel);
        return testEnvironment;
    }
}

