/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.table.XCell;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessiblePreviewCell
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a Spreadsheet document");
            xSheetDoc = sOfficeFactory.createCalcDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xSheetDoc ");
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(xComponent);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        Object object2;
        XInterface xInterface;
        Object object3;
        XInterface xInterface2;
        XInterface xInterface3;
        XAccessibleContext xAccessibleContext = null;
        XCell xCell = null;
        try {
            printWriter.println("Getting spreadsheet");
            xInterface3 = xSheetDoc.getSheets();
            xInterface2 = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xInterface3);
            object3 = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xInterface2.getByIndex(0));
            printWriter.println("Getting a cell from sheet");
            xCell = object3.getCellByPosition(0, 0);
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Error getting cell object from spreadsheet document", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Error getting cell object from spreadsheet document", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Error getting cell object from spreadsheet document", illegalArgumentException);
        }
        xCell.setFormula("Value");
        xInterface3 = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSheetDoc);
        xInterface2 = xInterface3.getCurrentController();
        try {
            object3 = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xInterface2);
            xInterface = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, ((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.util.URLTransformer"));
            object2 = new URL[]{new URL()};
            object2[0].Complete = ".uno:PrintPreview";
            xInterface.parseStrict((URL[])object2);
            object = object2[0];
            XDispatch xDispatch = object3.queryDispatch((URL)object, "", 0);
            if (xDispatch != null) {
                xDispatch.dispatch((URL)object, null);
            }
        }
        catch (Exception exception) {
            printWriter.println("Couldn't change mode");
            throw new StatusException(Status.failed("Couldn't change mode"));
        }
        this.shortWait();
        object3 = new AccessibilityTools();
        xInterface = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)testParameters.getMSF(), (XModel)xInterface3);
        object2 = AccessibilityTools.getAccessibleObject(xInterface);
        AccessibilityTools.getAccessibleObjectForRole((XAccessible)object2, (short)59, true);
        xAccessibleContext = AccessibilityTools.SearchedContext;
        printWriter.println("ImplementationName " + utils.getImplName(xAccessibleContext));
        object = new TestEnvironment(xAccessibleContext);
        ((TestEnvironment)object).addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                System.out.println("Fire Event");
            }
        });
        return object;
    }

    protected void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }
}

