/*
 * Decompiled with CFR 0.152.
 */
package ifc.ui.dialogs;

import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCancellable;
import lib.MultiMethodTest;

public class _XExecutableDialog
extends MultiMethodTest {
    public XExecutableDialog oObj = null;
    private ExecThread eThread = null;

    public void _setTitle() {
        this.oObj.setTitle("The Title");
        this.tRes.tested("setTitle()", true);
    }

    public void _execute() {
        String string = this.tEnv.getTestCase().getObjectName();
        boolean bl = false;
        if (string.startsWith("OData") || string.startsWith("OSQL")) {
            this.log.println("dbaccess dialogs can't be closed via API");
            this.log.println("therefore they aren't executed");
            this.log.println("and the result is set to true");
            bl = true;
        } else {
            this.eThread = new ExecThread(this.oObj);
            this.log.println("Starting Dialog");
            this.eThread.start();
            XCancellable xCancellable = (XCancellable)UnoRuntime.queryInterface(XCancellable.class, (Object)this.tEnv.getTestObject());
            this.shortWait();
            if (xCancellable != null) {
                this.closeDialog();
                short s = this.eThread.execRes;
                this.log.println("result: " + s);
                bl = s == 0;
            } else {
                this.disposeEnvironment();
                bl = true;
                this.log.println("XCancellable isn't supported and the environment is killed hard");
            }
        }
        this.tRes.tested("execute()", bl);
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("While waiting :" + interruptedException);
        }
    }

    public void after() {
        if (this.eThread.isAlive()) {
            this.log.println("Thread didn't die ... cleaning up");
            this.disposeEnvironment();
        }
    }

    private void closeDialog() {
        XCancellable xCancellable = (XCancellable)UnoRuntime.queryInterface(XCancellable.class, (Object)this.tEnv.getTestObject());
        if (xCancellable != null) {
            this.log.println("Cancelling Dialog");
            xCancellable.cancel();
        } else {
            this.disposeEnvironment();
        }
        long l = System.currentTimeMillis();
        boolean bl = false;
        this.log.println("waiting for dialog to close");
        while (this.eThread.isAlive() && !bl) {
            bl = System.currentTimeMillis() - l > 10000L;
        }
        this.log.println("done");
        try {
            if (this.eThread.isAlive()) {
                this.log.println("Interrupting Thread");
                this.eThread.interrupt();
                _XExecutableDialog _XExecutableDialog2 = this;
                _XExecutableDialog2.eThread.yield();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        l = System.currentTimeMillis();
        bl = false;
        this.log.println("waiting for interruption to work");
        while (this.eThread.isAlive() && !bl) {
            bl = System.currentTimeMillis() - l > 10000L;
        }
        this.log.println("DialogThread alive: " + this.eThread.isAlive());
        this.log.println("done");
    }

    protected class ExecThread
    extends Thread {
        public short execRes = (short)17;
        private XExecutableDialog Diag = null;

        public ExecThread(XExecutableDialog xExecutableDialog) {
            this.Diag = xExecutableDialog;
        }

        public void run() {
            try {
                this.execRes = this.Diag.execute();
                System.out.println("HERE: " + this.execRes);
            }
            catch (Exception exception) {
                _XExecutableDialog.this.log.println("Thread has been interrupted ... ");
            }
        }
    }
}

