/*
 * Decompiled with CFR 0.152.
 */
package ifc.table;

import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableColumns;
import com.sun.star.text.XSimpleText;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XTableColumns
extends MultiMethodTest {
    public XTableColumns oObj = null;
    private XCellRange xCellRange = null;
    private int lastColumn = 0;

    public void before() {
        this.xCellRange = (XCellRange)this.tEnv.getObjRelation("XTableColumns.XCellRange");
        if (this.xCellRange == null) {
            throw new StatusException(Status.failed("Relation missing"));
        }
        this.lastColumn = this.oObj.getCount() - 1;
    }

    public void _insertByIndex() {
        boolean bl = true;
        int n = this.oObj.getCount();
        try {
            this.log.println("Filling range ... ");
            this.fillRange(this.xCellRange);
            this.log.println("Inserting 1 column at position 1 ...");
            this.oObj.insertByIndex(1, 1);
            bl &= this.checkColumn(0, 0);
            bl &= this.checkColumnEmpty(1);
            bl &= this.checkColumn(2, 1);
            bl &= this.checkColumn(3, 2);
            bl &= this.checkColumnEmpty(4);
            if (this.lastColumn < 200) {
                bl &= this.checkColumn(this.lastColumn + 1, this.lastColumn);
                bl &= this.oObj.getCount() == n + 1;
            } else {
                bl &= this.checkColumnEmpty(this.lastColumn);
            }
            this.log.println("Inserting 1 column at position 0 ...");
            this.oObj.insertByIndex(0, 1);
            bl &= this.checkColumnEmpty(0);
            bl &= this.checkColumn(1, 0);
            bl &= this.checkColumnEmpty(2);
            bl &= this.checkColumn(3, 1);
            bl &= this.checkColumn(4, 2);
            bl &= this.checkColumnEmpty(5);
            if (this.lastColumn < 200) {
                bl &= this.checkColumn(this.lastColumn + 2, this.lastColumn);
                bl &= this.oObj.getCount() == n + 2;
            }
            this.log.println("Inserting 2 columns at position 0 ...");
            this.oObj.insertByIndex(0, 2);
            bl &= this.checkColumnEmpty(0);
            bl &= this.checkColumnEmpty(1);
            bl &= this.checkColumnEmpty(2);
            bl &= this.checkColumn(3, 0);
            bl &= this.checkColumnEmpty(4);
            bl &= this.checkColumn(5, 1);
            bl &= this.checkColumn(6, 2);
            bl &= this.checkColumnEmpty(7);
            if (this.lastColumn < 200) {
                bl &= this.checkColumn(this.lastColumn + 4, this.lastColumn);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(this.log);
            bl = false;
        }
        if (n < 200) {
            this.log.println("Checking that number of column increased.");
            bl &= this.oObj.getCount() == n + 4;
            this.log.println("Before: " + n + ", After: " + this.oObj.getCount());
        } else {
            this.log.println("Number of columns is " + n + ",");
            this.log.println("supposing that this is the whole spreadsheet and ");
            this.log.println("number of columns should not change.");
        }
        try {
            this.oObj.insertByIndex(-1, 1);
            this.log.println("No Exception occurred while inserting column at -1");
            bl &= false;
        }
        catch (Exception exception) {
            this.log.println("Inserting column at Index -1 ... OK");
            bl &= true;
        }
        int n2 = this.oObj.getCount();
        try {
            this.oObj.insertByIndex(n2, 1);
            this.log.println("No Exception occurred while inserting column at " + n2);
            bl &= false;
        }
        catch (Exception exception) {
            this.log.println("Inserting column at Index " + n2 + " ... OK");
            bl &= true;
        }
        if (this.tEnv.getTestCase().getObjectName().equals("ScTableColumnsObj")) {
            try {
                this.oObj.insertByIndex(0, 0);
                this.log.println("No Exception occurred while inserting 0 columns");
                bl &= false;
            }
            catch (Exception exception) {
                this.log.println("Inserting 0 columns ... OK");
                bl &= true;
            }
        }
        this.tRes.tested("insertByIndex()", bl);
    }

    public void _removeByIndex() {
        this.executeMethod("insertByIndex()");
        boolean bl = true;
        int n = this.oObj.getCount();
        try {
            this.log.println("Filling range ... ");
            this.log.println("Removing 2 columns at position 0 ...");
            this.oObj.removeByIndex(0, 2);
            bl &= this.checkColumnEmpty(0);
            bl &= this.checkColumn(1, 0);
            bl &= this.checkColumnEmpty(2);
            bl &= this.checkColumn(3, 1);
            bl &= this.checkColumn(4, 2);
            bl &= this.checkColumnEmpty(5);
            if (this.lastColumn < 200) {
                bl &= this.checkColumn(this.lastColumn + 2, this.lastColumn);
                bl &= this.oObj.getCount() == n - 2;
            }
            this.log.println("Removing 1 column at position 0 ...");
            this.oObj.removeByIndex(0, 1);
            bl &= this.checkColumn(0, 0);
            bl &= this.checkColumnEmpty(1);
            bl &= this.checkColumn(2, 1);
            bl &= this.checkColumn(3, 2);
            bl &= this.checkColumnEmpty(4);
            if (this.lastColumn < 200) {
                bl &= this.checkColumn(this.lastColumn + 1, this.lastColumn);
                bl &= this.oObj.getCount() == n - 3;
            }
            this.log.println("Removing 1 column at position 1 ...");
            this.oObj.removeByIndex(1, 1);
            bl &= this.checkColumn(0, 0);
            bl &= this.checkColumn(1, 1);
            bl &= this.checkColumn(2, 2);
            bl &= this.checkColumnEmpty(3);
            if (this.lastColumn < 200) {
                bl &= this.checkColumn(this.lastColumn, this.lastColumn);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(this.log);
            bl = false;
        }
        if (n < 200) {
            this.log.println("Checking that number of column increased.");
            bl &= this.oObj.getCount() == n - 4;
            this.log.println("Before: " + n + ", After: " + this.oObj.getCount());
        } else {
            this.log.println("Number of columns is " + n + ",");
            this.log.println("supposing that this is the whole spreadsheet and ");
            this.log.println("number of columns should not change.");
        }
        try {
            this.oObj.removeByIndex(-1, 1);
            this.log.println("No Exception occurred while removing column at -1");
            bl &= false;
        }
        catch (Exception exception) {
            this.log.println("removing column at Index -1 ... OK");
            bl &= true;
        }
        int n2 = this.oObj.getCount();
        try {
            this.oObj.removeByIndex(n2, 1);
            this.log.println("No Exception occurred while removing column at " + n2);
            bl &= false;
        }
        catch (Exception exception) {
            this.log.println("Removing column at Index " + n2 + " ... OK");
            bl &= true;
        }
        if (this.tEnv.getTestCase().getObjectName().equals("ScTableColumnsObj")) {
            try {
                this.oObj.removeByIndex(0, 0);
                this.log.println("No Exception occurred while removing 0 columns");
                bl &= false;
            }
            catch (Exception exception) {
                this.log.println("removing 0 columns ... OK");
                bl &= true;
            }
        }
        this.tRes.tested("removeByIndex()", bl);
    }

    private void setCellText(XCell xCell, String string) {
        XSimpleText xSimpleText = (XSimpleText)UnoRuntime.queryInterface(XSimpleText.class, (Object)xCell);
        xSimpleText.setString(string);
    }

    private String getCellText(XCell xCell) {
        XSimpleText xSimpleText = (XSimpleText)UnoRuntime.queryInterface(XSimpleText.class, (Object)xCell);
        return xSimpleText.getString();
    }

    private void fillRange(XCellRange xCellRange) throws IndexOutOfBoundsException {
        int n;
        for (n = 0; n <= this.lastColumn && n < 3; ++n) {
            this.setCellText(xCellRange.getCellByPosition(n, 0), "" + n + "a");
            this.setCellText(xCellRange.getCellByPosition(n, 1), "" + n + "b");
        }
        for (n = 3; n <= this.lastColumn && n < 10; ++n) {
            this.setCellText(xCellRange.getCellByPosition(n, 0), "");
            this.setCellText(xCellRange.getCellByPosition(n, 1), "");
        }
    }

    private boolean checkColumn(int n, int n2) throws IndexOutOfBoundsException {
        if (n >= this.oObj.getCount()) {
            return true;
        }
        String string = this.getCellText(this.xCellRange.getCellByPosition(n, 0));
        String string2 = this.getCellText(this.xCellRange.getCellByPosition(n, 1));
        if (!("" + n2 + "a").equals(string) || !("" + n2 + "b").equals(string2)) {
            this.log.println("FAILED for column " + n + " and index " + n2 + "(" + string + "," + string2 + ")");
            return false;
        }
        return true;
    }

    private boolean checkColumnEmpty(int n) throws IndexOutOfBoundsException {
        if (n >= this.oObj.getCount()) {
            return true;
        }
        String string = this.getCellText(this.xCellRange.getCellByPosition(n, 0));
        String string2 = this.getCellText(this.xCellRange.getCellByPosition(n, 1));
        if (!"".equals(string) || !"".equals(string2)) {
            this.log.println("FAILED for column " + n + " is not empty (" + string + "," + string2 + ")");
            return false;
        }
        return true;
    }
}

