/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.EnhancedMouseEvent;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XEnhancedMouseClickHandler;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XEnhancedMouseClickBroadcaster;
import com.sun.star.uno.UnoRuntime;
import java.awt.AWTException;
import java.awt.Robot;
import lib.MultiMethodTest;
import util.AccessibilityTools;
import util.DesktopTools;

public class _XEnhancedMouseClickBroadcaster
extends MultiMethodTest {
    public XEnhancedMouseClickBroadcaster oObj;
    protected boolean mousePressed = false;
    protected boolean mouseReleased = false;
    protected XEnhancedMouseClickHandler listener = new MyListener();
    private XModel docModel = null;

    public void before() {
        this.docModel = (XModel)UnoRuntime.queryInterface(XModel.class, this.tEnv.getObjRelation("FirstModel"));
        DesktopTools.bringWindowToFromt(this.docModel);
    }

    public void _addEnhancedMouseClickHandler() {
        this.oObj.addEnhancedMouseClickHandler(this.listener);
        this.clickOnSheet();
        if (!this.mousePressed || !this.mouseReleased) {
            this.oObj.removeEnhancedMouseClickHandler(this.listener);
        }
        this.tRes.tested("addEnhancedMouseClickHandler()", this.mousePressed && this.mouseReleased);
    }

    public void _removeEnhancedMouseClickHandler() {
        this.requiredMethod("addEnhancedMouseClickHandler()");
        this.mousePressed = false;
        this.mouseReleased = false;
        this.oObj.removeEnhancedMouseClickHandler(this.listener);
        this.clickOnSheet();
        this.tRes.tested("removeEnhancedMouseClickHandler()", !this.mousePressed && !this.mouseReleased);
    }

    protected boolean clickOnSheet() {
        this.log.println("try to open contex menu...");
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)this.tParam.getMSF(), this.docModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)40);
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext);
        Point point = xAccessibleComponent.getLocationOnScreen();
        Rectangle rectangle = xAccessibleComponent.getBounds();
        this.log.println("klick mouse button...");
        try {
            Robot robot = new Robot();
            int n = point.X + rectangle.Width / 2 + 50;
            int n2 = point.Y + rectangle.Height / 2 + 50;
            robot.mouseMove(n, n2);
            System.out.println("Press Button");
            robot.mousePress(4);
            System.out.println("Release Button");
            robot.mouseRelease(4);
            System.out.println("done");
            System.out.println("warte");
            this.shortWait();
            System.out.println("Press Button");
            robot.mousePress(16);
            System.out.println("Release Button");
            robot.mouseRelease(16);
            System.out.println("done " + robot.getAutoDelay());
        }
        catch (AWTException aWTException) {
            this.log.println("couldn't press mouse button");
        }
        return true;
    }

    private void shortWait() {
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }

    protected class MyListener
    implements XEnhancedMouseClickHandler {
        protected MyListener() {
        }

        public void disposing(EventObject eventObject) {
        }

        public boolean mousePressed(EnhancedMouseEvent enhancedMouseEvent) {
            _XEnhancedMouseClickBroadcaster.this.log.println("mousePressed");
            _XEnhancedMouseClickBroadcaster.this.mousePressed = true;
            return true;
        }

        public boolean mouseReleased(EnhancedMouseEvent enhancedMouseEvent) {
            _XEnhancedMouseClickBroadcaster.this.log.println("mouseReleased");
            _XEnhancedMouseClickBroadcaster.this.mouseReleased = true;
            return true;
        }
    }
}

