/*
 * Decompiled with CFR 0.152.
 */
package ifc.sdbcx;

import com.sun.star.beans.PropertyValue;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XDriver;
import com.sun.star.sdbcx.XDataDefinitionSupplier;
import com.sun.star.sdbcx.XTablesSupplier;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDataDefinitionSupplier
extends MultiMethodTest {
    public XDataDefinitionSupplier oObj = null;
    String url = null;
    String wrongUrl = null;
    PropertyValue[] info = null;
    XConnection connection = null;

    protected void before() {
        this.url = (String)this.tEnv.getObjRelation("XDriver.URL");
        if (this.url == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XDriver.URL'"));
        }
        this.wrongUrl = (String)this.tEnv.getObjRelation("XDriver.UNSUITABLE_URL");
        if (this.wrongUrl == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XDriver.WRONG_URL'"));
        }
        this.info = (PropertyValue[])this.tEnv.getObjRelation("XDriver.INFO");
        if (this.info == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XDriver.INFO'"));
        }
    }

    public void _getDataDefinitionByConnection() {
        boolean bl = true;
        XDriver xDriver = (XDriver)UnoRuntime.queryInterface(XDriver.class, (Object)this.oObj);
        if (xDriver == null) {
            this.log.println("The XDriver interface isn't supported");
            this.tRes.tested("getDataDefinitionByConnection()", Status.skipped(false));
            return;
        }
        try {
            this.connection = xDriver.connect(this.url, this.info);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        if (this.connection == null) {
            this.log.println("Couldn't get connection to specified url using specified info");
            this.tRes.tested("getDataDefinitionByConnection()", Status.skipped(false));
            return;
        }
        XTablesSupplier xTablesSupplier = null;
        try {
            this.log.println("getDataDefinitionByConnection(connection)");
            xTablesSupplier = this.oObj.getDataDefinitionByConnection(this.connection);
            bl = xTablesSupplier != null;
        }
        catch (SQLException sQLException) {
            this.log.println("Unexpected exception: " + sQLException);
            bl = false;
        }
        try {
            this.log.println("getDataDefinitionByConnection(null)");
            xTablesSupplier = this.oObj.getDataDefinitionByConnection(null);
            bl = xTablesSupplier == null;
        }
        catch (SQLException sQLException) {
            this.log.println("Exception: " + sQLException);
            bl = true;
        }
        this.tRes.tested("getDataDefinitionByConnection()", bl);
    }

    public void _getDataDefinitionByURL() {
        boolean bl = false;
        XTablesSupplier xTablesSupplier = null;
        try {
            this.log.println("getDataDefinitionByURL('" + this.url + "')");
            xTablesSupplier = this.oObj.getDataDefinitionByURL(this.url, this.info);
            bl = xTablesSupplier != null;
        }
        catch (SQLException sQLException) {
            this.log.println("Unexpected exception: " + sQLException);
            bl = false;
        }
        try {
            this.log.println("getDataDefinitionByURL('" + this.wrongUrl + "')");
            xTablesSupplier = this.oObj.getDataDefinitionByURL(this.wrongUrl, this.info);
            this.log.println("Exception was expected");
            bl = false;
        }
        catch (SQLException sQLException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        this.tRes.tested("getDataDefinitionByURL()", true);
    }
}

