/*
 * Decompiled with CFR 0.152.
 */
package ifc.sdbc;

import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSetUpdate;
import com.sun.star.sdbc.XRowUpdate;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XResultSetUpdate
extends MultiMethodTest {
    public XResultSetUpdate oObj = null;
    private UpdateTester tester = null;

    public void before() throws StatusException {
        this.tester = (UpdateTester)this.tEnv.getObjRelation("XResultSetUpdate.UpdateTester");
        if (this.tester == null) {
            this.log.println("Required relation not found !!!");
            throw new StatusException("Required relation not found !!!", new NullPointerException());
        }
    }

    public void _deleteRow() {
        this.executeMethod("moveToCurrentRow()");
        this.executeMethod("updateRow()");
        this.executeMethod("cancelRowUpdates()");
        boolean bl = true;
        try {
            int n = this.tester.rowCount();
            this.oObj.deleteRow();
            int n2 = this.tester.rowCount();
            bl = n == n2 + 1;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("deleteRow()", bl);
    }

    public void _updateRow() {
        this.executeMethod("moveToCurrentRow()");
        boolean bl = true;
        try {
            this.tester.update();
            this.oObj.updateRow();
            bl = this.tester.wasUpdated();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateRow()", bl);
    }

    public void _cancelRowUpdates() {
        this.executeMethod("moveToCurrentRow()");
        boolean bl = true;
        try {
            this.tester.update();
            this.oObj.cancelRowUpdates();
            bl = !this.tester.wasUpdated();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("cancelRowUpdates()", bl);
    }

    public void _moveToInsertRow() {
        boolean bl = true;
        try {
            this.oObj.moveToInsertRow();
            bl = this.tester.currentRow() < 1;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("moveToInsertRow()", bl);
    }

    public void _moveToCurrentRow() {
        boolean bl = true;
        try {
            this.oObj.moveToCurrentRow();
            bl = this.tester.currentRow() >= 1;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("moveToCurrentRow()", bl);
    }

    public void _insertRow() {
        this.executeMethod("moveToInsertRow()");
        boolean bl = true;
        try {
            this.oObj.moveToCurrentRow();
            int n = this.tester.rowCount();
            this.oObj.moveToInsertRow();
            XRowUpdate xRowUpdate = (XRowUpdate)UnoRuntime.queryInterface(XRowUpdate.class, (Object)this.oObj);
            xRowUpdate.updateString(1, "open");
            xRowUpdate.updateInt(2, 5);
            xRowUpdate.updateDouble(5, 3.4);
            xRowUpdate.updateBoolean(10, true);
            this.oObj.insertRow();
            this.oObj.moveToCurrentRow();
            int n2 = this.tester.rowCount();
            bl = n + 1 == n2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            this.log.println("******" + sQLException.getMessage());
            bl = false;
        }
        this.tRes.tested("insertRow()", bl);
    }

    public void after() {
    }

    public static interface UpdateTester {
        public int rowCount() throws SQLException;

        public void update() throws SQLException;

        public boolean wasUpdated() throws SQLException;

        public int currentRow() throws SQLException;
    }
}

