/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XDispatchRecorder;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.utils;

public class _XDispatchRecorder
extends MultiMethodTest {
    public static XDispatchRecorder oObj = null;
    XFrame xFrame = null;
    URL dispURL = null;
    PropertyValue[] dispArgs = new PropertyValue[0];

    protected void before() {
        this.xFrame = (XFrame)this.tEnv.getObjRelation("XDispatchRecorder.Frame");
        if (this.xFrame == null) {
            throw new StatusException(Status.failed("Relation not found"));
        }
    }

    public void _startRecording() {
        oObj.startRecording(this.xFrame);
        oObj.endRecording();
        this.tRes.tested("startRecording()", true);
    }

    public void _getRecordedMacro() {
        boolean bl;
        this.clearBuffer();
        oObj.startRecording(this.xFrame);
        this.log.println("dispatch calles via API must be recorded");
        this.dispURL = utils.parseURL((XMultiServiceFactory)this.tParam.getMSF(), ".uno:InsertText");
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "Text";
        propertyValue.Value = "XDispatchRecorder.endRecording()";
        this.dispArgs = new PropertyValue[]{propertyValue};
        this.log.println("Dispatching event for frame ...");
        XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)this.xFrame);
        XDispatch xDispatch = xDispatchProvider.queryDispatch(this.dispURL, "", 0);
        xDispatch.dispatch(this.dispURL, this.dispArgs);
        this.shortWait();
        this.log.println("Getting macro ... :");
        String string = oObj.getRecordedMacro();
        this.log.println(string);
        this.log.println("Ending record ...");
        oObj.endRecording();
        boolean bl2 = bl = string != null && string.indexOf(this.dispURL.Complete) > -1;
        if (!bl) {
            this.log.println("Dispatch URL '" + this.dispURL.Complete + "' was NOT found in macro - FAILED");
        }
        this.tRes.tested("getRecordedMacro()", bl);
    }

    public void _endRecording() {
        oObj.startRecording(this.xFrame);
        oObj.endRecording();
        String string = oObj.getRecordedMacro();
        boolean bl = true;
        if (string.length() != 0) {
            this.log.println("'endRecording()' was called but macro buffer is not cleared: FALSE");
            this.log.println(string);
            bl = false;
        }
        this.tRes.tested("endRecording()", bl);
    }

    public void _recordDispatch() {
        boolean bl;
        this.clearBuffer();
        oObj.startRecording(this.xFrame);
        this.dispURL = utils.parseURL((XMultiServiceFactory)this.tParam.getMSF(), ".uno:InsertText");
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "Text";
        propertyValue.Value = "XDispatchRecorder.recordDispatch()";
        this.dispArgs = new PropertyValue[]{propertyValue};
        this.log.println("Recording dispatch ...");
        oObj.recordDispatch(this.dispURL, this.dispArgs);
        this.log.println("Getting macro ... :");
        String string = oObj.getRecordedMacro();
        this.log.println(string);
        oObj.endRecording();
        boolean bl2 = bl = string != null && string.indexOf(this.dispURL.Complete) > -1 && string.indexOf((String)this.dispArgs[0].Value) > -1;
        if (!bl) {
            this.log.println("Dispatch URL '" + this.dispURL.Complete + "' or its argument '" + this.dispArgs[0].Value + "' was not found in macro returned - FAILED");
        }
        this.tRes.tested("recordDispatch()", bl);
    }

    public void _recordDispatchAsComment() {
        boolean bl;
        this.clearBuffer();
        oObj.startRecording(this.xFrame);
        this.dispURL = utils.parseURL((XMultiServiceFactory)this.tParam.getMSF(), ".uno:InsertText");
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "Text";
        propertyValue.Value = "XDispatchRecorder.recordDispatchAsComment()";
        this.dispArgs = new PropertyValue[]{propertyValue};
        this.log.println("Recording dispatch ...");
        oObj.recordDispatchAsComment(this.dispURL, this.dispArgs);
        this.log.println("Getting macro ... :");
        String string = oObj.getRecordedMacro();
        this.log.println(string);
        oObj.endRecording();
        boolean bl2 = bl = string != null && string.indexOf(this.dispURL.Complete) > -1 && string.indexOf((String)this.dispArgs[0].Value) > -1;
        if (!bl) {
            this.log.println("Dispatch URL '" + this.dispURL.Complete + "' or its argument '" + this.dispArgs[0].Value + "' was not found in macro returned - FAILED");
        }
        this.log.println("Checking if macro is commented ...");
        int n = string.indexOf((String)this.dispArgs[0].Value);
        int n2 = string.lastIndexOf("\n", n);
        String string2 = string.substring(n2 + 1, n).toLowerCase();
        this.log.println("Line start is '" + string2 + "'");
        if (string2.startsWith("'") || string2.startsWith("rem")) {
            this.log.println("Line is commented : OK");
        } else {
            this.log.println("Line is not commented : FAILED");
            bl = false;
        }
        this.tRes.tested("recordDispatchAsComment()", bl);
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void clearBuffer() {
        oObj.startRecording(this.xFrame);
        oObj.endRecording();
        String string = oObj.getRecordedMacro();
        if (string.length() != 0) {
            this.log.println("ERROR: 'endRecording()' was called but macro buffer is not cleared!");
            this.log.println(string);
        }
    }
}

