/*
 * Decompiled with CFR 0.152.
 */
package ifc.container;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.container.ContainerEvent;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XContainer;
import com.sun.star.container.XContainerListener;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XNamingService;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XContainer
extends MultiMethodTest {
    public XContainer oObj = null;
    private boolean bElementInserted = false;
    private boolean bElementRemoved = false;
    private boolean bElementReplaced = false;
    private PrintWriter _log = null;
    private XNameContainer NC = null;
    private XControlContainer CC = null;
    private XNamingService NV = null;
    private XNameReplace NR = null;
    private Object inst = null;
    private Object inst2 = null;
    MyListener listener = new MyListener();

    public void before() throws StatusException {
        this._log = this.log;
        Object object = this.tEnv.getObjRelation("XContainer.AlternateObject");
        if (object != null) {
            this.oObj = (XContainer)UnoRuntime.queryInterface(XContainer.class, object);
        }
        this.NC = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)this.oObj);
        Object object2 = null;
        if (this.NC == null) {
            object2 = this.tEnv.getObjRelation("XContainer.Container");
        }
        if (object2 != null) {
            if (object2 instanceof XControlContainer) {
                this.CC = (XControlContainer)object2;
            } else if (object2 instanceof XNamingService) {
                this.NV = (XNamingService)object2;
            } else if (object2 instanceof XNameReplace) {
                this.NR = (XNameReplace)object2;
                this.inst2 = this.tEnv.getObjRelation("XContainer.NewValue");
                this.inst = this.tEnv.getObjRelation("XContainer.ElementName");
            } else if (object2 instanceof XNameContainer) {
                this.NC = (XNameContainer)object2;
            }
        }
        if (this.NC == null && this.CC == null && this.NV == null && this.NR == null) {
            throw new StatusException(Status.failed("Neither object implements XNameContainer nor relation 'XContainer.Container' found."));
        }
        if (this.inst == null) {
            this.inst = this.tEnv.getObjRelation("INSTANCE");
        }
        if (this.inst == null) {
            this.log.println("No INSTANCE ObjRelation!!! ");
            throw new StatusException(Status.failed("No INSTANCE ObjRelation!!!"));
        }
        if (this.inst2 == null) {
            this.inst2 = this.tEnv.getObjRelation("INSTANCE2");
        }
    }

    public void _addContainerListener() {
        boolean bl = true;
        this.oObj.addContainerListener(this.listener);
        bl &= this.performChanges();
        if (this.NC != null) {
            bl &= this.bElementReplaced;
        }
        if (this.NR == null) {
            bl &= this.bElementRemoved;
        }
        if (this.NR == null) {
            bl &= this.bElementInserted;
        }
        if (!bl) {
            this.log.println("inserted was " + (this.bElementInserted ? "" : "NOT") + " called.");
            if (this.NC != null) {
                this.log.println("replaced was " + (this.bElementReplaced ? "" : "NOT") + " called.");
            }
            this.log.println("removed was " + (this.bElementRemoved ? "" : "NOT") + " called.");
        }
        this.tRes.tested("addContainerListener()", bl);
    }

    public void _removeContainerListener() {
        this.requiredMethod("addContainerListener()");
        boolean bl = true;
        this.bElementInserted = false;
        this.bElementRemoved = false;
        this.bElementReplaced = false;
        this.oObj.removeContainerListener(this.listener);
        bl &= this.performChanges();
        bl &= !this.bElementReplaced;
        bl &= !this.bElementRemoved;
        this.tRes.tested("removeContainerListener()", bl &= !this.bElementInserted);
    }

    protected boolean performChanges() {
        if (this.CC != null) {
            return this.performChanges2();
        }
        if (this.NV != null) {
            return this.performChanges3();
        }
        if (this.NR != null) {
            return this.performChanges4();
        }
        boolean bl = true;
        try {
            String[] stringArray = this.NC.getElementNames();
            this.log.println("Elements count = " + stringArray.length);
            this.NC.insertByName("XContainer_dummy", this.inst);
            stringArray = this.NC.getElementNames();
            this.log.println("Elements count = " + stringArray.length);
            if (this.inst2 == null) {
                this.NC.replaceByName("XContainer_dummy", this.inst);
            } else {
                this.NC.replaceByName("XContainer_dummy", this.inst2);
            }
            this.NC.removeByName("XContainer_dummy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Exception occured ");
            illegalArgumentException.printStackTrace(this.log);
            bl = false;
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.log.println("Exception occured ");
            wrappedTargetException.printStackTrace(this.log);
            bl = false;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.log.println("Exception occured ");
            noSuchElementException.printStackTrace(this.log);
            bl = false;
        }
        catch (ElementExistException elementExistException) {
            this.log.println("Exception occured ");
            elementExistException.printStackTrace(this.log);
            bl = false;
        }
        return bl;
    }

    protected boolean performChanges2() {
        int n = this.CC.getControls().length;
        this.CC.addControl("NewControl", (XControl)this.inst);
        this.shortWait();
        int n2 = this.CC.getControls().length;
        this.CC.removeControl(this.CC.getControl("NewControl"));
        this.shortWait();
        return n2 > n;
    }

    protected boolean performChanges3() {
        boolean bl = true;
        Object object = null;
        try {
            object = this.NV.getRegisteredObject("MyFactory");
            this.NV.revokeObject("MyFactory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.NV.registerObject("MyFactory", this.inst);
            object = this.NV.getRegisteredObject("MyFactory");
            bl &= object != null;
        }
        catch (Exception exception) {
            exception.printStackTrace(this.log);
            this.log.println("registerObject failed");
            bl &= false;
        }
        try {
            this.NV.revokeObject("MyFactory");
            object = this.NV.getRegisteredObject("MyFactory");
            this.log.println("revokeObject failed");
            bl &= false;
        }
        catch (Exception exception) {
            bl &= true;
        }
        return bl;
    }

    protected boolean performChanges4() {
        boolean bl = true;
        Object object = this.inst2;
        Object object2 = null;
        String string = null;
        try {
            string = (String)this.inst;
        }
        catch (ClassCastException classCastException) {
            this.log.write("Expected String as object relations 'XContainer.ElementName'.");
            classCastException.printStackTrace(this.log);
            return false;
        }
        try {
            object2 = this.NR.getByName(string);
            this.NR.replaceByName(string, object);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.log);
            bl = false;
        }
        try {
            this.NR.replaceByName(string, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.log);
            bl = false;
        }
        return bl;
    }

    private void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("While waiting :" + interruptedException);
        }
    }

    public class MyListener
    implements XContainerListener {
        public void elementInserted(ContainerEvent containerEvent) {
            _XContainer.this.bElementInserted = true;
        }

        public void elementRemoved(ContainerEvent containerEvent) {
            _XContainer.this.bElementRemoved = true;
        }

        public void elementReplaced(ContainerEvent containerEvent) {
            _XContainer.this.bElementReplaced = true;
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

