/*
 * Decompiled with CFR 0.152.
 */
package ifc.connection;

import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XAcceptor
extends MultiMethodTest {
    protected PrintWriter log_;
    public XAcceptor oObj = null;
    protected String connectString = null;

    public void before() throws StatusException {
        this.connectString = (String)this.tEnv.getObjRelation("XAcceptor.connectStr");
        this.log_ = this.log;
        if (this.connectString == null) {
            throw new StatusException("No object relation found", new NullPointerException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _accept() {
        boolean bl;
        block38: {
            Object object;
            bl = true;
            AcceptorThread acceptorThread = null;
            AcceptorThread acceptorThread2 = null;
            XAcceptor xAcceptor = null;
            XConnector xConnector = null;
            try {
                object = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.connection.Connector");
                xConnector = (XConnector)UnoRuntime.queryInterface(XConnector.class, object);
                XInterface xInterface = (XInterface)((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.connection.Acceptor");
                xAcceptor = (XAcceptor)UnoRuntime.queryInterface(XAcceptor.class, (Object)xInterface);
            }
            catch (com.sun.star.uno.Exception exception) {
                exception.printStackTrace(this.log);
                throw new StatusException("Can't create service", exception);
            }
            try {
                acceptorThread = new AcceptorThread(this.oObj);
                acceptorThread.start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                object = xConnector.connect(this.connectString);
                if (object == null) {
                    this.log.println("Connector returned : null");
                } else {
                    this.log.println("Connector returned : " + object.getDescription());
                }
                try {
                    acceptorThread.join(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (acceptorThread.isAlive()) {
                    bl = false;
                    this.log.println("Method call haven't returned");
                    if (acceptorThread.acceptedCall == null) {
                        this.log.println("Acceptor returned : null");
                    } else {
                        this.log.println("Acceptor returned : " + acceptorThread.acceptedCall.getDescription());
                    }
                } else {
                    if (acceptorThread.ex != null) {
                        this.log.println("Exception occured in accept() thread :");
                        acceptorThread.ex.printStackTrace(this.log);
                    }
                    if (acceptorThread.acceptedCall == null) {
                        this.log.println("Method returned : null");
                    } else {
                        this.log.println("Method returned : " + acceptorThread.acceptedCall.getDescription());
                    }
                    bl &= acceptorThread.acceptedCall != null;
                }
            }
            catch (ConnectionSetupException connectionSetupException) {
                connectionSetupException.printStackTrace(this.log);
                bl = false;
            }
            catch (NoConnectException noConnectException) {
                noConnectException.printStackTrace(this.log);
                bl = false;
            }
            finally {
                this.oObj.stopAccepting();
                if (acceptorThread.isAlive()) {
                    acceptorThread.interrupt();
                }
            }
            this.log.println("___ Testing for accepting on the same port ...");
            try {
                acceptorThread2 = new AcceptorThread(xAcceptor);
                acceptorThread2.start();
                try {
                    acceptorThread2.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!acceptorThread2.isAlive()) break block38;
                this.log.println("Duplicate acceptor is listening ...");
                acceptorThread = new AcceptorThread(this.oObj);
                acceptorThread.start();
                try {
                    acceptorThread.join(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (acceptorThread.isAlive()) {
                    this.oObj.stopAccepting();
                    acceptorThread.interrupt();
                    this.log.println("Acceptor with the same port must cause an error but didn't");
                    bl = false;
                } else {
                    this.log.println("Accepted call = " + acceptorThread.acceptedCall);
                    if (acceptorThread.ex == null) {
                        this.log.println("No exception was thrown when trying to listen on the same port");
                    } else if (acceptorThread.ex instanceof AlreadyAcceptingException || acceptorThread.ex instanceof ConnectionSetupException) {
                        this.log.println("Rigth exception was thrown when trying to listen on the same port");
                    } else {
                        bl = false;
                        this.log.println("Wrong exception was thrown when trying to listen on the same port :");
                        acceptorThread.ex.printStackTrace(this.log);
                    }
                }
            }
            finally {
                xAcceptor.stopAccepting();
                if (acceptorThread2.isAlive()) {
                    acceptorThread2.interrupt();
                }
            }
        }
        this.tRes.tested("accept()", bl);
    }

    public void _stopAccepting() {
        boolean bl = true;
        AcceptorThread acceptorThread = new AcceptorThread(this.oObj);
        acceptorThread.start();
        this.oObj.stopAccepting();
        try {
            acceptorThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (acceptorThread.isAlive()) {
            acceptorThread.interrupt();
            bl = false;
            this.log.println("Method call haven't returned");
        } else {
            if (acceptorThread.ex != null) {
                this.log.println("Exception occured in accept() thread :");
                acceptorThread.ex.printStackTrace(this.log);
                bl = false;
            } else {
                bl = true;
            }
            if (acceptorThread.acceptedCall == null) {
                this.log.println("accept() returned : null");
            } else {
                this.log.println("accept() returned : " + acceptorThread.acceptedCall.getDescription());
            }
        }
        this.tRes.tested("stopAccepting()", bl);
    }

    protected class AcceptorThread
    extends Thread {
        public Exception ex = null;
        private XAcceptor acc = null;
        public XConnection acceptedCall = null;

        public AcceptorThread(XAcceptor xAcceptor) {
            this.acc = xAcceptor;
        }

        public void run() {
            try {
                this.acceptedCall = this.acc.accept(_XAcceptor.this.connectString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.ex = illegalArgumentException;
            }
            catch (ConnectionSetupException connectionSetupException) {
                this.ex = connectionSetupException;
            }
            catch (AlreadyAcceptingException alreadyAcceptingException) {
                this.ex = alreadyAcceptingException;
            }
        }
    }
}

