/*
 * Decompiled with CFR 0.152.
 */
package ifc.bridge;

import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.bridge.XInstanceProvider;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.StatusException;
import util.utils;

public class _XUnoUrlResolver
extends MultiMethodTest {
    static int basePort = 0;
    int curPort = 0;
    public XUnoUrlResolver oObj;

    public void _resolve() {
        String string = (String)this.tParam.get("CNCSTR");
        int n = string.indexOf("port=") + 5;
        string = string.substring(0, n);
        System.out.println("ConnectString: " + string);
        basePort = (Integer)this.tEnv.getObjRelation("PORT");
        this.curPort = utils.getNextFreePort(basePort);
        this.log.println("Choose Port nr: " + this.curPort);
        string = string + this.curPort;
        try {
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)this.tParam.getMSF();
            XBridgeFactory xBridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, this.tEnv.getObjRelation("BRIDGEFACTORY"));
            XAcceptor xAcceptor = (XAcceptor)UnoRuntime.queryInterface(XAcceptor.class, this.tEnv.getObjRelation("ACCEPTOR"));
            MyInstanceProvider myInstanceProvider = new MyInstanceProvider(xMultiServiceFactory);
            BridgeThread bridgeThread = new BridgeThread(xAcceptor, xBridgeFactory, myInstanceProvider, string);
            bridgeThread.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Object object = this.oObj.resolve("uno:" + string + ";urp;com.sun.star.lang.ServiceManager");
            XMultiServiceFactory xMultiServiceFactory2 = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, object);
            if (bridgeThread.isAlive()) {
                bridgeThread.interrupt();
            }
            this.tRes.tested("resolve()", xMultiServiceFactory2 != null);
        }
        catch (NoConnectException noConnectException) {
            this.log.println("Unexpected exception thrown " + noConnectException.getMessage());
            noConnectException.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", noConnectException);
        }
        catch (ConnectionSetupException connectionSetupException) {
            this.log.println("Unexpected exception thrown " + connectionSetupException.getMessage());
            connectionSetupException.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", connectionSetupException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Unexpected exception thrown " + illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", illegalArgumentException);
        }
    }

    class BridgeThread
    extends Thread {
        private XBridgeFactory xBrdgFctr = null;
        private XInstanceProvider xInstProv = null;
        private XAcceptor xAcc = null;
        private String connectString = null;
        public XBridge xBridge = null;

        public BridgeThread(XAcceptor xAcceptor, XBridgeFactory xBridgeFactory, XInstanceProvider xInstanceProvider, String string) {
            this.xInstProv = xInstanceProvider;
            this.xBrdgFctr = xBridgeFactory;
            this.xAcc = xAcceptor;
            this.connectString = string;
        }

        public void run() {
            try {
                XConnection xConnection = this.xAcc.accept(this.connectString);
                this.xBridge = this.xBrdgFctr.createBridge("MyBridge", "urp", xConnection, this.xInstProv);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace(_XUnoUrlResolver.this.log);
            }
            catch (ConnectionSetupException connectionSetupException) {
                connectionSetupException.printStackTrace(_XUnoUrlResolver.this.log);
            }
            catch (AlreadyAcceptingException alreadyAcceptingException) {
                alreadyAcceptingException.printStackTrace(_XUnoUrlResolver.this.log);
            }
            catch (BridgeExistsException bridgeExistsException) {
                bridgeExistsException.printStackTrace(_XUnoUrlResolver.this.log);
            }
        }
    }

    class MyInstanceProvider
    implements XInstanceProvider {
        private XMultiServiceFactory xMSF = null;

        public MyInstanceProvider(XMultiServiceFactory xMultiServiceFactory) {
            this.xMSF = xMultiServiceFactory;
        }

        public Object getInstance(String string) throws NoSuchElementException {
            try {
                return this.xMSF.createInstance(string);
            }
            catch (Exception exception) {
                throw new StatusException("Unexpected exception", exception);
            }
        }
    }
}

