/*
 * Decompiled with CFR 0.152.
 */
package ifc.bridge;

import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XBridgeFactory
extends MultiMethodTest {
    public XBridgeFactory oObj = null;
    private String bridgeName = null;
    AcceptorThread acceptorThread = null;
    public static int uniqueSuffix = 0;
    public static Object synchFlag = new Object();
    public String connectString;

    protected void after() {
        this.acceptorThread.acc.stopAccepting();
        if (this.acceptorThread.isAlive()) {
            this.acceptorThread.interrupt();
        }
    }

    public void _getExistingBridges() {
        XBridge[] xBridgeArray = this.oObj.getExistingBridges();
        this.log.println("Existing bridges :");
        for (int i = 0; i < xBridgeArray.length; ++i) {
            this.log.println("  " + xBridgeArray[i].getDescription());
        }
        if (xBridgeArray.length > 0) {
            this.bridgeName = xBridgeArray[0].getName();
        }
        this.tRes.tested("getExistingBridges()", xBridgeArray != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _createBridge() {
        Object object;
        Object object2;
        Object object3;
        XBridge xBridge = null;
        XConnection xConnection = null;
        boolean bl = false;
        try {
            object3 = (XInterface)((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.connection.Connector");
            object2 = (XConnector)UnoRuntime.queryInterface(XConnector.class, object3);
            object3 = (XInterface)((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.connection.Acceptor");
            object = (XAcceptor)UnoRuntime.queryInterface(XAcceptor.class, object3);
            this.connectString = (String)this.tEnv.getObjRelation("CNNCTSTR");
            this.acceptorThread = new AcceptorThread((XAcceptor)object);
            this.acceptorThread.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            xConnection = object2.connect(this.connectString);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(this.log);
            throw new StatusException("Can't create connection", exception);
        }
        try {
            object3 = (String)this.tParam.get("PROTOCOL");
            if (object3 == null) {
                object3 = "urp";
            }
            object = synchFlag;
            synchronized (object) {
                object2 = "MyBridge" + uniqueSuffix++;
            }
            this.log.println("Creating bridge with name " + (String)object2);
            xBridge = this.oObj.createBridge((String)object2, (String)object3, xConnection, null);
            bl = xBridge != null;
        }
        catch (BridgeExistsException bridgeExistsException) {
            this.log.println("Exception while bridge creating :" + bridgeExistsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Exception while bridge creating :" + illegalArgumentException);
        }
        this.tRes.tested("createBridge()", bl);
    }

    public void _getBridge() {
        this.executeMethod("getExistingBridges()");
        if (this.bridgeName == null) {
            this.log.println("No name for getting the bridge");
            return;
        }
        XBridge xBridge = this.oObj.getBridge(this.bridgeName);
        this.tRes.tested("getBridge()", xBridge != null && this.bridgeName.equals(xBridge.getName()));
    }

    protected class AcceptorThread
    extends Thread {
        private XAcceptor acc = null;
        public Exception ex = null;
        public XConnection acceptedCall = null;

        public AcceptorThread(XAcceptor xAcceptor) {
            this.acc = xAcceptor;
        }

        public void run() {
            try {
                this.acceptedCall = this.acc.accept(_XBridgeFactory.this.connectString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.ex = illegalArgumentException;
            }
            catch (ConnectionSetupException connectionSetupException) {
                this.ex = connectionSetupException;
            }
            catch (AlreadyAcceptingException alreadyAcceptingException) {
                this.ex = alreadyAcceptingException;
            }
        }
    }
}

