/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.awt.AdjustmentEvent;
import com.sun.star.awt.Point;
import com.sun.star.awt.XAdjustmentListener;
import com.sun.star.awt.XScrollBar;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import java.awt.AWTException;
import java.awt.Robot;
import lib.MultiMethodTest;
import util.FormTools;

public class _XScrollBar
extends MultiMethodTest {
    public XScrollBar oObj;
    public boolean adjusted = false;
    XAdjustmentListener listener = new AdjustmentListener();

    public void _addAdjustmentListener() {
        FormTools.switchDesignOf((XMultiServiceFactory)this.tParam.getMSF(), (XTextDocument)this.tEnv.getObjRelation("Document"));
        this.shortWait();
        this.oObj.addAdjustmentListener(this.listener);
        this.adjustScrollBar();
        boolean bl = this.adjusted;
        this.oObj.removeAdjustmentListener(this.listener);
        this.adjusted = false;
        this.adjustScrollBar();
        this.tRes.tested("addAdjustmentListener()", bl &= !this.adjusted);
    }

    public void _removeAdjustmentListener() {
        this.requiredMethod("addAdjustmentListener()");
        this.tRes.tested("removeAdjustmentListener()", true);
    }

    public void _setBlockIncrement() {
        this.oObj.setBlockIncrement(15);
        this.oObj.setBlockIncrement(5);
        int n = this.oObj.getBlockIncrement();
        this.tRes.tested("setBlockIncrement()", n == 5);
    }

    public void _getBlockIncrement() {
        this.requiredMethod("setBlockIncrement()");
        this.tRes.tested("getBlockIncrement()", true);
    }

    public void _setLineIncrement() {
        this.oObj.setLineIncrement(12);
        this.oObj.setLineIncrement(2);
        int n = this.oObj.getLineIncrement();
        this.tRes.tested("setLineIncrement()", n == 2);
    }

    public void _getLineIncrement() {
        this.requiredMethod("setLineIncrement()");
        this.tRes.tested("getLineIncrement()", true);
    }

    public void _setMaximum() {
        this.oObj.setMaximum(490);
        this.oObj.setMaximum(480);
        int n = this.oObj.getMaximum();
        this.tRes.tested("setMaximum()", n == 480);
    }

    public void _getMaximum() {
        this.requiredMethod("setMaximum()");
        this.tRes.tested("getMaximum()", true);
    }

    public void _setOrientation() {
        this.oObj.setOrientation(0);
        this.oObj.setOrientation(1);
        int n = this.oObj.getOrientation();
        this.tRes.tested("setOrientation()", n == 1);
    }

    public void _getOrientation() {
        this.requiredMethod("setOrientation()");
        this.tRes.tested("getOrientation()", true);
    }

    public void _setValue() {
        this.oObj.setMaximum(600);
        this.oObj.setValue(480);
        this.oObj.setValue(520);
        int n = this.oObj.getValue();
        this.tRes.tested("setValue()", n == 520);
    }

    public void _getValue() {
        this.requiredMethod("setValue()");
        this.tRes.tested("getValue()", true);
    }

    public void _setVisibleSize() {
        this.oObj.setVisibleSize(700);
        this.oObj.setVisibleSize(500);
        int n = this.oObj.getVisibleSize();
        this.tRes.tested("setVisibleSize()", n == 500);
    }

    public void _getVisibleSize() {
        this.requiredMethod("setVisibleSize()");
        this.tRes.tested("getVisibleSize()", true);
    }

    public void _setValues() {
        this.oObj.setValues(80, 200, 300);
        this.oObj.setValues(70, 210, 500);
        int n = this.oObj.getValue();
        int n2 = this.oObj.getVisibleSize();
        int n3 = this.oObj.getMaximum();
        this.tRes.tested("setValues()", n == 70 && n2 == 210 && n3 == 500);
    }

    private void adjustScrollBar() {
        XScrollBar xScrollBar = (XScrollBar)UnoRuntime.queryInterface(XScrollBar.class, (Object)this.tEnv.getTestObject());
        xScrollBar.setValue(500);
        this.shortWait();
        XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)this.tEnv.getTestObject());
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessible.getAccessibleContext());
        Point point = xAccessibleComponent.getLocationOnScreen();
        try {
            Robot robot = new Robot();
            robot.mouseMove(point.X + 50, point.Y + 75);
            robot.mousePress(16);
            robot.mouseRelease(16);
        }
        catch (AWTException aWTException) {
            System.out.println("couldn't adjust scrollbar");
        }
        this.shortWait();
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("While waiting :" + interruptedException);
        }
    }

    public class AdjustmentListener
    implements XAdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            System.out.println("Adjustment Value changed");
            System.out.println("AdjustmentEvent: " + adjustmentEvent.Value);
            _XScrollBar.this.adjusted = true;
        }

        public void disposing(EventObject eventObject) {
            System.out.println("Listener disposed");
        }
    }
}

