/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.UnoRuntime;
import convwatch.ConvWatch;
import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.DirectoryHelper;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.OfficePrint;
import helper.URLHelper;
import java.io.File;

public class GraphicalDifferenceCheck {
    private static void showVersion() {
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("");
            GlobalLogWriter.get().println("+##############################+");
            GlobalLogWriter.get().println("##### THIS IS CONVWATCH    #####");
            GlobalLogWriter.get().println("##### Debug Version 1.0015 #####");
            GlobalLogWriter.get().println("+##############################+");
            GlobalLogWriter.get().println("");
        }
    }

    public static void createReferences(String string, String string2, GraphicalTestArguments graphicalTestArguments) throws ConvWatchException {
        GraphicalDifferenceCheck.showVersion();
        File file = new File(string);
        if (file.isDirectory()) {
            String string3 = System.getProperty("file.separator");
            String string4 = file.getAbsolutePath();
            Object[] objectArray = DirectoryHelper.traverse(string, graphicalTestArguments.getFileFilter(), graphicalTestArguments.includeSubDirectories());
            for (int i = 0; i < objectArray.length; ++i) {
                String string5 = (String)objectArray[i];
                String string6 = string2 + string3 + FileHelper.removeFirstDirectorysAndBasenameFrom(string5, string);
                GraphicalDifferenceCheck.createOneReferenceFile(string5, string6, graphicalTestArguments);
            }
        } else {
            GraphicalDifferenceCheck.createOneReferenceFile(string, string2, graphicalTestArguments);
        }
    }

    public static boolean createOneReferenceFile(String string, String string2, GraphicalTestArguments graphicalTestArguments) throws ConvWatchException {
        GraphicalDifferenceCheck.showVersion();
        if (graphicalTestArguments != null) {
            graphicalTestArguments.setInputFile(string);
        }
        return OfficePrint.buildReference(graphicalTestArguments, string2, string);
    }

    public static boolean isReferenceExists(String string, String string2, GraphicalTestArguments graphicalTestArguments) {
        return OfficePrint.isReferenceExists(graphicalTestArguments, string2, string);
    }

    public static boolean check(String string, String string2, String string3, GraphicalTestArguments graphicalTestArguments) throws ConvWatchException {
        return GraphicalDifferenceCheck.check(string, string2, string3, null, graphicalTestArguments);
    }

    public static boolean check(String string, String string2, String string3, String string4, GraphicalTestArguments graphicalTestArguments) throws ConvWatchException {
        GraphicalDifferenceCheck.showVersion();
        boolean bl = true;
        File file = new File(string);
        if (file.isDirectory()) {
            String string5 = System.getProperty("file.separator");
            Object[] objectArray = DirectoryHelper.traverse(string, graphicalTestArguments.getFileFilter(), graphicalTestArguments.includeSubDirectories());
            if (objectArray.length != 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    String string6 = (String)objectArray[i];
                    String string7 = FileHelper.removeFirstDirectorysAndBasenameFrom(string6, string);
                    String string8 = string3;
                    String string9 = string2;
                    String string10 = string4;
                    if (string7.length() > 0) {
                        if (string8 != null) {
                            string8 = string8 + string5 + string7;
                        }
                        string9 = string9 + string5 + string7;
                        if (string10 != null) {
                            string10 = string10 + string5 + string7;
                        }
                    }
                    bl &= GraphicalDifferenceCheck.checkOneFile(string6, string9, string8, string10, graphicalTestArguments);
                }
            }
        } else {
            bl = GraphicalDifferenceCheck.checkOneFile(string, string2, string3, string4, graphicalTestArguments);
        }
        return bl;
    }

    public static boolean checkOneFile(String string, String string2, String string3, GraphicalTestArguments graphicalTestArguments) throws ConvWatchException {
        return GraphicalDifferenceCheck.checkOneFile(string, string2, string3, null, graphicalTestArguments);
    }

    public static boolean checkOneFile(String string, String string2, String string3, String string4, GraphicalTestArguments graphicalTestArguments) throws ConvWatchException {
        GraphicalDifferenceCheck.showVersion();
        if (graphicalTestArguments != null) {
            graphicalTestArguments.setInputFile(string);
        }
        boolean bl = false;
        bl = string4 != null ? ConvWatch.checkDiffDiff(graphicalTestArguments, string2, string, string3, string4) : ConvWatch.check(graphicalTestArguments, string2, string, string3);
        return bl;
    }

    public static boolean checkOneFile(XComponent xComponent, String string, String string2, String string3, GraphicalTestArguments graphicalTestArguments) throws ConvWatchException {
        GraphicalDifferenceCheck.showVersion();
        String string4 = GraphicalDifferenceCheck.createInputFile(xComponent, string, string2);
        string4 = FileHelper.getSystemPathFromFileURL(string4);
        return ConvWatch.check(graphicalTestArguments, string, string4, string3);
    }

    private static String createInputFile(XComponent xComponent, String string, String string2) throws ConvWatchCancelException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = GraphicalDifferenceCheck.getXMLOutputFilterforXComponent(xComponent, stringBuffer);
        if (string2 == null) {
            string2 = "OOoTestDocument";
        }
        if (string2.indexOf(46) == -1) {
            string2 = stringBuffer.insert(0, string2).toString();
        }
        String string4 = URLHelper.getFileURLFromSystemPath(GraphicalDifferenceCheck.ensureEndingFileSep(string) + string2);
        XStorable xStorable = null;
        xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
        if (xStorable == null) {
            throw new ConvWatchCancelException("com.sun.star.frame.XStorable could not be instantiated from the office.");
        }
        PropertyValue propertyValue = new PropertyValue("FilterName", -1, string3, PropertyState.getDefault());
        PropertyValue propertyValue2 = new PropertyValue("Overwrite", -1, new Boolean(true), PropertyState.getDefault());
        try {
            xStorable.storeAsURL(string4, new PropertyValue[]{propertyValue, propertyValue2});
        }
        catch (IOException iOException) {
            throw new ConvWatchCancelException("Wrap IOException caught, " + iOException.getMessage());
        }
        GlobalLogWriter.get().println("Saving XComponent as " + string4);
        return string4;
    }

    private static String getXMLOutputFilterforXComponent(XComponent xComponent, StringBuffer stringBuffer) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xComponent);
        if (xServiceInfo.supportsService("com.sun.star.text.TextDocument")) {
            GraphicalDifferenceCheck.resetBuffer(stringBuffer, ".sxw");
            return "swriter: StarOffice XML (Writer)";
        }
        if (xServiceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            GraphicalDifferenceCheck.resetBuffer(stringBuffer, ".sxc");
            return "scalc: StarOffice XML (Calc)";
        }
        if (xServiceInfo.supportsService("com.sun.star.presentation.PresentationDocument")) {
            GraphicalDifferenceCheck.resetBuffer(stringBuffer, ".sxi");
            return "simpress: StarOffice XML (Impress)";
        }
        if (xServiceInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            GraphicalDifferenceCheck.resetBuffer(stringBuffer, ".sxd");
            return "sdraw: StarOffice XML (Draw)";
        }
        if (xServiceInfo.supportsService("com.sun.star.formula.FormulaProperties")) {
            GraphicalDifferenceCheck.resetBuffer(stringBuffer, ".sxm");
            return "smath: StarOffice XML (Math)";
        }
        return null;
    }

    private static StringBuffer resetBuffer(StringBuffer stringBuffer, String string) {
        if (stringBuffer != null) {
            stringBuffer.replace(0, stringBuffer.length(), string);
        }
        return stringBuffer;
    }

    private static String ensureEndingFileSep(String string) {
        if (string != null && !string.equals("") && !string.endsWith(File.separator)) {
            string = string.trim() + File.separator;
        } else if (string == null) {
            string = "";
        }
        return string;
    }
}

