/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.ImageHelper;
import convwatch.Rect;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class BorderRemover {
    ImageHelper m_aImage;

    BorderRemover() {
    }

    boolean compareColorWithTolerance(int n, int n2, int n3) {
        double d;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n2 >> 16 & 0xFF;
        int n8 = n2 >> 8 & 0xFF;
        int n9 = n2 & 0xFF;
        if (n3 > 100) {
            n3 = 100;
        }
        if ((d = (double)(n3 * 256 / 100)) < 0.0) {
            d = 0.0;
        }
        return (double)Math.abs(n4 - n7) < d && (double)Math.abs(n5 - n8) < d && (double)Math.abs(n6 - n9) < d;
    }

    public boolean createNewImageWithoutBorder(String string, String string2) throws IOException {
        Object object;
        this.m_aImage = ImageHelper.createImageHelper(string);
        int n = this.m_aImage.getPixel(0, 0);
        Rect rect = this.findBorder(this.m_aImage, n);
        RenderedImage renderedImage = this.createImage(this.m_aImage, rect);
        File file = new File(string2);
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            object = Class.forName("javax.imageio.ImageIO");
            Method method = ((Class)object).getDeclaredMethod("getWriterMIMETypes", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            String[] stringArray = (String[])object2;
            Method method2 = ((Class)object).getDeclaredMethod("write", RenderedImage.class, String.class, File.class);
            method2.invoke(object, renderedImage, "image/jpeg", file);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            reflectiveOperationException = classNotFoundException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            reflectiveOperationException = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            reflectiveOperationException = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            reflectiveOperationException = invocationTargetException;
        }
        if (reflectiveOperationException != null) {
            object = System.getProperty("java.version");
            throw new IOException("Cannot construct object with current Java version " + (String)object + ": " + reflectiveOperationException.getMessage());
        }
        return true;
    }

    Rect findBorder(ImageHelper imageHelper, int n) {
        Rect rect;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = imageHelper.getHeight();
        int n7 = n5 = imageHelper.getWidth();
        int n8 = 0;
        int n9 = n6;
        int n10 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n7; ++n3) {
                n2 = imageHelper.getPixel(n3, n4);
                if (this.compareColorWithTolerance(n2, n, 10)) continue;
                n7 = Math.min(n7, n3);
                n9 = Math.min(n9, n4);
            }
        }
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = n5 - 1; n3 >= n8; --n3) {
                n2 = n6 - n4 - 1;
                int n11 = imageHelper.getPixel(n3, n2);
                if (this.compareColorWithTolerance(n11, n, 10)) continue;
                n8 = Math.max(n8, n3);
                n10 = Math.max(n10, n2);
            }
        }
        if (n7 < n8 && n9 < n10) {
            n3 = n8 - n7 + 1;
            n2 = n10 - n9 + 1;
            rect = new Rect(n7, n9, n3, n2);
        } else {
            rect = new Rect(0, 0, 1, 1);
        }
        return rect;
    }

    RenderedImage createImage(ImageHelper imageHelper, Rect rect) throws IllegalArgumentException {
        int n = rect.getWidth();
        int n2 = rect.getHeight();
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("width or height are too small or negative.");
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        int n3 = rect.getX();
        int n4 = rect.getY();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                bufferedImage.setRGB(j, i, imageHelper.getPixel(j + n3, i + n4));
            }
        }
        return bufferedImage;
    }
}

