/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.RegistryKeyType;
import com.sun.star.registry.RegistryValueType;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;

public class RegistryTools {
    public static XSimpleRegistry createRegistryService(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        Object object = xMultiServiceFactory.createInstance("com.sun.star.registry.SimpleRegistry");
        return (XSimpleRegistry)UnoRuntime.queryInterface(XSimpleRegistry.class, object);
    }

    public static XSimpleRegistry openRegistry(String string, XMultiServiceFactory xMultiServiceFactory) throws Exception {
        XSimpleRegistry xSimpleRegistry = RegistryTools.createRegistryService(xMultiServiceFactory);
        xSimpleRegistry.open(string, false, true);
        return xSimpleRegistry;
    }

    public static boolean compareKeys(XRegistryKey xRegistryKey, XRegistryKey xRegistryKey2) {
        String string;
        if (xRegistryKey == null || xRegistryKey2 == null || !xRegistryKey.isValid() || !xRegistryKey2.isValid()) {
            return false;
        }
        String string2 = RegistryTools.getShortKeyName(xRegistryKey.getKeyName());
        if (!string2.equals(string = RegistryTools.getShortKeyName(xRegistryKey2.getKeyName()))) {
            return false;
        }
        try {
            if (xRegistryKey.getValueType() != xRegistryKey2.getValueType()) {
                return false;
            }
        }
        catch (InvalidRegistryException invalidRegistryException) {
            return false;
        }
        try {
            RegistryValueType registryValueType = xRegistryKey.getValueType();
            if (registryValueType.equals(RegistryValueType.ASCII)) {
                if (!xRegistryKey.getAsciiValue().equals(xRegistryKey2.getAsciiValue())) {
                    return false;
                }
            } else if (registryValueType.equals(RegistryValueType.STRING)) {
                if (!xRegistryKey.getStringValue().equals(xRegistryKey2.getStringValue())) {
                    return false;
                }
            } else if (registryValueType.equals(RegistryValueType.LONG)) {
                if (xRegistryKey.getLongValue() != xRegistryKey2.getLongValue()) {
                    return false;
                }
            } else if (registryValueType.equals(RegistryValueType.BINARY)) {
                byte[] byArray;
                byte[] byArray2 = xRegistryKey.getBinaryValue();
                if (byArray2.length != (byArray = xRegistryKey2.getBinaryValue()).length) {
                    return false;
                }
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] == byArray[i]) continue;
                    return false;
                }
            } else if (registryValueType.equals(RegistryValueType.ASCIILIST)) {
                String[] stringArray;
                String[] stringArray2 = xRegistryKey.getAsciiListValue();
                if (stringArray2.length != (stringArray = xRegistryKey2.getAsciiListValue()).length) {
                    return false;
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i].equals(stringArray[i])) continue;
                    return false;
                }
            } else if (registryValueType.equals(RegistryValueType.STRINGLIST)) {
                String[] stringArray;
                String[] stringArray3 = xRegistryKey.getStringListValue();
                if (stringArray3.length != (stringArray = xRegistryKey2.getStringListValue()).length) {
                    return false;
                }
                for (int i = 0; i < stringArray3.length; ++i) {
                    if (stringArray3[i].equals(stringArray[i])) continue;
                    return false;
                }
            } else if (registryValueType.equals(RegistryValueType.LONGLIST)) {
                int[] nArray;
                int[] nArray2 = xRegistryKey.getLongListValue();
                if (nArray2.length != (nArray = xRegistryKey2.getLongListValue()).length) {
                    return false;
                }
                for (int i = 0; i < nArray2.length; ++i) {
                    if (nArray2[i] == nArray[i]) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String getShortKeyName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("/");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected static boolean compareKeyTrees(XRegistryKey xRegistryKey, XRegistryKey xRegistryKey2, boolean bl) {
        if (bl && !RegistryTools.compareKeys(xRegistryKey, xRegistryKey2)) {
            return false;
        }
        try {
            String[] stringArray = xRegistryKey.getKeyNames();
            String[] stringArray2 = xRegistryKey2.getKeyNames();
            if (stringArray == null && stringArray2 == null) {
                return true;
            }
            if (stringArray == null || stringArray2 == null || stringArray2.length != stringArray.length) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = RegistryTools.getShortKeyName(stringArray[i]);
                XRegistryKey xRegistryKey3 = xRegistryKey2.openKey(string);
                if (xRegistryKey3 == null) {
                    return false;
                }
                if (!xRegistryKey.getKeyType(string).equals(xRegistryKey2.getKeyType(string))) {
                    return false;
                }
                if (!(xRegistryKey.getKeyType(string).equals(RegistryKeyType.LINK) ? !RegistryTools.getShortKeyName(xRegistryKey.getLinkTarget(string)).equals(RegistryTools.getShortKeyName(xRegistryKey2.getLinkTarget(string))) : !RegistryTools.compareKeyTrees(xRegistryKey.openKey(string), xRegistryKey2.openKey(string), true))) continue;
                return false;
            }
        }
        catch (InvalidRegistryException invalidRegistryException) {
            return false;
        }
        return true;
    }

    public static boolean compareKeyTrees(XRegistryKey xRegistryKey, XRegistryKey xRegistryKey2) {
        return RegistryTools.compareKeyTrees(xRegistryKey, xRegistryKey2, false);
    }

    public static void printRegistryInfo(XSimpleRegistry xSimpleRegistry, PrintWriter printWriter) {
        try {
            RegistryTools.printRegistryInfo(xSimpleRegistry.getRootKey(), printWriter);
        }
        catch (InvalidRegistryException invalidRegistryException) {
            printWriter.println("!!! Can't open root registry key for info printing");
        }
    }

    public static void printRegistryInfo(XRegistryKey xRegistryKey, PrintWriter printWriter) {
        if (xRegistryKey == null) {
            printWriter.println("/(null)");
            return;
        }
        printWriter.println("/");
        try {
            RegistryTools.printTreeInfo(xRegistryKey, printWriter, "  ");
        }
        catch (InvalidRegistryException invalidRegistryException) {
            printWriter.println("Exception accessing registry :");
            invalidRegistryException.printStackTrace(printWriter);
        }
    }

    private static void printTreeInfo(XRegistryKey xRegistryKey, PrintWriter printWriter, String string) throws InvalidRegistryException {
        String[] stringArray = xRegistryKey.getKeyNames();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            RegistryTools.printKeyInfo(xRegistryKey, stringArray[i], printWriter, string);
            XRegistryKey xRegistryKey2 = xRegistryKey.openKey(RegistryTools.getShortKeyName(stringArray[i]));
            RegistryTools.printTreeInfo(xRegistryKey2, printWriter, string + "  ");
            xRegistryKey2.closeKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printKeyInfo(XRegistryKey xRegistryKey, String string, PrintWriter printWriter, String string2) throws InvalidRegistryException {
        printWriter.print(string2);
        string = RegistryTools.getShortKeyName(string);
        XRegistryKey xRegistryKey2 = xRegistryKey.openKey(string);
        if (xRegistryKey2 == null) {
            printWriter.println("(null)");
            return;
        }
        printWriter.print("/" + RegistryTools.getShortKeyName(xRegistryKey2.getKeyName()) + " ");
        if (!xRegistryKey2.isValid()) {
            printWriter.println("(not valid)");
            return;
        }
        if (xRegistryKey2.isReadOnly()) {
            printWriter.print("(read only) ");
        }
        if (xRegistryKey.getKeyType(string) == RegistryKeyType.LINK) {
            printWriter.println("(link to " + xRegistryKey.getLinkTarget(string) + ")");
            return;
        }
        try {
            RegistryValueType registryValueType = xRegistryKey2.getValueType();
            if (registryValueType.equals(RegistryValueType.ASCII)) {
                printWriter.println("[ASCII] = '" + xRegistryKey2.getAsciiValue() + "'");
            } else if (registryValueType.equals(RegistryValueType.STRING)) {
                printWriter.println("[STRING] = '" + xRegistryKey2.getStringValue() + "'");
            } else if (registryValueType.equals(RegistryValueType.LONG)) {
                printWriter.println("[LONG] = " + xRegistryKey2.getLongValue());
            } else if (registryValueType.equals(RegistryValueType.BINARY)) {
                printWriter.print("[BINARY] = {");
                byte[] byArray = xRegistryKey2.getBinaryValue();
                for (int i = 0; i < byArray.length; ++i) {
                    printWriter.print("" + byArray[i] + ",");
                }
                printWriter.println("}");
            } else if (registryValueType.equals(RegistryValueType.ASCIILIST)) {
                printWriter.print("[ASCIILIST] = {");
                String[] stringArray = xRegistryKey2.getAsciiListValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    printWriter.print("'" + stringArray[i] + "',");
                }
                printWriter.println("}");
            } else if (registryValueType.equals(RegistryValueType.STRINGLIST)) {
                printWriter.print("[STRINGLIST] = {");
                String[] stringArray = xRegistryKey2.getStringListValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    printWriter.print("'" + stringArray[i] + "',");
                }
                printWriter.println("}");
            } else if (registryValueType.equals(RegistryValueType.LONGLIST)) {
                printWriter.print("[LONGLIST] = {");
                int[] nArray = xRegistryKey2.getLongListValue();
                for (int i = 0; i < nArray.length; ++i) {
                    printWriter.print("" + nArray[i] + ",");
                }
                printWriter.println("}");
            } else {
                printWriter.println("");
            }
        }
        catch (Exception exception) {
            printWriter.println("Exception occured : ");
            exception.printStackTrace(printWriter);
        }
        finally {
            xRegistryKey2.closeKey();
        }
    }
}

